/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.fm.common.ROMRowSet;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class FMDBHelper {
    private static Connection getConn(Context ctx) throws SQLDataException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            throw new SQLDataException(e);
        }
        return conn;
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    public static int[] executeBatch(Context ctx, List sqls) throws SQLDataException {
        int[] ret = null;
        if (sqls == null || sqls.size() == 0) {
            return ret;
        }
        Connection conn = FMDBHelper.getConn(ctx);
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            int n = sqls.size();
            for (int i = 0; i < n; ++i) {
                stmt.addBatch(sqls.get(i).toString());
            }
            ret = stmt.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        return ret;
    }

    public static int[] executeBatch(Context ctx, String prepareSql, List params) throws SQLDataException {
        int[] ret = null;
        if (prepareSql == null || params == null || params.size() == 0) {
            return ret;
        }
        Connection conn = FMDBHelper.getConn(ctx);
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(prepareSql);
            int n = params.size();
            for (int i = 0; i < n; ++i) {
                Object param = params.get(i);
                if (param instanceof Object[]) {
                    Object[] arryParam = (Object[])param;
                    int m = arryParam.length;
                    for (int j = 0; j < m; ++j) {
                        ps.setObject(j + 1, arryParam[j]);
                    }
                } else {
                    ps.setObject(1, param);
                }
                ps.addBatch();
            }
            ret = ps.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
        }
        return ret;
    }

    public static ROMRowSet executeQuery(Context ctx, String sql) throws SQLDataException {
        if (sql == null || sql.trim().length() == 0) {
            return null;
        }
        ROMRowSet rrs = new ROMRowSet();
        Connection conn = FMDBHelper.getConn(ctx);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            rrs.setRs(rowset);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return rrs;
    }

    public static ROMRowSet executeQuery(Context ctx, String sql, Object[] params) throws SQLDataException {
        if (sql == null || sql.trim().length() == 0) {
            return null;
        }
        ROMRowSet rrs = new ROMRowSet();
        Connection conn = FMDBHelper.getConn(ctx);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            rrs.setRs(rowset);
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return rrs;
    }
}

