/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.LogTaskDetailCollection;
import com.kingdee.eas.fm.common.LogTaskDetailFactory;
import com.kingdee.eas.fm.common.LogTaskDetailInfo;
import com.kingdee.eas.fm.common.app.AbstractLogManagerFacadeControllerBean;
import com.kingdee.eas.fm.common.app.log.model.LogTaskDefVO;
import com.kingdee.eas.fm.common.app.log.model.LogTaskDetailVO;
import com.kingdee.eas.fm.common.app.log.model.LogTaskRunVO;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogManagerFacadeControllerBean
extends AbstractLogManagerFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.common.app.LogManagerFacadeControllerBean");

    @Override
    protected LogTaskDefVO _getTaskDef(Context ctx, String id) throws BOSException, EASBizException {
        LogTaskDefVO vo = new LogTaskDefVO();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select * from t_fm_logtaskdef where fid=?", (Object[])new Object[]{id});
        try {
            if (!rowSet.next()) {
                throw new BOSException("No such Task, name: " + id + "!");
            }
            vo.setId(rowSet.getString("FID"));
            vo.setDescription(rowSet.getString("FDescription"));
            vo.setEnabled(rowSet.getBoolean("FEnabled"));
            vo.setKey0(rowSet.getString("FKey0"));
            vo.setKey1(rowSet.getString("FKey1"));
            vo.setKey2(rowSet.getString("FKey2"));
            vo.setKey3(rowSet.getString("FKey3"));
            vo.setName(rowSet.getString("FName"));
            vo.setNumber(rowSet.getString("FNumber"));
            vo.setRunning(rowSet.getBoolean("FRunning"));
            vo.setRunningTaskId(rowSet.getString("FRunningTaskId"));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return vo;
    }

    @Override
    protected LogTaskRunVO _getTaskRun(Context ctx, String id) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _insertTaskRun(Context ctx, LogTaskRunVO taskRun) throws BOSException, EASBizException {
        String sql = "insert into t_fm_logtaskrun(fid,ftaskdefid,fstartdate,fenddate)values(?,?,?,?)";
        Object[] params = new Object[]{taskRun.getId(), taskRun.getTaskDef().getId(), new Timestamp(taskRun.getStartDate().getTime()), null};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _updateTaskRun(Context ctx, LogTaskRunVO taskRun) throws BOSException, EASBizException {
        String sql = "update t_fm_logtaskrun set fenddate=? where fid=?";
        Object[] params = new Object[]{new Timestamp(taskRun.getEndDate().getTime()), taskRun.getId()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _insertTaskDetail(Context ctx, LogTaskDetailVO taskDetail) throws BOSException, EASBizException {
        LogTaskDetailInfo info = new LogTaskDetailInfo();
        info.setId(BOSUuid.read((String)taskDetail.getId()));
        info.setTaskRunId(taskDetail.getTaskRun().getId());
        info.setStartDate(new Timestamp(taskDetail.getStartDate().getTime()));
        info.setEndDate(new Timestamp(taskDetail.getEndDate().getTime()));
        info.setKey0(taskDetail.getKey0());
        info.setKey1(taskDetail.getKey1());
        info.setKey2(taskDetail.getKey2());
        info.setKey3(taskDetail.getKey3());
        info.setStatus(taskDetail.getStatus());
        byte[] logBytes = "".getBytes();
        if (taskDetail.getLog() != null) {
            try {
                logBytes = taskDetail.getLog().getBytes("GBK");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        info.setLog(logBytes);
        LogTaskDetailFactory.getLocalInstance(ctx).addnew(info);
    }

    @Override
    protected void _setRunningState(Context ctx, String taskDefId, boolean running) throws BOSException, EASBizException {
        String sql = "update t_fm_logtaskdef set frunning=? where fid=?";
        Object[] params = new Object[]{running, taskDefId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected Map _getTaskRunList(Context ctx, String filterItems, int page, int rows) throws BOSException {
        HashMap<String, Serializable> gridData = new HashMap<String, Serializable>();
        try {
            String keyCountSql = "SELECT COUNT(*) NUM FROM T_FM_LogTaskRun";
            IRowSet keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
            keyCountRowSet.next();
            int num = keyCountRowSet.getInt("NUM");
            gridData.put("totalCount", Integer.valueOf(num));
            if (num == 0) {
                gridData.put("listData", new ArrayList());
            } else {
                String selectSql = "SELECT T0.FID,T0.FStartDate,T0.FEndDate,T0.FTaskDefId, T1.FName FROM T_FM_LogTaskRun T0 INNER JOIN T_FM_LogTaskDef T1 ON T0.FTaskDefId=T1.FID ORDER BY T0.FStartDate DESC";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (int)(rows * (page - 1)), (int)rows);
                ArrayList<LogTaskRunVO> listData = new ArrayList<LogTaskRunVO>();
                while (rowSet.next()) {
                    LogTaskRunVO taskRun = new LogTaskRunVO();
                    taskRun.setId(rowSet.getString("FID"));
                    LogTaskDefVO taskDef = new LogTaskDefVO();
                    taskDef.setId(rowSet.getString("FTaskDefId"));
                    taskDef.setName(rowSet.getString("FName"));
                    taskRun.setTaskDef(taskDef);
                    taskRun.setStartDate(rowSet.getTimestamp("FStartDate"));
                    taskRun.setEndDate(rowSet.getTimestamp("FEndDate"));
                    listData.add(taskRun);
                }
                gridData.put("listData", listData);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return gridData;
    }

    @Override
    protected Map _getTaskDetailList(Context ctx, String filterItems, int page, int rows) throws BOSException {
        HashMap<String, Serializable> gridData = new HashMap<String, Serializable>();
        try {
            String keyCountSql = "SELECT COUNT(*) NUM FROM T_FM_LogTaskDetail WHERE " + filterItems;
            IRowSet keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
            keyCountRowSet.next();
            int total = keyCountRowSet.getInt("NUM");
            gridData.put("totalCount", Integer.valueOf(total));
            if (total == 0) {
                gridData.put("listData", new ArrayList());
            } else {
                String selectSql = "SELECT FID FROM T_FM_LogTaskDetail WHERE " + filterItems + " ORDER BY FStartDate";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (int)(rows * (page - 1)), (int)rows);
                StringBuffer oql = new StringBuffer("where id in ('NE'");
                while (rowSet.next()) {
                    oql.append(",'" + rowSet.getString("FID") + "'");
                }
                oql.append(") order by startDate");
                LogTaskDetailCollection coll = LogTaskDetailFactory.getLocalInstance(ctx).getCollection(oql.toString());
                ArrayList<LogTaskDetailVO> listData = new ArrayList<LogTaskDetailVO>();
                for (int i = 0; i < coll.size(); ++i) {
                    LogTaskDetailInfo info = coll.get(i);
                    LogTaskDetailVO detail = new LogTaskDetailVO();
                    detail.setId(info.getId().toString());
                    detail.setKey0(info.getKey0());
                    detail.setKey1(info.getKey1());
                    detail.setKey2(info.getKey2());
                    detail.setKey3(info.getKey3());
                    detail.setStartDate(info.getStartDate());
                    detail.setEndDate(info.getEndDate());
                    detail.setStatus(info.getStatus());
                    detail.setLog(new String(info.getLog(), "GBK"));
                    listData.add(detail);
                }
                gridData.put("listData", listData);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return gridData;
    }
}

