/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.app.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ILogManagerFacade;
import com.kingdee.eas.fm.common.LogManagerFacadeFactory;
import com.kingdee.eas.fm.common.app.log.model.LogTaskDefVO;
import com.kingdee.eas.fm.common.app.log.model.LogTaskDetailVO;
import com.kingdee.eas.fm.common.app.log.model.LogTaskRunVO;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LogManager {
    public static final String TASK_DEF_BOSTYPE = "671BC32A";
    public static final String TASK_RUN_BOSTYPE = "671BF9B0";
    public static final String TASK_DETAIL_BOSTYPE = "D7C44B0C";
    private static ThreadLocal<Map<String, LogManager>> logTaskDefMaps = new ThreadLocal<Map<String, LogManager>>(){

        @Override
        public Map<String, LogManager> initialValue() {
            return new HashMap<String, LogManager>();
        }
    };
    private LogTaskDefVO taskDef = null;
    private LogTaskRunVO taskRun = null;
    private LogTaskDetailVO taskDetail = null;
    private Context ctx = null;

    private LogManager(Context ctx, String taskDefId) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.taskDef = this.fetchTaskDef(taskDefId);
    }

    public static LogManager getInstance(Context ctx, String taskDefId) throws EASBizException, BOSException {
        Map<String, LogManager> taskDefMap = logTaskDefMaps.get();
        LogManager logManager = taskDefMap.get(taskDefId);
        if (logManager == null) {
            logManager = new LogManager(ctx, taskDefId);
            taskDefMap.put(taskDefId, logManager);
        }
        return logManager;
    }

    public boolean isRunning() throws EASBizException, BOSException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        return !iMutex.requestObjIDForUpdate(this.taskDef.getId());
    }

    private LogTaskDefVO fetchTaskDef(String taskDefId) throws EASBizException, BOSException {
        LogTaskDefVO taskDef = LogManagerFacadeFactory.getLocalInstance(this.ctx).getTaskDef(taskDefId);
        return taskDef;
    }

    public LogTaskRunVO startTask() throws EASBizException, BOSException {
        ILogManagerFacade facade = LogManagerFacadeFactory.getLocalInstance(this.ctx);
        this.taskRun = new LogTaskRunVO();
        this.taskRun.setTaskDef(this.taskDef);
        this.taskRun.setId(BOSUuid.create((String)TASK_RUN_BOSTYPE).toString());
        this.taskRun.setStartDate(new Date());
        facade.insertTaskRun(this.taskRun);
        return this.taskRun;
    }

    public void finishTask() throws BOSException, EASBizException {
        this.saveTaskDetail();
        ILogManagerFacade facade = LogManagerFacadeFactory.getLocalInstance(this.ctx);
        this.taskRun.setEndDate(new Date());
        facade.updateTaskRun(this.taskRun);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)this.ctx);
        iMutex.releaseObjIDForUpdate(this.taskDef.getId());
    }

    public LogTaskDetailVO getTaskDetail() throws EASBizException, BOSException {
        if (this.taskDetail != null) {
            return this.taskDetail;
        }
        return this.addTaskDetail();
    }

    public LogTaskDetailVO addTaskDetail() throws EASBizException, BOSException {
        return this.addTaskDetail(null, null, null, null);
    }

    public LogTaskDetailVO addTaskDetail(String key0, String key1, String key2, String key3) throws EASBizException, BOSException {
        if (this.taskDetail != null) {
            this.saveTaskDetail();
        }
        this.taskDetail = new LogTaskDetailVO();
        this.taskDetail.setTaskRun(this.taskRun);
        this.taskDetail.setId(BOSUuid.create((String)TASK_DETAIL_BOSTYPE).toString());
        this.taskDetail.setKey0(key0);
        this.taskDetail.setKey1(key1);
        this.taskDetail.setKey2(key2);
        this.taskDetail.setKey3(key3);
        this.taskDetail.setStartDate(new Date());
        this.taskDetail.setStatus(2);
        return this.taskDetail;
    }

    public void saveTaskDetail() throws BOSException, EASBizException {
        if (this.taskDetail == null) {
            return;
        }
        this.taskDetail.setEndDate(new Date());
        ILogManagerFacade facade = LogManagerFacadeFactory.getLocalInstance(this.ctx);
        facade.insertTaskDetail(this.taskDetail);
        this.taskDetail = null;
    }
}

