/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.jsoup.nodes;

import com.kingdee.eas.fm.common.jsoup.Connection;
import com.kingdee.eas.fm.common.jsoup.Jsoup;
import com.kingdee.eas.fm.common.jsoup.helper.HttpConnection;
import com.kingdee.eas.fm.common.jsoup.helper.Validate;
import com.kingdee.eas.fm.common.jsoup.nodes.Attributes;
import com.kingdee.eas.fm.common.jsoup.nodes.Element;
import com.kingdee.eas.fm.common.jsoup.parser.Tag;
import com.kingdee.eas.fm.common.jsoup.select.Elements;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag, String baseUri, Attributes attributes) {
        super(tag, baseUri, attributes);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    public Connection submit() {
        String action = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(action, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method = this.attr("method").toUpperCase(Locale.ENGLISH).equals("POST") ? Connection.Method.POST : Connection.Method.GET;
        Connection con = Jsoup.connect(action).data(this.formData()).method(method);
        return con;
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
        for (Element el : this.elements) {
            String name;
            if (!el.tag().isFormSubmittable() || (name = el.attr("name")).length() == 0) continue;
            if ("select".equals(el.tagName())) {
                Elements options = el.select("option[selected]");
                for (Element option : options) {
                    data.add(HttpConnection.KeyVal.create(name, option.val()));
                }
                continue;
            }
            data.add(HttpConnection.KeyVal.create(name, el.val()));
        }
        return data;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

