/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BatchActionUtils {
    private static final String PERMISSION_SERVICE = "com.kingdee.eas.framework.client.service.PermissionService";

    private static String getActionName(ItemAction action) {
        String actionName = action.getActionName();
        if (StringUtils.isEmpty((String)actionName)) {
            String clzName = action.getClass().getName();
            int idx = clzName.lastIndexOf(36);
            actionName = idx > -1 ? clzName.substring(idx + 1) : ((idx = clzName.lastIndexOf(46)) > -1 ? clzName.substring(idx + 1) : clzName);
        }
        return actionName;
    }

    private static void checkFunctionPermission(IObjectPK userPK, List orgPKs, IMetaDataPK uiMedataPK, IMetaDataPK actionPK) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        int size = orgPKs.size();
        for (int i = 0; i < size; ++i) {
            String orgId = (String)orgPKs.get(i);
            iPermission.checkFunctionPermission(userPK, (IObjectPK)new ObjectUuidPK(orgId), uiMedataPK, actionPK);
        }
    }

    private static void processPermissionResult(BatchSelectionEntries selectionEntries, Map resultMap) {
        int size = selectionEntries.size();
        for (int i = 0; i < size; ++i) {
            BatchSelectionEntry entry = selectionEntries.get(i);
            if (!resultMap.containsKey(entry.getOrgId())) continue;
            entry.setResultMsg(resultMap.get(entry.getOrgId()).toString());
        }
    }

    public static boolean checkPermission(BatchSelectionEntries selectionEntries, ItemAction action, IObjectPK userPK, IMetaDataPK metaDataPK) throws BOSException, EASBizException {
        if (action == null || selectionEntries == null || selectionEntries.size() == 0) {
            return true;
        }
        List orgPKs = selectionEntries.getOrgList();
        BatchActionUtils.checkFunctionPermission(userPK, orgPKs, metaDataPK, (IMetaDataPK)new MetaDataPK(BatchActionUtils.getActionName(action)));
        return true;
    }

    private static boolean isIncludePermissionService(ItemAction itemAction) {
        Map services = itemAction.getServices();
        return services != null && services.containsKey(PERMISSION_SERVICE);
    }

    public static List getCustomPermissionActions(Set excludeActionSet, Map allActionMap) {
        if (EmptyUtil.isEmpty((Collection)excludeActionSet)) {
            return new ArrayList();
        }
        HashMap<String, String> excludeActionMap = new HashMap<String, String>();
        Iterator<Object> iterator = excludeActionSet.iterator();
        String actionName = null;
        while (iterator.hasNext()) {
            actionName = (String)iterator.next();
            excludeActionMap.put(actionName, actionName);
        }
        iterator = allActionMap.keySet().iterator();
        ArrayList actionsList = new ArrayList();
        while (iterator.hasNext()) {
            ItemAction itemAction;
            String key = iterator.next().toString();
            if (!excludeActionMap.containsKey(key) || !(itemAction = (ItemAction)allActionMap.get(key)).isVisible() || !BatchActionUtils.isIncludePermissionService(itemAction)) continue;
            actionsList.add(allActionMap.get(key));
        }
        return actionsList;
    }
}

