/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;

public class AccountCurrencyVerifyUtil {
    public static void verifyAccountCurrency(Context ctx, String accountid, String currencyId) throws EASBizException, BOSException {
        AccountCurrencyVerifyUtil.verifyAccountCurrency(ctx, accountid, currencyId, null);
    }

    public static void verifyAccountCurrency(Context ctx, String accountid, String currencyId, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        AccountViewInfo account = null;
        CurrencyInfo localCurrency = null;
        boolean isLocalCurrency = false;
        if (ctx == null) {
            if (company == null) {
                company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            }
            localCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
            account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountid)), sic);
        } else {
            if (company == null) {
                company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            }
            localCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
            account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountid)), sic);
        }
        if (localCurrency == null || localCurrency.getId() == null) {
            return;
        }
        if (localCurrency.getId().toString().equals(currencyId)) {
            isLocalCurrency = true;
        }
        switch (account.getAccountingcurrency().getValue()) {
            case 2: {
                return;
            }
            case 0: {
                if (isLocalCurrency) break;
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
            case 1: {
                AccountCurrencyCollection acctCurColl = account.getAccountCurrency();
                for (int j = 0; j < acctCurColl.size(); ++j) {
                    if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                    return;
                }
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
        }
    }

    public static void verifyAccountCurrency(Context ctx, AccountViewInfo acctView, String currencyId, String baseCurrencyId) throws EASBizException, BOSException {
        boolean isLocalCurrency = false;
        if (baseCurrencyId.equals(currencyId)) {
            isLocalCurrency = true;
        }
        switch (acctView.getAccountingcurrency().getValue()) {
            case 2: {
                return;
            }
            case 0: {
                if (isLocalCurrency) break;
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
            case 1: {
                AccountCurrencyCollection acctCurColl = acctView.getAccountCurrency();
                for (int j = 0; j < acctCurColl.size(); ++j) {
                    if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                    return;
                }
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
        }
    }

    public static boolean isAccountCurrency(Context ctx, String accountid, String currencyId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        AccountViewInfo account = null;
        CompanyOrgUnitInfo company = null;
        CurrencyInfo localCurrency = null;
        boolean isLocalCurrency = false;
        if (ctx == null) {
            company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            localCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
            account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountid)), sic);
        } else {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            localCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
            account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountid)), sic);
        }
        if (localCurrency.getId().toString().equals(currencyId)) {
            isLocalCurrency = true;
        }
        switch (account.getAccountingcurrency().getValue()) {
            case 2: {
                return true;
            }
            case 0: {
                return isLocalCurrency;
            }
            case 1: {
                AccountCurrencyCollection acctCurColl = account.getAccountCurrency();
                for (int j = 0; j < acctCurColl.size(); ++j) {
                    if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static boolean isAccountCurrency(String localCurrency, AccountViewInfo account, String currencyId) throws EASBizException, BOSException {
        boolean isLocalCur = false;
        if (localCurrency.equals(currencyId)) {
            isLocalCur = true;
        }
        switch (account.getAccountingcurrency().getValue()) {
            case 2: {
                return true;
            }
            case 0: {
                return isLocalCur;
            }
            case 1: {
                AccountCurrencyCollection acctCurColl = account.getAccountCurrency();
                for (int j = 0; j < acctCurColl.size(); ++j) {
                    if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }
}

