/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.fm.common.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculateAdapter;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Date;

public class AccrualCalculate_PayDeposit
extends AccrualCalculateAdapter {
    public AccrualCalculate_PayDeposit(AccrualCalculatorElementNeededInfo acen) {
        super(acen);
    }

    @Override
    protected BigDecimal getPrincipal() {
        return this.acen.getDepositBalance().subtract(this.acen.getFloorAmt());
    }

    @Override
    protected BigDecimal getIntervalDays() {
        return this.acen.getIntervalDays();
    }

    private BigDecimal getBaseNumber() {
        if (this.acen.getIntRateTypeExpressionEnum() != IntRateTypeExpressionEnum.YEAR) {
            return Constants.ONE_THOUSAND;
        }
        return Constants.ONE_HUNDRED;
    }

    @Override
    protected BigDecimal getPeriodicalRate(Context ctx) {
        return this.acen.getYearRate();
    }

    @Override
    public BigDecimal calcPeriodicalAccrual(Context ctx) {
        BigDecimal result = Constants.ZERO;
        BigDecimal natualAmt = this.getPrincipal();
        BigDecimal rate = this.getPeriodicalRate(ctx);
        BigDecimal yearDays = this.getYearDays();
        BigDecimal base = this.getBaseNumber();
        BigDecimal intervalDays = this.getIntervalDays();
        int precision = this.getPrecision(ctx);
        if (this.isNull(natualAmt) || this.isNull(rate) || this.isNull(yearDays) || this.isNull(intervalDays) || this.isZero(base) || this.isZero(yearDays)) {
            return result;
        }
        result = natualAmt.multiply(intervalDays).multiply(rate).divide(yearDays, precision, 4).divide(base, precision, 4);
        return result;
    }

    private boolean isZero(BigDecimal bigDecimal) {
        return bigDecimal.compareTo(Constants.ZERO) == 0;
    }

    private boolean isNull(BigDecimal bigDecimal) {
        return bigDecimal == null;
    }

    public BigDecimal calcCurrentAccrual() {
        return Constants.ZERO;
    }

    @Override
    protected void checkEmtpy() {
    }

    @Override
    protected String getMsgHeader() {
        return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"83_AccrualCalculate_PayDeposit");
    }

    @Override
    protected int getPrecision(Context ctx) {
        return super.getPrecision(ctx);
    }

    @Override
    protected Date getEndDate() {
        return null;
    }

    @Override
    protected Date getStartDate() {
        return null;
    }

    @Override
    protected boolean doCalcPeriodicalAccrual() {
        return false;
    }

    @Override
    protected boolean doCalcCurrentAccrual() {
        return false;
    }
}

