/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.FMBillBigDecimalUtil;
import com.kingdee.eas.fm.common.util.FMBillClientUtil;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Field;
import java.util.HashSet;
import javax.swing.JTextField;

public class FMBillKDTableUtil {
    private static final Color SUM_ROW_COLOR = new Color(0xF6F6B6);

    public static KDTextField initKDTableTextColumnStyle(KDTable table, String colName, int length) {
        KDTextField txtText = new KDTextField();
        txtText.setMaxLength(length);
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtText));
        return txtText;
    }

    public static ICellEditor getTextCellEditor(int maxLength) {
        KDTextField txtText = new KDTextField();
        txtText.setMaxLength(maxLength);
        return new KDTDefaultCellEditor((JTextField)txtText);
    }

    public static KDDatePicker initKDTableDateColumnStyle(KDTable table, String colName) {
        return FMBillKDTableUtil.initKDTableDateColumnStyle(table, colName, false);
    }

    public static KDDatePicker initKDTableDateColumnStyle(KDTable table, String colName, boolean isLocked) {
        KDDatePicker pkDate = new KDDatePicker();
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        String formatString = CtrlFormatUtilities.getDateFormatString();
        table.getColumn(colName).getStyleAttributes().setNumberFormat(formatString);
        table.getColumn(colName).getStyleAttributes().setLocked(isLocked);
        return pkDate;
    }

    public static KDFormattedTextField initKDTableNumberColumnStyle(KDTable table, String colName, boolean isLocked) {
        return FMBillKDTableUtil.initKDTableNumberColumnStyle(table, colName, 0, "0", "9999999999999", isLocked);
    }

    public static KDFormattedTextField initKDTableNumberColumnStyle(KDTable table, String colName, int precision, boolean isLocked) {
        return FMBillKDTableUtil.initKDTableNumberColumnStyle(table, colName, precision, "0", "9999999999999", isLocked);
    }

    public static KDFormattedTextField initKDTableNumberColumnStyle(KDTable table, String colName, String minVal, String maxVal, boolean isLocked) {
        return FMBillKDTableUtil.initKDTableNumberColumnStyle(table, colName, 0, minVal, maxVal, isLocked);
    }

    public static KDFormattedTextField initKDTableNumberColumnStyle(KDTable table, String colName, int precision, String minVal, String maxVal, boolean isLocked) {
        KDFormattedTextField txtNumber = FMBillClientUtil.numberControlFormat(null, precision, minVal, maxVal);
        table.getColumn(colName).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtNumber));
        table.getColumn(colName).getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
        table.getColumn(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn(colName).getStyleAttributes().setLocked(isLocked);
        return txtNumber;
    }

    public static void verifyKDTablesRequire(Class clazz, CoreUIObject ui, KDTabbedPane kDTabbedPaneEntry, String[] kdTableNames) {
        for (int i = 0; i < kdTableNames.length; ++i) {
            try {
                Field field = clazz.getDeclaredField(kdTableNames[i]);
                field.setAccessible(true);
                KDTable fieldVal = (KDTable)field.get(ui);
                FMBillKDTableUtil.verifyKDTableRequire(ui, kDTabbedPaneEntry, fieldVal);
                continue;
            }
            catch (SecurityException field) {
                continue;
            }
            catch (NoSuchFieldException field) {
                continue;
            }
            catch (IllegalArgumentException field) {
                continue;
            }
            catch (IllegalAccessException field) {
                continue;
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
        kDTabbedPaneEntry.setSelectedIndex(0);
    }

    public static void verifyKDTableRequire(CoreUIObject ui, KDTabbedPane kDTabbedPaneEntry, KDTable kdTable) {
        for (int i = 0; i < kdTable.getRowCount(); ++i) {
            IRow row = kdTable.getRow(i);
            for (int j = 0; j < kdTable.getColumnCount(); ++j) {
                IColumn column = kdTable.getColumn(j);
                if (!FMBillKDTableUtil.isNeedVerify(row, column)) continue;
                FMBillKDTableUtil.verifyKDCellInput(ui, kDTabbedPaneEntry, kdTable, row, column.getKey());
            }
        }
    }

    public static void verifyKDCellInput(CoreUIObject ui, KDTabbedPane kDTabbedPaneEntry, KDTable kdTable, IRow row, String key) {
        int colIndex = kdTable.getColumnIndex(key);
        if (FMHelper.isEmpty(row.getCell(key).getValue())) {
            kDTabbedPaneEntry.setSelectedComponent((Component)kdTable.getParent());
            kdTable.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdTable.getHeadRow(0).getCell(key).getValue();
            String msg = headValue + " " + EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"CanNotBeNull");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    private static boolean isNeedVerify(IRow row, IColumn column) {
        return !row.getStyleAttributes().getBackground().equals(SUM_ROW_COLOR) && !column.getStyleAttributes().isHided() && column.isRequired();
    }

    public static boolean isSumRow(IRow row) {
        return row.getStyleAttributes().getBackground().equals(SUM_ROW_COLOR);
    }

    public static void verifyColumnDataNotRepeat(CoreUIObject ui, KDTabbedPane tabbedPane, KDTable table, String fieldName) {
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        tabbedPane.setSelectedComponent((Component)table.getParent());
        for (int i = 0; i < table.getRowCount(); ++i) {
            ICell cell;
            CoreBaseInfo info;
            IRow row = table.getRow(i);
            if (FMBillKDTableUtil.isSumRow(row) || (info = (CoreBaseInfo)(cell = row.getCell(fieldName)).getValue()) == null || info.getId() == null || set.add(info.getId())) continue;
            MsgBox.showInfo((Component)ui, (String)(FMBillUtil.getResouseString("tbl_fenluzhong") + FMBillKDTableUtil.getColumnName(table, fieldName) + FMBillUtil.getResouseString("tbl_ziduanbuchongfu")));
            table.getEditManager().editCellAt(cell.getRowIndex(), cell.getColumnIndex());
            SysUtil.abort();
        }
    }

    public static void verifyColumnNumberNotZero(CoreUIObject ui, KDTabbedPane tabbedPane, KDTable table, String fieldName) {
        tabbedPane.setSelectedComponent((Component)table.getParent());
        for (int i = 0; i < table.getRowCount(); ++i) {
            ICell cell;
            IRow row = table.getRow(i);
            if (FMBillKDTableUtil.isSumRow(row) || !FMBillBigDecimalUtil.isEqZero((cell = row.getCell(fieldName)).getValue())) continue;
            MsgBox.showInfo((Component)ui, (String)(FMBillUtil.getResouseString("tbl_fenluzhong") + FMBillKDTableUtil.getColumnName(table, fieldName) + FMBillUtil.getResouseString("tbl_ziduanling")));
            table.getEditManager().editCellAt(cell.getRowIndex(), cell.getColumnIndex());
            SysUtil.abort();
        }
    }

    private static String getColumnName(KDTable table, String fieldName) {
        int columnIndex = table.getColumn(fieldName).getColumnIndex();
        return table.getHead().getRow(0).getCell(columnIndex).getValue().toString();
    }

    public static void resetKDTableColumnsPrecesion(KDTable table, String[] columns, int precision) {
        String format = FMClientHelper.getNumberFtm((int)precision);
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            IColumn col = table.getColumn(columns[i]);
            col.getStyleAttributes().setNumberFormat(format);
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public void setPrecesionByCurrency(KDComboBox cbbCurrency, KDFormattedTextField[] textFields) {
        CurrencyInfo currencyInfo = (CurrencyInfo)cbbCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        int precesion = currencyInfo.getPrecision();
        if (!FMHelper.isEmpty(textFields) && textFields.length > 0) {
            int arraySize = textFields.length;
            for (int i = 0; i < arraySize; ++i) {
                textFields[i].setPrecision(precesion);
            }
        }
    }

    public static void checkSelectOneItem(CoreUI ui, KDTable table) {
        IBlock selectBlock;
        if (table.getRowCount() == 0 || table.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"152_FMBillKDTableUtil")));
            SysUtil.abort();
        }
        if (table.getSelectManager().size() > 1) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"153_FMBillKDTableUtil"));
            SysUtil.abort();
        }
        if (table.getSelectManager().size() == 1 && (selectBlock = KDTSelectBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(0))).getTop() != selectBlock.getBottom()) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"153_FMBillKDTableUtil"));
            SysUtil.abort();
        }
    }
}

