/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class FMMutexUtil {
    public static final String RES = "com.kingdee.eas.fm.common.FMMutexResource";
    public static String LOCK_DRAFT_ONLINE_DOWNLOAD = "DRAFT_ONLINE_DOWNLOAD";
    public static String LOCK_DRAFT_SCHEDULE_DOWNLOAD = "DRAFT_SCHEDULE_DOWNLOAD";
    public static String LOCK_DRAFT_ONLINE_DOWNLOAD_DESC = "DRAFT_ONLINE_DOWNLOAD_DESC";
    public static String LOCK_DRAFT_SCHEDULE_DOWNLOAD_DESC = "DRAFT_SCHEDULE_DOWNLOAD_DESC";
    public static String DRAFT_ONLINE_DOWNLOAD_DETAIL = "DRAFT_ONLINE_DOWNLOAD_DETAIL";
    public static String DRAFT_SCHEDULE_DOWNLOAD_DETAIL = "DRAFT_SCHEDULE_DOWNLOAD_DETAIL";
    private static Map<String, String> strs = new HashMap<String, String>();

    public static String getString(Context ctx, String resName) {
        if (ctx != null) {
            String key = resName + "_" + ctx.getLocale();
            if (strs.containsKey(key)) {
                return strs.get(key);
            }
            String str = ResourceBase.getString((String)RES, (String)resName, (Locale)ctx.getLocale());
            strs.put(key, str);
            return str;
        }
        return EASResource.getString((String)RES, (String)resName);
    }

    public static String getWatingMessage(Context ctx, MutexParameter excuting, MutexParameter mp) {
        Object[] params = new Object[]{"", mp.getActionName()};
        if (ctx != null) {
            try {
                UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(excuting.getUserID().toString()));
                params[0] = user.getName();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            return ResourceBase.getString((String)RES, (String)"WATING_FOR_LOCK", (Locale)ctx.getLocale(), (Object[])params);
        }
        try {
            UserInfo user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(excuting.getUserID().toString()));
            params[0] = user.getName();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return EASResource.getString((String)RES, (String)"WATING_FOR_LOCK", (Object[])params);
    }

    public static MutexParameter buildLocalParameter(Context ctx, String mutexlock, String companyId, String userId, String actionResName, String actionDetail) {
        return FMMutexUtil.buildMutexParameter(ctx, ctx.getAIS(), companyId, userId, mutexlock, actionResName, actionDetail, MutexLockType.EXCLUSIVE_LOCK, actionResName);
    }

    public static MutexParameter buildRemoteParameter(SysContext ctx, String companyId, String userId, String mutexlock, String actionResName, String actionDetail) {
        return FMMutexUtil.buildMutexParameter(null, ctx.getDcName(), companyId, userId, mutexlock, actionResName, actionDetail, MutexLockType.EXCLUSIVE_LOCK, actionResName);
    }

    protected static MutexParameter buildMutexParameter(Context ctx, String dcName, String companyId, String userId, String mutexlock, String actionResName, String actionDetailResName, MutexLockType type, String descResName) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        mp.setMutexName(mutexlock + "_" + companyId);
        String actionName = FMMutexUtil.getString(ctx, actionResName);
        String detail = FMMutexUtil.getString(ctx, actionDetailResName);
        actionName = actionName + "[" + detail + "]";
        mp.setActionName(actionName);
        mp.setOrgUnitID(EmptyUtil.isEmpty((String)companyId) ? null : BOSUuid.read((String)companyId));
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(type);
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        String description = FMMutexUtil.getString(ctx, descResName);
        mp.setDescription(description);
        return mp;
    }

    public static void releaseMutex(Context ctx, Uuid uuid) throws BOSException {
        IMutexServiceControl mutex = null;
        mutex = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutex.releaseMutex(uuid);
    }
}

