/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FMPermissionUtil {
    private static Logger logger = CoreUIObject.getLogger(FMPermissionUtil.class);
    private static final String ORG_RELATION = "orgRelation";
    private static final String PERM_ITEM_TYPE = "permItemType";
    private static final String ORG_TYPE = "OrgType";
    private static final String ENABLE_DATA_PERMISSION = "enableDataPermission";

    private static Locale[] getLocales(IMetaDataLoader loader) {
        SolutionInfo solutionInfo = loader.getSolution();
        LanguageCollection languages = solutionInfo.getLanguages();
        int size = languages.size();
        Locale[] locales = new Locale[size];
        for (int i = 0; i < size; ++i) {
            locales[i] = languages.get(i).getLocale();
        }
        return locales;
    }

    private static List getPermissionItemInfos(PermissionItemCollection coll, String[] keyNames) {
        ArrayList<IObjectValue> list = new ArrayList<IObjectValue>();
        Map map = FMPermissionUtil.buildMap(coll);
        for (int i = 0; i < keyNames.length; ++i) {
            if (!map.containsKey(keyNames[i])) {
                logger.info((Object)("Can not find the permission in your metas " + keyNames[i] + " !"));
                continue;
            }
            list.add(coll.getObject(map.get(keyNames[i])));
        }
        return list;
    }

    private static Map buildMap(PermissionItemCollection coll) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(5000);
        for (PermissionItemInfo info : coll) {
            map.put(info.getName(), new Integer(info.hashCode()));
        }
        return map;
    }

    private static PermItemCollection getPermItemCollection(IMetaDataLoader loader, Locale[] locales, List list) {
        PermItemCollection collection = new PermItemCollection();
        HashMap<String, PermItemInfo> mapPermItem = new HashMap<String, PermItemInfo>(200);
        BOSObjectType bosObjectType = new PermItemInfo().getBOSType();
        for (int i = 0; i < list.size(); ++i) {
            int j;
            PermissionItemInfo info = (PermissionItemInfo)list.get(i);
            String groupName = StringUtils.replace((String)info.getGroupName(), (String)".", (String)"!") + "!" + info.getName();
            String ID = info.getInnerID();
            String number = info.getName();
            String name = info.getName();
            String longNumber = groupName;
            String objectType = null;
            EntityObjectRefInfo entityObjectRefInfo = info.getEntityObjectMetadataRef();
            if (entityObjectRefInfo == null) {
                objectType = null;
            } else {
                try {
                    EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK(entityObjectRefInfo.getEntityMetaInfo().getFullName()));
                    objectType = entity != null && entity.getType() != null ? entity.getType().toString() : null;
                }
                catch (RuntimeException e) {
                    logger.info((Object)"build permItem error!");
                    objectType = null;
                }
            }
            PermItemType type = PermItemType.BIZ_FUNCTION;
            String strPermItemType = info.getExtendedProperty(PERM_ITEM_TYPE);
            if (!StringUtils.isEmpty((String)strPermItemType)) {
                type = PermItemType.getEnum((int)Integer.parseInt(strPermItemType));
            }
            OrgType orgRelation = null;
            String strOrgRelation = info.getExtendedProperty(ORG_RELATION);
            if (!StringUtils.isEmpty((String)strOrgRelation)) {
                orgRelation = FMPermissionUtil.getOrgType(strOrgRelation);
            } else if (StringUtils.isEmpty((String)objectType)) {
                orgRelation = OrgType.NONE;
            } else {
                try {
                    EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)objectType));
                    String strOrgType = entity.getExtendedProperty(ORG_TYPE);
                    orgRelation = !StringUtils.isEmpty((String)strOrgType) ? FMPermissionUtil.getOrgType(strOrgType) : OrgType.NONE;
                }
                catch (RuntimeException e) {
                    logger.info((Object)"build permItem error!");
                    orgRelation = OrgType.NONE;
                }
            }
            String operationType = info.getType();
            boolean enableDataPermission = false;
            String strEnableDataPermission = info.getExtendedProperty(ENABLE_DATA_PERMISSION);
            if (!StringUtils.isEmpty((String)strEnableDataPermission)) {
                enableDataPermission = Boolean.valueOf(strEnableDataPermission);
            }
            PermItemInfo childPermItem = new PermItemInfo();
            childPermItem.setId(BOSUuid.read((String)ID));
            childPermItem.setNumber(number);
            childPermItem.setName(name);
            int length = locales.length;
            for (j = 0; j < length; ++j) {
                childPermItem.setAlias(info.getAlias(locales[j]), locales[j]);
            }
            childPermItem.setLongNumber(longNumber);
            childPermItem.setObjectType(objectType);
            childPermItem.setType(type);
            childPermItem.setOrgRelation(orgRelation);
            childPermItem.setOperationType(OperationType.getEnum((String)operationType));
            childPermItem.setEnableDataPermission(enableDataPermission);
            childPermItem.setParent(null);
            childPermItem.setIsLeaf(true);
            length = locales.length;
            for (j = 0; j < length; ++j) {
                childPermItem.setDescription(info.getDescription(locales[j]), locales[j]);
            }
            if (!mapPermItem.containsKey(longNumber)) {
                mapPermItem.put(longNumber, childPermItem);
            }
            collection.add(childPermItem);
            StringTokenizer tokenizerGroupName = new StringTokenizer(groupName, "!");
            String parentLongNumber = null;
            int step = 0;
            while (tokenizerGroupName.hasMoreTokens()) {
                ++step;
                String tempGroupName = tokenizerGroupName.nextToken();
                parentLongNumber = parentLongNumber == null ? tempGroupName : parentLongNumber + "!" + tempGroupName;
                PermItemInfo parentItem = (PermItemInfo)childPermItem.clone();
                parentItem.setId(BOSUuid.create((BOSObjectType)bosObjectType));
                parentItem.setNumber(tempGroupName);
                parentItem.setName(tempGroupName);
                int length2 = locales.length;
                for (int j2 = 0; j2 < length2; ++j2) {
                    if (StringUtils.isEmpty((String)info.getGroup(locales[j2]))) continue;
                    String tempGroup = StringUtils.replace((String)info.getGroup(locales[j2]), (String)".", (String)"!") + "!" + info.getName();
                    StringTokenizer tokenizerGroup = new StringTokenizer(tempGroup, "!");
                    String tempAlias = null;
                    for (int k = 0; k < step; ++k) {
                        if (!tokenizerGroup.hasMoreTokens()) continue;
                        tempAlias = tokenizerGroup.nextToken();
                    }
                    parentItem.setAlias(tempAlias, locales[j2]);
                }
                parentItem.setLongNumber(parentLongNumber);
                parentItem.setObjectType(null);
                parentItem.setType(PermItemType.INTEGRATION_FUNCTION);
                parentItem.setOrgRelation(OrgType.NONE);
                parentItem.setIsLeaf(false);
                parentItem.setOperationType(OperationType.OTHER);
                parentItem.setEnableDataPermission(false);
                if (mapPermItem.containsKey(parentLongNumber)) continue;
                mapPermItem.put(parentLongNumber, parentItem);
                collection.add(parentItem);
            }
        }
        return collection;
    }

    private static OrgType getOrgType(String str) {
        Iterator iterator = OrgType.iterator();
        while (iterator.hasNext()) {
            OrgType orgType = (OrgType)iterator.next();
            if (!orgType.getName().equalsIgnoreCase(str)) continue;
            return orgType;
        }
        return null;
    }

    public static void printPermissionSql(String[] keyNames) {
        if (keyNames == null || keyNames.length < 1) {
            return;
        }
        MetaDataLoaderFactory.setClientMetaDataPath((String)"W:\\apusic\\metas;W:\\eas\\Server\\server\\metas\\*.jar");
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        Locale[] locales = FMPermissionUtil.getLocales(loader);
        int length = locales.length;
        PermissionInfo permissionInfo = loader.getPermission();
        PermissionItemCollection permissionItems = permissionInfo.getPermissionItems();
        List infos = FMPermissionUtil.getPermissionItemInfos(permissionItems, keyNames);
        PermItemCollection coll = FMPermissionUtil.getPermItemCollection(loader, locales, infos);
        for (int i = 0; i < coll.size(); ++i) {
            int j;
            PermItemInfo info = coll.get(i);
            String ID = info.getId().toString();
            String number = info.getNumber();
            String name = info.getName();
            String longNumber = info.getLongNumber();
            String objectType = info.getObjectType();
            PermItemType permItemType = info.getType();
            OrgType orgRelation = info.getOrgRelation();
            String parentID = info.getParent() == null ? null : info.getParent().getId().toString();
            int isLeaf = info.isIsLeaf() ? 1 : 0;
            OperationType operationType = info.getOperationType();
            boolean enableDataPermission = info.isEnableDataPermission();
            StringBuffer buffer = new StringBuffer();
            buffer.append(" INSERT INTO T_PM_PermItem(FID, FNumber, FName, ");
            for (j = 0; j < length; ++j) {
                buffer.append(MultiLangHelper.getFieldName((String)"FAlias", (Locale)locales[j])).append(", ");
            }
            buffer.append(" FLongNumber, FObjectType, FType, FOrgRelation, FParentID, FIsLeaf, FOperationType, FIsApplyToF7, ");
            for (j = 0; j < length; ++j) {
                if (j == length - 1) {
                    buffer.append(MultiLangHelper.getFieldName((String)"FDescription", (Locale)locales[j])).append(" ");
                    continue;
                }
                buffer.append(MultiLangHelper.getFieldName((String)"FDescription", (Locale)locales[j])).append(", ");
            }
            buffer.append(") VALUES ( ");
            buffer.append(" '").append(ID).append("' , ");
            buffer.append(" N'").append(number).append("' , ");
            buffer.append(" N'").append(name).append("' , ");
            for (j = 0; j < length; ++j) {
                buffer.append(info.getAlias(locales[j]) == null ? null : " N'" + info.getAlias(locales[j]) + "' ").append(", ");
            }
            buffer.append(" N'").append(longNumber).append("' , ");
            buffer.append(objectType == null ? null : " N'" + objectType + "' ").append(" , ");
            buffer.append(" ").append(permItemType.getValue()).append(" , ");
            buffer.append(" ").append(orgRelation.getValue()).append(" , ");
            buffer.append(" ").append(parentID == null ? null : " '" + parentID + "' ").append(" , ");
            buffer.append(" ").append(isLeaf).append(" , ");
            buffer.append(" '").append(operationType.getValue()).append("' , ");
            buffer.append(" ").append(enableDataPermission ? 1 : 0).append(" , ");
            for (j = 0; j < length; ++j) {
                if (j == length - 1) {
                    buffer.append(info.getDescription(locales[j]) == null ? null : " N'" + info.getAlias(locales[j]) + "' ").append(" ");
                    continue;
                }
                buffer.append(info.getDescription(locales[j]) == null ? null : " N'" + info.getAlias(locales[j]) + "' ").append(", ");
            }
            buffer.append(" ); ");
            logger.info((Object)buffer.toString());
        }
    }

    public static void main(String[] args) {
        FMPermissionUtil.printPermissionSql(new String[]{"Cheque_05View", "Cheque_09Verify"});
    }
}

