/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.app.BireportBaseFacadeControllerBean;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class JournalBalanceUtil {
    private JournalBalanceUtil() {
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public static boolean appendFilter(String fieldName, String[] ids, StringBuffer sql, SqlParams sp, String op) {
        if (ids == null || ids.length == 0) {
            return false;
        }
        if (ids.length == 1) {
            sql.append(' ').append(op).append(' ').append(fieldName).append("=?");
            sp.addString(ids[0]);
        } else if (ids.length > 1000) {
            int count = ids.length / 1000;
            int mod = ids.length % 1000;
            if (mod != 0) {
                ++count;
            }
            sql.append(' ').append(op).append(' ').append("(");
            for (int i = 0; i < count; ++i) {
                sql.append(fieldName).append(" in(");
                int size = i == count - 1 ? i * 1000 + mod : i * 1000 + 1000;
                for (int j = 0; j < size; ++j) {
                    sql.append('?');
                    sp.addString(ids[j]);
                    if (j == size - 1) continue;
                    sql.append(',');
                }
                sql.append(')');
                if (i != count - 1) {
                    sql.append(" or ");
                    continue;
                }
                sql.append(") ");
            }
        } else {
            sql.append(' ').append(op).append(' ').append(fieldName).append(" in(");
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                sql.append('?');
                sp.addString(ids[i]);
                if (i == n - 1) continue;
                sql.append(',');
            }
            sql.append(')');
        }
        return true;
    }

    public static boolean appendFilter(String fieldName, Set idSet, StringBuffer sql, SqlParams sp, String op) {
        if (idSet == null || idSet.size() == 0) {
            return false;
        }
        String[] ids = new String[idSet.size()];
        idSet.toArray(ids);
        return JournalBalanceUtil.appendFilter(fieldName, ids, sql, sp, op);
    }

    public static String getFilter(String fieldName, Set idSet, SqlParams sp, String op) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        String[] ids = new String[idSet.size()];
        idSet.toArray(ids);
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        if (ids.length == 1) {
            sql.append(' ').append(op).append(' ').append(fieldName).append("=?");
            sp.addString(ids[0]);
        } else {
            sql.append(' ').append(op).append(' ').append(fieldName).append(" in(");
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                sql.append('?');
                sp.addString(ids[i]);
                if (i == n - 1) continue;
                sql.append(',');
            }
            sql.append(')');
        }
        return sql.toString();
    }

    public static boolean appendCurrencyFilter(String fieldName, List currencyList, StringBuffer sql, SqlParams sp, boolean allForeignCurrency) {
        int size = currencyList.size();
        if (size == 0) {
            return false;
        }
        if (allForeignCurrency) {
            if (size == 1) {
                sql.append(" and ").append(fieldName).append("<>?");
                CurrencyInfo baseCurrency = (CurrencyInfo)currencyList.get(0);
                sp.addString(baseCurrency.getId().toString());
            } else {
                sql.append(" and ").append(fieldName).append(" not in(");
                int n = size;
                for (int i = 0; i < n; ++i) {
                    sql.append('?');
                    if (i != n - 1) {
                        sql.append(',');
                    }
                    sp.addString(((CurrencyInfo)currencyList.get(i)).getId().toString());
                }
                sql.append(')');
            }
            return true;
        }
        String[] ids = new String[size];
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            ids[i] = ((CurrencyInfo)currencyList.get(i)).getId().toString();
        }
        return JournalBalanceUtil.appendFilter(fieldName, ids, sql, sp, "and");
    }

    public static String createJournalBalanceTable(Timestamp toDate, String amountUnit, Set bankIdSet, Set companyIdSet, boolean allForeignCurrency, List currencyList, Context ctx) throws BOSException, SQLDataException {
        String bTempTable = BireportBaseFacadeControllerBean.getTempTableName((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"101_JournalBalanceUtil"), (Context)ctx);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer bsql = new StringBuffer();
        SqlParams bsp = new SqlParams();
        bsql.append("select distinct datediff(dd,B.FEndDate,{ts'").append(sdf.format(toDate)).append("'})*(case when A.FPeriodID=C.FCurrentPeriodID then 30*1000 else 1 end) as mostnear,").append("A.FPeriodID,A.FCompanyID, A.FAccountBankId, A.FCurrencyId,").append(" A.FMonthBalance FmonthDebitAmt, 0 FmonthCreditAmt").append("\n into ").append(bTempTable).append("\n from T_CAS_JournalBalance A").append("\n inner join t_bd_period B on B.FID=A.FPeriodID").append("\n inner join T_BD_SystemStatusCtrol C on C.Fcompanyid=A.FCompanyID").append("\n inner join T_BD_SystemStatus D on D.FID=C.Fsystemstatusid and D.fName=?");
        if (bankIdSet != null && bankIdSet.size() > 0) {
            bsql.append("\n inner join T_BD_AccountBanks E on E.FID=A.FAccountBankID");
        }
        bsql.append("\n where (B.FEndDate<={ts'").append(sdf.format(toDate)).append("'} or (B.FEndDate>{ts'").append(sdf.format(toDate)).append("'} and B.FID=C.Fstartperiodid)) ");
        bsp.addInt(7);
        JournalBalanceUtil.appendFilter("A.FCompanyId", companyIdSet, bsql, bsp, "and");
        bsql.append('\n');
        JournalBalanceUtil.appendCurrencyFilter("A.FCurrencyID", currencyList, bsql, bsp, allForeignCurrency);
        if (bankIdSet != null && bankIdSet.size() > 0) {
            bsql.append('\n');
            JournalBalanceUtil.appendFilter("E.FBank", bankIdSet, bsql, bsp, "and");
        }
        bsql.append(" and A.FTYPE = 2 ");
        BireportBaseFacadeControllerBean.executeSelectInto((String)bsql.toString(), (SqlParams)bsp, (Context)ctx);
        StringBuffer qcSql = new StringBuffer().append("\n    select distinct * from (").append("\n        select C.FBeginDate FEndDate, A.FPeriodID,A.FCompanyID, A.FAccountBankId, A.FCurrencyId, A.FmonthDebitAmt FDebitAmount, A.FmonthCreditAmt FCreditAmount").append("\n        from ").append(bTempTable).append(" A ").append("\n        inner join (").append("\n            select min(mostnear) mostnear, FCompanyID, FAccountBankId, FCurrencyID").append("\n            from ").append(bTempTable).append("\n            group by FCompanyID, FAccountBankId, FCurrencyID").append("\n        ) B on B.mostnear=A.mostnear and B.FCompanyID=A.FCompanyID and B.FAccountBankId=A.FAccountBankId and B.FCurrencyID=A.FCurrencyID").append("\n        inner join T_BD_Period C on C.FID=A.FPeriodID ").append("\n    ) B_INNER");
        StringBuffer innerSql = new StringBuffer();
        innerSql.append("\n\n    select distinct A.FCreateDate, A.FPeriodID, A.FCompanyID, A.FAccountBankId, A.FCurrencyID ,").append(" A.FDebitAmount, A.FCreditAmount").append("\n    from T_CAS_JournalSummary A").append("\n    left join ( ").append(qcSql).append("\n    ) B on B.FCompanyID=A.FCompanyID and B.FAccountBankId=A.FAccountBankId and B.FCurrencyID=A.FCurrencyID").append("\n    where A.FCreateDate<={ts'").append(sdf.format(toDate)).append("'} and (A.FCreateDate>B.FEndDate or B.FEndDate is null)").append("\n union all").append("\n select A.FEndDate FCreateDate, A.FPeriodID, A.FCompanyID, A.FAccountBankId, A.FCurrencyID ,").append("A.FDebitAmount, A.FCreditAmount from ( \n").append(qcSql).append("\n   ) A\n");
        StringBuffer factSql = new StringBuffer();
        StringBuffer factGroup = new StringBuffer();
        SqlParams sp = new SqlParams();
        factSql.append(" select A.FCurrencyId, isNull(F.FConvertRate,1) FConvertRate,").append(" sum(case BB.FProperty when ? then A.FDebitAmount-A.FCreditAmount else 0 end)/").append(amountUnit).append(" FCurrent,").append(" sum(case BB.FProperty when ? then A.FDebitAmount-A.FCreditAmount else 0 end)/").append(amountUnit).append(" FFixed,").append(" sum((A.FDebitAmount-A.FCreditAmount))/").append(amountUnit).append(" FSum");
        sp.addInt(1).addInt(2);
        factGroup.append("\n group by A.FCurrencyID, F.FConvertRate");
        factSql.append(", A.FCompanyID");
        factGroup.append(", A.FCompanyID");
        factSql.append(", B.FBank FBankID");
        factGroup.append(", B.FBank");
        factSql.append("\n from \n(").append(innerSql).append("\n) A");
        factSql.append("\n inner join T_BD_AccountBanks B on B.FID=A.FAccountBankID").append("\n inner join T_BD_AccountProperty BB on BB.FID=B.FPropertyID").append("\n inner join T_Org_Company C on C.FID=A.FCompanyID").append("\n inner join T_BD_ExchangeTable D on D.FID=C.FBaseExgTableID").append("\n left join (").append("\n    select A.FID, A.FSourceCurrencyID, A.FTargetCurrencyID, A.FExchangeTableID, max(B.Favailtime) Favailtime").append("\n    from T_BD_ExchangeAux A").append("\n    inner join T_BD_ExchangeRate B on B.FExchangeAuxID=A.FID").append("\n    group by A.fid, A.FSourceCurrencyID, A.FTargetCurrencyID, A.FExchangeTableID").append("\n ) E on E.FExchangeTableID=D.FID and E.FSourceCurrencyID=A.FCurrencyID and E.FTargetCurrencyID=C.FBaseCurrencyID").append("\n left join T_BD_ExchangeRate F on F.FExchangeAuxID=E.FID and F.Favailtime=E.Favailtime").append("\n where (F.FAvailTime is null or (F.FAvailTime<=A.FCreateDate and F.FInvalidTime>=A.FCreateDate))");
        factSql.append("\n and A.FCreateDate<={ts'").append(sdf.format(toDate)).append("'} ");
        JournalBalanceUtil.appendFilter("A.FCompanyId", companyIdSet, factSql, sp, "and");
        JournalBalanceUtil.appendCurrencyFilter("A.FCurrencyID", currencyList, factSql, sp, allForeignCurrency);
        factSql.append('\n');
        JournalBalanceUtil.appendFilter("B.FBank", bankIdSet, factSql, sp, "and");
        factSql.append(factGroup);
        String factTempTable = BireportBaseFacadeControllerBean.getTempTableName((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"102_JournalBalanceUtil"), (Context)ctx);
        BireportBaseFacadeControllerBean.executeSelectInto((String)("select * into " + factTempTable + " from (" + factSql.toString() + ") TEMP"), (SqlParams)sp, (Context)ctx);
        BireportBaseFacadeControllerBean.dropTempTable((String)bTempTable, (Context)ctx);
        return factTempTable;
    }

    public static String createJournalBalanceTable2(Timestamp toDate, String amountUnit, Set bankIdSet, Set companyIdSet, boolean allForeignCurrency, List currencyList, Context ctx) throws BOSException, SQLDataException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "{ts'" + sdf.format(toDate) + "'}";
        StringBuffer maxPeriodSql = new StringBuffer();
        maxPeriodSql.append("SELECT a.fcompanyid, b.fid fperiodid, b.fbegindate, b.fenddate \n").append("  FROM (SELECT   a.fcompanyid, MAX (b.fbegindate) fbegindate, \n").append("                 MAX (b.fenddate) fenddate \n").append("            FROM t_cas_journalbalance a LEFT OUTER JOIN t_bd_period b \n").append("                 ON a.fperiodid = b.fid \n").append("           WHERE a.ftype = 2 \n").append("             AND (   (    b.fbegindate <= ").append(date).append(" \n").append("                      AND a.fisinit = 0 \n").append("                     ) \n").append("                  OR (    b.fbegindate >= ").append(date).append(" \n").append("                      AND a.fisinit = 1 \n").append("                     ) \n").append("                 ) \n").append("        GROUP BY a.fcompanyid) a \n").append("       LEFT OUTER JOIN t_bd_period b ON a.fbegindate = b.fbegindate \n").append("       LEFT OUTER JOIN t_org_company c ON a.fcompanyid = c.fid \n").append(" WHERE b.ftypeid = c.faccountperiodid \n");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fcurrencyid,fconvertrate,fcompanyid,fbankid, \n").append("\tsum(fcurrent) fcurrent,sum(ffixed) ffixed, sum(fsum) fsum \n").append("  FROM (").append("SELECT a.fcurrencyid, ISNULL(f.fconvertrate, 1) fconvertrate, \n").append("\t\t(CASE BB.FProperty WHEN ? THEN FMonthBalance ELSE 0 END)/").append(amountUnit).append(" FCurrent, \n").append("\t\t(CASE BB.FProperty WHEN ? THEN FMonthBalance ELSE 0 END)/").append(amountUnit).append(" FFixed, \n").append("       a.FMonthBalance / ").append(amountUnit).append(" fsum, \n").append("\t\ta.FCompanyId, b.FBank FBankId \n").append("  FROM (SELECT a.fcompanyid, a.faccountviewid, a.faccountbankid, \n").append("               a.fcurrencyid, a.fmonthstartamt fmonthbalance, a.fperiodid, b.fbegindate, \n").append("               b.fenddate fcreatedate \n").append("          FROM t_cas_journalbalance a \n").append("\t\t\tJOIN ( \n").append(maxPeriodSql).append("\t\t\t\t) b \n").append("\tON a.fcompanyid=b.fcompanyid AND a.fperiodid=b.fperiodid \n").append("         WHERE a.ftype = 2 \n").append("           AND (b.fbegindate <= {ts'").append(sdf.format(toDate)).append("'} AND a.fisinit = 0 \n").append("                OR (b.fbegindate >= {ts'").append(sdf.format(toDate)).append("'} AND a.fisinit = 1 \n").append("                   ) \n").append("               ) \n").append("        UNION ALL \n").append("        SELECT   a.fcompanyid, a.faccountviewid, a.faccountbankid, \n").append("                 a.fcurrencyid, \n").append("                 a.fdebitamount - a.fcreditamount fmonthbalance, \n").append("                 a.fperiodid, b.fbegindate, a.fcreatedate \n").append("            FROM t_cas_journalsummary a \n").append("\t\t\t\t   LEFT JOIN ( \n").append(maxPeriodSql).append("\t\t\t\t   ) b on a.fcompanyid=b.fcompanyid \n").append("           WHERE a.ftype = 2 \n").append("             AND a.fcreatedate <= {ts'").append(sdf.format(toDate)).append("'} \n").append("             AND (a.fcreatedate >= b.fbegindate or b.fbegindate is null )\n").append("\t\t\t  AND not exists (select * from t_cas_journalbalance jb \n").append("\t\t\t\t\tleft join T_BD_SystemStatusCtrol sysStaCtr on sysStaCtr.fcompanyid=jb.fcompanyid \n").append("\t\t\t\t\tleft join T_BD_SystemStatus sysSta on sysStaCtr.FSystemStatusID=sysSta.FID \n").append("\t\t\t\t\twhere a.fcompanyid=jb.fcompanyid and a.fperiodid=jb.fperiodid \n").append("\t\t\t\t\t\tand a.fperiodid<>sysStaCtr.fcurrentperiodid and b.fperiodid<>a.fperiodid and sysSta.FName=7) \n").append("\t\t\t) a \n").append("       INNER JOIN t_bd_accountbanks b ON b.fid = a.faccountbankid \n").append("       INNER JOIN t_bd_accountproperty bb ON bb.fid = b.fpropertyid \n").append("       INNER JOIN t_org_company c ON c.fid = a.fcompanyid \n").append("       INNER JOIN t_bd_exchangetable d ON d.fid = c.fbaseexgtableid \n").append("       LEFT JOIN \n").append("       (SELECT   a.fid, a.fsourcecurrencyid, a.ftargetcurrencyid, \n").append("                 a.fexchangetableid, MAX (b.favailtime) favailtime \n").append("            FROM t_bd_exchangeaux a INNER JOIN t_bd_exchangerate b \n").append("                 ON b.fexchangeauxid = a.fid \n").append("        GROUP BY a.fid, \n").append("                 a.fsourcecurrencyid, \n").append("                 a.ftargetcurrencyid, \n").append("                 a.fexchangetableid) e \n").append("       ON e.fexchangetableid = d.fid \n").append("     AND e.fsourcecurrencyid = a.fcurrencyid \n").append("     AND e.ftargetcurrencyid = c.fbasecurrencyid \n").append("       LEFT JOIN t_bd_exchangerate f \n").append("       ON f.fexchangeauxid = e.fid AND f.favailtime = e.favailtime \n").append(" WHERE (   f.favailtime IS NULL \n").append("        OR (f.favailtime <= a.fcreatedate AND f.finvalidtime >= a.fcreatedate \n").append("           ) \n").append("       )) aa WHERE 1=1 \n");
        SqlParams params = new SqlParams();
        params.addInt(1).addInt(2);
        JournalBalanceUtil.appendFilter("aa.FCompanyId", companyIdSet, sql, params, "and");
        JournalBalanceUtil.appendCurrencyFilter("aa.FCurrencyID", currencyList, sql, params, allForeignCurrency);
        JournalBalanceUtil.appendFilter("aa.fbankid", bankIdSet, sql, params, "and");
        sql.append(" group by aa.fcurrencyid,aa.fconvertrate,aa.fcompanyid,aa.fbankid \n");
        String factTempTable = BireportBaseFacadeControllerBean.getTempTableName((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"102_JournalBalanceUtil"), (Context)ctx);
        BireportBaseFacadeControllerBean.executeSelectInto((String)("select * into " + factTempTable + " from (" + sql.toString() + ") TEMP"), (SqlParams)params, (Context)ctx);
        return factTempTable;
    }

    public static String createJournalBalanceTable3(Timestamp toDate, String amountUnit, Set bankIdSet, Set companyIdSet, boolean allForeignCurrency, List currencyList, Context ctx) throws EASBizException, BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("{yyyy-MM-dd}");
        String bTempTable = BireportBaseFacadeControllerBean.getTempTableName((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"101_JournalBalanceUtil"), (Context)ctx);
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        sql.append("select AA.FCurrencyID, AA.FCompanyID,AA.FBankID, \n");
        sql.append("isNull(F.FConvertRate,1) as FConvertRate, \n");
        sql.append("case when FPropertyID = 1 then FBalance/" + amountUnit + " else 0 end as FCurrent, \n");
        sql.append("case when FPropertyID = 2 then FBalance/" + amountUnit + " else 0 end as FFixed, \n");
        sql.append("FBalance/" + amountUnit + " as FSum from \n");
        sql.append("( \n");
        sql.append("select J.FCompanyID as FCompanyID, \n");
        sql.append("J.FCurrencyID as FCurrencyID,\n");
        sql.append("A.FBank as FBankID, \n");
        sql.append("B.FProperty as FPropertyID, \n");
        sql.append("Sum(J.FDebitAmount - J.FCreditAmount) as FBalance \n");
        sql.append("from T_CAS_JournalSummary as J \n");
        sql.append("inner join T_BD_AccountBanks  as A \n");
        sql.append("on J.FAccountBankID = A.FID \n");
        sql.append("inner join T_BD_Bank as T \n");
        sql.append("on T.FID = A.FBank \n");
        sql.append("inner join T_BD_AccountProperty B \n");
        sql.append("on B.FID = A.FPropertyID \n");
        sql.append("where \n");
        sql.append("J.FType = 2 \n");
        sql.append("and ( B.FProperty = 1 or B.FProperty = 2) \n");
        sql.append("and J.FCreateDate <= ");
        sql.append(sdf.format(toDate));
        sql.append("\n");
        JournalBalanceUtil.appendFilter("J.FCompanyID", companyIdSet, sql, sp, "and");
        JournalBalanceUtil.appendCurrencyFilter("J.FCurrencyID", currencyList, sql, sp, allForeignCurrency);
        JournalBalanceUtil.appendFilter("A.FBank", bankIdSet, sql, sp, "and");
        sql.append("group by J.FCurrencyID,J.FCompanyID,A.FBank,B.FProperty \n");
        sql.append(") as AA \n");
        sql.append("inner join T_ORG_Company C ");
        sql.append("on C.FID = AA.FCompanyID ");
        sql.append("inner join T_BD_ExchangeTable D ");
        sql.append("on D.FID = C.FBaseExgTableID ");
        sql.append("left join ( ");
        sql.append("select A.FID, A.FSourceCurrencyID, A.FTargetCurrencyID, A.FExchangeTableID, max(B.Favailtime) Favailtime ");
        sql.append("from T_BD_ExchangeAux A ");
        sql.append("inner join T_BD_ExchangeRate B on B.FExchangeAuxID=A.FID ");
        sql.append("group by A.fid, A.FSourceCurrencyID, A.FTargetCurrencyID, A.FExchangeTableID ");
        sql.append(") E ");
        sql.append("on E.FExchangeTableID = D.FID and E.FSourceCurrencyID = AA.FCurrencyID and E.FTargetCurrencyID = C.FBaseCurrencyID ");
        sql.append("left join T_BD_ExchangeRate F  ");
        sql.append("on F.FExchangeAuxID=E.FID and F.Favailtime=E.Favailtime ");
        String factTempTable = BireportBaseFacadeControllerBean.getTempTableName((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"102_JournalBalanceUtil"), (Context)ctx);
        BireportBaseFacadeControllerBean.executeSelectInto((String)("select * into " + factTempTable + " from (" + sql.toString() + ") TEMP"), (SqlParams)sp, (Context)ctx);
        BireportBaseFacadeControllerBean.dropTempTable((String)bTempTable, (Context)ctx);
        return factTempTable;
    }

    public static String createJournalBalanceTable4(Timestamp toDate, String amountUnit, Set bankIdSet, Set companyIdSet, boolean allForeignCurrency, List currencyList, Context ctx) throws BOSException, SQLDataException, EASBizException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "{ts'" + sdf.format(toDate) + "'}";
        StringBuffer maxPeriodSql = new StringBuffer();
        maxPeriodSql.append("SELECT a.fcompanyid, b.fid fperiodid, b.fbegindate, b.fenddate \n").append("  FROM (SELECT   a.fcompanyid, MAX (b.fbegindate) fbegindate, \n").append("                 MAX (b.fenddate) fenddate \n").append("            FROM t_cas_journalbalance a LEFT OUTER JOIN t_bd_period b \n").append("                 ON a.fperiodid = b.fid \n").append("           WHERE a.ftype = 2 \n").append("             AND (   (    b.fbegindate <= ").append(date).append(" \n").append("                      AND a.fisinit = 0 \n").append("                     ) \n").append("                  OR (    b.fbegindate >= ").append(date).append(" \n").append("                      AND a.fisinit = 1 \n").append("                     ) \n").append("                 ) \n").append("        GROUP BY a.fcompanyid) a \n").append("       LEFT OUTER JOIN t_bd_period b ON a.fbegindate = b.fbegindate \n").append("       LEFT OUTER JOIN t_org_company c ON a.fcompanyid = c.fid \n").append(" WHERE b.ftypeid = c.faccountperiodid \n");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT fcurrencyid,fconvertrate,fcompanyid,fbankid, \n").append("\tsum(fcurrent) fcurrent,sum(ffixed) ffixed, sum(fsum) fsum \n").append("  FROM (").append("SELECT a.fcurrencyid, ISNULL(f.fconvertrate, 1) fconvertrate, \n").append("\t\t(CASE BB.FProperty WHEN ? THEN FMonthBalance ELSE 0 END)/").append(amountUnit).append(" FCurrent, \n").append("\t\t(CASE BB.FProperty WHEN ? THEN FMonthBalance ELSE 0 END)/").append(amountUnit).append(" FFixed, \n").append("       a.FMonthBalance / ").append(amountUnit).append(" fsum, \n").append("\t\ta.FCompanyId, b.FBank FBankId \n").append("  FROM (SELECT a.fcompanyid, a.faccountviewid, a.faccountbankid, \n").append("               a.fcurrencyid, a.fmonthstartamt fmonthbalance, a.fperiodid, b.fbegindate, \n").append("               b.fenddate fcreatedate \n").append("          FROM t_cas_journalbalance a \n").append("\t\t\tJOIN ( \n").append(maxPeriodSql).append("\t\t\t\t) b \n").append("\tON a.fcompanyid=b.fcompanyid AND a.fperiodid=b.fperiodid \n").append("         WHERE a.ftype = 2 \n").append("           AND (b.fbegindate <= {ts'").append(sdf.format(toDate)).append("'} AND a.fisinit = 0 \n").append("                OR (b.fbegindate >= {ts'").append(sdf.format(toDate)).append("'} AND a.fisinit = 1 \n").append("                   ) \n").append("               ) \n").append("        UNION ALL \n").append("        SELECT   a.fcompanyid, a.faccountviewid, a.faccountbankid, \n").append("                 a.fcurrencyid, \n").append("                 a.fdebitamount - a.fcreditamount fmonthbalance, \n").append("                 a.fperiodid, b.fbegindate, a.fcreatedate \n").append("            FROM t_cas_journalsummary a \n").append("\t\t\t\t   LEFT JOIN ( \n").append(maxPeriodSql).append("\t\t\t\t   ) b on a.fcompanyid=b.fcompanyid \n").append("           WHERE a.ftype = 2 \n").append("             AND a.fcreatedate <= {ts'").append(sdf.format(toDate)).append("'} \n").append("             AND (a.fcreatedate >= b.fbegindate or b.fbegindate is null )\n").append("\t\t\t  AND not exists (select * from t_cas_journalbalance jb \n").append("\t\t\t\t\tleft join T_BD_SystemStatusCtrol sysStaCtr on sysStaCtr.fcompanyid=jb.fcompanyid \n").append("\t\t\t\t\tleft join T_BD_SystemStatus sysSta on sysStaCtr.FSystemStatusID=sysSta.FID \n").append("\t\t\t\t\twhere a.fcompanyid=jb.fcompanyid and a.fperiodid=jb.fperiodid \n").append("\t\t\t\t\t\tand a.fperiodid<>sysStaCtr.fcurrentperiodid and b.fperiodid<>a.fperiodid and sysSta.FName=7) \n").append("\t\t\t) a \n").append("       INNER JOIN t_bd_accountbanks b ON b.fid = a.faccountbankid \n").append("       INNER JOIN t_bd_accountproperty bb ON bb.fid = b.fpropertyid \n").append("       INNER JOIN t_org_company c ON c.fid = a.fcompanyid \n").append("       INNER JOIN t_bd_exchangetable d ON d.fid = c.fbaseexgtableid \n").append("       LEFT JOIN \n").append("       (SELECT   a.fid, a.fsourcecurrencyid, a.ftargetcurrencyid, \n").append("                 a.fexchangetableid, MAX (b.favailtime) favailtime \n").append("            FROM t_bd_exchangeaux a INNER JOIN t_bd_exchangerate b \n").append("                 ON b.fexchangeauxid = a.fid \n").append("        GROUP BY a.fid, \n").append("                 a.fsourcecurrencyid, \n").append("                 a.ftargetcurrencyid, \n").append("                 a.fexchangetableid) e \n").append("       ON e.fexchangetableid = d.fid \n").append("     AND e.fsourcecurrencyid = a.fcurrencyid \n").append("     AND e.ftargetcurrencyid = c.fbasecurrencyid \n").append("       LEFT JOIN t_bd_exchangerate f \n").append("       ON f.fexchangeauxid = e.fid AND f.favailtime = e.favailtime \n").append(" ) aa WHERE 1=1 \n");
        SqlParams params = new SqlParams();
        params.addInt(1).addInt(2);
        String temp1 = JournalBalanceUtil.appendFilterForTempTable(ctx, "aa.FCompanyId", companyIdSet, sql, params, "and");
        String temp2 = JournalBalanceUtil.appendCurrencyFilterForTempTable(ctx, "aa.FCurrencyID", currencyList, sql, params, allForeignCurrency);
        String temp3 = JournalBalanceUtil.appendFilterForTempTable(ctx, "aa.fbankid", bankIdSet, sql, params, "and");
        sql.append(" group by aa.fcurrencyid,aa.fconvertrate,aa.fcompanyid,aa.fbankid \n");
        String factTempTable = BireportBaseFacadeControllerBean.getTempTableName((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"102_JournalBalanceUtil"), (Context)ctx);
        BireportBaseFacadeControllerBean.executeSelectInto((String)("select * into " + factTempTable + " from (" + sql.toString() + ") TEMP"), (SqlParams)params, (Context)ctx);
        if (temp1 != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(temp1);
        }
        if (temp2 != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(temp2);
        }
        if (temp3 != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(temp3);
        }
        return factTempTable;
    }

    public static String appendFilterForTempTable(Context ctx, String fieldName, Set idSet, StringBuffer sql, SqlParams sp, String op) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        String[] ids = new String[idSet.size()];
        idSet.toArray(ids);
        return JournalBalanceUtil.appendFilterForTempTable(ctx, fieldName, ids, sql, sp, op);
    }

    public static String appendFilterForTempTable(Context ctx, String fieldName, String[] ids, StringBuffer sql, SqlParams sp, String op) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        String tempTableName = null;
        if (ids.length == 1) {
            sql.append(' ').append(op).append(' ').append(fieldName).append("=?");
            sp.addString(ids[0]);
        } else if (ids.length > 500) {
            tempTableName = JournalBalanceUtil.createTempTable(ctx);
            StringBuffer sb = new StringBuffer();
            sb.append("insert into ").append(tempTableName).append(" values (?)");
            ArrayList<String[]> paramsList = new ArrayList<String[]>(ids.length);
            for (int i = 0; i < ids.length; ++i) {
                String[] arr = new String[]{ids[i]};
                paramsList.add(arr);
            }
            DbUtil.executeBatch((Context)ctx, (String)sb.toString(), paramsList);
            sql.append(' ').append(op).append(' ').append(fieldName).append(" in (select * from ").append(tempTableName).append(")");
        } else {
            sql.append(' ').append(op).append(' ').append(fieldName).append(" in(");
            int n = ids.length;
            for (int i = 0; i < n; ++i) {
                sql.append('?');
                sp.addString(ids[i]);
                if (i == n - 1) continue;
                sql.append(',');
            }
            sql.append(')');
        }
        return tempTableName;
    }

    private static String createTempTable(Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tableName = null;
        sql.append(" create table tempTableName(fid varchar(44))");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tableName = pool.createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    public static String appendCurrencyFilterForTempTable(Context ctx, String fieldName, List currencyList, StringBuffer sql, SqlParams sp, boolean allForeignCurrency) throws EASBizException, BOSException {
        int size = currencyList.size();
        if (size == 0) {
            return null;
        }
        if (allForeignCurrency) {
            if (size == 1) {
                sql.append(" and ").append(fieldName).append("<>?");
                CurrencyInfo baseCurrency = (CurrencyInfo)currencyList.get(0);
                sp.addString(baseCurrency.getId().toString());
            } else {
                sql.append(" and ").append(fieldName).append(" not in(");
                int n = size;
                for (int i = 0; i < n; ++i) {
                    sql.append('?');
                    if (i != n - 1) {
                        sql.append(',');
                    }
                    sp.addString(((CurrencyInfo)currencyList.get(i)).getId().toString());
                }
                sql.append(')');
            }
            return null;
        }
        String[] ids = new String[size];
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            ids[i] = ((CurrencyInfo)currencyList.get(i)).getId().toString();
        }
        return JournalBalanceUtil.appendFilterForTempTable(ctx, fieldName, ids, sql, sp, "and");
    }
}

