/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fm.common.util.CellData;
import com.kingdee.eas.fm.common.util.SingleRow;
import com.kingdee.eas.fm.common.util.TableSnapShot;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiKDTableSnapShot
implements TableSnapShot {
    private String[] titleKeys;
    private SingleRow[] rowList;
    private Map tableMap;
    private String[] headTitles;
    private UserDefineColumnCollection udcc;

    public MultiKDTableSnapShot(Map tables, UserDefineColumnCollection udcc) {
        this.tableMap = tables;
        this.udcc = udcc;
    }

    public void init() {
        this.initArraySize();
        this.initIitleKeysValue();
        this.initRowList();
    }

    private void initRowList() {
        if (this.rowList.length == 0) {
            this.genBlackRecord();
        } else {
            this.genRecordAccordingTable();
        }
    }

    private void genRecordAccordingTable() {
        for (int i = 0; i < this.rowList.length; ++i) {
            Iterator it = this.tableMap.keySet().iterator();
            int position = 0;
            CellData[] cells = new CellData[this.titleKeys.length];
            while (it.hasNext()) {
                String key = it.next().toString();
                KDTable tblMainTmp = (KDTable)this.tableMap.get(key);
                int tableRowCount = tblMainTmp.getRowCount();
                if (tableRowCount <= i) {
                    this.fillBlank(tblMainTmp, position, cells);
                } else {
                    this.fillValue(tblMainTmp, tblMainTmp.getRow(i), position, cells);
                }
                position += tblMainTmp.getColumnCount();
            }
            this.assembleUserDefineColumnValue(position, cells);
            this.rowList[i] = new SingleRow(cells);
        }
    }

    private void genBlackRecord() {
        Iterator it = this.tableMap.keySet().iterator();
        int position = 0;
        CellData[] cells = new CellData[this.titleKeys.length];
        while (it.hasNext()) {
            String key = it.next().toString();
            KDTable tblMainTmp = (KDTable)this.tableMap.get(key);
            this.fillBlank(tblMainTmp, position, cells);
            position += tblMainTmp.getColumnCount();
        }
        this.assembleUserDefineColumnValue(position, cells);
        this.rowList[0] = new SingleRow(cells);
    }

    private void assembleUserDefineColumnValue(int position, CellData[] cells) {
        int userDefineColumnCount = this.udcc.size();
        for (int n = 0; n < userDefineColumnCount; ++n) {
            CellData cd;
            UserDefineColumnInfo uudi = this.udcc.getIndex(n);
            cells[n + position] = cd = new CellData(uudi.getColumnValue(), String.class, null, uudi.getName(), uudi.getName());
        }
    }

    private void fillValue(KDTable tblMainTmp, IRow rowData, int position, CellData[] cells) {
        Class cls = null;
        int colunmCount = tblMainTmp.getColumnCount();
        for (int m = 0; m < colunmCount; ++m) {
            CellData cd;
            String columnKey = this.titleKeys[m + position].substring(this.titleKeys[m + position].indexOf(".") + 1);
            Object cellValue = rowData.getCell(columnKey).getValue();
            if (cellValue != null && cellValue instanceof Boolean) {
                Boolean b = (Boolean)cellValue;
                cellValue = b != false ? EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"112_KDTableSnapShot") : EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"113_KDTableSnapShot");
            }
            cells[m + position] = cd = new CellData(cellValue, cls, null, this.titleKeys[m + position], this.titleKeys[m + position]);
        }
    }

    private void fillBlank(KDTable tblMainTmp, int position, CellData[] cells) {
        Class cls = null;
        int colunmCount = tblMainTmp.getColumnCount();
        for (int m = 0; m < colunmCount; ++m) {
            CellData cd;
            cells[m + position] = cd = new CellData("", cls, null, this.titleKeys[m + position], this.titleKeys[m + position]);
        }
    }

    private void initIitleKeysValue() {
        Iterator it = this.tableMap.keySet().iterator();
        int position = 0;
        while (it.hasNext()) {
            String key = it.next().toString();
            KDTable tblMainTmp = (KDTable)this.tableMap.get(key);
            this.assembleTableColumn(key, tblMainTmp, position);
            position += tblMainTmp.getColumnCount();
        }
        this.assembleUserDefineColumn(position);
    }

    private void assembleUserDefineColumn(int position) {
        for (int i = 0; i < this.udcc.size(); ++i) {
            UserDefineColumnInfo uudi = this.udcc.getIndex(i);
            this.titleKeys[i + position] = uudi.getName();
            this.headTitles[position + i] = uudi.getAlias();
        }
    }

    private void assembleTableColumn(String tableAlias, KDTable tblMainTmp, int position) {
        KDTColumns kdcs = tblMainTmp.getColumns();
        List columnList = kdcs.getColumns();
        int size = columnList.size();
        for (int i = 0; i < size; ++i) {
            KDTColumn columnS = (KDTColumn)columnList.get(i);
            this.titleKeys[position + i] = tableAlias + "." + columnS.getKey();
            this.headTitles[position + i] = tableAlias + "." + columnS.getKey();
        }
    }

    private void initArraySize() {
        Iterator it = this.tableMap.keySet().iterator();
        int rowCount = 0;
        int columnCount = 0;
        while (it.hasNext()) {
            String key = it.next().toString();
            KDTable tblMainTmp = (KDTable)this.tableMap.get(key);
            int tblRowCount = tblMainTmp.getRowCount();
            columnCount += tblMainTmp.getColumnCount();
            if (tblRowCount < rowCount) continue;
            rowCount = tblRowCount;
        }
        this.rowList = new SingleRow[rowCount];
        this.titleKeys = new String[columnCount + this.udcc.size()];
        this.headTitles = new String[columnCount + this.udcc.size()];
        if (rowCount == 0) {
            this.rowList = new SingleRow[1];
        }
    }

    @Override
    public String[] getTitleKeys() {
        return this.titleKeys;
    }

    @Override
    public SingleRow[] getRowList() {
        return this.rowList;
    }

    @Override
    public String[] getHeadTitles() {
        return this.headTitles;
    }
}

