/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeFactory;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeInfo;
import com.kingdee.eas.fm.fs.ISubsidiaryBookProvider;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class FeeForGuaranteeSubsidiaryBookProvider
implements ISubsidiaryBookProvider {
    public SubsidiaryLedgerCollection getCollection(Context ctx, String billId) throws BOSException, EASBizException {
        FeeForGuaranteeInfo feeInfo = this.getFeeForGuaranteeInfo(ctx, billId);
        SubsidiaryLedgerCollection coll = new SubsidiaryLedgerCollection();
        SubsidiaryLedgerInfo slInfo1 = this.createBaseLedger(ctx, feeInfo);
        slInfo1.setInnerAccount(feeInfo.getInnerAccount());
        slInfo1.setApplyUnit(feeInfo.getCompany());
        slInfo1.setCreditAmount(feeInfo.getMoneyAmount());
        slInfo1.setLocalAmount(feeInfo.getSxfzbwb());
        coll.add(slInfo1);
        return coll;
    }

    private FeeForGuaranteeInfo getFeeForGuaranteeInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return FeeForGuaranteeFactory.getLocalInstance(ctx).getFeeForGuaranteeInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        return sic;
    }

    private SubsidiaryLedgerInfo createBaseLedger(Context ctx, FeeForGuaranteeInfo feeInfo) throws BOSException {
        SubsidiaryLedgerInfo slInfo = new SubsidiaryLedgerInfo();
        slInfo.setDate(FeeForGuaranteeFactory.getLocalInstance(ctx).getNewDate());
        slInfo.setCurrency(feeInfo.getCurrency());
        slInfo.setBillId(feeInfo.getId());
        slInfo.setBillNumber(feeInfo.getNumber());
        slInfo.setExchangeRate(feeInfo.getLocalExRate());
        slInfo.setIsDownLoad(false);
        slInfo.setBookkeeper(feeInfo.getCreator());
        slInfo.setDescription(feeInfo.getDescription());
        slInfo.setBizType(SubsidiaryBillTypeEnum.FEEBILL);
        slInfo.setCompany(feeInfo.getCompany());
        String des = "";
        if (ctx != null) {
            des = ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"134_FeeForGuaranteeBookNotifyBuilder", (Locale)ctx.getLocale());
        }
        slInfo.setDescription(des);
        return slInfo;
    }
}

