/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondReleasePlanInfo;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.bond.CashSettleFactory;
import com.kingdee.eas.fm.bond.CashSettleInfo;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IEJBAccess;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillUsedFactory;
import com.kingdee.eas.fm.ctl.AssureBillUsedInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.app.AbstractAssureBillManagerFacadeControllerBean;
import com.kingdee.eas.fm.fin.BillTypeEnum;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.RevokeStatusEnum;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayDetailInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayFactory;
import com.kingdee.eas.fm.sl.LoanContractRepayInfo;
import com.kingdee.eas.fm.sl.LoanFetchCollection;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class AssureBillManagerFacadeControllerBean
extends AbstractAssureBillManagerFacadeControllerBean {
    @Override
    protected void _useAssure(Context ctx, BOSUuid assureBillId, BOSUuid companyId, BigDecimal amount, BOSUuid finBillId) throws BOSException, EASBizException {
        FinancingBillInfo finBillInfo = (FinancingBillInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId.toString());
        for (GuaranteeDetailInfo element : finBillInfo.getGuaranteeEntrys()) {
            AssureBillUsedInfo newUsedInfo;
            AssureBillInfo assInfo;
            if (element.getBillId() == null || element.getBilltype() != GuanTypeBillEnum.AssureBill) continue;
            BigDecimal bizBalanceLocalDelta = amount.multiply(element.getExchangeRate()).multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4));
            BigDecimal bizLocal = bizBalanceLocalDelta.multiply((assInfo = AssureBillFactory.getLocalInstance(ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))).getExRate()).add(assInfo.getBizLocalBalance());
            if (Constants.MAX_VALUE.compareTo(bizLocal) <= 0) {
                throw new FMException(FMException.VALUEOVERFLOW, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"4_AssureBillManagerFacadeControllerBean", (Locale)ctx.getLocale())});
            }
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FBizLocalBalance=?\n where FId=?", (Object[])new Object[]{bizLocal, assInfo.getId().toString()});
            this.updateAssureResAmount(ctx, assInfo.getId().toString());
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("finbillId", (Object)finBillInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("assureBillId", (Object)assInfo.getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("returnedAmount", (Object)Constants.ZERO, CompareType.GREATER));
            boolean alreadyReturn = AssureBillUsedFactory.getLocalInstance(ctx).exists(filterInfo);
            if (BillTypeEnum.LOAN.equals((Object)this.getBillType(finBillInfo))) {
                DbUtil.execute((Context)ctx, (String)"delete from T_CTL_AssureBillUsed where FFinBillId=? and FAssureBillId=? ", (Object[])new Object[]{finBillInfo.getId().toString(), assInfo.getId().toString()});
                newUsedInfo = new AssureBillUsedInfo();
                newUsedInfo.setAssureBillId(assInfo.getId().toString());
                newUsedInfo.setFinbillId(finBillInfo.getId().toString());
                newUsedInfo.setFinbillNumber(finBillInfo.getNumber());
                newUsedInfo.setBillType(finBillInfo.getBOSType().toString());
                newUsedInfo.setCompanyAssured(finBillInfo.getCompany());
                newUsedInfo.setUsedAssAmount(finBillInfo.getAmount().multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4)).multiply(element.getExchangeRate()));
                newUsedInfo.setAssureBeginDate(finBillInfo.getIssueDate());
                newUsedInfo.setAssureEndDate(finBillInfo.getExpiredDate());
                newUsedInfo.setAssBalance(finBillInfo.getBalance().multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4)).multiply(element.getExchangeRate()));
                newUsedInfo.setReturnedAmount(newUsedInfo.getUsedAssAmount().subtract(newUsedInfo.getAssBalance()));
                newUsedInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
                newUsedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
                newUsedInfo.setLastUpdateTime(DateUtil.getTimeStampDayBegin());
                newUsedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
                AssureBillUsedFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)newUsedInfo);
                continue;
            }
            if (alreadyReturn) {
                DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBillUsed set FAssBalance=?-FReturnedAmount where FfinbillId=? and FassureBillId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(assInfo.getExRate()), finBillInfo.getId().toString(), assInfo.getId().toString()});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)"delete from T_CTL_AssureBillUsed where FFinBillId=? and FAssureBillId=? ", (Object[])new Object[]{finBillInfo.getId().toString(), assInfo.getId().toString()});
            newUsedInfo = new AssureBillUsedInfo();
            newUsedInfo.setAssureBillId(assInfo.getId().toString());
            newUsedInfo.setFinbillId(finBillInfo.getId().toString());
            newUsedInfo.setFinbillNumber(finBillInfo.getNumber());
            newUsedInfo.setBillType(finBillInfo.getBOSType().toString());
            newUsedInfo.setCompanyAssured(finBillInfo.getCompany());
            if (finBillInfo.isHistoryBill() && new LoanInfo().getBOSType().toString().equals(finBillInfo.getId().getType().toString()) && finBillInfo.getBalance() != null) {
                newUsedInfo.setUsedAssAmount(finBillInfo.getBalance().multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4)).multiply(element.getExchangeRate()));
            } else {
                newUsedInfo.setUsedAssAmount(finBillInfo.getAmount().multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4)).multiply(element.getExchangeRate()));
            }
            newUsedInfo.setAssureBeginDate(finBillInfo.getIssueDate());
            newUsedInfo.setAssureEndDate(finBillInfo.getExpiredDate());
            newUsedInfo.setAssBalance(finBillInfo.getBalance().multiply(assInfo.getExRate()));
            newUsedInfo.setReturnedAmount(Constants.ZERO);
            newUsedInfo.setCreateTime(DateUtil.getTimeStampDayBegin());
            newUsedInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
            newUsedInfo.setLastUpdateTime(DateUtil.getTimeStampDayBegin());
            newUsedInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
            AssureBillUsedFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)newUsedInfo);
        }
    }

    private BigDecimal getAmount(FinancingBillInfo info) {
        if (info.getId().getType().equals((Object)new PayableBillInfo().getBOSType())) {
            PayableBillInfo commInfo = (PayableBillInfo)info;
            return commInfo.getAmount().subtract(commInfo.getAssureAmount());
        }
        if (BillTypeEnum.LOAN.equals((Object)this.getBillType(info))) {
            return info.getBalance();
        }
        return info.getAmount();
    }

    @Override
    protected void _cancelAssure(Context ctx, BOSUuid finBillId) throws BOSException, EASBizException {
        IEJBAccess ejbAccessor = EJBAccessFactory.createLocalInstance((Context)ctx);
        FinancingBillInfo finBillInfo = (FinancingBillInfo)ejbAccessor.getEntityInfo(finBillId.toString());
        for (GuaranteeDetailInfo element : finBillInfo.getGuaranteeEntrys()) {
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null) continue;
            AssureBillInfo aInfo = (AssureBillInfo)ejbAccessor.getEntityInfo(element.getBillId());
            BigDecimal bizBalanceLocalDelta = this.getAmount(finBillInfo).multiply(element.getExchangeRate()).multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4));
            if (!RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus())) {
                DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FBizLocalBalance=FBizLocalBalance-?\n where FId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(aInfo.getExRate()), element.getBillId()});
            }
            this.updateAssureResAmount(ctx, element.getBillId());
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("finbillId", (Object)finBillId));
            filterInfo.getFilterItems().add(new FilterItemInfo("assureBillId", (Object)element.getBillId()));
            filterInfo.getFilterItems().add(new FilterItemInfo("returnedAmount", (Object)Constants.ZERO, CompareType.GREATER));
            boolean alreadyReturn = AssureBillUsedFactory.getLocalInstance(ctx).exists(filterInfo);
            if (alreadyReturn) {
                DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBillUsed set FUsedAssAmount=?,FAssBalance=?-FReturnedAmount where FFinbillId=? and FAssureBillId=?", (Object[])new Object[]{bizBalanceLocalDelta, bizBalanceLocalDelta, finBillId.toString(), element.getBillId()});
                continue;
            }
            DbUtil.execute((Context)ctx, (String)"delete from T_CTL_AssureBillUsed where FFinbillId=? and FAssureBillId=?", (Object[])new Object[]{finBillId.toString(), element.getBillId()});
        }
    }

    @Override
    protected void _returnAssure(Context ctx, BOSUuid repayBillId) throws BOSException, EASBizException {
        if (repayBillId.getType().equals((Object)new RepaymentInfo().getBOSType())) {
            RepaymentInfo repayInfo = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repayBillId));
            String finBillId = repayInfo.getSourceBillId();
            BigDecimal repayAmount = repayInfo.getAmount();
            this.returnAssure(ctx, finBillId, repayAmount);
        } else if (repayBillId.getType().equals((Object)new LoanContractRepayInfo().getBOSType())) {
            LoanContractRepayInfo repayInfo = LoanContractRepayFactory.getLocalInstance((Context)ctx).getLoanContractRepayInfo((IObjectPK)new ObjectUuidPK(repayBillId));
            HashSet<String> numSet = new HashSet<String>();
            HashMap<String, BigDecimal> AmountMap = new HashMap<String, BigDecimal>();
            for (int i = 0; i < repayInfo.getRepayContractDetail().size(); ++i) {
                LoanContractRepayDetailInfo info = repayInfo.getRepayContractDetail().get(i);
                numSet.add(info.getFetchLoanNm());
                AmountMap.put(info.getFetchLoanNm(), info.getRepayAmt());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
            LoanFetchCollection colls = LoanFetchFactory.getLocalInstance((Context)ctx).getLoanFetchCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                LoanFetchInfo fetchInfo = colls.get(i);
                if (fetchInfo.isHistoryBill()) continue;
                String finBillId = fetchInfo.getId().toString();
                BigDecimal repayAmount = (BigDecimal)AmountMap.get(fetchInfo.getNumber());
                this.returnAssure(ctx, finBillId, repayAmount);
            }
        } else if (repayBillId.getType().equals((Object)new CashSettleInfo().getBOSType())) {
            CashSettleInfo repayInfo = CashSettleFactory.getLocalInstance((Context)ctx).getCashSettleInfo((IObjectPK)new ObjectUuidPK(repayBillId));
            String finBillId = repayInfo.getSourceBillId();
            BigDecimal repayAmount = repayInfo.getAmount();
            this.returnAssure(ctx, finBillId, repayAmount);
        }
    }

    private void returnAssure(Context ctx, String finBillId, BigDecimal repayAmount) throws EASBizException, BOSException {
        FinancingBillInfo finBillInfo = (FinancingBillInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId);
        if (finBillInfo == null) {
            return;
        }
        for (GuaranteeDetailInfo element : finBillInfo.getGuaranteeEntrys()) {
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null) continue;
            AssureBillInfo assInfo = AssureBillFactory.getLocalInstance(ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()));
            BigDecimal bizBalanceLocalDelta = repayAmount.multiply(element.getExchangeRate()).multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4));
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBillUsed set FReturnedAmount=FReturnedAmount+?,FAssBalance=FAssBalance-? where FFinbillId=? and FAssureBillId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(assInfo.getExRate()), bizBalanceLocalDelta.multiply(assInfo.getExRate()), finBillId, assInfo.getId().toString()});
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FBizLocalBalance=FBizLocalBalance-?\n where FId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(assInfo.getExRate()), assInfo.getId().toString()});
            this.updateAssureResAmount(ctx, assInfo.getId().toString());
        }
    }

    @Override
    protected void _cancelReturnAssure(Context ctx, BOSUuid repayId) throws BOSException, EASBizException {
        if (repayId.getType().equals((Object)new RepaymentInfo().getBOSType())) {
            RepaymentInfo repayInfo = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repayId));
            String finBillId = repayInfo.getSourceBillId();
            BigDecimal repayAmount = repayInfo.getAmount();
            this.cancelReturnAssure(ctx, finBillId, repayAmount);
        } else if (repayId.getType().equals((Object)new LoanContractRepayInfo().getBOSType())) {
            LoanContractRepayInfo repayInfo = LoanContractRepayFactory.getLocalInstance((Context)ctx).getLoanContractRepayInfo((IObjectPK)new ObjectUuidPK(repayId));
            HashSet<String> numSet = new HashSet<String>();
            HashMap<String, BigDecimal> AmountMap = new HashMap<String, BigDecimal>();
            for (int i = 0; i < repayInfo.getRepayContractDetail().size(); ++i) {
                LoanContractRepayDetailInfo info = repayInfo.getRepayContractDetail().get(i);
                numSet.add(info.getFetchLoanNm());
                AmountMap.put(info.getFetchLoanNm(), info.getRepayAmt());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
            LoanFetchCollection colls = LoanFetchFactory.getLocalInstance((Context)ctx).getLoanFetchCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                LoanFetchInfo fetchInfo = colls.get(i);
                if (fetchInfo.isHistoryBill()) continue;
                String finBillId = fetchInfo.getId().toString();
                BigDecimal repayAmount = (BigDecimal)AmountMap.get(fetchInfo.getNumber());
                this.cancelReturnAssure(ctx, finBillId, repayAmount);
            }
        } else if (repayId.getType().equals((Object)new CashSettleInfo().getBOSType())) {
            CashSettleInfo repayInfo = CashSettleFactory.getLocalInstance((Context)ctx).getCashSettleInfo((IObjectPK)new ObjectUuidPK(repayId));
            String finBillId = repayInfo.getSourceBillId();
            BigDecimal repayAmount = repayInfo.getAmount();
            this.cancelReturnAssure(ctx, finBillId, repayAmount);
        }
    }

    private void cancelReturnAssure(Context ctx, String finBillId, BigDecimal repayAmount) throws EASBizException, BOSException {
        FinancingBillInfo finBillInfo = (FinancingBillInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId);
        if (finBillInfo == null) {
            return;
        }
        for (GuaranteeDetailInfo element : finBillInfo.getGuaranteeEntrys()) {
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null) continue;
            AssureBillInfo assInfo = AssureBillFactory.getLocalInstance(ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()));
            BigDecimal bizBalanceLocalDelta = repayAmount.multiply(element.getExchangeRate()).multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4));
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBillUsed set FReturnedAmount=FReturnedAmount-?,FAssBalance=FAssBalance+? \nwhere FFinbillId=? and FAssureBillId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(assInfo.getExRate()), bizBalanceLocalDelta.multiply(assInfo.getExRate()), finBillId, assInfo.getId().toString()});
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FBizLocalBalance=FBizLocalBalance+?\n where FId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(assInfo.getExRate()), assInfo.getId().toString()});
            this.updateAssureResAmount(ctx, assInfo.getId().toString());
        }
    }

    private void updateAssureResAmount(Context ctx, String assId) throws BOSException, EASBizException {
        AssureBillInfo info = AssureBillFactory.getLocalInstance(ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(assId));
        BigDecimal remainAmount = info.getBizLocalBalance().multiply(info.getAssurePercent().divide(new BigDecimal(String.valueOf(100)), 4, 4));
        if (Constants.MAX_VALUE.compareTo(remainAmount) <= 0) {
            throw new FMException(FMException.VALUEOVERFLOW, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"4_AssureBillManagerFacadeControllerBean", (Locale)ctx.getLocale())});
        }
        DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FAssureResAmount=(FBizLocalBalance*FAssurePercent/100.00)\n where FId=?", (Object[])new Object[]{assId});
    }

    private BillTypeEnum getBillType(FinancingBillInfo info) {
        if (info instanceof PayableBillInfo) {
            return BillTypeEnum.PAYABLEBILL;
        }
        if (info instanceof LoanInfo) {
            return BillTypeEnum.LOAN;
        }
        if (info instanceof LetterOfCreditInfo) {
            return BillTypeEnum.LETTEROFCREDIT;
        }
        if (info instanceof LetterOfGuaranteeInfo) {
            return BillTypeEnum.LETTEROFGUARANTEE;
        }
        if (info instanceof LoanContractInfo) {
            return BillTypeEnum.LOANCONTRACT;
        }
        if (info instanceof LoanFetchInfo) {
            return BillTypeEnum.LOANFETCH;
        }
        if (info instanceof BondReleasePlanInfo) {
            return BillTypeEnum.BOND_RELEASE_PLAN;
        }
        if (info instanceof BondReleaseReportInfo) {
            return BillTypeEnum.BOND_RELEASE_REPORT;
        }
        return null;
    }

    @Override
    protected void _processRevoke(Context ctx, BOSUuid finBillId) throws BOSException, EASBizException {
        this.cancelAssureForRevoke(ctx, finBillId);
    }

    protected void cancelAssureForRevoke(Context ctx, BOSUuid finBillId) throws BOSException, EASBizException {
        IEJBAccess ejbAccessor = EJBAccessFactory.createLocalInstance((Context)ctx);
        FinancingBillInfo finBillInfo = (FinancingBillInfo)ejbAccessor.getEntityInfo(finBillId.toString());
        for (GuaranteeDetailInfo element : finBillInfo.getGuaranteeEntrys()) {
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null || !RevokeStatusEnum.revoked.equals((Object)element.getRevokeStatus())) continue;
            AssureBillInfo aInfo = (AssureBillInfo)ejbAccessor.getEntityInfo(element.getBillId());
            BigDecimal bizBalanceLocalDelta = this.getAmount(finBillInfo).multiply(element.getExchangeRate()).multiply(element.getScale().divide(new BigDecimal(String.valueOf(100)), 4, 4));
            DbUtil.execute((Context)ctx, (String)"update T_CTL_AssureBill set FBizLocalBalance=FBizLocalBalance-?\n where FId=?", (Object[])new Object[]{bizBalanceLocalDelta.multiply(aInfo.getExRate()), element.getBillId()});
            this.updateAssureResAmount(ctx, element.getBillId());
            DbUtil.execute((Context)ctx, (String)"delete from T_CTL_AssureBillUsed where FFinbillId=? and FAssureBillId=?", (Object[])new Object[]{finBillId.toString(), element.getBillId()});
        }
    }
}

