/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookMessageInfo;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.FeeException;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeBookNotifyBuilder;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeInfo;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeSubsidiaryBookProvider;
import com.kingdee.eas.fm.ctl.LetOfGuaranteeException;
import com.kingdee.eas.fm.ctl.app.AbstractFeeForGuaranteeControllerBean;
import com.kingdee.eas.fm.fs.ISubsidiaryLedger;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class FeeForGuaranteeControllerBean
extends AbstractFeeForGuaranteeControllerBean {
    @Override
    protected void _addBatch(Context ctx, IObjectCollection fee) throws BOSException, EASBizException {
        if (fee == null || fee.size() < 1) {
            return;
        }
        for (int i = 0; i < fee.size(); ++i) {
            FeeForGuaranteeInfo feeFGInfo = (FeeForGuaranteeInfo)fee.getObject(i);
            this._addnew(ctx, (IObjectValue)feeFGInfo);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select count(*) as total_1 from T_BOT_Relation where FSrcObjectID = ? ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        int num = 0;
        try {
            while (rowset.next()) {
                num = rowset.getInt("total_1");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetOfGuaranteeException(LetOfGuaranteeException.HASVENCANNOTDEL);
        }
        FeeForGuaranteeInfo info = this.getFeeForGuaranteeInfo(ctx, pk);
        if (info.getInnerAccount() != null) {
            this._deleteSubsidiary(ctx, pk.toString());
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _book(Context ctx, Set idSet) throws BOSException, EASBizException {
        FeeForGuaranteeBookNotifyBuilder builder = new FeeForGuaranteeBookNotifyBuilder();
        JournalCollection journalColl = builder.getJournalColl(ctx, idSet);
        BookMessageInfo msg = BookNotifyFacadeFactory.getLocalInstance((Context)ctx).bookBatch(journalColl);
        if (!msg.isSuccess()) {
            throw new FMException(FMException.BOOK_NOT_SUCCESS, new Object[]{msg.getMsg()});
        }
        String userid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        String ids = FMHelper.setTran2String((Set)idSet);
        String sql = "update T_CTL_FeeForGuarantee set fcashierid = '" + userid + "' where fid in " + ids;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _bookReverse(Context ctx, Set isSet) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company;
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK((company = localInstance.getCurrentCompany()).getId()));
        if (val != 0) {
            throw new FeeException(FeeException.CUSTOMEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"12_FeeForGuaranteeControllerBean", (Locale)ctx.getLocale())});
        }
        String billId = null;
        String sql = "update T_CTL_FeeForGuarantee set fcashierid = null where fid = ?";
        IBookNotifyFacade facade = BookNotifyFacadeFactory.getLocalInstance((Context)ctx);
        Iterator iter = isSet.iterator();
        while (iter.hasNext()) {
            billId = iter.next().toString();
            FeeForGuaranteeInfo feeInfo = this.getFeeForGuaranteeInfo(ctx, (IObjectPK)new ObjectUuidPK(billId));
            if (feeInfo.getAccountBank() != null) {
                facade.antiBook(billId);
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{billId});
                continue;
            }
            throw new FeeException(FeeException.ACCOUNTBANKISNULL);
        }
    }

    @Override
    protected Date _getNewDate(Context ctx) throws BOSException {
        return new Date();
    }

    @Override
    protected boolean _deleteSubsidiary(Context ctx, String id) {
        boolean flag = true;
        try {
            String strSelSql = "select * from T_FS_SubsidiaryLedger where fbillid = '" + id + "'";
            if (DbUtil.executeQuery((Context)ctx, (String)strSelSql).size() == 0) {
                return true;
            }
            String strDelSql = "delete T_FS_SubsidiaryLedger where fbillid = '" + id + "'";
            DbUtil.execute((Context)ctx, (String)strDelSql);
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    @Override
    protected void _subsidiaryBook(Context ctx, Set idSet) throws BOSException, FeeException, EASBizException {
        String builderName = FeeForGuaranteeSubsidiaryBookProvider.class.getName();
        String billId = null;
        ISubsidiaryLedger facade = SubsidiaryLedgerFactory.getLocalInstance((Context)ctx);
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            billId = iter.next().toString();
            facade.book(billId, builderName);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isInnerAccNull;
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        IObjectPK iFeePK = super._addnew(ctx, model);
        boolean bl = isInnerAccNull = this.getFeeForGuaranteeInfo(ctx, iFeePK).getInnerAccount() == null;
        if (!isInnerAccNull) {
            idSet.add(iFeePK);
            this._subsidiaryBook(ctx, idSet);
        }
        return iFeePK;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FeeForGuaranteeInfo feeOldInfo = this.getFeeForGuaranteeInfo(ctx, (IObjectPK)new ObjectStringPK(((FeeForGuaranteeInfo)model).getId().toString()));
        String oldInnerAccPK = null;
        if (feeOldInfo.getInnerAccount() != null) {
            oldInnerAccPK = feeOldInfo.getInnerAccount().getId().toString();
        }
        IObjectPK feePK = super._submit(ctx, model);
        FeeForGuaranteeInfo feeNewInfo = this.getFeeForGuaranteeInfo(ctx, feePK);
        String newInnerAccPK = null;
        if (feeNewInfo.getInnerAccount() != null) {
            newInnerAccPK = feeNewInfo.getInnerAccount().getId().toString();
        }
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        idSet.add(feePK);
        this._againBook(ctx, idSet, oldInnerAccPK, newInnerAccPK);
        return feePK;
    }

    @Override
    protected boolean _isAgainBook(Context ctx, String oldId, String newId) throws BOSException, EASBizException {
        return true;
    }

    @Override
    protected void _againBook(Context ctx, Set idSet, String oldInnerId, String newInnerId) throws BOSException, EASBizException {
        boolean isAgain = false;
        Iterator iter = idSet.iterator();
        String billId = null;
        while (iter.hasNext()) {
            billId = iter.next().toString();
        }
        InnerAccountInfo oldInfo = null;
        if (oldInnerId != null) {
            oldInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(oldInnerId));
        }
        InnerAccountInfo newInfo = null;
        if (newInnerId != null) {
            newInfo = InnerAccountFactory.getLocalInstance((Context)ctx).getInnerAccountInfo((IObjectPK)new ObjectStringPK(newInnerId));
        }
        boolean isEditDataInnerNull = true;
        isEditDataInnerNull = oldInfo == null;
        HashSet<String> feeIdSet = new HashSet<String>();
        boolean flag = this._isAgainBook(ctx, oldInnerId, newInnerId);
        boolean isCanDelete = true;
        if (flag) {
            if (oldInfo != null) {
                isCanDelete = this._deleteSubsidiary(ctx, billId);
            }
            if (!isCanDelete) {
                throw new FeeException(FeeException.FEEISNOTEDIT);
            }
            if (newInfo != null) {
                feeIdSet.add(billId);
                this._subsidiaryBook(ctx, feeIdSet);
                isAgain = true;
            }
        } else {
            return;
        }
        if (!isAgain && flag && oldInfo != null && newInfo != null) {
            throw new FeeException(FeeException.BOOKISLOST);
        }
    }
}

