/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.GuaranteeColEnum;
import com.kingdee.eas.fm.ctl.KcTypeEnum;
import com.kingdee.eas.fm.ctl.LGTypeInfo;
import com.kingdee.eas.fm.ctl.LetOfGuaranteeEntryCollection;
import com.kingdee.eas.fm.ctl.LetOfGuaranteeEntryInfo;
import com.kingdee.eas.fm.ctl.LetOfGuaranteeException;
import com.kingdee.eas.fm.ctl.LetOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.app.AbstractLetOfGuaranteeControllerBean;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.GuaranteeTypeFactory;
import com.kingdee.eas.fm.fin.GuaranteeTypeInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class LetOfGuaranteeControllerBean
extends AbstractLetOfGuaranteeControllerBean {
    @Override
    protected int _getModifyTimes(Context ctx, String guarId) throws BOSException {
        String sql = "Select count(*) as total From T_CTL_LetOfGuarantee Where FGuaranteeId = ? ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{guarId});
        int num = 0;
        try {
            while (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return num;
    }

    @Override
    protected boolean _isAudit(Context ctx, String id) throws BOSException {
        String audi = "";
        String sql = " Select FAuditorID as audi From T_CTL_LetOfGuarantee Where FID = ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            while (rowset.next()) {
                audi = rowset.getString("audi");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return !StringUtils.isEmpty((String)audi);
    }

    @Override
    protected boolean _checkHasNew(Context ctx, String id) throws BOSException, EASBizException {
        int num = 0;
        LetOfGuaranteeInfo info = LetOfGuaranteeFactory.getLocalInstance(ctx).getLetOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(id));
        String sql = " Select count(*)  as total From T_CTL_LetOfGuarantee Where FGuaranteeId = ? and FModifyTimes > ?";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getGuaranteeId(), String.valueOf(info.getModifyTimes())});
        try {
            while (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return num <= 0;
    }

    @Override
    protected void _audit(Context ctx, String id, IObjectCollection col) throws BOSException, EASBizException {
        LetOfGuaranteeInfo info = LetOfGuaranteeFactory.getLocalInstance(ctx).getLetOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(id));
        LetterOfGuaranteeInfo letterInfo = this.upDateGuarColumn(ctx, (IObjectValue)info, "Audit");
        if (letterInfo.getExpiredDate() != null && !letterInfo.getExpiredDate().after(letterInfo.getIssueDate())) {
            throw new LetOfGuaranteeException(LetOfGuaranteeException.ENDDATEMUSTLATERTHANBEGINDATE);
        }
        if (letterInfo.getReAssureDate() != null && letterInfo.getExpiredDate().compareTo(letterInfo.getReAssureDate()) > 0) {
            throw new LetOfGuaranteeException(LetOfGuaranteeException.REDAYMUSTTHANENDDAY);
        }
        this.modifyOther(ctx, letterInfo);
        if (col != null) {
            letterInfo.setReduceCol((CreditFinancingReduceCollection)col);
        }
        LetterOfGuaranteeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(letterInfo.getId()), (CoreBaseInfo)letterInfo);
        String sql = " Update T_CTL_LetOfGuarantee Set FAuditorID =? Where FID=? ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString(), id});
    }

    @Override
    protected void _cancelAudit(Context ctx, String id, IObjectCollection col) throws BOSException, EASBizException {
        LetOfGuaranteeInfo info = LetOfGuaranteeFactory.getLocalInstance(ctx).getLetOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(id));
        LetterOfGuaranteeInfo letterInfo = this.upDateGuarColumn(ctx, (IObjectValue)info, "reAudit");
        this.modifyOther(ctx, letterInfo);
        if (col != null) {
            letterInfo.setReduceCol((CreditFinancingReduceCollection)col);
        }
        LetterOfGuaranteeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(letterInfo.getId()), (CoreBaseInfo)letterInfo);
        String sql = " Update T_CTL_LetOfGuarantee Set FAuditorID =null Where FID=? ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
    }

    @Override
    protected int _getNoAuditEntryNum(Context ctx, String entryId) throws BOSException {
        int times = 0;
        int sum = 0;
        String item = " ";
        String id = " ";
        String sql = " Select B.FmodifyTimes as FT,A.Fitems as Fitems,B.FGuaranteeid as Fid From T_CTL_LetOfGuaranteeEntry  A left join  T_CTL_LetOfGuarantee B on B.FID = A.FParentID Where A.FID = ?  ";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{entryId});
        try {
            while (rowset.next()) {
                times = rowset.getInt("FT");
                item = rowset.getString("Fitems");
                id = rowset.getString("Fid");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        sql = " Select count(*) as total_1 From T_CTL_LetOfGuaranteeEntry  A left join  T_CTL_LetOfGuarantee B on B.FID = A.FParentID Where A.Fitems = ? and B.FmodifyTimes > ? and  B.FGuaranteeid = ?";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{item, String.valueOf(times), id});
        try {
            while (rowset.next()) {
                sum = rowset.getInt("total_1");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sum;
    }

    private LetterOfGuaranteeInfo upDateGuarColumn(Context ctx, IObjectValue model, String Flag) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Source.*"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        sic.add(new SelectorItemInfo("GaranteeType.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        Object object = null;
        LetOfGuaranteeInfo Letinfo = (LetOfGuaranteeInfo)model;
        LetOfGuaranteeEntryCollection infoEntrys = Letinfo.getEntrys();
        LetterOfGuaranteeInfo info = (LetterOfGuaranteeInfo)LetterOfGuaranteeFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(Letinfo.getGuaranteeId()), sic);
        for (int i = 0; i < infoEntrys.size(); ++i) {
            LetOfGuaranteeEntryInfo entryInfo = infoEntrys.get(i);
            object = Flag.equals("Audit") ? this.getRealValue(entryInfo, entryInfo.getItemAfterMod()) : this.getRealValue(entryInfo, entryInfo.getItembeforeMod());
            this.setValue(info, entryInfo.getItems().getName(), object, ctx);
        }
        return info;
    }

    private Object getRealValue(LetOfGuaranteeEntryInfo entryInfo, String value) throws BOSException, EASBizException {
        Object typeInfo;
        Object object = null;
        if (value == null || entryInfo.getItems() == GuaranteeColEnum.Receiver || entryInfo.getItems() == GuaranteeColEnum.license) {
            object = value;
            return object;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.LGType) {
            typeInfo = new LGTypeInfo();
            typeInfo.setId(BOSUuid.read((String)value));
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.applyUnit) {
            typeInfo = new CompanyOrgUnitInfo();
            typeInfo.setId(BOSUuid.read((String)value));
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.department) {
            typeInfo = new AdminOrgUnitInfo();
            typeInfo.setId(BOSUuid.read((String)value));
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.transBank) {
            typeInfo = new BankInfo();
            typeInfo.setId(BOSUuid.read((String)value));
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.dealer) {
            typeInfo = new PersonInfo();
            typeInfo.setId(BOSUuid.read((String)value));
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.GuaranteeTypeInputMode) {
            typeInfo = null;
            if (1 == Integer.parseInt(value)) {
                typeInfo = GuaranteeTypeInputModeEnum.assure;
            }
            if (4 == Integer.parseInt(value)) {
                typeInfo = GuaranteeTypeInputModeEnum.credit;
            }
            if (3 == Integer.parseInt(value)) {
                typeInfo = GuaranteeTypeInputModeEnum.impawn;
            }
            if (6 == Integer.parseInt(value)) {
                typeInfo = GuaranteeTypeInputModeEnum.mix;
            }
            if (5 == Integer.parseInt(value)) {
                typeInfo = GuaranteeTypeInputModeEnum.other;
            }
            if (2 == Integer.parseInt(value)) {
                typeInfo = GuaranteeTypeInputModeEnum.pledge;
            }
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.kcType) {
            typeInfo = null;
            if ("5".equals(value)) {
                typeInfo = KcTypeEnum.Other;
            }
            if ("1".equals(value)) {
                typeInfo = KcTypeEnum.RedirectAndTele;
            }
            if ("2".equals(value)) {
                typeInfo = KcTypeEnum.DirectAndLetter;
            }
            if ("4".equals(value)) {
                typeInfo = KcTypeEnum.TransAndLetter;
            }
            if ("3".equals(value)) {
                typeInfo = KcTypeEnum.TransAndTele;
            }
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.Amount || entryInfo.getItems() == GuaranteeColEnum.LocalCurExRate) {
            typeInfo = new BigDecimal(value);
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.Amount) {
            typeInfo = new BigDecimal(value);
            object = typeInfo;
        }
        if (entryInfo.getItems() == GuaranteeColEnum.IssueDate || entryInfo.getItems() == GuaranteeColEnum.ExpiredDate || entryInfo.getItems() == GuaranteeColEnum.reAssureDate) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                typeInfo = format.parse(value);
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            object = typeInfo;
        }
        return object;
    }

    private void setValue(LetterOfGuaranteeInfo info, String ColumnName, Object ColumnValue, Context ctx) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = null;
        entity = loader.getEntity(info.getBOSType());
        PropertyCollection pc = entity.getInheritedNoDuplicatedProperties();
        Method methodSet = null;
        try {
            for (int i = 0; i < pc.size(); ++i) {
                PropertyInfo pro = pc.get(i);
                String fieldName = pro.getName();
                if (!ColumnName.equalsIgnoreCase(fieldName)) continue;
                String fieldNameForMethod = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                if (!FMHelper.isEmpty((Object)ColumnValue) && !"entrys".equals(fieldName)) {
                    if (ColumnName.equals("GuaranteeTypeInputMode")) {
                        GuaranteeTypeInfo ginfo = null;
                        if (ColumnValue.toString().equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"140_LetOfGuaranteeControllerBean", (Locale)ctx.getLocale())) || ColumnValue.toString().equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"141_LetOfGuaranteeControllerBean", (Locale)ctx.getLocale()))) {
                            info.setGaranteeType(null);
                        } else if (ColumnValue.toString().equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"142_LetOfGuaranteeControllerBean", (Locale)ctx.getLocale()))) {
                            ginfo = GuaranteeTypeFactory.getLocalInstance((Context)ctx).getGuaranteeTypeInfo((IObjectPK)new ObjectUuidPK("3Xj3DQEJEADgAFQ6wKgTyFBDv/A="));
                            info.setGaranteeType(ginfo);
                        } else if (ColumnValue.toString().equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"143_LetOfGuaranteeControllerBean", (Locale)ctx.getLocale()))) {
                            ginfo = GuaranteeTypeFactory.getLocalInstance((Context)ctx).getGuaranteeTypeInfo((IObjectPK)new ObjectUuidPK("3Xj3DQEJEADgAFSlwKgTyFBDv/A="));
                            info.setGaranteeType(ginfo);
                        } else if (ColumnValue.toString().equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"144_LetOfGuaranteeControllerBean", (Locale)ctx.getLocale()))) {
                            ginfo = GuaranteeTypeFactory.getLocalInstance((Context)ctx).getGuaranteeTypeInfo((IObjectPK)new ObjectUuidPK("3Xj3DQEJEADgAFUAwKgTyFBDv/A="));
                            info.setGaranteeType(ginfo);
                        } else if (ColumnValue.toString().equals(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"145_LetOfGuaranteeControllerBean", (Locale)ctx.getLocale()))) {
                            ginfo = GuaranteeTypeFactory.getLocalInstance((Context)ctx).getGuaranteeTypeInfo((IObjectPK)new ObjectUuidPK("3Xj3DQEJEADgAFQgwKgTyFBDv/A="));
                            info.setGaranteeType(ginfo);
                        }
                    }
                    String methodNameSet = "set" + fieldNameForMethod;
                    methodSet = info.getClass().getMethod(methodNameSet, ColumnValue.getClass());
                    methodSet.invoke((Object)info, ColumnValue);
                } else if (ColumnName.equals("reAssureDate") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setReAssureDate(null);
                } else if (ColumnName.equals("kcType") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setString("kcType", null);
                } else if (ColumnName.equals("license") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setLicense(null);
                } else if (ColumnName.equals("dealer") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setDealer(null);
                } else if (ColumnName.equals("applyUnit") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setApplyUnit(null);
                } else if (ColumnName.equals("transBank") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setTransBank(null);
                } else if (ColumnName.equals("LGType") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setLGType(null);
                } else if (ColumnName.equals("department") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setDepartment(null);
                } else if (ColumnName.equals("GaranteeType") && FMHelper.isEmpty((Object)ColumnValue)) {
                    info.setGuaranteeTypeInputMode(null);
                }
                break;
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (RuntimeException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    protected boolean _modifyGuarantee(Context ctx, String id, boolean flag, IObjectCollection col) throws BOSException, EASBizException {
        String sql = "";
        if (flag) {
            LetOfGuaranteeInfo info = LetOfGuaranteeFactory.getLocalInstance(ctx).getLetOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(id));
            LetterOfGuaranteeInfo letterInfo = this.upDateGuarColumn(ctx, (IObjectValue)info, "Audit");
            this.modifyOther(ctx, letterInfo);
            if (col != null) {
                letterInfo.setReduceCol((CreditFinancingReduceCollection)col);
            }
            LetterOfGuaranteeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(letterInfo.getId()), (CoreBaseInfo)letterInfo);
            sql = " Update T_CTL_LetOfGuarantee Set FAuditorID =? Where FID=? ";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString(), id});
            return true;
        }
        LetOfGuaranteeInfo info = LetOfGuaranteeFactory.getLocalInstance(ctx).getLetOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(id));
        LetterOfGuaranteeInfo letterInfo = this.upDateGuarColumn(ctx, (IObjectValue)info, "reAudit");
        this.modifyOther(ctx, letterInfo);
        if (col != null) {
            letterInfo.setReduceCol((CreditFinancingReduceCollection)col);
        }
        LetterOfGuaranteeFactory.getLocalInstance(ctx).submit((CoreBaseInfo)letterInfo);
        sql = " Update T_CTL_LetOfGuarantee Set FAuditorID =null Where FID=? ";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        return true;
    }

    private void modifyOther(Context ctx, LetterOfGuaranteeInfo letterInfo) throws BOSException, EASBizException, FinBizException {
        BigDecimal Horizon = FinHorizon.getHorizon((Date)letterInfo.getIssueDate(), (Date)letterInfo.getExpiredDate());
        BigDecimal biginfo = new BigDecimal(String.valueOf(Horizon));
        this.setValue(letterInfo, "Horizon", biginfo, ctx);
        BigDecimal bdAmount = letterInfo.getAmount();
        BigDecimal bdCurExRaTe = letterInfo.getLocalCurExRate();
        BigDecimal biginBalancefo = new BigDecimal(String.valueOf(bdAmount));
        this.setValue(letterInfo, "Amount", biginBalancefo, ctx);
        this.setValue(letterInfo, "AmountLocalCur", biginBalancefo.multiply(bdCurExRaTe), ctx);
        BigDecimal hasAmount = this.checkJe(ctx, letterInfo.getId().toString());
        if (hasAmount.equals(new BigDecimal(0))) {
            this.setValue(letterInfo, "Balance", biginBalancefo, ctx);
        } else {
            this.setValue(letterInfo, "Balance", biginBalancefo.subtract(hasAmount), ctx);
        }
        this.setValue(letterInfo, "creditLocalAmt", letterInfo.getAmount().multiply(letterInfo.getCreditCurExRate()), ctx);
    }

    private BigDecimal checkJe(Context ctx, String id) throws BOSException, EASBizException {
        IRowSet rowset = null;
        BigDecimal amount = new BigDecimal(0);
        BigDecimal balance = new BigDecimal(0);
        String sql = " Select FAmount as amount,FBalance as balance From T_CTL_LetterOfGuarantee Where FID =? ";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            while (rowset.next()) {
                amount = rowset.getBigDecimal("amount");
                balance = rowset.getBigDecimal("balance");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return amount.subtract(balance);
    }
}

