/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.ctl.GuaranteeApplyFactory;
import com.kingdee.eas.fm.ctl.GuaranteeApplyInfo;
import com.kingdee.eas.fm.ctl.LetOfGuaranteeException;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeCollection;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeException;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeHelper;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeStateEnum;
import com.kingdee.eas.fm.ctl.app.AbstractLetterOfGuaranteeControllerBean;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowFactory;
import com.kingdee.eas.fm.mnt.LGForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LetterOfGuaranteeControllerBean
extends AbstractLetterOfGuaranteeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ctl.app.LetterOfGuaranteeControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk;
        LetterOfGuaranteeInfo info;
        GuaranteeApplyInfo guaranInfo;
        LetterOfGuaranteeInfo info1 = (LetterOfGuaranteeInfo)model;
        info1.setHistoryBill(false);
        if (info1.getSourceBillId() != null && (guaranInfo = GuaranteeApplyFactory.getLocalInstance(ctx).getGuaranteeApplyInfo((IObjectPK)new ObjectUuidPK(info1.getSourceBillId()))) != null) {
            BigDecimal alreadyAmount = guaranInfo.getAlreadyAmount();
            if (alreadyAmount == null) {
                alreadyAmount = new BigDecimal(0);
            }
            if (guaranInfo.getAmount().doubleValue() - alreadyAmount.doubleValue() < info1.getAmount().doubleValue()) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"29_LetterOfGuaranteeControllerBean", (Locale)ctx.getLocale())));
            }
            DbUtil.execute((Context)ctx, (String)("update T_CTL_Guaranteeapply set FAlreadyAmount = '" + info1.getAmount() + "' where FID = '" + info1.getSourceBillId() + "'"));
        }
        if (FMHelper.isEmpty((String)(info = this.getLetterOfGuaranteeInfo(ctx, pk = super._addnew(ctx, model))).getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("Balance");
        LetterOfGuaranteeInfo lgInfo = (LetterOfGuaranteeInfo)this._getValue(ctx, pk, sic);
        if (lgInfo.getBalance().compareTo(SysConstant.BIGZERO) == 0) {
            throw new FinBizException(FinBizException.BALANCEISZERO);
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BigDecimal amount;
        BigDecimal alreadyAmount;
        GuaranteeApplyInfo guaranInfo;
        LetterOfGuaranteeInfo lgInfo = (LetterOfGuaranteeInfo)model;
        if (lgInfo.getSourceBillId() != null && (guaranInfo = GuaranteeApplyFactory.getLocalInstance(ctx).getGuaranteeApplyInfo((IObjectPK)new ObjectUuidPK(lgInfo.getSourceBillId()))) != null && (alreadyAmount = guaranInfo.getAlreadyAmount()).compareTo(amount = lgInfo.getAmount()) != 0) {
            guaranInfo.setAlreadyAmount(lgInfo.getAmount());
            GuaranteeApplyFactory.getLocalInstance(ctx).submit((CoreBaseInfo)guaranInfo);
        }
        DbUtil.execute((Context)ctx, (String)("update T_CTL_FeeForGuarantee set FFBusinessNumber = '" + lgInfo.getNumber() + "' where fGuaranteeId = '" + pk + "'"));
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo lgInfo = (LetterOfGuaranteeInfo)model;
        if (lgInfo.isIsOnlySubmit()) {
            ObjectUuidPK pk = new ObjectUuidPK(lgInfo.getId());
            DbUtil.execute((Context)ctx, (String)("update T_CTL_LetterOfGuarantee set FState = " + lgInfo.getState().getValue() + " where FID = '" + pk + "'"));
            return pk;
        }
        if (lgInfo.getCreditCurExRate() == null) {
            lgInfo.setCreditCurExRate(Constants.ZERO);
        }
        if (!lgInfo.isIsExposure()) {
            lgInfo.setOpenAmount(Constants.ZERO);
        }
        IObjectPK pk = super._submit(ctx, model);
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).genForecastedBlockingFlow(BOSUuid.read((String)pk.toString()), LGForecastedBlockingFlowGenerator.class.getName());
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo lgInfo = (LetterOfGuaranteeInfo)model;
        if (lgInfo.getCreditCurExRate() == null) {
            lgInfo.setCreditCurExRate(Constants.ZERO);
        }
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        GuaranteeApplyInfo guaranteeInfo;
        String id;
        this.checkDelete(ctx, pk.toString());
        LetterOfGuaranteeInfo lgBillInfo = this.getLetterOfGuaranteeInfo(ctx, pk);
        if (lgBillInfo.getBalance().compareTo(lgBillInfo.getAmount()) != 0) {
            throw new FinBizException(FinBizException.AMOUNTNOTEQUALBALANCE);
        }
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).deleteForecastedBlockingFlow(BOSUuid.read((String)pk.toString()));
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)lgBillInfo, (String)lgBillInfo.getCompany().getId().toString());
        Set idSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)pk.toString());
        if (idSet.size() > 0 && BOSUuid.read((String)(id = (String)idSet.iterator().next())).getType().equals((Object)new GuaranteeApplyInfo().getBOSType()) && (guaranteeInfo = GuaranteeApplyFactory.getLocalInstance(ctx).getGuaranteeApplyInfo((IObjectPK)new ObjectUuidPK(id))) != null) {
            double alreadyAmount = guaranteeInfo.getAlreadyAmount().doubleValue() - lgBillInfo.getAmount().doubleValue();
            guaranteeInfo.setAlreadyAmount(new BigDecimal(alreadyAmount));
            GuaranteeApplyFactory.getLocalInstance(ctx).submit((CoreBaseInfo)guaranteeInfo);
        }
        super._delete(ctx, pk);
    }

    protected void verify(Context ctx, FinancingBillInfo finBill) throws EASBizException, BOSException {
        super.verify(ctx, finBill);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Institution");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"Receiver");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)finBill, (String)"LGType");
    }

    protected boolean isExpiredDateRequired() {
        return false;
    }

    @Override
    protected void _AntiCancelNoRePay(Context ctx, String pk) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo finBillInfo = this.getLetterOfGuaranteeInfo(ctx, (IObjectPK)new ObjectUuidPK(pk), this.getSelectors());
        super.modifyQuantum(ctx, (IObjectPK)new ObjectUuidPK(pk), false);
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).editForecastBlockingFlow(finBillInfo.getId(), finBillInfo.getAmount().negate());
        this.updateLetterOfGuaranteeBalance(ctx, pk, false);
        this.updateLetterOfGuaranteeCancel(ctx, pk, false, true);
    }

    @Override
    protected void _CancelNoRePaybill(Context ctx, String pk, boolean isManual) throws BOSException, EASBizException {
        FinancingBillInfo finBillInfo = FinUtils.getFinBillLocal((Context)ctx, (String)pk);
        super.modifyQuantum(ctx, (IObjectPK)new ObjectUuidPK(pk), true);
        ForecastedBlockingFlowFactory.getLocalInstance((Context)ctx).editForecastBlockingFlow(finBillInfo.getId(), finBillInfo.getBalance());
        this.updateLetterOfGuaranteeBalance(ctx, pk, true);
        this.updateLetterOfGuaranteeCancel(ctx, pk, true, isManual);
    }

    private void updateLetterOfGuaranteeCancel(Context ctx, String pk, boolean isCancel, boolean isManual) throws EASBizException, BOSException {
        LetterOfGuaranteeInfo info = this.getLetterOfGuaranteeInfo(ctx, (IObjectPK)new ObjectUuidPK(pk));
        if (isCancel) {
            UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            info.setCancelor(user);
            info.setCancelDate(isManual ? DateHelper.getDayBegin() : info.getExpiredDate());
        } else {
            info.setCancelor(null);
            info.setCancelDate(null);
        }
        super._updatePartial(ctx, (IObjectValue)info, this.getUpdatePartialSelectors());
    }

    private SelectorItemCollection getUpdatePartialSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("cancelDate"));
        sic.add(new SelectorItemInfo("cancelor"));
        return sic;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo info = this.getLetterOfGuaranteeInfo(ctx, pk);
        if (LetterOfGuaranteeHelper.isCanAudit(info)) {
            this.doAudit(ctx, info);
        }
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo info = this.getLetterOfGuaranteeInfo(ctx, pk);
        if (LetterOfGuaranteeHelper.isCanAntiAudit(info)) {
            this.doAntiAudit(ctx, info);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo info = this.getLetterOfGuaranteeInfo(ctx, pk);
        if (!LetterOfGuaranteeHelper.isCanAudit(info)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"30_LetterOfGuaranteeControllerBean", (Locale)ctx.getLocale())));
        }
        this.doAudit(ctx, info);
    }

    @Override
    protected void _antiAudit4WF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo info = this.getLetterOfGuaranteeInfo(ctx, pk);
        if (!LetterOfGuaranteeHelper.isCanAntiAudit(info) || info.isIsSuoPei()) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"31_LetterOfGuaranteeControllerBean", (Locale)ctx.getLocale())));
        }
        this.doAntiAudit(ctx, info);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            LetterOfGuaranteeInfo info = (LetterOfGuaranteeInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setFiVouchered(false);
            } else {
                info.setFiVouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected void _batchSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        LetterOfGuaranteeInfo info;
        int i;
        if (idSet == null || idSet.size() <= 0) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        LetterOfGuaranteeCollection coll = this.getLetterOfGuaranteeCollection(ctx, evi);
        int size = coll.size();
        for (i = 0; i < size; ++i) {
            info = coll.get(i);
            if (LetterOfGuaranteeStateEnum.SAVE.equals((Object)info.getState())) continue;
            throw new LetterOfGuaranteeException(LetterOfGuaranteeException.CAN_NOT_SUBMIT);
        }
        for (i = 0; i < size; ++i) {
            info = coll.get(i);
            info.setState(LetterOfGuaranteeStateEnum.SUBMIT);
            info.setIsOnlySumbit(true);
            this.submit(ctx, (CoreBaseInfo)info);
        }
    }

    private void checkAmount(BigDecimal amount, CreditLimitInfo creditLimitInfo, CreditLimitEntryInfo shareEntry, boolean isRepayment) throws FinBizException {
        ShareTypeEnum shareType = creditLimitInfo.getShareType();
        BigDecimal banlance = null;
        banlance = shareType.equals((Object)ShareTypeEnum.ASSIGN) ? shareEntry.getBanlance() : creditLimitInfo.getBalance();
        if (!(isRepayment || banlance.compareTo(Constants.ZERO) >= 0 && amount.compareTo(banlance) <= 0)) {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
    }

    private void updateLimitState(Context ctx, String limitId) throws BOSException, EASBizException {
        CreditLimitStatusEnum creditStatus = this.calcCreditStatus(ctx, limitId);
        String ssql = "UPDATE T_FIN_CreditLimit SET FCreditLimitStat = ? WHERE (FID = ?)";
        DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(creditStatus.getValue()), limitId});
    }

    private void updateLetterOfGuaranteeBalance(Context ctx, String finId, boolean isDis) throws BOSException, EASBizException {
        String ssql = "UPDATE T_ctl_LetterOfGuarantee SET FIsDis = ? WHERE FID = ?";
        if (isDis) {
            DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(1), finId});
        } else {
            DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(0), finId});
        }
    }

    private CreditLimitStatusEnum calcCreditStatus(Context ctx, String id) throws BOSException, EASBizException {
        CreditLimitInfo clInfo = CreditLimitFactory.getLocalInstance((Context)ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(id));
        BigDecimal bdAmount = clInfo.getQuotaAmount();
        BigDecimal bdBalance = clInfo.getBalance();
        CreditLimitStatusEnum state = null;
        if (bdBalance.compareTo(bdAmount) == 0 && !clInfo.isIsClosed()) {
            state = CreditLimitStatusEnum.INEFFECTIVE;
        } else if (bdBalance.compareTo(SysConstant.BIGZERO) > 0 && bdBalance.compareTo(bdAmount) != 0 && !clInfo.isIsClosed() || bdBalance.compareTo(SysConstant.BIGZERO) < 0 && bdBalance.compareTo(bdAmount) != 0 && !clInfo.isIsClosed() && clInfo.isIsUnion()) {
            state = CreditLimitStatusEnum.EFFECTIVE;
        } else if (bdBalance.compareTo(SysConstant.BIGZERO) == 0 || clInfo.isIsClosed()) {
            state = CreditLimitStatusEnum.EXPIRED;
        } else {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
        return state;
    }

    private void doAudit(Context ctx, LetterOfGuaranteeInfo info) throws BOSException {
        String sql = "update T_CTL_LetterOfGuarantee set FState = 2 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"32_LetterOfGuaranteeControllerBean", (Locale)ctx.getLocale())));
    }

    private void doAntiAudit(Context ctx, LetterOfGuaranteeInfo info) throws BOSException {
        String sql = "update T_CTL_LetterOfGuarantee set FState = 0 where FID = '" + info.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql.toString());
        logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"1_AssureBillControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"16_GuaranteeApplyControllerBean", (Locale)ctx.getLocale())));
    }

    @Override
    protected boolean _HasNoAudit(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "";
        IRowSet rowset = null;
        int num = 0;
        sql = " Select count(*)  as total From T_CTL_LetOfGuarantee Where FGuaranteeId =? and (FAuditorID='' or FAuditorID is null) ";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            while (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return num <= 0;
    }

    protected void checkDelete(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "";
        IRowSet rowset = null;
        int num = 0;
        sql = " Select count(*)  as total From T_CTL_LetOfGuarantee Where FGuaranteeId =?  ";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            while (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetOfGuaranteeException(LetOfGuaranteeException.HASMODIFYGUARANTEE);
        }
        sql = " Select count(*)  as total From T_CTL_FeeForGuarantee Where FGuaranteeId =?  ";
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id});
        try {
            while (rowset.next()) {
                num = rowset.getInt("total");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (num > 0) {
            throw new LetOfGuaranteeException(LetOfGuaranteeException.HASFEEGUARANTEE);
        }
    }

    @Override
    protected Map _getAussAmount(Context ctx, String id) throws BOSException, EASBizException {
        if (id == null) {
            return null;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        EntityViewInfo evi2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)new GuaranteeApplyInfo().getBOSType().toString(), CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)id, CompareType.EQUALS));
        filter2.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new AssureAmountInfo().getBOSType().toString(), CompareType.EQUALS));
        evi2.setFilter(filter2);
        BOTRelationCollection botp = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(evi2);
        AssureAmountInfo assureAmount = null;
        if (botp == null || botp.size() < 1) {
            resMap.put("assureAmount", assureAmount);
        } else {
            String assureAmountId = botp.get(0).getDestObjectID();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("amount"));
            selector.add(new SelectorItemInfo("payAcct"));
            selector.add(new SelectorItemInfo("assureRate"));
            selector.add(new SelectorItemInfo("currency.*"));
            assureAmount = AssureAmountFactory.getLocalInstance((Context)ctx).getAssureAmountInfo((IObjectPK)new ObjectUuidPK(assureAmountId), selector);
            resMap.put("assureAmount", assureAmount);
        }
        String sql = "select FAmount from T_CTL_GuaranteeApply where Fid='" + id + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                resMap.put("amount", rowSet.getBigDecimal(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return resMap;
    }

    @Override
    protected void _suoPei(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.EQUALS));
        LetterOfGuaranteeCollection letter = LetterOfGuaranteeFactory.getLocalInstance(ctx).getLetterOfGuaranteeCollection(evi);
        if (letter.size() > 0) {
            LetterOfGuaranteeInfo info = letter.get(0);
            info.setIsSuoPei(true);
        }
    }

    @Override
    protected void _autoCancel(Context ctx, Set idSet, boolean isManual) throws BOSException, EASBizException {
        String billId2 = "";
        for (String billId2 : idSet) {
            super.CancelNoRePaybill(ctx, billId2, isManual);
        }
    }

    @Override
    protected Map _batchAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            if (id == null || id.length() <= 0) continue;
            this.audit(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
        return null;
    }

    @Override
    protected Map _batchAntiAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            if (id == null || id.length() <= 0) continue;
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK(id));
        }
        return null;
    }

    @Override
    protected Map _batchAntiCancelNoPay(Context ctx, Set idSet) throws BOSException, EASBizException {
        for (String id : idSet) {
            if (id == null || id.length() <= 0) continue;
            this.AntiCancelNoRePay(ctx, id);
        }
        return null;
    }
}

