/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.ecore.BusinessNotificationCollection;
import com.kingdee.eas.fm.ecore.BusinessNotificationFactory;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.MessageFactory;
import com.kingdee.eas.fm.ecore.MessageInfo;
import com.kingdee.eas.fm.ecore.SystemStatusCollection;
import com.kingdee.eas.fm.ecore.SystemStatusFactory;
import com.kingdee.eas.fm.ecore.app.AbstractECoreQueryServiceFacadeControllerBean;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.impl.FindByElecDraft;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class ECoreQueryServiceFacadeControllerBean
extends AbstractECoreQueryServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ECoreQueryServiceFacadeControllerBean");

    @Override
    protected Map _getDraftInfoService(Context ctx, String draftTakerOrgCode, String draftNumber) throws BOSException, EASBizException {
        String stringdate = "2011-08-09";
        Map returnMap = FindByElecDraft.getElecDraft(ctx, draftTakerOrgCode, draftNumber, DateUtil.parseDate(stringdate), false);
        return returnMap;
    }

    @Override
    protected String _getBankNameByAcctSvcr(Context ctx, String acctSvcrID) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)acctSvcrID));
        viewinfo.setFilter(fi);
        BEBankCollection eAssColl = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(viewinfo);
        if (eAssColl.size() != 0) {
            return eAssColl.get(0).getName();
        }
        return null;
    }

    @Override
    protected IObjectCollection _getDraftBillEntryInfo(Context ctx, String draftNumber) throws BOSException, EASBizException {
        return ECDSCommon.findElecDraftBillEntryList(ctx, draftNumber);
    }

    @Override
    protected IObjectCollection _getBusinessNotionficationByOrgCode(Context ctx, String orgCode, String draftNumber, boolean ishandExeption, ElecDraftActionEnum actionType) throws BOSException {
        if (!ishandExeption) {
            return this.findBusinessNotiFicationByOrgCode(ctx, draftNumber, orgCode, actionType);
        }
        return this.findByIsHandExeption(ctx, ishandExeption, draftNumber, orgCode);
    }

    private BusinessNotificationCollection findByIsHandExeption(Context ctx, boolean ishandExeption, String draftNumber, String orgCode) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("isHandleError", (Object)new Boolean(ishandExeption)));
        fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)orgCode));
        viewinfo.setFilter(fi);
        return BusinessNotificationFactory.getLocalInstance(ctx).getBusinessNotificationCollection(viewinfo);
    }

    private BusinessNotificationCollection findBusinessNotiFicationByOrgCode(Context ctx, String draftNumber, String orgCode, ElecDraftActionEnum actionType) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)actionType));
        fi.getFilterItems().add(new FilterItemInfo("holderOrgCode", (Object)orgCode));
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        return BusinessNotificationFactory.getLocalInstance(ctx).getBusinessNotificationCollection(viewinfo);
    }

    @Override
    protected Map _getdraftUnderReplySevice(Context ctx, String draftNumber) throws BOSException, EASBizException {
        return FindByElecDraft.getElecDraft(ctx, null, draftNumber, new Date(), false);
    }

    @Override
    protected String _getPaperInfoRespService(Context ctx, String messageID) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("msgID", (Object)messageID));
        viewinfo.setFilter(fi);
        MessageInfo messageInfo = MessageFactory.getLocalInstance(ctx).getMessageCollection(viewinfo).get(0);
        return messageInfo.getMessage();
    }

    @Override
    protected Map _getDraftBackInformation(Context ctx, String draftTakerOrgCode, String draftNumber) throws BOSException, EASBizException {
        return FindByElecDraft.getDraftBackInformation(ctx, draftTakerOrgCode, draftNumber);
    }

    @Override
    protected Date _getSystemDate(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        SystemStatusCollection col = SystemStatusFactory.getLocalInstance(ctx).getSystemStatusCollection(viewinfo);
        if (col != null && col.size() > 0) {
            return col.get(0).getCurSysDate();
        }
        return null;
    }
}

