/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.ecds.EcoreStringUtils;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class KMsgBuildUtil {
    public static KMsgHead resolveHeadStr(String msghead) {
        KMsgHead kMsgHead = new KMsgHead();
        kMsgHead.getBeginFlag().setStr(msghead.substring(0, 3));
        kMsgHead.getVersionID().setStr(msghead.substring(3, 5));
        kMsgHead.getSenderSID().setStr(msghead.substring(17, 19));
        kMsgHead.getSenderCID().setStr(msghead.substring(19, 27));
        kMsgHead.getReceiverSID().setStr(msghead.substring(39, 41));
        kMsgHead.getReceiverCID().setStr(msghead.substring(41, 49));
        kMsgHead.getMesgPriority().setStr(msghead.substring(147, 148));
        kMsgHead.getEncryptFlag().setStr(msghead.substring(148, 149));
        kMsgHead.getReserve().setStr(msghead.substring(189, 197));
        kMsgHead.getEndFlag().setStr(msghead.substring(197));
        kMsgHead.getOrigSendDate().setStr(msghead.substring(73, 81));
        kMsgHead.getOrigSendTime().setStr(msghead.substring(81, 87));
        kMsgHead.getBodyLength().setStr(msghead.substring(149, 157));
        kMsgHead.getSenderID().setStr(msghead.substring(5, 17));
        kMsgHead.getReceiverID().setStr(msghead.substring(27, 39));
        kMsgHead.getOrigSender().setStr(msghead.substring(49, 61));
        kMsgHead.getOrigReceiver().setStr(msghead.substring(61, 73));
        kMsgHead.getMesgType().setStr(msghead.substring(87, 107));
        kMsgHead.getMesgID().setStr(msghead.substring(107, 127));
        kMsgHead.getMesgRefID().setStr(msghead.substring(127, 147));
        return kMsgHead;
    }

    public static String buildKMsgHead(String senderID, String receiverID, String origSender, String origReceiver, String mesgType, String mesgID, String bodyLength, String bodyXml, String mesgRefID) throws UnsupportedEncodingException, BOSException {
        char endFlag_a = '\r';
        char endFlag_b = '\n';
        String bodyChksum = "";
        try {
            bodyChksum = EcoreStringUtils.hash(bodyXml.getBytes("utf-8"), "MD5");
        }
        catch (UnsupportedEncodingException e1) {
            throw new BOSException((Throwable)e1);
        }
        Date d = new Date();
        SimpleDateFormat sy = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sh = new SimpleDateFormat("HHmmss");
        String origSendDate = sy.format(d);
        String origSendTime = sh.format(d);
        KMsgHead kMsgHead = new KMsgHead();
        kMsgHead.getBeginFlag().setStr("{H:");
        kMsgHead.getVersionID().setStr("01");
        kMsgHead.getSenderSID().setStr("CD");
        kMsgHead.getSenderCID().setStr("        ");
        kMsgHead.getReceiverSID().setStr("CD");
        kMsgHead.getReceiverCID().setStr("        ");
        kMsgHead.getMesgPriority().setStr("3");
        kMsgHead.getEncryptFlag().setStr("N");
        kMsgHead.getReserve().setStr("");
        kMsgHead.getEndFlag().setStr("}" + endFlag_a + endFlag_b);
        kMsgHead.getOrigSendDate().setStr(origSendDate);
        kMsgHead.getOrigSendTime().setStr(origSendTime);
        kMsgHead.getBodyLength().setStr(bodyLength);
        kMsgHead.getBodyChksum().setStr(bodyChksum);
        kMsgHead.getSenderID().setStr(senderID);
        kMsgHead.getReceiverID().setStr(receiverID);
        kMsgHead.getOrigSender().setStr(origSender);
        kMsgHead.getOrigReceiver().setStr(origReceiver);
        kMsgHead.getMesgType().setStr(mesgType);
        kMsgHead.getMesgID().setStr(mesgID);
        if (mesgRefID == null) {
            kMsgHead.getMesgRefID().setStr("                    ");
        } else {
            kMsgHead.getMesgRefID().setStr(mesgRefID);
        }
        StringBuffer res = new StringBuffer();
        res.append("                                                                                                                                                                                                        ");
        res.insert(0, kMsgHead.getBeginFlag().getStr());
        res.insert(3, kMsgHead.getVersionID().getStr());
        res.insert(5, kMsgHead.getSenderID().getStr());
        res.insert(17, kMsgHead.getSenderSID().getStr());
        res.insert(19, kMsgHead.getSenderCID().getStr());
        res.insert(27, kMsgHead.getReceiverID().getStr());
        res.insert(39, kMsgHead.getReceiverSID().getStr());
        res.insert(41, kMsgHead.getReceiverCID().getStr());
        res.insert(49, kMsgHead.getOrigSender().getStr());
        res.insert(61, kMsgHead.getOrigReceiver().getStr());
        res.insert(73, kMsgHead.getOrigSendDate().getStr());
        res.insert(81, kMsgHead.getOrigSendTime().getStr());
        res.insert(87, kMsgHead.getMesgType().getStr());
        res.insert(107, kMsgHead.getMesgID().getStr());
        res.insert(127, kMsgHead.getMesgRefID().getStr());
        res.insert(147, kMsgHead.getMesgPriority().getStr());
        res.insert(148, kMsgHead.getEncryptFlag().getStr());
        res.insert(149, kMsgHead.getBodyLength().getStr());
        res.insert(157, kMsgHead.getBodyChksum().getStr());
        res.insert(189, kMsgHead.getReserve().getStr());
        res.insert(197, kMsgHead.getEndFlag().getStr());
        res.delete(200, res.length());
        return String.valueOf(res);
    }

    public KMsg buildKMsg() {
        return null;
    }
}

