/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds;

import com.kingdee.bos.ui.face.CoreUIObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Dom4jUtil {
    private static final Logger logger = CoreUIObject.getLogger(Dom4jUtil.class);

    public static void main(String[] args) {
        Dom4jUtil.readXML();
    }

    public static Map readXML() {
        HashMap<String, String> rmap = new HashMap<String, String>();
        String xmlPath = "/w:/testCfg.xml";
        File file = new File(xmlPath);
        if (!file.exists()) {
            return null;
        }
        Document doc = Dom4jUtil.getDoc(xmlPath);
        Element root = doc.getRootElement();
        Iterator itr = root.elementIterator("remoteCfg");
        while (itr.hasNext()) {
            Element element = (Element)itr.next();
            try {
                rmap.put("ipStr", Dom4jUtil.getTagText(element, "ipStr"));
                rmap.put("userName", Dom4jUtil.getTagText(element, "userName"));
                rmap.put("userId", Dom4jUtil.getTagText(element, "userId"));
                rmap.put("dataCenterId", Dom4jUtil.getTagText(element, "dataCenterId"));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        Iterator itr2 = root.elementIterator("thread");
        while (itr2.hasNext()) {
            Element element = (Element)itr2.next();
            try {
                rmap.put("isOpen", Dom4jUtil.getTagText(element, "isOpen"));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return rmap;
    }

    public static Document getDoc(String xmlPath) {
        Document doc = null;
        SAXReader saxReader = new SAXReader();
        try {
            doc = saxReader.read(xmlPath);
        }
        catch (DocumentException e) {
            logger.error((Object)e);
        }
        return doc;
    }

    public static String getSingleText(Document doc, String tagName) {
        String strText = "";
        try {
            Element root = doc.getRootElement();
            Iterator itr = root.elementIterator(tagName);
            if (itr.hasNext()) {
                Element e = (Element)itr.next();
                strText = e.getTextTrim();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return strText;
    }

    public static String getTagText(Element element, String tagName) throws Exception {
        String strText = "";
        try {
            Iterator itr = element.elementIterator(tagName);
            if (!itr.hasNext()) {
                throw new Exception("NoThisTagException:" + tagName);
            }
            Element e = (Element)itr.next();
            strText = e.getTextTrim();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return strText;
    }

    public static String[] getTagArr(Element element, String tagName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String strText = "";
        try {
            Iterator itr = element.elementIterator(tagName);
            boolean hasTagFlag = false;
            while (itr.hasNext()) {
                Element e = (Element)itr.next();
                strText = e.getTextTrim();
                list.add(strText);
                hasTagFlag = true;
            }
            if (!hasTagFlag) {
                throw new Exception("NoThisTagException:" + tagName);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return null;
    }
}

