/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.ecore.BizContractReplyBillInfo;
import com.kingdee.eas.fm.ecore.ContractActionBillCollection;
import com.kingdee.eas.fm.ecore.ContractActionBillFactory;
import com.kingdee.eas.fm.ecore.ContractActionBillInfo;
import com.kingdee.eas.fm.ecore.ContractActionEnum;
import com.kingdee.eas.fm.ecore.ContractCancelBillInfo;
import com.kingdee.eas.fm.ecore.ContractOfferReqBillInfo;
import com.kingdee.eas.fm.ecore.ContractReplyTypeEnum;
import com.kingdee.eas.fm.ecore.ContractRescindReqBillInfo;
import com.kingdee.eas.fm.ecore.ContractStateEnum;
import com.kingdee.eas.fm.ecore.CtrctOfferXptNoticeBillInfo;
import com.kingdee.eas.fm.ecore.ElecContractBillCollection;
import com.kingdee.eas.fm.ecore.ElecContractBillFactory;
import com.kingdee.eas.fm.ecore.ElecContractBillInfo;
import com.kingdee.eas.fm.ecore.FMECDSBillBaseInfo;
import com.kingdee.eas.fm.ecore.IFMECDSBillBase;
import com.kingdee.eas.fm.ecore.IOperateServiceAgreement;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementFactory;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Date;
import org.apache.log4j.Logger;

public class ECDSContractUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon");

    public static ElecContractBillInfo findElecContractInfo(Context ctx, String IdNb) throws BOSException {
        if (null == IdNb) {
            return null;
        }
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("contractNumber", (Object)IdNb));
        viewinfo.setFilter(fi);
        ElecContractBillCollection ec = ElecContractBillFactory.getLocalInstance(ctx).getElecContractBillCollection(viewinfo);
        if (ec.size() != 0) {
            return ec.get(0);
        }
        return null;
    }

    public static void updateElecContractWithRescissionInfo(Context ctx, String contractNumber, ContractRescindReqBillInfo rescindInfo) throws EASBizException, BOSException {
        ElecContractBillInfo contractInfo = ECDSContractUtil.findElecContractInfo(ctx, contractNumber);
        if (contractInfo.isIsRescinded() && contractInfo.getRscisnPropsrCmonId() != null) {
            return;
        }
        contractInfo.setRescissionDate(rescindInfo.getCtrctDate());
        contractInfo.setRscisnMrkr(rescindInfo.getRscisnMrkr());
        contractInfo.setRescissionCode(rescindInfo.getRscisnRsnCd());
        contractInfo.setRscisnRsnRmrk(rescindInfo.getRscisnRsnRmrk());
        contractInfo.setRscisnPropsrRole(rescindInfo.getRscisnPropsrRole());
        contractInfo.setRscisnPropsrCmonId(rescindInfo.getRscisnPropsrOrgCode());
        contractInfo.setRscisnPropsrElctrncSgntr(rescindInfo.getElctrncSgntr());
        contractInfo.setRscisnPropsrAccount(rescindInfo.getRscisnPropsrAcount());
        contractInfo.setRscisnPropsrBank(rescindInfo.getRscisnPropsrBank());
        contractInfo.setRscisnPropsrAgcyBank(rescindInfo.getRscisnPropsrBankBak());
        contractInfo.setIsRescinded(true);
        ElecContractBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(contractInfo.getId()), (CoreBaseInfo)contractInfo);
    }

    public static FMECDSBillBaseInfo getOriginalReceiveInfo(Context ctx, BizContractReplyBillInfo replyInfo, boolean isFindSendAction) throws BOSException, EASBizException {
        if (isFindSendAction) {
            return ECDSContractUtil.getApplyBillInfoByMessageID(ctx, replyInfo.getOriMessageID(), null, new ContractActionEnum[]{ContractActionEnum.SEND});
        }
        return ECDSContractUtil.getApplyBillInfoByMessageID(ctx, replyInfo.getOriMessageID(), replyInfo.getReplierOrgCode(), new ContractActionEnum[]{ContractActionEnum.RECEIVE});
    }

    public static FMECDSBillBaseInfo getOriginalApplyInfo(Context ctx, ContractCancelBillInfo cancelInfo, boolean isFindSendAction) throws BOSException, EASBizException {
        if (isFindSendAction) {
            return ECDSContractUtil.getApplyBillInfoByMessageID(ctx, cancelInfo.getOrgnlMsgId(), cancelInfo.getCxlPropsrCmonId(), new ContractActionEnum[]{ContractActionEnum.SEND});
        }
        return ECDSContractUtil.getApplyBillInfoByMessageID(ctx, cancelInfo.getOrgnlMsgId(), null, new ContractActionEnum[]{ContractActionEnum.RECEIVE});
    }

    public static FMECDSBillBaseInfo getOriginalApplyInfo(Context ctx, CtrctOfferXptNoticeBillInfo xptInfo, boolean isFindSendAction) throws BOSException, EASBizException {
        if (isFindSendAction) {
            return ECDSContractUtil.getApplyBillInfoByMessageID(ctx, xptInfo.getOrgMessageID(), null, new ContractActionEnum[]{ContractActionEnum.SEND});
        }
        return null;
    }

    private static FMECDSBillBaseInfo getApplyBillInfoByMessageID(Context ctx, String messageID, String holderOrgCode, ContractActionEnum[] actionType) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("messageId", (Object)messageID);
        StringBuffer markString = new StringBuffer("#0");
        if (actionType != null && actionType.length > 0) {
            filter.appendFilterItem("actionType", (Object)new Integer(actionType[0].getValue()));
            markString.append(" and (#1 ");
            for (int i = 1; i < actionType.length; ++i) {
                filter.appendFilterItem("actionType", (Object)new Integer(actionType[i].getValue()));
                markString.append(" or #" + (i + 1));
            }
            markString.append(")");
        }
        if (holderOrgCode != null) {
            filter.appendFilterItem("holderOrgCode", (Object)holderOrgCode);
            int orgPosition = actionType != null && actionType.length > 0 ? actionType.length + 1 : 1;
            markString.append(" and #" + orgPosition);
        }
        filter.setMaskString(markString.toString());
        view.setFilter(filter);
        ContractActionBillCollection actionBillCol = ContractActionBillFactory.getLocalInstance(ctx).getContractActionBillCollection(view);
        if (actionBillCol.size() > 0) {
            ContractActionBillInfo actionBill = actionBillCol.get(0);
            String bizRecordID = actionBill.getBizRecordBillID();
            if (bizRecordID == null) {
                return null;
            }
            BOSObjectType bosType = BOSUuid.read((String)bizRecordID).getType();
            IFMECDSBillBase fmECDSBillBase = (IFMECDSBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(bosType);
            return fmECDSBillBase.getFMECDSBillBaseInfo((IObjectPK)new ObjectStringPK(bizRecordID));
        }
        return null;
    }

    public static String findOrgCodeByAccountAndBank(Context ctx, String accountNumber, String bankNumber) throws EASBizException, BOSException {
        EntityViewInfo v1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bizGatherNumber", (Object)accountNumber, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("bizPayNumber", (Object)accountNumber, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("actorBank", (Object)bankNumber, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("enable", (Object)new Boolean(true), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("openDate", (Object)new Date(), CompareType.LESS_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("endDate", (Object)new Date(), CompareType.GREATER_EQUALS));
        fi.setMaskString("(#0 or #1) and #2 and #3 and #4 and #5 ");
        v1.setFilter(fi);
        IOperateServiceAgreement Ioper = OperateServiceAgreementFactory.getLocalInstance(ctx);
        OperateServiceAgreementInfo info = Ioper.getOperateServiceAgreementCollection(v1).get(0);
        return info.getBizOrgNumber();
    }

    public static void insertElecContractBillInfo(Context ctx, ContractOfferReqBillInfo offerReqInfo, BizContractReplyBillInfo replyBillInfo) throws BOSException, EASBizException {
        if (!ECDSContractUtil.isExistElecContractBillByContractNumber(ctx, replyBillInfo.getCtrctNumber())) {
            if (replyBillInfo.getReplyType().equals((Object)ContractReplyTypeEnum.YYHF)) {
                ElecContractBillInfo contractInfo = new ElecContractBillInfo();
                contractInfo.setIssueDate(offerReqInfo.getIssueDate());
                contractInfo.setContractType(offerReqInfo.getContractType());
                if (offerReqInfo.getDueDate() != null) {
                    contractInfo.setDueDate(offerReqInfo.getDueDate());
                }
                contractInfo.setCanlationMarker(offerReqInfo.getCanlationMarker());
                contractInfo.setRescissionType(offerReqInfo.getRescissionType());
                contractInfo.setContentFormat(offerReqInfo.getContentFormat());
                contractInfo.setContent(offerReqInfo.getContent());
                contractInfo.setSaveTime(offerReqInfo.getSaveTime());
                contractInfo.setOfferRole(offerReqInfo.getOfferRole());
                contractInfo.setOfferName(offerReqInfo.getOfferName());
                contractInfo.setOfferOrgCode(offerReqInfo.getOfferOrgCode());
                contractInfo.setOfferElecSign(offerReqInfo.getOfferElecSign());
                contractInfo.setOfferAccount(offerReqInfo.getOfferAccount());
                contractInfo.setOfferBank(offerReqInfo.getOfferBank());
                contractInfo.setOffeeRole(replyBillInfo.getReplierRole());
                contractInfo.setOffeeName(offerReqInfo.getOffeeName());
                contractInfo.setOffeeOrgCode(replyBillInfo.getReplierOrgCode());
                contractInfo.setOffeeElecSign(replyBillInfo.getReplierElctrncSgntr());
                contractInfo.setOffeeAccount(replyBillInfo.getReplierAccount());
                contractInfo.setOffeeBank(replyBillInfo.getReplierBank());
                contractInfo.setOffeeReplyDate(replyBillInfo.getRspnsMrDt());
                contractInfo.setContractNumber(replyBillInfo.getCtrctNumber());
                contractInfo.setContractStatus(ContractStateEnum.YW04);
                contractInfo.setIsRescinded(false);
                ElecContractBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)contractInfo);
            }
        } else {
            return;
        }
    }

    public static boolean isExistElecContractBillByContractNumber(Context ctx, String contractNumber) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("contractNumber", (Object)contractNumber));
        viewinfo.setFilter(fi);
        ElecContractBillCollection cc = ElecContractBillFactory.getLocalInstance(ctx).getElecContractBillCollection(viewinfo);
        return cc.size() != 0;
    }

    public static ContractActionBillInfo findContracttSendActionBill(Context ctx, String messageId) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.appendFilterItem("messageID", (Object)messageId);
        fi.appendFilterItem("actionType", (Object)new Integer(0));
        fi.appendFilterItem("actionType", (Object)new Integer(2));
        fi.appendFilterItem("actionType", (Object)new Integer(1));
        fi.appendFilterItem("actionType", (Object)new Integer(12));
        fi.setMaskString("#0 and (#1 or #2 or #3 or #4)");
        viewinfo.setFilter(fi);
        ContractActionBillCollection cc = ContractActionBillFactory.getLocalInstance(ctx).getContractActionBillCollection(viewinfo);
        if (cc.size() != 0) {
            return cc.get(0);
        }
        return null;
    }
}

