/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECoreException;
import com.kingdee.eas.fm.ecore.IApplyBillBase;
import com.kingdee.eas.fm.ecore.IPaperDraftBillBase;
import com.kingdee.eas.fm.ecore.PaperApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.PaperDraftBillBaseInfo;
import com.kingdee.eas.fm.ecore.app.KMsgUtil;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendCommercialDraftRepurchasedDiscountRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendContractCommonCancellation;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendContractCommonResponse;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendContractRescissionRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftAcceptanceRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftAnnulingSuspendingPaymentRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftCertificateBindingRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftCollectionRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftCreditInfomationQueryRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftDestructionRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftDiscountRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftDrawingbackRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftEndorsementRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftFreeFormatMessageRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftMonthlySummaryRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftOverduePresentationRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftPaymentRefusedRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftRecourseAgreementRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftRecourseNotificationRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftRediscountWithCentralBankRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftRediscountWithCommercialBankRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftRepurchasedCollateralizationRegiste;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftRepurchasedRediscountWithCentralBankRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftSettlementRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftShowADraftRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendDraftSuspendingPaymentRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandleContractOfferRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandleDraftPresentationRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerAcceptanceRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftCancellationRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftCollateralizationRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftCommonSignUp;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftQuotingRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftRediscountWithCentralBankRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftRegisterInformationQuery;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftRepurchasedCollateralizationRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerCommercialDraftRepurchasedRediscountWithCommercialBankRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerContractMonthlyDetailsRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerContractMonthlySummaryRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerDiscountRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerGuaranteeRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerIssuanceRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHandlerRegisterRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.SendHanleCommercialDraftCentralBankSellingDraftsRequest;
import com.kingdee.eas.fm.ecore.app.ecds.impl.sendHandlerCommercialDraftCollateralizationRegister;
import com.kingdee.eas.fm.ecore.app.ecds.impl.sendHandlerCommercialDraftRediscountWithCommercialBankRegister;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ECDSUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.ECDSUtil");

    public static void send(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String msgType = "";
        ISendHandler buildMsgBean = null;
        KMsg kmsg = null;
        String oppAccountBank = "";
        String sendBank = "";
        try {
            msgType = ECDSUtil.findMsgTypeByBillBaseInfo(billBaseInfo);
            buildMsgBean = ECDSUtil.switchBeanByMsgType(msgType);
            kmsg = buildMsgBean.sendBefore(ctx, billBaseInfo);
            buildMsgBean.checkAndFill(ctx, kmsg, billBaseInfo);
            oppAccountBank = buildMsgBean.getOppAccountBank(ctx, billBaseInfo);
            sendBank = buildMsgBean.getSendBank(ctx, billBaseInfo);
            if (billBaseInfo instanceof ApplyBillBaseInfo) {
                ApplyBillBaseInfo info = (ApplyBillBaseInfo)billBaseInfo;
                info.setIsApplySuccess(ApplyBillStatusEnum.SEND_TO_ECDS);
                IApplyBillBase applyBillBase = (IApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(info.getBOSType());
                applyBillBase.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            } else if (billBaseInfo instanceof PaperDraftBillBaseInfo) {
                PaperDraftBillBaseInfo info = (PaperDraftBillBaseInfo)billBaseInfo;
                info.setApplyStatus(PaperApplyBillStatusEnum.SEND_TO_ECDS);
                IPaperDraftBillBase paperDraftBillBase = (IPaperDraftBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(info.getBOSType());
                paperDraftBillBase.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"26_ECDSUtil", (Locale)ctx.getLocale()));
        }
        catch (Exception e) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"27_ECDSUtil", (Locale)ctx.getLocale()) + e.getMessage()));
            throw new ECoreException(ECoreException.SEND_BIZ_BUILDMSG, e);
        }
        KMsgUtil.send(ctx, msgType, kmsg, "01", oppAccountBank, ECDSUtil.findSendFlagByBillBaseInfo(billBaseInfo), ECDSUtil.findHasPtcptSgntr(billBaseInfo), null, buildMsgBean, billBaseInfo, sendBank);
    }

    private static boolean findHasPtcptSgntr(BillBaseInfo billBaseInfo) {
        BOSObjectType bosType = billBaseInfo.getBOSType();
        String bosTypeStr = bosType.toString();
        return ECDSCommon.findHasPtcptSgntr(bosTypeStr);
    }

    private static String findSendFlagByBillBaseInfo(BillBaseInfo billBaseInfo) {
        BOSObjectType bosType = billBaseInfo.getBOSType();
        String bosTypeStr = bosType.toString();
        return ECDSCommon.findMqTypeByBosType(bosTypeStr);
    }

    public static String findMsgTypeByBillBaseInfo(BillBaseInfo billBaseInfo) {
        BOSObjectType bosType = billBaseInfo.getBOSType();
        String bosTypeStr = bosType.toString();
        return ECDSCommon.findMsgTypeByBosType(bosTypeStr);
    }

    private static ISendHandler switchBeanByMsgType(String msgType) {
        logger.info((Object)(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"28_ECDSUtil") + msgType));
        if ("001".equals(msgType)) {
            return new SendHandlerRegisterRequest();
        }
        if ("002".equals(msgType)) {
            return new SendHandlerAcceptanceRequest();
        }
        if ("003".equals(msgType)) {
            return new SendHandlerIssuanceRequest();
        }
        if ("004".equals(msgType)) {
            return new SendDraftDestructionRequest();
        }
        if ("010".equals(msgType)) {
            return new SendDraftEndorsementRequest();
        }
        if ("011".equals(msgType)) {
            return new SendHandlerDiscountRequest();
        }
        if ("012".equals(msgType)) {
            return new SendCommercialDraftRepurchasedDiscountRequest();
        }
        if ("013".equals(msgType)) {
            return new SendDraftRediscountWithCommercialBankRequest();
        }
        if ("014".equals(msgType)) {
            return new SendHandlerCommercialDraftRepurchasedRediscountWithCommercialBankRequest();
        }
        if ("015".equals(msgType)) {
            return new SendDraftRediscountWithCentralBankRequest();
        }
        if ("016".equals(msgType)) {
            return new SendDraftRepurchasedRediscountWithCentralBankRequest();
        }
        if ("017".equals(msgType)) {
            return new SendHandlerGuaranteeRequest();
        }
        if ("018".equals(msgType)) {
            return new SendHandlerCommercialDraftCollateralizationRequest();
        }
        if ("019".equals(msgType)) {
            return new SendHandlerCommercialDraftRepurchasedCollateralizationRequest();
        }
        if ("020".equals(msgType)) {
            return new SendHandleDraftPresentationRequest();
        }
        if ("021".equals(msgType)) {
            return new SendDraftOverduePresentationRequest();
        }
        if ("022".equals(msgType)) {
            return new SendDraftRecourseNotificationRequest();
        }
        if ("023".equals(msgType)) {
            return new SendDraftRecourseAgreementRequest();
        }
        if ("025".equals(msgType)) {
            return new SendHanleCommercialDraftCentralBankSellingDraftsRequest();
        }
        if ("031".equals(msgType)) {
            return new SendHandlerCommercialDraftCommonSignUp();
        }
        if ("032".equals(msgType)) {
            return new SendHandlerCommercialDraftCancellationRequest();
        }
        if ("037".equals(msgType)) {
            return new SendDraftCreditInfomationQueryRequest();
        }
        if ("039".equals(msgType)) {
            return new SendDraftFreeFormatMessageRequest();
        }
        if ("076".equals(msgType)) {
            return new SendDraftMonthlySummaryRequest();
        }
        if ("107".equals(msgType)) {
            return new SendDraftCollectionRegister();
        }
        if ("207".equals(msgType)) {
            return new SendContractRescissionRequest();
        }
        if ("042".equals(msgType)) {
            return new SendDraftShowADraftRequest();
        }
        if ("065".equals(msgType)) {
            return new SendDraftCertificateBindingRequest();
        }
        if ("206".equals(msgType)) {
            return new SendContractCommonCancellation();
        }
        if ("101".equals(msgType)) {
            return new SendDraftAcceptanceRegister();
        }
        if ("102".equals(msgType)) {
            return new SendDraftDiscountRegister();
        }
        if ("103".equals(msgType)) {
            return new sendHandlerCommercialDraftRediscountWithCommercialBankRegister();
        }
        if ("104".equals(msgType)) {
            return new SendHandlerCommercialDraftRediscountWithCentralBankRegister();
        }
        if ("105".equals(msgType)) {
            return new sendHandlerCommercialDraftCollateralizationRegister();
        }
        if ("106".equals(msgType)) {
            return new SendDraftRepurchasedCollateralizationRegiste();
        }
        if ("108".equals(msgType)) {
            return new SendDraftSettlementRegister();
        }
        if ("109".equals(msgType)) {
            return new SendDraftPaymentRefusedRegister();
        }
        if ("110".equals(msgType)) {
            return new SendDraftSuspendingPaymentRegister();
        }
        if ("111".equals(msgType)) {
            return new SendDraftAnnulingSuspendingPaymentRegister();
        }
        if ("201".equals(msgType)) {
            return new SendHandleContractOfferRequest();
        }
        if ("125".equals(msgType)) {
            return new SendDraftDrawingbackRegister();
        }
        if ("121".equals(msgType)) {
            return new SendHandlerCommercialDraftRegisterInformationQuery();
        }
        if ("221".equals(msgType)) {
            return new SendHandlerContractMonthlySummaryRequest();
        }
        if ("123".equals(msgType)) {
            return new SendHandlerCommercialDraftQuotingRequest();
        }
        if ("223".equals(msgType)) {
            return new SendHandlerContractMonthlyDetailsRequest();
        }
        if ("205".equals(msgType)) {
            return new SendContractCommonResponse();
        }
        return null;
    }
}

