/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.ecore.DraftHoldTypeEnum;
import com.kingdee.eas.fm.ecore.DraftMonthlySummaryFactory;
import com.kingdee.eas.fm.ecore.DraftMonthlySummaryInfo;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftMonthlyDetailsRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftMonthlySummaryInformation;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.DocumentCommercialDraft;
import com.kingdee.eas.fm.ecore.app.bean.node.Accptd;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.ForComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Hldg;
import com.kingdee.eas.fm.ecore.app.bean.node.Ptcpt;
import com.kingdee.eas.fm.ecore.app.bean.node.SummryDt;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.IMsgReceiveCallBack;
import com.kingdee.eas.fm.ecore.app.util.DateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CallBackDraftMonthlySummaryInformation
implements IMsgReceiveCallBack {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.impl.CallBackDraftMonthlySummaryInformation");

    @Override
    public void parseRecMsg(Context ctx, String msgNum, KMsg kmsg, KMsgHead kmsgHead) throws EASBizException, BOSException {
        DocumentCommercialDraft dm = kmsg.getDocumentCommercialDraft();
        CommercialDraftMonthlySummaryInformation dr = (CommercialDraftMonthlySummaryInformation)dm;
        List ptcptList = dr.getPtcpt();
        Iterator it = ptcptList.iterator();
        HashMap<String, String> draft2bank = new HashMap<String, String>();
        HashMap<String, String> draft2Amt = new HashMap<String, String>();
        while (it.hasNext()) {
            Ptcpt ptcpt = (Ptcpt)it.next();
            DraftMonthlySummaryInfo info = new DraftMonthlySummaryInfo();
            info.setOrgnlMsgId(dr.getOrgnlMsgId().getId());
            info.setOrgnlMsgDt(ECDSCommon.getDateByStr(dr.getOrgnlMsgId().getCreDtTm()));
            info.setSeqNb(dr.getSgmntn().getSeqNb());
            info.setNbOfSgmnts(dr.getSgmntn().getNbOfSgmnts());
            info.setSummryDt(DateUtil.parseDate(dr.getSummryDt().getDt()));
            info.setAcctSvcr(ptcpt.getAcct().getAcctSvcr());
            List accptList = ptcpt.getAccptd();
            for (int i = 0; i < accptList.size(); ++i) {
                Accptd accptd = (Accptd)accptList.get(i);
                info.setHoldType(DraftHoldTypeEnum.Accptd);
                info.setEclDraftNumber(accptd.getComrclDrft().getIdNb());
                draft2Amt.put(accptd.getComrclDrft().getIdNb(), accptd.getComrclDrft().getIsseAmt());
                draft2bank.put(accptd.getComrclDrft().getIdNb(), accptd.getAccptr().getAcct().getId());
                info.setIsseAmt(new BigDecimal(accptd.getComrclDrft().getIsseAmt()));
                info.setAccount(accptd.getAccptr().getAcct().getId());
                DraftMonthlySummaryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            }
            List hldrList = ptcpt.getHldg();
            for (int i = 0; i < hldrList.size(); ++i) {
                Hldg hldg = (Hldg)hldrList.get(i);
                info.setHoldType(DraftHoldTypeEnum.Hldg);
                info.setEclDraftNumber(hldg.getComrclDrft().getIdNb());
                draft2Amt.put(hldg.getComrclDrft().getIdNb(), hldg.getComrclDrft().getIsseAmt());
                draft2bank.put(hldg.getComrclDrft().getIdNb(), hldg.getAcct().getId());
                info.setIsseAmt(new BigDecimal(hldg.getComrclDrft().getIsseAmt()));
                info.setAccount(hldg.getAcct().getId());
                info.setDraftStatus(ECDSBillStatusEnum.getEnum(hldg.getComrclDrft().getSts()));
                DraftMonthlySummaryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            }
        }
    }

    private void draftMonthDetailRequest(Context ctx, Map draft2bank, Map draft2Amt, Date checkDate) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        CommercialDraftMonthlyDetailsRequest messageInfo = new CommercialDraftMonthlyDetailsRequest();
        Set draftSet = draft2bank.keySet();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("draftNumber", draftSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ElecDraftBillCollection colls = ElecDraftBillFactory.getLocalInstance(ctx).getElecDraftBillCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            ElecDraftBillInfo info = colls.get(i);
            draftSet.remove(info.getDraftNumber());
        }
        HashMap bank2Draft = new HashMap();
        for (String draftNumber : draftSet) {
            List<String> draftList;
            String bank = (String)draft2bank.get(draftNumber);
            if (bank2Draft.containsKey(bank)) {
                draftList = (List)bank2Draft.get(bank);
                draftList.add(draftNumber);
                bank2Draft.put(bank, draftList);
                continue;
            }
            draftList = new ArrayList();
            draftList.add(draftNumber);
            bank2Draft.put(bank, draftList);
        }
        SummryDt summryDt = new SummryDt();
        summryDt.setDt(DateHelper.formatDate2((Date)checkDate));
        messageInfo.setSummryDt(summryDt);
        ArrayList ptcpt = new ArrayList();
        Ptcpt ptcptInfo = new Ptcpt();
        Set bankSet = bank2Draft.keySet();
        for (String bankCode : bankSet) {
            Set drafts = (Set)bank2Draft.get(bankCode);
            ArrayList<ForComrclDrft> comrclDrftList = new ArrayList<ForComrclDrft>();
            for (String draftNumber : drafts) {
                ForComrclDrft forComrclDrft = new ForComrclDrft();
                forComrclDrft.setIdNb(draftNumber);
                forComrclDrft.setIsseAmt((String)draft2Amt.get(draftNumber));
                comrclDrftList.add(forComrclDrft);
            }
            ptcptInfo.setForComrclDrft(comrclDrftList);
            Acct acct = new Acct();
            acct.setAcctSvcr(bankCode);
            ptcptInfo.setAcct(acct);
            messageInfo.setPtcpt(ptcpt);
            kMsg.setDocumentCommercialDraft(messageInfo);
        }
    }
}

