/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.BusinessEnum;
import com.kingdee.eas.fm.ecore.DraftEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.EcdsException;
import com.kingdee.eas.fm.ecore.QuotingEnum;
import com.kingdee.eas.fm.ecore.QuotingRequestBillFactory;
import com.kingdee.eas.fm.ecore.QuotingRequestBillInfo;
import com.kingdee.eas.fm.ecore.QuotingRequestEntryBillFactory;
import com.kingdee.eas.fm.ecore.QuotingRequestEntryBillInfo;
import com.kingdee.eas.fm.ecore.QuotingTypEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.ecore.SystemActionStatusEnum;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftQuotingRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.DocumentCommercialDraft;
import com.kingdee.eas.fm.ecore.app.bean.node.Brdcstee;
import com.kingdee.eas.fm.ecore.app.bean.node.QtgInf;
import com.kingdee.eas.fm.ecore.app.bean.node.Qtr;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.IMsgReceiveCallBack;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;

public class CallbackCommercialDraftQuotingRequest
implements IMsgReceiveCallBack {
    @Override
    public void parseRecMsg(Context ctx, String msgNum, KMsg kmsg, KMsgHead kmsgHead) throws EASBizException, BOSException {
        DocumentCommercialDraft dm = kmsg.getDocumentCommercialDraft();
        CommercialDraftQuotingRequest commercialDraftQuotingRequest = (CommercialDraftQuotingRequest)dm;
        try {
            this.commercialDraftQuotingRequest(commercialDraftQuotingRequest, ctx, kmsg);
        }
        catch (ParseException e) {
            throw new EcdsException(EcdsException.DATAERROR);
        }
    }

    public void commercialDraftQuotingRequest(CommercialDraftQuotingRequest commercialDraftQuotingRequest, Context ctx, KMsg kmsg) throws BOSException, ParseException, EASBizException {
        QuotingRequestBillInfo info = new QuotingRequestBillInfo();
        info.setMessageID(commercialDraftQuotingRequest.getMsgId().getId());
        info.setMessageTime(ECDSCommon.getTimestampByStr(commercialDraftQuotingRequest.getMsgId().getCreDtTm()));
        QtgInf qtgInf = commercialDraftQuotingRequest.getQtgInf();
        info.setQuotingType(QuotingEnum.getEnum(qtgInf.getQtgTp()));
        info.setBusinessType(BusinessEnum.getEnum(qtgInf.getBizTp()));
        info.setQuotingAmount(new BigDecimal(qtgInf.getAmt()));
        info.setQuotingRate(new BigDecimal(qtgInf.getIntrstRate()));
        info.setQuotingTerm(new BigDecimal(qtgInf.getRmdrMtrty()));
        info.setAccptrScp(qtgInf.getAccptrScp());
        info.setDraftType(DraftEnum.getEnum(qtgInf.getDrftTp()));
        info.setXprtnDt(new BigDecimal(qtgInf.getXprtnDt()));
        info.setIsSend(false);
        Qtr qtr = commercialDraftQuotingRequest.getQtr();
        info.setQtrType(RoleEnum.getEnum(qtr.getRole()));
        info.setQtrName(qtr.getNm());
        info.setQtrBank(qtr.getAcct().getAcctSvcr());
        info.setPhoneNumber(qtr.getPhneNb());
        List brdcsteeList = commercialDraftQuotingRequest.getBrdcstee();
        IObjectPK newPK = null;
        if (brdcsteeList == null || brdcsteeList.size() <= 0) {
            newPK = QuotingRequestBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
        } else {
            newPK = QuotingRequestBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            for (int i = 0; i < brdcsteeList.size(); ++i) {
                Brdcstee brdcstee = (Brdcstee)brdcsteeList.get(i);
                QuotingRequestEntryBillInfo entry = new QuotingRequestEntryBillInfo();
                entry.setParentID(BOSUuid.read((String)newPK.toString()));
                entry.setRecvQuotingType(QuotingTypEnum.getEnum(brdcstee.getTp()));
                entry.setRecvBank(brdcstee.getAcct().getAcctSvcr());
                QuotingRequestEntryBillFactory.getLocalInstance(ctx).addnew(entry);
            }
        }
        ECDSCommon.insertSystemAction(ctx, kmsg, null, null, null, String.valueOf(newPK), SystemActionStatusEnum.RECEIVE_SYSTEM_NOTICE, null, DraftMessageEnum.M123);
    }
}

