/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECoreException;
import com.kingdee.eas.fm.ecore.ExceptionCodeEnum;
import com.kingdee.eas.fm.ecore.ExceptionNotificationBillFactory;
import com.kingdee.eas.fm.ecore.ExceptionNotificationBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementCollection;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementFactory;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.KMsgUtil;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCentralBankSellingDraftsRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCollateralizationRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftCommonTransmission;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftDiscountRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftEndorsementRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftExceptionNotification;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftGuaranteeRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRecourseNotification;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCentralBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCommercialBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.OrgnlMsgId;
import com.kingdee.eas.fm.ecore.app.bean.node.XcptnInf;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.util.FmEcrUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CommercialDraftExceptionNotificationImpl {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.impl.CommercialDraftExceptionNotificationImpl");
    private static String BIZ_ERROR = "BIZ_ERROR";

    public boolean checkCommercialDraftExceptionNotification(Context ctx, KMsg kmsg, KMsgHead kMsgHead) throws BOSException, EASBizException {
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"151_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
        String nm = "";
        String acctId = "";
        String acctSvcr = "";
        String rcvgAcctId = "";
        ECDSBillStatusEnum ebEnum = null;
        CommercialDraftCommonTransmission cc = (CommercialDraftCommonTransmission)kmsg.getDocumentCommercialDraft();
        if (cc.getReqInf().getCommercialDraftEndorsementRequest() != null) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"152_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            CommercialDraftEndorsementRequest ce = cc.getReqInf().getCommercialDraftEndorsementRequest();
            ebEnum = ECDSBillStatusEnum.BSDQS;
            nm = ce.getEndrsee().getNm();
            acctId = ce.getEndrsee().getAcct().getId();
            acctSvcr = ce.getEndrsee().getAcct().getAcctSvcr();
        } else if (cc.getReqInf().getCommercialDraftRediscountWithCommercialBankRequest() != null) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"153_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            ebEnum = ECDSBillStatusEnum.HGSZHTXDQS;
            CommercialDraftRediscountWithCommercialBankRequest cr = cc.getReqInf().getCommercialDraftRediscountWithCommercialBankRequest();
            nm = cr.getRcvgBkOfRdscntWthComrclBk().getNm();
            acctId = cr.getRcvgBkOfRdscntWthComrclBk().getAcct().getId();
            acctSvcr = cr.getRcvgBkOfRdscntWthComrclBk().getAcct().getAcctSvcr();
        } else if (cc.getReqInf().getCommercialDraftDiscountRequest() != null) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"108_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
            ebEnum = ECDSBillStatusEnum.HGSTXDQS;
            CommercialDraftDiscountRequest cr = cc.getReqInf().getCommercialDraftDiscountRequest();
            nm = cr.getDscntBk().getNm();
            acctId = cr.getDscntBk().getAcct().getId();
            acctSvcr = cr.getDscntBk().getAcct().getAcctSvcr();
            rcvgAcctId = cr.getAOAccnInf().getId();
        } else {
            if (cc.getReqInf().getCommercialDraftRepurchasedDiscountRequest() != null) {
                return true;
            }
            if (cc.getReqInf().getCommercialDraftRediscountWithCentralBankRequest() != null) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"110_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                ebEnum = ECDSBillStatusEnum.MDSZTXDQS;
                CommercialDraftRediscountWithCentralBankRequest cr = cc.getReqInf().getCommercialDraftRediscountWithCentralBankRequest();
                nm = cr.getRdscntWthCntrlBkSys().getNm();
                acctId = cr.getRdscntWthCntrlBkSys().getAcct().getId();
                acctSvcr = cr.getRdscntWthCntrlBkSys().getAcct().getAcctSvcr();
            } else if (cc.getReqInf().getCommercialDraftRecourseNotification() != null) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"111_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                CommercialDraftRecourseNotification cr = cc.getReqInf().getCommercialDraftRecourseNotification();
                ebEnum = cr.getRcrs().getTp() == ECDSBillStatusEnum.JFZSDQC.getValue() ? ECDSBillStatusEnum.JFZSDQC : ECDSBillStatusEnum.FJFZSDQC;
                nm = cr.getRcvgPrsnOfRcrs().getNm();
                acctId = cr.getRcvgPrsnOfRcrs().getAcct().getId();
                acctSvcr = cr.getRcvgPrsnOfRcrs().getAcct().getAcctSvcr();
            } else if (cc.getReqInf().getCommercialDraftGuaranteeRequest() != null) {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"112_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                ebEnum = ECDSBillStatusEnum.BZDQS;
                CommercialDraftGuaranteeRequest cr = cc.getReqInf().getCommercialDraftGuaranteeRequest();
                nm = cr.getGuarntr().getNm();
                acctId = cr.getGuarntr().getAcct().getId();
                acctSvcr = cr.getGuarntr().getAcct().getAcctSvcr();
            } else {
                if (cc.getReqInf().getCommercialDraftRepurchasedRediscountWithCommercialBankRequest() != null) {
                    return true;
                }
                if (cc.getReqInf().getCommercialDraftOverduePresentationRequest() != null) {
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"114_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                    return true;
                }
                if (cc.getReqInf().getCommercialDraftCollateralizationRequest() != null) {
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"115_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                    ebEnum = ECDSBillStatusEnum.ZYDQS;
                    CommercialDraftCollateralizationRequest cr = cc.getReqInf().getCommercialDraftCollateralizationRequest();
                    nm = cr.getCollztnBk().getNm();
                    acctId = cr.getCollztnBk().getAcct().getId();
                    acctSvcr = cr.getCollztnBk().getAcct().getAcctSvcr();
                } else {
                    if (cc.getReqInf().getCommercialDraftPresentationRequest() != null) {
                        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"116_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                        ebEnum = ECDSBillStatusEnum.TSFKDQS;
                        return true;
                    }
                    if (cc.getReqInf().getCommercialDraftRepurchasedCollateralizationRequest() != null) {
                        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"117_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                        return true;
                    }
                    if (cc.getReqInf().getCommercialDraftAcceptanceRequest() != null) {
                        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"154_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
                        return true;
                    }
                    if (cc.getReqInf().getCommercialDraftCentralBankSellingDraftsRequest() != null) {
                        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"119_CallBackDraftCommonTransmission", (Locale)ctx.getLocale()));
                        CommercialDraftCentralBankSellingDraftsRequest ce = cc.getReqInf().getCommercialDraftCentralBankSellingDraftsRequest();
                        ebEnum = ECDSBillStatusEnum.YHMPDQS;
                        nm = ce.getBuyrInf().getNm();
                        acctId = ce.getBuyrInf().getAcct().getId();
                        acctSvcr = ce.getBuyrInf().getAcct().getAcctSvcr();
                    } else if (cc.getReqInf().getCommercialDraftIssuanceRequest() != null) {
                        return true;
                    }
                }
            }
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"155_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
        return this.checkPramAndSend(cc, ctx, nm, acctId, acctSvcr, rcvgAcctId, ebEnum);
    }

    private boolean checkPramAndSend(CommercialDraftCommonTransmission cc, Context ctx, String nm, String acctId, String acctSvcr, String rcvgAcctId, ECDSBillStatusEnum ebEnum) throws BOSException, EASBizException {
        String msgId = cc.getMsgId().getId();
        String origSender = msgId.substring(0, 12);
        ExceptionCodeEnum cenum = this.checkParm(ctx, nm, acctId, acctSvcr, rcvgAcctId);
        if (cenum != null) {
            String id = cc.getMsgId().getId();
            String creDtTm = cc.getMsgId().getCreDtTm();
            String idNb = cc.getComrclDrft().getIdNb();
            String isseAmt = cc.getComrclDrft().getIsseAmt();
            ExceptionNotificationBillInfo info = new ExceptionNotificationBillInfo();
            info.setOrgnlId(id);
            info.setOrgnlCreDtTm(ECDSCommon.getDateByStr(creDtTm));
            info.setComrclIdNb(idNb);
            info.setComrclIsseAmt(new BigDecimal(isseAmt));
            info.setXcptnCd(cenum);
            info.setIsSend(true);
            IObjectPK pk = ExceptionNotificationBillFactory.getLocalInstance(ctx).addnew(info);
            KMsg kMsg = new KMsg();
            OrgnlMsgId orgnlMsgId = new OrgnlMsgId();
            orgnlMsgId.setId(cc.getMsgId().getId());
            orgnlMsgId.setCreDtTm(cc.getMsgId().getCreDtTm());
            ComrclDrft comrclDrft = new ComrclDrft();
            comrclDrft.setIdNb(cc.getComrclDrft().getIdNb());
            comrclDrft.setIsseAmt(cc.getComrclDrft().getIsseAmt());
            XcptnInf xcptnInf = new XcptnInf();
            xcptnInf.setXcptnCd(cenum.getValue());
            CommercialDraftExceptionNotification commercialDraftExceptionNotification = new CommercialDraftExceptionNotification();
            commercialDraftExceptionNotification.setOrgnlMsgId(orgnlMsgId);
            commercialDraftExceptionNotification.setComrclDrft(comrclDrft);
            commercialDraftExceptionNotification.setXcptnInf(xcptnInf);
            kMsg.setDocumentCommercialDraft(commercialDraftExceptionNotification);
            if (ExceptionCodeEnum.EC01.equals((Object)cenum)) {
                String code = FmEcrUtil.getMQManageBankCode(ctx);
                acctSvcr = FmEcrUtil.getActorBankByAPCode(ctx, code);
            }
            try {
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"156_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
                KMsgUtil.send(ctx, "035", kMsg, "01", origSender, "common", true, null, null, null, acctSvcr);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"157_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            }
            catch (Exception e) {
                throw new ECoreException(ECoreException.REC_SEND, e);
            }
            ECDSCommon.insertSystemAction(ctx, kMsg, null, null, null, info.getId().toString(), null, cenum.getValue(), DraftMessageEnum.M035);
            return false;
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"158_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
        return true;
    }

    private ExceptionCodeEnum checkParm(Context ctx, String nm, String acctId, String acctSvcr, String rcvgAcctId) throws BOSException {
        OperateServiceAgreementCollection oac = OperateServiceAgreementFactory.getLocalInstance(ctx).getOperateServiceAgreementCollection();
        boolean acctSvcrFlag = false;
        boolean acctIdFlag = false;
        boolean rcvgAcctIdFlag = false;
        for (int i = 0; i < oac.size(); ++i) {
            if (acctId.equals(oac.get(i).getBizGatherNumber())) {
                acctIdFlag = true;
            }
            if (acctId.equals(oac.get(i).getBizPayNumber())) {
                acctIdFlag = true;
            }
            if (oac.get(i).getActorBank().equals(acctSvcr)) {
                acctSvcrFlag = true;
            }
            if ("".equals(rcvgAcctId)) continue;
            if (rcvgAcctId.equals(oac.get(i).getBizGatherNumber())) {
                rcvgAcctIdFlag = true;
            }
            if (!rcvgAcctId.equals(oac.get(i).getBizPayNumber())) continue;
            rcvgAcctIdFlag = true;
        }
        if (!acctIdFlag) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"159_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            return ExceptionCodeEnum.EC00;
        }
        if (!acctSvcrFlag) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"160_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            return ExceptionCodeEnum.EC01;
        }
        boolean nmFlag = false;
        OperateServiceAgreementInfo ainfo = null;
        for (int i = 0; i < oac.size(); ++i) {
            ainfo = oac.get(i);
            if (!ainfo.getOrgUnitName().equals(nm) || !ainfo.getBizGatherNumber().equals(acctId) && !ainfo.getBizPayNumber().equals(acctId) || !ainfo.getActorBank().equals(acctSvcr)) continue;
            nmFlag = true;
        }
        if (!nmFlag) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"161_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            return ExceptionCodeEnum.EC02;
        }
        if (!"".equals(rcvgAcctId) && !rcvgAcctIdFlag) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"162_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            return ExceptionCodeEnum.EC03;
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"163_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
        return null;
    }
}

