/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.ContractActionEnum;
import com.kingdee.eas.fm.ecore.CtrctOfferXptNoticeBillInfo;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ExceptionCodeEnum;
import com.kingdee.eas.fm.ecore.ExceptionNotificationBillFactory;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementCollection;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementFactory;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.KMsgUtil;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.KMsgHead;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.ContractOfferExceptionNotification;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.ContractOfferRequest;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.ContractOfferTransfer;
import com.kingdee.eas.fm.ecore.app.bean.node.Ctrct;
import com.kingdee.eas.fm.ecore.app.bean.node.OrgnlMsgId;
import com.kingdee.eas.fm.ecore.app.bean.node.XcptnInf;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.util.FmEcrUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ContractOfferExceptionNotificationImpl {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.impl.ContractOfferExceptionNotification");
    private static String BIZ_ERROR = "BIZ_ERROR";

    public boolean checkContractOfferExceptionNotification(Context ctx, KMsg kmsg, KMsgHead kMsgHead) throws BOSException, EASBizException {
        String nm = "";
        String acctId = "";
        String acctSvcr = "";
        ContractOfferTransfer cc = (ContractOfferTransfer)kmsg.getDocumentCommercialDraft();
        if (cc.getReqInf().getContractOfferRequest() != null) {
            ContractOfferRequest ce = cc.getReqInf().getContractOfferRequest();
            nm = ce.getOfferee().getNm();
            acctId = ce.getOfferee().getAcct().getId();
            acctSvcr = ce.getOfferee().getAcct().getAcctSvcr();
        }
        return this.checkPramAndSend(cc, ctx, nm, acctId, acctSvcr, acctSvcr);
    }

    private boolean checkPramAndSend(ContractOfferTransfer cc, Context ctx, String nm, String acctId, String acctSvcr, String rcvgAcctId) throws BOSException, EASBizException {
        String msgId = cc.getMsgId().getId();
        String origSender = msgId.substring(0, 12);
        ExceptionCodeEnum cenum = this.checkParm(ctx, nm, acctId, acctSvcr);
        if (cenum != null) {
            String id = cc.getMsgId().getId();
            String creDtTm = cc.getMsgId().getCreDtTm();
            String idNb = cc.getCtrct().getCtrctNb();
            CtrctOfferXptNoticeBillInfo info = new CtrctOfferXptNoticeBillInfo();
            info.setOrgMessageID(id);
            info.setOrgMessageTime(ECDSCommon.getTimestampByStr(creDtTm));
            info.setContractNumber(idNb);
            info.setExceptionCode(cenum);
            info.setIsSend(true);
            IObjectPK pk = ExceptionNotificationBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            KMsg kMsg = new KMsg();
            OrgnlMsgId orgnlMsgId = new OrgnlMsgId();
            orgnlMsgId.setId(cc.getMsgId().getId());
            orgnlMsgId.setCreDtTm(cc.getMsgId().getCreDtTm());
            Ctrct ctrct = new Ctrct();
            ctrct.setCtrctNb(idNb);
            XcptnInf xcptnInf = new XcptnInf();
            xcptnInf.setXcptnCd(cenum.getValue());
            ContractOfferExceptionNotification commercialDraftExceptionNotification = new ContractOfferExceptionNotification();
            commercialDraftExceptionNotification.setOrgnlMsgId(orgnlMsgId);
            commercialDraftExceptionNotification.setCtrct(ctrct);
            commercialDraftExceptionNotification.setXcptnInf(xcptnInf);
            kMsg.setDocumentCommercialDraft(commercialDraftExceptionNotification);
            if (ExceptionCodeEnum.EC01.equals((Object)cenum)) {
                String code = FmEcrUtil.getMQManageBankCode(ctx);
                acctSvcr = FmEcrUtil.getActorBankByAPCode(ctx, code);
            }
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"164_ContractOfferExceptionNotificationImpl", (Locale)ctx.getLocale()));
            KMsgUtil.send(ctx, "205", kMsg, "01", origSender, "common", true, null, null, null, acctSvcr);
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"165_ContractOfferExceptionNotificationImpl", (Locale)ctx.getLocale()));
            ECDSCommon.insertContracttAction(ctx, kMsg, idNb, BIZ_ERROR, null, null, ContractActionEnum.SEND_EXCEPTION, DraftMessageEnum.M205);
            return false;
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"158_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
        return true;
    }

    private ExceptionCodeEnum checkParm(Context ctx, String nm, String acctId, String acctSvcr) throws BOSException {
        OperateServiceAgreementCollection oac = OperateServiceAgreementFactory.getLocalInstance(ctx).getOperateServiceAgreementCollection();
        boolean acctSvcrFlag = false;
        boolean acctIdFlag = false;
        boolean rcvgAcctIdFlag = false;
        for (int i = 0; i < oac.size(); ++i) {
            if (acctId.equals(oac.get(i).getBizGatherNumber())) {
                acctIdFlag = true;
            }
            if (acctId.equals(oac.get(i).getBizPayNumber())) {
                acctIdFlag = true;
            }
            if (!oac.get(i).getActorBank().equals(acctSvcr)) continue;
            acctSvcrFlag = true;
        }
        if (!acctIdFlag) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"159_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            return ExceptionCodeEnum.EC00;
        }
        if (!acctSvcrFlag) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"160_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            return ExceptionCodeEnum.EC01;
        }
        boolean nmFlag = false;
        OperateServiceAgreementInfo ainfo = null;
        for (int i = 0; i < oac.size(); ++i) {
            ainfo = oac.get(i);
            if (!ainfo.getOrgUnitName().equals(nm) || !ainfo.getBizGatherNumber().equals(acctId) && !ainfo.getBizPayNumber().equals(acctId) || !ainfo.getActorBank().equals(acctSvcr)) continue;
            nmFlag = true;
        }
        if (!nmFlag) {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"161_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
            return ExceptionCodeEnum.EC02;
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"163_CommercialDraftExceptionNotificationImpl", (Locale)ctx.getLocale()));
        return null;
    }
}

