/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.ecds.AbstractElecDraftBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafAcceptRequestBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafAgainDiscountApplyBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafBankSellingDraftsRequestInfo;
import com.kingdee.eas.fm.common.ecds.EdrafDiscountAgainInfo;
import com.kingdee.eas.fm.common.ecds.EdrafDiscountRequestBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafDraftRepurchasedRediscountWithCentralBankRequestInfo;
import com.kingdee.eas.fm.common.ecds.EdrafElecDraftBillEntryCollection;
import com.kingdee.eas.fm.common.ecds.EdrafElecDraftBillEntryInfo;
import com.kingdee.eas.fm.common.ecds.EdrafElecDraftBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafEndorserRequestInfo;
import com.kingdee.eas.fm.common.ecds.EdrafGuaranteeRequestBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafImpawnUnchainApplyBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafOverdueCuePayInfo;
import com.kingdee.eas.fm.common.ecds.EdrafPledgeReqBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafPromptPaymentReqInfo;
import com.kingdee.eas.fm.common.ecds.EdrafRecourseAgreementRequestBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafRecourseNotificationBillInfo;
import com.kingdee.eas.fm.common.ecds.EdrafRepurchaseDiscountRedeemReqInfo;
import com.kingdee.eas.fm.common.ecds.EdrafRepurchaseDiscountTurnRedeemReqInfo;
import com.kingdee.eas.fm.common.ecds.EdrafTipsTicketCollectorBillInfo;
import com.kingdee.eas.fm.ecore.AcceptRequestBillInfo;
import com.kingdee.eas.fm.ecore.AgainDiscountApplyBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.BankSellingDraftsRequestInfo;
import com.kingdee.eas.fm.ecore.BizReceiveBillFactory;
import com.kingdee.eas.fm.ecore.BizReceiveBillInfo;
import com.kingdee.eas.fm.ecore.BizReplyBillFactory;
import com.kingdee.eas.fm.ecore.BizReplyBillInfo;
import com.kingdee.eas.fm.ecore.BusinessNotificationFactory;
import com.kingdee.eas.fm.ecore.BusinessNotificationInfo;
import com.kingdee.eas.fm.ecore.DiscountAgainInfo;
import com.kingdee.eas.fm.ecore.DiscountRequestBillInfo;
import com.kingdee.eas.fm.ecore.DiscountTypeEnum;
import com.kingdee.eas.fm.ecore.DraftBizTypeEnum;
import com.kingdee.eas.fm.ecore.DraftRepurchasedRediscountWithCentralBankRequestInfo;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillFactory;
import com.kingdee.eas.fm.ecore.ElecDraftActionBillInfo;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillAccptEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillAccptEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillDisctEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillDisctEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillPayReqEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillPayReqEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillRecrsEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillRecrsEntryInfo;
import com.kingdee.eas.fm.ecore.EndorserRequestInfo;
import com.kingdee.eas.fm.ecore.GuaranteeRequestBillInfo;
import com.kingdee.eas.fm.ecore.IApplyBillBase;
import com.kingdee.eas.fm.ecore.ImpawnUnchainApplyBillInfo;
import com.kingdee.eas.fm.ecore.OverdueCuePayInfo;
import com.kingdee.eas.fm.ecore.PledgeReqBillInfo;
import com.kingdee.eas.fm.ecore.PromptPaymentReqInfo;
import com.kingdee.eas.fm.ecore.RecourseAgreementRequestBillInfo;
import com.kingdee.eas.fm.ecore.RecourseNotificationBillInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountTurnRedeemReqInfo;
import com.kingdee.eas.fm.ecore.TipsTicketCollectorBillInfo;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FindByElecDraft {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ecore.app.ecds.FindByElecDraft");
    private static AbstractElecDraftBillInfo info;

    public static Map getElecDraft(Context ctx, String comId, String idNb, Date startDate, boolean flag) throws EASBizException, BOSException {
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"166_FindByElecDraft", (Locale)ctx.getLocale()));
        HashMap<String, Object> elecMap = new HashMap<String, Object>();
        ElecDraftBillInfo elecDraftInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, idNb);
        ECDSBillStatusEnum statEnum = null;
        if (!flag) {
            startDate = DateTimeUtils.addDay((Date)startDate, (long)1L);
            statEnum = FindByElecDraft.getECDSBillStatus(ctx, comId, idNb, startDate);
        }
        EdrafElecDraftBillEntryCollection eColl = FindByElecDraft.getElecDraftEntil(ctx, comId, idNb, startDate, flag);
        ApplyBillBaseInfo appinfo = FindByElecDraft.ElectDraftBillBusinessNotification(ctx, idNb);
        if (statEnum == null) {
            if (eColl.size() >= 1) {
                EdrafElecDraftBillEntryInfo entryInfo = eColl.get(eColl.size() - 1);
                if (entryInfo.getDraftBizType() == DraftBizTypeEnum.CHENGDUI) {
                    statEnum = ECDSBillStatusEnum.TSCDYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.SHOUPIAO) {
                    statEnum = ECDSBillStatusEnum.TSSPYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.BEISHU) {
                    statEnum = ECDSBillStatusEnum.BSYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.TIEXIAN) {
                    ElecDraftBillDisctEntryInfo elcInfo = FindByElecDraft.getElecDraftBillDisctEntry(ctx, entryInfo.getId().toString());
                    statEnum = elcInfo.getDiscountType().equals((Object)DiscountTypeEnum.RM00) ? ECDSBillStatusEnum.MDSTXYQS : ECDSBillStatusEnum.HGSTXYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.HGSTXSH) {
                    statEnum = ECDSBillStatusEnum.HGSTXSHYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.ZHUANTIEXIAN) {
                    ElecDraftBillDisctEntryInfo elcInfo = FindByElecDraft.getElecDraftBillDisctEntry(ctx, entryInfo.getId().toString());
                    statEnum = elcInfo.getDiscountType().equals((Object)DiscountTypeEnum.RM00) ? ECDSBillStatusEnum.MDSZHTXYQS : ECDSBillStatusEnum.HGSZHTXYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.HGSZHTXSH) {
                    statEnum = ECDSBillStatusEnum.HGSZHTXSHYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.ZAITIEXIAN) {
                    ElecDraftBillDisctEntryInfo elcInfo = FindByElecDraft.getElecDraftBillDisctEntry(ctx, entryInfo.getId().toString());
                    statEnum = elcInfo.getDiscountType().equals((Object)DiscountTypeEnum.RM00) ? ECDSBillStatusEnum.MDSZTXYQS : ECDSBillStatusEnum.HGSZTXYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.HGSZTXSH) {
                    statEnum = ECDSBillStatusEnum.HGSZTXSHYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.ZHIYA) {
                    statEnum = ECDSBillStatusEnum.ZYYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.ZHIYAJIECHU) {
                    statEnum = ECDSBillStatusEnum.ZYJCYQS;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.TISHIFUKUAN) {
                    statEnum = ECDSBillStatusEnum.PJYJQ;
                } else if (entryInfo.getDraftBizType() == DraftBizTypeEnum.YUQITISHIFUKUAN) {
                    statEnum = ECDSBillStatusEnum.PJYJQ;
                } else if (entryInfo.getDraftBizType() != DraftBizTypeEnum.ZHUISUO && entryInfo.getDraftBizType() != DraftBizTypeEnum.CHEPIAO && entryInfo.getDraftBizType() != DraftBizTypeEnum.YHMCSYHP && entryInfo.getDraftBizType() == DraftBizTypeEnum.BAOZHENG) {
                    int seq = entryInfo.getSeq() - 1;
                    if (seq == 0) {
                        seq = 1;
                    }
                    statEnum = FindByElecDraft.getElecDraftEntilBySeq(ctx, seq, entryInfo.getDraftNumber());
                }
                elecDraftInfo.setDraftECDSStatus(statEnum);
            }
        } else {
            elecDraftInfo.setDraftECDSStatus(statEnum);
        }
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNb));
        fi.getFilterItems().add(new FilterItemInfo("actionType", (Object)ElecDraftActionEnum.RECEIVE_WAIT_REPLY));
        fi.setMaskString("#0 and #1 ");
        SorterItemInfo sortInfo = new SorterItemInfo("CreateTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        BusinessNotificationInfo bussinfo = BusinessNotificationFactory.getLocalInstance(ctx).getBusinessNotificationCollection(viewinfo).get(0);
        EdrafElecDraftBillInfo info = new EdrafElecDraftBillInfo();
        info.setDraftType(elecDraftInfo.getDraftType());
        info.setDraftNumber(elecDraftInfo.getDraftNumber());
        info.setDraftECDSStatus(elecDraftInfo.getDraftECDSStatus());
        info.setDraftAmount(elecDraftInfo.getDraftAmount());
        info.setIssueDate(elecDraftInfo.getIssueDate());
        info.setDueDate(elecDraftInfo.getDueDate());
        info.setBanEndorsement(elecDraftInfo.getBanEndorsement());
        info.setRemark(elecDraftInfo.getRemark());
        info.setDrawerName(elecDraftInfo.getDrawerName());
        info.setDrawerRole(elecDraftInfo.getDrawerRole());
        info.setDrawerOrgCode(elecDraftInfo.getDrawerOrgCode());
        info.setDrawerAccount(elecDraftInfo.getDrawerAccount());
        info.setDrawerBank(elecDraftInfo.getDrawerBank());
        info.setDrawerCdtRater(elecDraftInfo.getDrawerCdtRater());
        info.setDrawerCreditRat(elecDraftInfo.getDrawerCreditRat());
        info.setDrawerRtDueDate(elecDraftInfo.getDrawerRtDueDate());
        info.setAcceptorName(elecDraftInfo.getAcceptorName());
        info.setAcceptorAccount(elecDraftInfo.getAcceptorAccount());
        info.setAcceptorBank(elecDraftInfo.getAcceptorBank());
        info.setPayeeName(elecDraftInfo.getPayeeName());
        info.setPayeeAccount(elecDraftInfo.getPayeeAccount());
        info.setPayeeBank(elecDraftInfo.getPayeeBank());
        info.setHolderOrgCode(elecDraftInfo.getHolderOrgCode());
        elecMap.put("eleInfo", info);
        elecMap.put("edrafElecDraftEntilColl", eColl);
        elecMap.put("requestInfo", appinfo);
        elecMap.put("holderOrgCode", bussinfo.getHolderOrgCode());
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"167_FindByElecDraft", (Locale)ctx.getLocale()));
        return elecMap;
    }

    public static EdrafElecDraftBillEntryCollection getElecDraftEntil(Context ctx, String ComID, String idNb, Date startDate, boolean flag) throws BOSException, EASBizException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNb));
        if (flag) {
            fi.getFilterItems().add(new FilterItemInfo("formerOrgCode", (Object)ComID));
            fi.getFilterItems().add(new FilterItemInfo("laterOrgCode", (Object)ComID));
            fi.getFilterItems().add(new FilterItemInfo("draftSignInDate", (Object)startDate, CompareType.LESS_EQUALS));
            fi.setMaskString("#0 and (#1 or #2) and #3");
        }
        SorterItemInfo sortInfo = new SorterItemInfo("seq");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.ASCEND);
        sortCol.add(sortInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accptEntry.*");
        sic.add("disctEntry.*");
        sic.add("payReqEntry.*");
        sic.add("recrsEntry.*");
        viewinfo.setSelector(sic);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        EdrafElecDraftBillEntryCollection col = new EdrafElecDraftBillEntryCollection();
        ElecDraftBillEntryCollection elecCol = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection(viewinfo);
        for (int i = 0; i < elecCol.size(); ++i) {
            ElecDraftBillEntryInfo info = elecCol.get(i);
            EdrafElecDraftBillEntryInfo edrafInfo = new EdrafElecDraftBillEntryInfo();
            edrafInfo.setDraftNumber(info.getDraftNumber());
            edrafInfo.setDraftBizType(info.getDraftBizType());
            edrafInfo.setDraftSignInDate(info.getDraftSignInDate());
            edrafInfo.setFormerName(info.getFormerName());
            edrafInfo.setFormerRole(info.getFormerRole());
            edrafInfo.setFormerOrgCode(info.getFormerOrgCode());
            edrafInfo.setFormerAccount(info.getFormerAccount());
            edrafInfo.setFormerBank(info.getFormerBank());
            edrafInfo.setFormerAgcyBank(info.getFormerAgcyBank());
            edrafInfo.setFormerRemark(info.getFormerRemark());
            edrafInfo.setLaterRole(info.getLaterRole());
            edrafInfo.setLaterName(info.getLaterName());
            edrafInfo.setLaterOrgCode(info.getLaterOrgCode());
            edrafInfo.setLaterAccount(info.getLaterAccount());
            edrafInfo.setLaterBank(info.getLaterBank());
            edrafInfo.setLaterAgcyBank(info.getLaterAgcyBank());
            edrafInfo.setLaterRemark(info.getLaterRemark());
            edrafInfo.setBanEndorsement(info.getBanEndorsement());
            edrafInfo.setProxySignature(info.getProxySignature());
            edrafInfo.setSettlementMode(info.getSettlementMode());
            edrafInfo.setInterestRate(info.getInterestRate());
            edrafInfo.setActualAmount(info.getActualAmount());
            edrafInfo.setGuarnteeAddress(info.getGuarnteeAddress());
            edrafInfo.setId(info.getId());
            EntityViewInfo otherInfo = new EntityViewInfo();
            FilterInfo otherFiler = new FilterInfo();
            otherFiler.getFilterItems().add(new FilterItemInfo("parent", (Object)info.getId().toString()));
            otherInfo.setFilter(otherFiler);
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.CHENGDUI)) {
                ElecDraftBillAccptEntryInfo acctInfo = ElecDraftBillAccptEntryFactory.getLocalInstance(ctx).getElecDraftBillAccptEntryCollection(otherInfo).get(0);
                edrafInfo.setAccptEntry(acctInfo);
            }
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.TIEXIAN) || info.getDraftBizType().equals((Object)DraftBizTypeEnum.ZHUANTIEXIAN) || info.getDraftBizType().equals((Object)DraftBizTypeEnum.ZAITIEXIAN)) {
                ElecDraftBillDisctEntryInfo disctInfo = ElecDraftBillDisctEntryFactory.getLocalInstance(ctx).getElecDraftBillDisctEntryCollection(otherInfo).get(0);
                edrafInfo.setDisctEntry(disctInfo);
            }
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.TISHIFUKUAN) || info.getDraftBizType().equals((Object)DraftBizTypeEnum.YUQITISHIFUKUAN)) {
                ElecDraftBillPayReqEntryInfo payInfo = ElecDraftBillPayReqEntryFactory.getLocalInstance(ctx).getElecDraftBillPayReqEntryCollection(otherInfo).get(0);
                edrafInfo.setPayReqEntry(payInfo);
            }
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.ZHUISUO)) {
                ElecDraftBillRecrsEntryInfo reqInfo = ElecDraftBillRecrsEntryFactory.getLocalInstance(ctx).getElecDraftBillRecrsEntryCollection(otherInfo).get(0);
                edrafInfo.setRecrsEntry(reqInfo);
            }
            edrafInfo.setCreateMessageID(info.getCreateMessageID());
            edrafInfo.setSeq(info.getSeq());
            col.add(edrafInfo);
        }
        return col;
    }

    public static ECDSBillStatusEnum getECDSBillStatus(Context ctx, String ComID, String idNb, Date startDate) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNb));
        SorterItemInfo sortInfo = new SorterItemInfo("CreateTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftActionBillInfo actionInfo = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(viewinfo).get(0);
        if (actionInfo != null) {
            return actionInfo.getCommunicatedDraftStatus();
        }
        return null;
    }

    public static ECDSBillStatusEnum getElecDraftEntilBySeq(Context ctx, int seq, String idNb) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNb));
        viewinfo.setFilter(fi);
        ElecDraftBillEntryInfo info = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection(viewinfo).get(0);
        if (info.getDraftBizType() == DraftBizTypeEnum.CHENGDUI) {
            return ECDSBillStatusEnum.TSCDYQS;
        }
        if (info.getDraftBizType() == DraftBizTypeEnum.BEISHU) {
            return ECDSBillStatusEnum.BSYQS;
        }
        return ECDSBillStatusEnum.CPYDJ;
    }

    public static ElecDraftBillDisctEntryInfo getElecDraftBillDisctEntry(Context ctx, String id) throws EASBizException, BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent", (Object)id));
        viewinfo.setFilter(fi);
        ElecDraftBillDisctEntryInfo eleInfo = ElecDraftBillDisctEntryFactory.getLocalInstance(ctx).getElecDraftBillDisctEntryCollection(viewinfo).get(0);
        return eleInfo;
    }

    public static ApplyBillBaseInfo ElectDraftBillBusinessNotification(Context ctx, String idNb) throws BOSException, EASBizException {
        BizReceiveBillInfo bizInfo = null;
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNb));
        fi.getFilterItems().add(new FilterItemInfo("notificationType", (Object)"N001"));
        SorterItemInfo sortInfo = new SorterItemInfo("CreateTime");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.DESCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        BusinessNotificationInfo bInfo = BusinessNotificationFactory.getLocalInstance(ctx).getBusinessNotificationCollection(viewinfo).get(0);
        if (bInfo != null) {
            EntityViewInfo bizviewinfo = new EntityViewInfo();
            FilterInfo fibiz = new FilterInfo();
            fibiz.getFilterItems().add(new FilterItemInfo("messageID", (Object)bInfo.getMessageID()));
            SorterItemInfo bizsortInfo = new SorterItemInfo("CreateTime");
            SorterItemCollection bizsortCol = new SorterItemCollection();
            bizsortInfo.setSortType(SortType.DESCEND);
            bizsortCol.add(bizsortInfo);
            bizviewinfo.setSorter(bizsortCol);
            bizviewinfo.setFilter(fibiz);
            bizInfo = BizReceiveBillFactory.getLocalInstance(ctx).getBizReceiveBillCollection(bizviewinfo).get(0);
            if (bizInfo == null) {
                EntityViewInfo drartActionviewinfo = new EntityViewInfo();
                FilterInfo drartActionbiz = new FilterInfo();
                drartActionbiz.getFilterItems().add(new FilterItemInfo("messageID", (Object)bInfo.getMessageID()));
                drartActionbiz.getFilterItems().add(new FilterItemInfo("actionType", (Object)ElecDraftActionEnum.SEND));
                SorterItemInfo actionSortInfo = new SorterItemInfo("CreateTime");
                SorterItemCollection actionSortCol = new SorterItemCollection();
                actionSortInfo.setSortType(SortType.DESCEND);
                actionSortCol.add(actionSortInfo);
                drartActionviewinfo.setSorter(actionSortCol);
                drartActionviewinfo.setFilter(drartActionbiz);
                ElecDraftActionBillInfo actionBillInfo = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(drartActionviewinfo).get(0);
                return FindByElecDraft.ElectDraftBillBusinessNotification_remote(ctx, actionBillInfo.getBizRecordBillID());
            }
            return FindByElecDraft.ElectDraftBillBusinessNotification_remote(ctx, bizInfo.getApplyBillID());
        }
        EntityViewInfo bizRepviewinfo = new EntityViewInfo();
        FilterInfo bizRepbiz = new FilterInfo();
        bizRepbiz.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)idNb));
        SorterItemInfo bizRepsortInfo = new SorterItemInfo("CreateTime");
        SorterItemCollection bizRepsortCol = new SorterItemCollection();
        bizRepsortInfo.setSortType(SortType.DESCEND);
        bizRepsortCol.add(bizRepsortInfo);
        bizRepviewinfo.setSorter(bizRepsortCol);
        bizRepviewinfo.setFilter(bizRepbiz);
        BizReplyBillInfo bizRepInfo = BizReplyBillFactory.getLocalInstance(ctx).getBizReplyBillCollection(bizRepviewinfo).get(0);
        EntityViewInfo drartRepActionviewinfo = new EntityViewInfo();
        FilterInfo drartRepActionbiz = new FilterInfo();
        drartRepActionbiz.getFilterItems().add(new FilterItemInfo("messageID", (Object)bizRepInfo.getOriMessageID()));
        drartRepActionbiz.getFilterItems().add(new FilterItemInfo("actionType", (Object)ElecDraftActionEnum.SEND));
        SorterItemInfo actionRepSortInfo = new SorterItemInfo("CreateTime");
        SorterItemCollection actionRepSortCol = new SorterItemCollection();
        actionRepSortInfo.setSortType(SortType.DESCEND);
        actionRepSortCol.add(actionRepSortInfo);
        drartRepActionviewinfo.setSorter(actionRepSortCol);
        drartRepActionviewinfo.setFilter(drartRepActionbiz);
        ElecDraftActionBillInfo actionBillInfo = ElecDraftActionBillFactory.getLocalInstance(ctx).getElecDraftActionBillCollection(drartRepActionviewinfo).get(0);
        return FindByElecDraft.ElectDraftBillBusinessNotification_remote(ctx, actionBillInfo.getBizRecordBillID());
    }

    public static ApplyBillBaseInfo ElectDraftBillBusinessNotification_remote(Context ctx, String pkid) throws BOSException, EASBizException {
        BOSUuid uuid = BOSUuid.read((String)pkid);
        IApplyBillBase applyBillBase = (IApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(uuid.getType());
        ApplyBillBaseInfo info = applyBillBase.getApplyBillBaseInfo((IObjectPK)new ObjectStringPK(pkid));
        if (info instanceof AcceptRequestBillInfo) {
            EdrafAcceptRequestBillInfo acceptInfo = new EdrafAcceptRequestBillInfo();
            acceptInfo.setDraftAmount(((AcceptRequestBillInfo)info).getDraftAmount());
            acceptInfo.setUcondlConsgnmtMrk(((AcceptRequestBillInfo)info).getUcondlConsgnmtMrk());
            acceptInfo.setContractNumber(((AcceptRequestBillInfo)info).getContractNumber());
            acceptInfo.setInvoiceNumber(((AcceptRequestBillInfo)info).getInvoiceNumber());
            acceptInfo.setBtchNumber(((AcceptRequestBillInfo)info).getBtchNumber());
            acceptInfo.setDrawerRole(((AcceptRequestBillInfo)info).getDrawerRole());
            acceptInfo.setDrawerOrgCode(((AcceptRequestBillInfo)info).getDrawerOrgCode());
            acceptInfo.setDrawerAccount(((AcceptRequestBillInfo)info).getDrawerAccount());
            acceptInfo.setDrawerBank(((AcceptRequestBillInfo)info).getDrawerBank());
            acceptInfo.setDrawerCarryBank(((AcceptRequestBillInfo)info).getDrawerCarryBank());
            acceptInfo.setDrawerElecSign(((AcceptRequestBillInfo)info).getDrawerElecSign());
            acceptInfo.setAcceptorCdtRater(((AcceptRequestBillInfo)info).getAcceptorCdtRater());
            acceptInfo.setAcceptorCreditRat(((AcceptRequestBillInfo)info).getAcceptorCreditRat());
            acceptInfo.setAcceptorRtDueDate(((AcceptRequestBillInfo)info).getAcceptorRtDueDate());
            acceptInfo.setRmrkByPropsr(((AcceptRequestBillInfo)info).getRmrkByPropsr());
            return acceptInfo;
        }
        if (info instanceof TipsTicketCollectorBillInfo) {
            EdrafTipsTicketCollectorBillInfo tipsticInfo = new EdrafTipsTicketCollectorBillInfo();
            tipsticInfo.setDrawerElecSign(((TipsTicketCollectorBillInfo)info).getDrawerElecSign());
            tipsticInfo.setDrawerRole(((TipsTicketCollectorBillInfo)info).getDrawerRole());
            tipsticInfo.setDrawerAccount(((TipsTicketCollectorBillInfo)info).getDrawerAccount());
            tipsticInfo.setDrawerCarryBank(((TipsTicketCollectorBillInfo)info).getDrawerCarryBank());
            tipsticInfo.setDrawerBank(((TipsTicketCollectorBillInfo)info).getDrawerBank());
            tipsticInfo.setDraftRemark(((TipsTicketCollectorBillInfo)info).getDraftRemark());
            tipsticInfo.setDraftOrgCode(((TipsTicketCollectorBillInfo)info).getDraftOrgCode());
            tipsticInfo.setDraftAmount(((TipsTicketCollectorBillInfo)info).getDraftAmount());
            tipsticInfo.setDraftNumber(((TipsTicketCollectorBillInfo)info).getDraftNumber());
            return tipsticInfo;
        }
        if (info instanceof EndorserRequestInfo) {
            EdrafEndorserRequestInfo endInfo = new EdrafEndorserRequestInfo();
            endInfo.setBillNumber(((EndorserRequestInfo)info).getBillNumber());
            endInfo.setBillAmount(((EndorserRequestInfo)info).getBillAmount());
            endInfo.setBanEndorsement(((EndorserRequestInfo)info).getBanEndorsement());
            endInfo.setEndorserRole(((EndorserRequestInfo)info).getEndorserRole());
            endInfo.setEndorserName(((EndorserRequestInfo)info).getEndorserName());
            endInfo.setEndorserOrgCode(((EndorserRequestInfo)info).getEndorserOrgCode());
            endInfo.setEndorserBank(((EndorserRequestInfo)info).getEndorserBank());
            endInfo.setEndorserAccount(((EndorserRequestInfo)info).getEndorserAccount());
            endInfo.setEndorserAgcyBank(((EndorserRequestInfo)info).getEndorserAgcyBank());
            endInfo.setByEndorserAccount(((EndorserRequestInfo)info).getByEndorserAccount());
            endInfo.setByEndorserBank(((EndorserRequestInfo)info).getByEndorserBank());
            endInfo.setByEndorserName(((EndorserRequestInfo)info).getByEndorserName());
            endInfo.setRemark(((EndorserRequestInfo)info).getRemark());
            return endInfo;
        }
        if (info instanceof DiscountRequestBillInfo) {
            EdrafDiscountRequestBillInfo discountInfo = new EdrafDiscountRequestBillInfo();
            discountInfo.setBillNumber(((DiscountRequestBillInfo)info).getBillNumber());
            discountInfo.setBillAmount(((DiscountRequestBillInfo)info).getBillAmount());
            discountInfo.setDiscounterType(((DiscountRequestBillInfo)info).getDiscounterType());
            discountInfo.setDiscountType(((DiscountRequestBillInfo)info).getDiscountType());
            discountInfo.setRate(((DiscountRequestBillInfo)info).getRate());
            discountInfo.setPayfor(((DiscountRequestBillInfo)info).getPayfor());
            discountInfo.setAssignmentMark(((DiscountRequestBillInfo)info).getAssignmentMark());
            discountInfo.setBalanceMark(((DiscountRequestBillInfo)info).getBalanceMark());
            discountInfo.setBackOpenDate(((DiscountRequestBillInfo)info).getBackOpenDate());
            discountInfo.setBackCloseDate(((DiscountRequestBillInfo)info).getBackCloseDate());
            discountInfo.setBackRate(((DiscountRequestBillInfo)info).getBackRate());
            discountInfo.setBackMoney(((DiscountRequestBillInfo)info).getBackMoney());
            discountInfo.setTxCtrctNb(((DiscountRequestBillInfo)info).getTxCtrctNb());
            discountInfo.setInvcNb(((DiscountRequestBillInfo)info).getInvcNb());
            discountInfo.setBtchNb(((DiscountRequestBillInfo)info).getBtchNb());
            discountInfo.setDiscounterRemark(((DiscountRequestBillInfo)info).getDiscounterRemark());
            discountInfo.setDiscounterAccount(((DiscountRequestBillInfo)info).getDiscounterAccount());
            discountInfo.setAccountId(((DiscountRequestBillInfo)info).getAccountId());
            discountInfo.setBankId(((DiscountRequestBillInfo)info).getBankId());
            discountInfo.setDiscounterType(((DiscountRequestBillInfo)info).getDiscounterType());
            discountInfo.setDiscounterName(((DiscountRequestBillInfo)info).getDiscounterName());
            discountInfo.setGroupId(((DiscountRequestBillInfo)info).getGroupId());
            discountInfo.setDiscounterSgin(((DiscountRequestBillInfo)info).getDiscounterSgin());
            discountInfo.setDiscounterBank(((DiscountRequestBillInfo)info).getDiscounterBank());
            discountInfo.setDiscounterBankBak(((DiscountRequestBillInfo)info).getDiscounterBankBak());
            discountInfo.setByDiscounterAccount(((DiscountRequestBillInfo)info).getByDiscounterAccount());
            discountInfo.setByDiscounterBank(((DiscountRequestBillInfo)info).getByDiscounterBank());
            discountInfo.setByDiscounterBank(((DiscountRequestBillInfo)info).getByDiscounterBank());
            discountInfo.setAssignmentMark(((DiscountRequestBillInfo)info).getAssignmentMark());
            discountInfo.setRequestDate(((DiscountRequestBillInfo)info).getRequestDate());
            return discountInfo;
        }
        if (info instanceof RepurchaseDiscountRedeemReqInfo) {
            EdrafRepurchaseDiscountRedeemReqInfo repdisInfo = new EdrafRepurchaseDiscountRedeemReqInfo();
            repdisInfo.setDraftAmount(((RepurchaseDiscountRedeemReqInfo)info).getDraftAmount());
            repdisInfo.setDraftNumber(((RepurchaseDiscountRedeemReqInfo)info).getDraftNumber());
            repdisInfo.setReqDate(((RepurchaseDiscountRedeemReqInfo)info).getReqDate());
            repdisInfo.setRedeemInterRate(((RepurchaseDiscountRedeemReqInfo)info).getRedeemInterRate());
            repdisInfo.setRedeemPaidAmt(((RepurchaseDiscountRedeemReqInfo)info).getRedeemPaidAmt());
            repdisInfo.setBanEndorsement(((RepurchaseDiscountRedeemReqInfo)info).getBanEndorsement());
            repdisInfo.setSettlementMark(((RepurchaseDiscountRedeemReqInfo)info).getSettlementMark());
            repdisInfo.setBatch(((RepurchaseDiscountRedeemReqInfo)info).getBatch());
            repdisInfo.setRemark(((RepurchaseDiscountRedeemReqInfo)info).getRemark());
            repdisInfo.setDrawerRole(((RepurchaseDiscountRedeemReqInfo)info).getDrawerRole());
            repdisInfo.setDrawerOrgCode(((RepurchaseDiscountRedeemReqInfo)info).getDrawerOrgCode());
            repdisInfo.setDrawerElecSign(((RepurchaseDiscountRedeemReqInfo)info).getDrawerElecSign());
            repdisInfo.setDrawerAccount(((RepurchaseDiscountRedeemReqInfo)info).getDrawerAccount());
            repdisInfo.setDrawerBank(((RepurchaseDiscountRedeemReqInfo)info).getDrawerBank());
            repdisInfo.setDrawerAccepBank(((RepurchaseDiscountRedeemReqInfo)info).getDrawerAccepBank());
            return repdisInfo;
        }
        if (info instanceof DiscountAgainInfo) {
            EdrafDiscountAgainInfo edrDisInfo = new EdrafDiscountAgainInfo();
            edrDisInfo.setBillAmount(((DiscountAgainInfo)info).getBillAmount());
            edrDisInfo.setBillNumber(((DiscountAgainInfo)info).getBillNumber());
            edrDisInfo.setDiscountType(((DiscountAgainInfo)info).getDiscountType());
            edrDisInfo.setRequestDate(((DiscountAgainInfo)info).getRequestDate());
            edrDisInfo.setRate(((DiscountAgainInfo)info).getRate());
            edrDisInfo.setPayfor(((DiscountAgainInfo)info).getPayfor());
            edrDisInfo.setAssignmentMark(((DiscountAgainInfo)info).getAssignmentMark());
            edrDisInfo.setBalanceMark(((DiscountAgainInfo)info).getBalanceMark());
            edrDisInfo.setDiscounterType(((DiscountAgainInfo)info).getDiscounterType());
            edrDisInfo.setDiscounterName(((DiscountAgainInfo)info).getDiscounterName());
            edrDisInfo.setGroupId(((DiscountAgainInfo)info).getGroupId());
            edrDisInfo.setDiscounterSgin(((DiscountAgainInfo)info).getDiscounterSgin());
            edrDisInfo.setDiscounterAccount(((DiscountAgainInfo)info).getDiscounterAccount());
            edrDisInfo.setDiscounterBank(((DiscountAgainInfo)info).getDiscounterBank());
            edrDisInfo.setDiscountBankBak(((DiscountAgainInfo)info).getDiscountBankBak());
            edrDisInfo.setByDiscounterAccount(((DiscountAgainInfo)info).getByDiscounterAccount());
            edrDisInfo.setByDiscounterBank(((DiscountAgainInfo)info).getByDiscounterBank());
            edrDisInfo.setByDiscounterName(((DiscountAgainInfo)info).getByDiscounterName());
            edrDisInfo.setBackCloseDate(((DiscountAgainInfo)info).getBackCloseDate());
            edrDisInfo.setBackOpenDate(((DiscountAgainInfo)info).getBackOpenDate());
            edrDisInfo.setBackRate(((DiscountAgainInfo)info).getBackRate());
            edrDisInfo.setBackMoney(((DiscountAgainInfo)info).getBackMoney());
            edrDisInfo.setBtchNb(((DiscountAgainInfo)info).getBtchNb());
            edrDisInfo.setDiscounterRemark(((DiscountAgainInfo)info).getDiscounterRemark());
            edrDisInfo.setBackMoney(((DiscountAgainInfo)info).getBackMoney());
            edrDisInfo.setDiscountBankBak(((DiscountAgainInfo)info).getDiscountBankBak());
            return edrDisInfo;
        }
        if (info instanceof RepurchaseDiscountTurnRedeemReqInfo) {
            EdrafRepurchaseDiscountTurnRedeemReqInfo repusInfo = new EdrafRepurchaseDiscountTurnRedeemReqInfo();
            repusInfo.setDraftAmount(((RepurchaseDiscountTurnRedeemReqInfo)info).getDraftAmount());
            repusInfo.setDraftNumber(((RepurchaseDiscountTurnRedeemReqInfo)info).getDraftNumber());
            repusInfo.setReqDate(((RepurchaseDiscountTurnRedeemReqInfo)info).getReqDate());
            repusInfo.setRedeemInterRate(((RepurchaseDiscountTurnRedeemReqInfo)info).getRedeemInterRate());
            repusInfo.setRedeemPaidAmt(((RepurchaseDiscountTurnRedeemReqInfo)info).getRedeemPaidAmt());
            repusInfo.setBanEndorsement(((RepurchaseDiscountTurnRedeemReqInfo)info).getBanEndorsement());
            repusInfo.setSettlementMark(((RepurchaseDiscountTurnRedeemReqInfo)info).getSettlementMark());
            repusInfo.setBatch(((RepurchaseDiscountTurnRedeemReqInfo)info).getBatch());
            repusInfo.setRemark(((RepurchaseDiscountTurnRedeemReqInfo)info).getRemark());
            repusInfo.setDrawerRole(((RepurchaseDiscountTurnRedeemReqInfo)info).getDrawerRole());
            repusInfo.setDrawerOrgCode(((RepurchaseDiscountTurnRedeemReqInfo)info).getDrawerOrgCode());
            repusInfo.setDrawerAccount(((RepurchaseDiscountTurnRedeemReqInfo)info).getDrawerAccount());
            repusInfo.setDrawerAccepBank(((RepurchaseDiscountTurnRedeemReqInfo)info).getDrawerAccepBank());
            repusInfo.setDrawerBank(((RepurchaseDiscountTurnRedeemReqInfo)info).getDrawerBank());
            repusInfo.setDrawerElecSign(((RepurchaseDiscountTurnRedeemReqInfo)info).getDrawerElecSign());
            return repusInfo;
        }
        if (info instanceof AgainDiscountApplyBillInfo) {
            EdrafAgainDiscountApplyBillInfo aginInfo = new EdrafAgainDiscountApplyBillInfo();
            aginInfo.setDraftAmount(((AgainDiscountApplyBillInfo)info).getDraftAmount());
            aginInfo.setDraftNumber(((AgainDiscountApplyBillInfo)info).getDraftNumber());
            aginInfo.setAgainDiscountType(((AgainDiscountApplyBillInfo)info).getAgainDiscountType());
            aginInfo.setAgainDiscountApplyDate(((AgainDiscountApplyBillInfo)info).getAgainDiscountApplyDate());
            aginInfo.setAgainDiscountRate(((AgainDiscountApplyBillInfo)info).getAgainDiscountRate());
            aginInfo.setFactAmount(((AgainDiscountApplyBillInfo)info).getFactAmount());
            aginInfo.setBanEndorsement(((AgainDiscountApplyBillInfo)info).getBanEndorsement());
            aginInfo.setSettlementOnline(((AgainDiscountApplyBillInfo)info).getSettlementOnline());
            aginInfo.setRedeemAmount(((AgainDiscountApplyBillInfo)info).getRedeemAmount());
            aginInfo.setRedeemEndDate(((AgainDiscountApplyBillInfo)info).getRedeemEndDate());
            aginInfo.setRedeemEndDate(((AgainDiscountApplyBillInfo)info).getRedeemStartDate());
            aginInfo.setBatchNumber(((AgainDiscountApplyBillInfo)info).getBatchNumber());
            aginInfo.setDrawerRole(((AgainDiscountApplyBillInfo)info).getDrawerRole());
            aginInfo.setDrawerAccount(((AgainDiscountApplyBillInfo)info).getDrawerAccount());
            aginInfo.setDrawerBank(((AgainDiscountApplyBillInfo)info).getDrawerBank());
            aginInfo.setDrawerName(((AgainDiscountApplyBillInfo)info).getDrawerName());
            aginInfo.setDrawerOrgCode(((AgainDiscountApplyBillInfo)info).getDrawerOrgCode());
            aginInfo.setDrawerRemark(((AgainDiscountApplyBillInfo)info).getDrawerRemark());
            aginInfo.setDrawerCarryBank(((AgainDiscountApplyBillInfo)info).getDrawerCarryBank());
            aginInfo.setElectricSign(((AgainDiscountApplyBillInfo)info).getElectricSign());
            aginInfo.setDiscountInAccount(((AgainDiscountApplyBillInfo)info).getDiscountInAccount());
            aginInfo.setDiscountInName(((AgainDiscountApplyBillInfo)info).getDiscountInName());
            aginInfo.setDiscountInBank(((AgainDiscountApplyBillInfo)info).getDiscountInBank());
            return aginInfo;
        }
        if (info instanceof DraftRepurchasedRediscountWithCentralBankRequestInfo) {
            EdrafDraftRepurchasedRediscountWithCentralBankRequestInfo repurcharseInfo = new EdrafDraftRepurchasedRediscountWithCentralBankRequestInfo();
            repurcharseInfo.setDraftAmount(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDraftAmount());
            repurcharseInfo.setDraftNumber(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDraftNumber());
            repurcharseInfo.setDiscountDate(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountDate());
            repurcharseInfo.setDiscountAmount(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountAmount());
            repurcharseInfo.setDiscountRate(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountRate());
            repurcharseInfo.setDiscountAmount(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountAmount());
            repurcharseInfo.setDiscountBanEndrsmtMk(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountBanEndrsmtMk());
            repurcharseInfo.setDiscountBatch(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountBatch());
            repurcharseInfo.setDiscountSttlmMk(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountSttlmMk());
            repurcharseInfo.setDiscountRmrkByPropsr(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getDiscountRmrkByPropsr());
            repurcharseInfo.setRdscntAccount(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getRdscntAccount());
            repurcharseInfo.setRdscntAgcyBank(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getRdscntAgcyBank());
            repurcharseInfo.setRdscntBank(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getRdscntBank());
            repurcharseInfo.setRdscntElctrncSgntr(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getRdscntElctrncSgntr());
            repurcharseInfo.setRdscntOrgCode(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getRdscntOrgCode());
            repurcharseInfo.setRdscntType(((DraftRepurchasedRediscountWithCentralBankRequestInfo)info).getRdscntType());
            return repurcharseInfo;
        }
        if (info instanceof GuaranteeRequestBillInfo) {
            EdrafGuaranteeRequestBillInfo guarInfo = new EdrafGuaranteeRequestBillInfo();
            guarInfo.setDraftNumber(((GuaranteeRequestBillInfo)info).getDraftNumber());
            guarInfo.setDraftAmount(((GuaranteeRequestBillInfo)info).getDraftAmount());
            guarInfo.setApplyDate(((GuaranteeRequestBillInfo)info).getApplyDate());
            guarInfo.setBatchNumber(((GuaranteeRequestBillInfo)info).getBatchNumber());
            guarInfo.setWarranteeAccount(((GuaranteeRequestBillInfo)info).getWarranteeAccount());
            guarInfo.setWarranteeAgcybank(((GuaranteeRequestBillInfo)info).getWarranteeAgcybank());
            guarInfo.setWarranteeElecSign(((GuaranteeRequestBillInfo)info).getWarranteeElecSign());
            guarInfo.setWarranteeName(((GuaranteeRequestBillInfo)info).getWarranteeName());
            guarInfo.setWarranteeOrgCode(((GuaranteeRequestBillInfo)info).getWarranteeOrgCode());
            guarInfo.setWarranteeRemark(((GuaranteeRequestBillInfo)info).getWarranteeRemark());
            guarInfo.setWarranteeRole(((GuaranteeRequestBillInfo)info).getWarranteeRole());
            guarInfo.setWarranteeBank(((GuaranteeRequestBillInfo)info).getWarranteeBank());
            guarInfo.setGuarantorAccount(((GuaranteeRequestBillInfo)info).getGuarantorAccount());
            guarInfo.setGuarantorBank(((GuaranteeRequestBillInfo)info).getGuarantorBank());
            guarInfo.setGuarantorName(((GuaranteeRequestBillInfo)info).getGuarantorName());
            return guarInfo;
        }
        if (info instanceof PledgeReqBillInfo) {
            EdrafPledgeReqBillInfo derPleInfo = new EdrafPledgeReqBillInfo();
            derPleInfo.setDraftAmount(((PledgeReqBillInfo)info).getDraftAmount());
            derPleInfo.setDraftNumber(((PledgeReqBillInfo)info).getDraftNumber());
            derPleInfo.setIssueDate(((PledgeReqBillInfo)info).getIssueDate());
            derPleInfo.setBatchNum(((PledgeReqBillInfo)info).getBatchNum());
            derPleInfo.setRemark(((PledgeReqBillInfo)info).getRemark());
            derPleInfo.setDrawerRole(((PledgeReqBillInfo)info).getDrawerRole());
            derPleInfo.setDrawerName(((PledgeReqBillInfo)info).getDrawerName());
            derPleInfo.setDrawerOrgCode(((PledgeReqBillInfo)info).getDrawerOrgCode());
            derPleInfo.setDrawerElecSign(((PledgeReqBillInfo)info).getDrawerElecSign());
            derPleInfo.setDrawerAccount(((PledgeReqBillInfo)info).getDrawerAccount());
            derPleInfo.setDrawerBank(((PledgeReqBillInfo)info).getDrawerBank());
            derPleInfo.setPledgeAccepBank(((PledgeReqBillInfo)info).getPledgeAccepBank());
            derPleInfo.setPledgeName(((PledgeReqBillInfo)info).getPledgeName());
            derPleInfo.setPledgeAccount(((PledgeReqBillInfo)info).getPledgeAccount());
            derPleInfo.setPledgeBank(((PledgeReqBillInfo)info).getPledgeBank());
            return derPleInfo;
        }
        if (info instanceof ImpawnUnchainApplyBillInfo) {
            EdrafImpawnUnchainApplyBillInfo edrImpawnInfo = new EdrafImpawnUnchainApplyBillInfo();
            edrImpawnInfo.setDraftAmount(((ImpawnUnchainApplyBillInfo)info).getDraftAmount());
            edrImpawnInfo.setDraftNumber(((ImpawnUnchainApplyBillInfo)info).getDraftNumber());
            edrImpawnInfo.setImpawnAccount(((ImpawnUnchainApplyBillInfo)info).getImpawnAccount());
            edrImpawnInfo.setImpawnUnchainDate(((ImpawnUnchainApplyBillInfo)info).getImpawnUnchainDate());
            edrImpawnInfo.setBatchNumber(((ImpawnUnchainApplyBillInfo)info).getBatchNumber());
            edrImpawnInfo.setPawneeRemark(((ImpawnUnchainApplyBillInfo)info).getPawneeRemark());
            edrImpawnInfo.setImpawnName(((ImpawnUnchainApplyBillInfo)info).getImpawnName());
            edrImpawnInfo.setImpawnBank(((ImpawnUnchainApplyBillInfo)info).getImpawnBank());
            edrImpawnInfo.setImpawnCarryBank(((ImpawnUnchainApplyBillInfo)info).getImpawnCarryBank());
            edrImpawnInfo.setImpawnOrgCode(((ImpawnUnchainApplyBillInfo)info).getImpawnOrgCode());
            edrImpawnInfo.setImpawnType(((ImpawnUnchainApplyBillInfo)info).getImpawnType());
            edrImpawnInfo.setElectricSign(((ImpawnUnchainApplyBillInfo)info).getElectricSign());
            return edrImpawnInfo;
        }
        if (info instanceof PromptPaymentReqInfo) {
            EdrafPromptPaymentReqInfo promptInfo = new EdrafPromptPaymentReqInfo();
            promptInfo.setRemark(((PromptPaymentReqInfo)info).getRemark());
            promptInfo.setPaymentDate(((PromptPaymentReqInfo)info).getPaymentDate());
            promptInfo.setPaymentAmount(((PromptPaymentReqInfo)info).getPaymentAmount());
            promptInfo.setProxyPropositio(((PromptPaymentReqInfo)info).getProxyPropositio());
            promptInfo.setSettlementMark(((PromptPaymentReqInfo)info).getSettlementMark());
            promptInfo.setDraweeRemark(((PromptPaymentReqInfo)info).getDraweeRemark());
            promptInfo.setRoleType(((PromptPaymentReqInfo)info).getRoleType());
            promptInfo.setReloAccount(((PromptPaymentReqInfo)info).getReloAccount());
            promptInfo.setReloAgcyBank(((PromptPaymentReqInfo)info).getReloAgcyBank());
            promptInfo.setReloBank(((PromptPaymentReqInfo)info).getReloBank());
            promptInfo.setRoleName(((PromptPaymentReqInfo)info).getRoleName());
            promptInfo.setOrgCode(((PromptPaymentReqInfo)info).getOrgCode());
            promptInfo.setReloAccount(((PromptPaymentReqInfo)info).getReloAccount());
            promptInfo.setReloBank(((PromptPaymentReqInfo)info).getReloBank());
            promptInfo.setReloAgcyBank(((PromptPaymentReqInfo)info).getReloAgcyBank());
            return promptInfo;
        }
        if (info instanceof OverdueCuePayInfo) {
            EdrafOverdueCuePayInfo overInfo = new EdrafOverdueCuePayInfo();
            overInfo.setDraftAmount(((OverdueCuePayInfo)info).getDraftAmount());
            overInfo.setDraftNumber(((OverdueCuePayInfo)info).getDraftNumber());
            overInfo.setOverdueDate(((OverdueCuePayInfo)info).getOverdueDate());
            overInfo.setOverdueAmount(((OverdueCuePayInfo)info).getOverdueAmount());
            overInfo.setOverdueReason(((OverdueCuePayInfo)info).getOverdueReason());
            overInfo.setDrawerAccount(((OverdueCuePayInfo)info).getDrawerAccount());
            overInfo.setDrawerBank(((OverdueCuePayInfo)info).getDrawerBank());
            overInfo.setDrawerName(((OverdueCuePayInfo)info).getDrawerName());
            overInfo.setDrawerOrgCode(((OverdueCuePayInfo)info).getDrawerOrgCode());
            overInfo.setDrawerRole(((OverdueCuePayInfo)info).getDrawerRole());
            overInfo.setDrawerCarryBank(((OverdueCuePayInfo)info).getDrawerCarryBank());
            overInfo.setElectricSign(((OverdueCuePayInfo)info).getElectricSign());
            overInfo.setSettlementOnline(((OverdueCuePayInfo)info).getSettlementOnline());
            overInfo.setPayerRemark(((OverdueCuePayInfo)info).getPayerRemark());
            overInfo.setSupplyApplySign(((OverdueCuePayInfo)info).getSupplyApplySign());
            return overInfo;
        }
        if (info instanceof RecourseNotificationBillInfo) {
            EdrafRecourseNotificationBillInfo recorInfo = new EdrafRecourseNotificationBillInfo();
            recorInfo.setRecoursElecSign(((RecourseNotificationBillInfo)info).getRecoursElecSign());
            recorInfo.setRecourseType(((RecourseNotificationBillInfo)info).getRecourseType());
            recorInfo.setRecourseData(((RecourseNotificationBillInfo)info).getRecourseData());
            recorInfo.setRecourseAccout(((RecourseNotificationBillInfo)info).getRecourseAccout());
            recorInfo.setRecourseCode(((RecourseNotificationBillInfo)info).getRecourseCode());
            recorInfo.setRecourseRemark(((RecourseNotificationBillInfo)info).getRecourseRemark());
            recorInfo.setRecourseRole(((RecourseNotificationBillInfo)info).getRecourseRole());
            recorInfo.setRecourseName(((RecourseNotificationBillInfo)info).getRecourseName());
            recorInfo.setRecourseBizCode(((RecourseNotificationBillInfo)info).getRecourseBizCode());
            recorInfo.setRecourseAccout(((RecourseNotificationBillInfo)info).getRecourseAccout());
            recorInfo.setRecourseBank(((RecourseNotificationBillInfo)info).getRecourseBank());
            recorInfo.setRecourseCarryBa(((RecourseNotificationBillInfo)info).getRecourseCarryBa());
            recorInfo.setByRecName(((RecourseNotificationBillInfo)info).getByRecName());
            recorInfo.setByRecCode(((RecourseNotificationBillInfo)info).getByRecCode());
            recorInfo.setByRecAccout(((RecourseNotificationBillInfo)info).getByRecAccout());
            recorInfo.setByRecBank(((RecourseNotificationBillInfo)info).getByRecBank());
            recorInfo.setByRecCarryBank(((RecourseNotificationBillInfo)info).getByRecCarryBank());
            recorInfo.setRecourseAmount(((RecourseNotificationBillInfo)info).getRecourseAmount());
            return recorInfo;
        }
        if (info instanceof RecourseAgreementRequestBillInfo) {
            EdrafRecourseAgreementRequestBillInfo recouse = new EdrafRecourseAgreementRequestBillInfo();
            recouse.setOrgMessageId(((RecourseAgreementRequestBillInfo)info).getOrgMessageId());
            recouse.setOrgMessageTime(((RecourseAgreementRequestBillInfo)info).getOrgMessageTime());
            recouse.setDraftNumber(((RecourseAgreementRequestBillInfo)info).getDraftNumber());
            recouse.setDraftAmount(((RecourseAgreementRequestBillInfo)info).getDraftAmount());
            recouse.setAgreeDate(((RecourseAgreementRequestBillInfo)info).getAgreeDate());
            recouse.setAgreeAmount(((RecourseAgreementRequestBillInfo)info).getAgreeAmount());
            recouse.setAgreeRemark(((RecourseAgreementRequestBillInfo)info).getAgreeRemark());
            recouse.setAgreemanType(((RecourseAgreementRequestBillInfo)info).getAgreemanType());
            recouse.setAgreemanName(((RecourseAgreementRequestBillInfo)info).getAgreemanName());
            recouse.setGroupId(((RecourseAgreementRequestBillInfo)info).getGroupId());
            recouse.setAgreemanSgin(((RecourseAgreementRequestBillInfo)info).getAgreemanSgin());
            recouse.setAgreemanAccount(((RecourseAgreementRequestBillInfo)info).getAgreemanAccount());
            recouse.setAgreemanBank(((RecourseAgreementRequestBillInfo)info).getAgreemanBank());
            recouse.setAgreemanBankBak(((RecourseAgreementRequestBillInfo)info).getAgreemanBankBak());
            return recouse;
        }
        if (info instanceof BankSellingDraftsRequestInfo) {
            EdrafBankSellingDraftsRequestInfo edrafBankInfo = new EdrafBankSellingDraftsRequestInfo();
            edrafBankInfo.setDrafNumber(((BankSellingDraftsRequestInfo)info).getDrafNumber());
            edrafBankInfo.setDraftAmount(((BankSellingDraftsRequestInfo)info).getDraftAmount());
            edrafBankInfo.setReqDate(((BankSellingDraftsRequestInfo)info).getReqDate());
            edrafBankInfo.setInterestRate(((BankSellingDraftsRequestInfo)info).getInterestRate());
            edrafBankInfo.setAmount(((BankSellingDraftsRequestInfo)info).getAmount());
            edrafBankInfo.setBanEndorsement(((BankSellingDraftsRequestInfo)info).getBanEndorsement());
            edrafBankInfo.setSettlementMark(((BankSellingDraftsRequestInfo)info).getSettlementMark());
            edrafBankInfo.setBatch(((BankSellingDraftsRequestInfo)info).getBatch());
            edrafBankInfo.setRemark(((BankSellingDraftsRequestInfo)info).getRemark());
            edrafBankInfo.setSalerType(((BankSellingDraftsRequestInfo)info).getSalerType());
            edrafBankInfo.setSalerName(((BankSellingDraftsRequestInfo)info).getSalerName());
            edrafBankInfo.setSalerAccount(((BankSellingDraftsRequestInfo)info).getSalerAccount());
            edrafBankInfo.setSalerOrgCode(((BankSellingDraftsRequestInfo)info).getSalerOrgCode());
            edrafBankInfo.setSalerUnderWrite(((BankSellingDraftsRequestInfo)info).getSalerUnderWrite());
            edrafBankInfo.setSalerBank(((BankSellingDraftsRequestInfo)info).getSalerBank());
            edrafBankInfo.setSalerAgcyBank(((BankSellingDraftsRequestInfo)info).getSalerAgcyBank());
            edrafBankInfo.setBuyerName(((BankSellingDraftsRequestInfo)info).getBuyerName());
            edrafBankInfo.setBuyerAccount(((BankSellingDraftsRequestInfo)info).getBuyerAccount());
            edrafBankInfo.setBuyerBank(((BankSellingDraftsRequestInfo)info).getBuyerBank());
            return edrafBankInfo;
        }
        return null;
    }

    public static Map getDraftBackInformation(Context ctx, String draftTakerOrgCode, String draftNumber) throws BOSException {
        int seQTemp = 0;
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("draftNumber", (Object)draftNumber));
        SorterItemInfo sortInfo = new SorterItemInfo("seq");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.ASCEND);
        sortCol.add(sortInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("accptEntry.*");
        sic.add("disctEntry.*");
        sic.add("payReqEntry.*");
        sic.add("recrsEntry.*");
        viewinfo.setSelector(sic);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        ElecDraftBillEntryCollection draftColl = ElecDraftBillEntryFactory.getLocalInstance(ctx).getElecDraftBillEntryCollection(viewinfo);
        for (int i = 0; i < draftColl.size(); ++i) {
            if (!draftColl.get(i).getFormerOrgCode().equals(draftTakerOrgCode) && !draftColl.get(i).getLaterOrgCode().equals(draftTakerOrgCode)) continue;
            seQTemp = draftColl.get(i).getSeq();
        }
        EdrafElecDraftBillEntryCollection col = new EdrafElecDraftBillEntryCollection();
        for (int i = 0; i < draftColl.size(); ++i) {
            if (seQTemp < draftColl.get(i).getSeq()) {
                draftColl.removeObject(i);
            }
            ElecDraftBillEntryInfo info = draftColl.get(i);
            EdrafElecDraftBillEntryInfo edrafInfo = new EdrafElecDraftBillEntryInfo();
            edrafInfo.setDraftNumber(info.getDraftNumber());
            edrafInfo.setDraftBizType(info.getDraftBizType());
            edrafInfo.setDraftSignInDate(info.getDraftSignInDate());
            edrafInfo.setFormerName(info.getFormerName());
            edrafInfo.setFormerRole(info.getFormerRole());
            edrafInfo.setFormerOrgCode(info.getFormerOrgCode());
            edrafInfo.setFormerAccount(info.getFormerAccount());
            edrafInfo.setFormerBank(info.getFormerBank());
            edrafInfo.setFormerAgcyBank(info.getFormerAgcyBank());
            edrafInfo.setFormerRemark(info.getFormerRemark());
            edrafInfo.setLaterRole(info.getLaterRole());
            edrafInfo.setLaterName(info.getLaterName());
            edrafInfo.setLaterOrgCode(info.getLaterOrgCode());
            edrafInfo.setLaterAccount(info.getLaterAccount());
            edrafInfo.setLaterBank(info.getLaterBank());
            edrafInfo.setLaterAgcyBank(info.getLaterAgcyBank());
            edrafInfo.setLaterRemark(info.getLaterRemark());
            edrafInfo.setBanEndorsement(info.getBanEndorsement());
            edrafInfo.setProxySignature(info.getProxySignature());
            edrafInfo.setSettlementMode(info.getSettlementMode());
            edrafInfo.setInterestRate(info.getInterestRate());
            edrafInfo.setActualAmount(info.getActualAmount());
            edrafInfo.setGuarnteeAddress(info.getGuarnteeAddress());
            EntityViewInfo otherInfo = new EntityViewInfo();
            FilterInfo otherFiler = new FilterInfo();
            otherFiler.getFilterItems().add(new FilterItemInfo("parent", (Object)info.getId().toString()));
            otherInfo.setFilter(otherFiler);
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.CHENGDUI)) {
                ElecDraftBillAccptEntryInfo acctInfo = ElecDraftBillAccptEntryFactory.getLocalInstance(ctx).getElecDraftBillAccptEntryCollection(otherInfo).get(0);
                edrafInfo.setAccptEntry(acctInfo);
            }
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.TIEXIAN)) {
                ElecDraftBillDisctEntryInfo disctInfo = ElecDraftBillDisctEntryFactory.getLocalInstance(ctx).getElecDraftBillDisctEntryCollection(otherInfo).get(0);
                edrafInfo.setDisctEntry(info.getDisctEntry());
            }
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.TISHIFUKUAN) || info.getDraftBizType().equals((Object)DraftBizTypeEnum.YUQITISHIFUKUAN)) {
                ElecDraftBillPayReqEntryInfo payInfo = ElecDraftBillPayReqEntryFactory.getLocalInstance(ctx).getElecDraftBillPayReqEntryCollection(otherInfo).get(0);
                edrafInfo.setPayReqEntry(payInfo);
            }
            if (info.getDraftBizType().equals((Object)DraftBizTypeEnum.ZHUISUO)) {
                ElecDraftBillRecrsEntryInfo reqInfo = ElecDraftBillRecrsEntryFactory.getLocalInstance(ctx).getElecDraftBillRecrsEntryCollection(otherInfo).get(0);
                edrafInfo.setRecrsEntry(info.getRecrsEntry());
            }
            edrafInfo.setCreateMessageID(info.getCreateMessageID());
            edrafInfo.setSeq(info.getSeq());
            col.add(edrafInfo);
        }
        HashMap<String, Object> draftMap = new HashMap<String, Object>();
        draftMap.put("EdrafElecColl", col);
        draftMap.put("", "");
        return draftMap;
    }
}

