/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.ContractActionEnum;
import com.kingdee.eas.fm.ecore.ContractCancelBillInfo;
import com.kingdee.eas.fm.ecore.ContractOfferReqBillInfo;
import com.kingdee.eas.fm.ecore.ContractRescindReqBillInfo;
import com.kingdee.eas.fm.ecore.ContractStateEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ElecContractBillInfo;
import com.kingdee.eas.fm.ecore.FMECDSBillBaseInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.ContractCommonCancellation;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.Ctrct;
import com.kingdee.eas.fm.ecore.app.bean.node.CxlPropsr;
import com.kingdee.eas.fm.ecore.app.bean.node.OrgnlMsgId;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSContractUtil;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendContractCommonCancellation
implements ISendHandler {
    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ContractCancelBillInfo info = (ContractCancelBillInfo)billBaseInfo;
        FMECDSBillBaseInfo applyBillBaseInfo = ECDSContractUtil.getOriginalApplyInfo(ctx, info, true);
        if (applyBillBaseInfo instanceof ContractOfferReqBillInfo) {
            return ((ContractOfferReqBillInfo)applyBillBaseInfo).getOffeeBank();
        }
        if (applyBillBaseInfo instanceof ContractRescindReqBillInfo) {
            ElecContractBillInfo elInfo = ECDSContractUtil.findElecContractInfo(ctx, info.getCtrctNb());
            if (((ContractRescindReqBillInfo)applyBillBaseInfo).getRscisnPropsrOrgCode().equals(elInfo.getOfferOrgCode())) {
                return elInfo.getOffeeBank();
            }
            return elInfo.getOfferBank();
        }
        return null;
    }

    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        ContractCancelBillInfo contractInfo = (ContractCancelBillInfo)billBaseInfo;
        FMECDSBillBaseInfo applyBillBaseInfo = ECDSContractUtil.getOriginalApplyInfo(ctx, contractInfo, true);
        if (applyBillBaseInfo instanceof ContractOfferReqBillInfo) {
            ECDSCommon.insertContracttAction(ctx, kmsg, contractInfo.getCtrctNb(), contractInfo.getBizPromoterOrgCode(), contractInfo.getId().toString(), ContractStateEnum.YW01, ContractActionEnum.SEND, DraftMessageEnum.M206);
        } else if (applyBillBaseInfo instanceof ContractRescindReqBillInfo) {
            ECDSCommon.insertContracttAction(ctx, kmsg, contractInfo.getCtrctNb(), contractInfo.getBizPromoterOrgCode(), contractInfo.getId().toString(), ContractStateEnum.YW02, ContractActionEnum.SEND, DraftMessageEnum.M206);
        }
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ContractCancelBillInfo info = (ContractCancelBillInfo)billBaseInfo;
        KMsg kMsg = new KMsg();
        ContractCommonCancellation documentDraft = new ContractCommonCancellation();
        OrgnlMsgId orgnlMsgId = new OrgnlMsgId();
        orgnlMsgId.setId(info.getOrgnlMsgId());
        orgnlMsgId.setCreDtTm(ECDSCommon.getMessTimeByTimestamp(info.getOrgnlCreDtTm()));
        Ctrct ctrct = new Ctrct();
        ctrct.setCtrctNb(info.getCtrctNb());
        CxlPropsr cxlPropsr = new CxlPropsr();
        cxlPropsr.setRole(info.getCxlPropsrRole().getValue().toString());
        cxlPropsr.setCmonId(info.getCxlPropsrCmonId());
        cxlPropsr.setElctrncSgntr(info.getCxlPropsrElctrncSgntr());
        Acct acct = new Acct();
        acct.setId(info.getCxlPropsrAccount());
        acct.setAcctSvcr(info.getCxlPropsrBank());
        cxlPropsr.setAcct(acct);
        Agcy agcy = new Agcy();
        Acct agcy_acct = new Acct();
        agcy_acct.setAcctSvcr(info.getCxlPropsrBankBak());
        agcy.setAcct(agcy_acct);
        cxlPropsr.setAgcy(agcy);
        documentDraft.setCtrct(ctrct);
        documentDraft.setCxlPropsr(cxlPropsr);
        documentDraft.setOrgnlMsgId(orgnlMsgId);
        kMsg.setDocumentCommercialDraft(documentDraft);
        return kMsg;
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        ContractCancelBillInfo info = (ContractCancelBillInfo)billBaseInfo;
        return info.getCxlPropsrBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
    }
}

