/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.BizContractReplyBillInfo;
import com.kingdee.eas.fm.ecore.ContractActionEnum;
import com.kingdee.eas.fm.ecore.ContractStateEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.ContractCommonResponse;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.Ctrct;
import com.kingdee.eas.fm.ecore.app.bean.node.OrgnlMsgId;
import com.kingdee.eas.fm.ecore.app.bean.node.Rspnr;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSContractUtil;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendContractCommonResponse
implements ISendHandler {
    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        BizContractReplyBillInfo bizContractReplyBillInfo = (BizContractReplyBillInfo)billBaseInfo;
        String oriMessageId = bizContractReplyBillInfo.getOriMessageID();
        if (oriMessageId != null) {
            return oriMessageId.substring(0, 12);
        }
        return null;
    }

    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        BizContractReplyBillInfo bizContractReplyBillInfo = (BizContractReplyBillInfo)billBaseInfo;
        ContractCommonResponse contractCommonResponse = (ContractCommonResponse)kmsg.getDocumentCommercialDraft();
        String IdNb = contractCommonResponse.getCtrct().getCtrctNb();
        boolean isResponseOfferReq = ECDSContractUtil.isExistElecContractBillByContractNumber(ctx, IdNb);
        ContractStateEnum contractState = isResponseOfferReq ? ContractStateEnum.YW04 : ContractStateEnum.YW01;
        ECDSCommon.insertContracttAction(ctx, kmsg, IdNb, contractCommonResponse.getRspnr().getCmonId(), bizContractReplyBillInfo.getId().toString(), contractState, ContractActionEnum.SEND_REPLY, DraftMessageEnum.M205);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        BizContractReplyBillInfo bizContractReplyBillInfo = (BizContractReplyBillInfo)billBaseInfo;
        ContractCommonResponse contractCommonResponse = new ContractCommonResponse();
        OrgnlMsgId orgnlMsgId = new OrgnlMsgId();
        orgnlMsgId.setId(bizContractReplyBillInfo.getOriMessageID());
        orgnlMsgId.setCreDtTm(ECDSCommon.getMessTimeByTimestamp(bizContractReplyBillInfo.getOriMessageTime()));
        contractCommonResponse.setOrgnlMsgId(orgnlMsgId);
        Ctrct ctrct = new Ctrct();
        ctrct.setCtrctNb(bizContractReplyBillInfo.getCtrctNumber());
        ctrct.setRspnsMrkr(bizContractReplyBillInfo.getRspnsMrkr().getValue());
        ctrct.setDt(bizContractReplyBillInfo.getRspnsMrDt().toString());
        contractCommonResponse.setCtrct(ctrct);
        Rspnr rspnr = new Rspnr();
        rspnr.setRole(bizContractReplyBillInfo.getReplierRole().getValue());
        rspnr.setCmonId(bizContractReplyBillInfo.getReplierOrgCode());
        rspnr.setElctrncSgntr(bizContractReplyBillInfo.getReplierElctrncSgntr());
        Acct acct = new Acct();
        acct.setId(bizContractReplyBillInfo.getReplierAccount());
        acct.setAcctSvcr(bizContractReplyBillInfo.getReplierBank());
        rspnr.setAcct(acct);
        Agcy agcy = new Agcy();
        acct = new Acct();
        acct.setAcctSvcr(bizContractReplyBillInfo.getReplierAgcyBank());
        agcy.setAcct(acct);
        rspnr.setAgcy(agcy);
        contractCommonResponse.setRspnr(rspnr);
        kMsg.setDocumentCommercialDraft(contractCommonResponse);
        return kMsg;
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        BizContractReplyBillInfo bizContractReplyBillInfo = (BizContractReplyBillInfo)billBaseInfo;
        return bizContractReplyBillInfo.getReplierBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
    }
}

