/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.BizCancelBillInfo;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftDestructionRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Drwr;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftDestructionRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        BizCancelBillInfo entityInfo = (BizCancelBillInfo)billBaseInfo;
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, entityInfo.getCancelOrgCode(), entityInfo.getDraftNumber().toString());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, String.valueOf(entityInfo.getDraftNumber()), entityInfo.getCancelOrgCode(), entityInfo.getId().toString(), stateEnum, ElecDraftActionEnum.SEND, DraftMessageEnum.M004, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        BizCancelBillInfo entityInfo = (BizCancelBillInfo)billBaseInfo;
        CommercialDraftDestructionRequest di = new CommercialDraftDestructionRequest();
        ComrclDrft cd = new ComrclDrft();
        cd.setIdNb(String.valueOf(entityInfo.getDraftNumber()));
        cd.setIsseAmt(String.valueOf(entityInfo.getDraftAmount().setScale(0, 4)));
        Drwr dw = new Drwr();
        Acct dwAcct = new Acct();
        dwAcct.setId(entityInfo.getCancelAccount());
        dwAcct.setAcctSvcr(entityInfo.getCancelBank());
        dw.setAcct(dwAcct);
        Agcy agcy = new Agcy();
        Acct acct = new Acct();
        acct.setAcctSvcr(entityInfo.getCancelAgcyBank());
        agcy.setAcct(acct);
        dw.setAgcy(agcy);
        dw.setRole(entityInfo.getCancelRole().getValue());
        dw.setCmonId(entityInfo.getCancelOrgCode());
        dw.setElctrncSgntr(entityInfo.getEletricSign());
        di.setComrclDrft(cd);
        di.setDrwr(dw);
        kMsg.setDocumentCommercialDraft(di);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        BizCancelBillInfo entityInfo = (BizCancelBillInfo)billBaseInfo;
        return entityInfo.getCancelBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        BizCancelBillInfo entityInfo = (BizCancelBillInfo)billBaseInfo;
        return entityInfo.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftDestructionRequest ct = (CommercialDraftDestructionRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getDrwr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDrwr().getAcct().getAcctSvcr(), acctId = ct.getDrwr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDrwr().setRole(oinfo.getOrgUnitRoleType().getValue());
    }
}

