/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.OverdueCuePayInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftOverduePresentationRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.DrftHldr;
import com.kingdee.eas.fm.ecore.app.bean.node.OvrduePrsnttn;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftOverduePresentationRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        OverdueCuePayInfo entityInfo = (OverdueCuePayInfo)billBaseInfo;
        String idNb = entityInfo.getDraftNumber();
        String holderOrgCode = entityInfo.getDrawerOrgCode();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, entityInfo.getId().toString(), eenum, ElecDraftActionEnum.getEnum(0), DraftMessageEnum.getEnum("M021"), null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        OverdueCuePayInfo entityInfo = (OverdueCuePayInfo)billBaseInfo;
        CommercialDraftOverduePresentationRequest di = new CommercialDraftOverduePresentationRequest();
        ComrclDrft cd = new ComrclDrft();
        cd.setIdNb(entityInfo.getDraftNumber());
        cd.setIsseAmt(String.valueOf(entityInfo.getDraftAmount().setScale(2, 4)));
        OvrduePrsnttn op = new OvrduePrsnttn();
        op.setApplDt(entityInfo.getOverdueDate().toString());
        op.setAmt(String.valueOf(entityInfo.getOverdueAmount().setScale(2, 4)));
        if (entityInfo.getSupplyApplySign() != null) {
            op.setPrxyPropstn(entityInfo.getSupplyApplySign().getValue());
        }
        if (!FMHelper.isEmpty((String)entityInfo.getPayerRemark())) {
            op.setRmrkByPropsr(entityInfo.getPayerRemark());
        } else {
            op.setRmrkByPropsr(null);
        }
        op.setRsn(entityInfo.getOverdueReason());
        if (entityInfo.getSettlementOnline() != null) {
            op.setSttlmMk(entityInfo.getSettlementOnline().getValue());
        }
        DrftHldr dh = new DrftHldr();
        Acct dhAcct = new Acct();
        dhAcct.setAcctSvcr(entityInfo.getDrawerBank());
        dhAcct.setId(entityInfo.getDrawerAccount());
        dh.setAcct(dhAcct);
        dh.setCmonId(entityInfo.getDrawerOrgCode());
        dh.setElctrncSgntr(entityInfo.getElectricSign());
        dh.setNm(entityInfo.getDrawerName());
        Agcy agcy = new Agcy();
        Acct acct = new Acct();
        acct.setAcctSvcr(entityInfo.getDrawerCarryBank());
        agcy.setAcct(acct);
        dh.setAgcy(agcy);
        di.setComrclDrft(cd);
        di.setOvrduePrsnttn(op);
        di.setDrftHldr(dh);
        kMsg.setDocumentCommercialDraft(di);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        OverdueCuePayInfo entityInfo = (OverdueCuePayInfo)billBaseInfo;
        ElecDraftBillInfo info = ECDSCommon.findElecDraftBillInfoByIndb(ctx, entityInfo.getDraftNumber().toString());
        return info.getAcceptorBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        OverdueCuePayInfo entityInfo = (OverdueCuePayInfo)billBaseInfo;
        return entityInfo.getDrawerBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        OverdueCuePayInfo entityInfo = (OverdueCuePayInfo)billBaseInfo;
        return String.valueOf(entityInfo.getDraftNumber());
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        OverdueCuePayInfo entityInfo = (OverdueCuePayInfo)billBaseInfo;
        CommercialDraftOverduePresentationRequest ct = (CommercialDraftOverduePresentationRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getDrftHldr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDrftHldr().getAcct().getAcctSvcr(), acctId = ct.getDrftHldr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDrftHldr().setRole(oinfo.getOrgUnitRoleType().getValue());
        entityInfo.setDrawerRole(oinfo.getOrgUnitRoleType());
    }
}

