/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.AgainDiscountApplyBillInfo;
import com.kingdee.eas.fm.ecore.DiscountTypeEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRediscountWithCentralBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.RdscntWthCntrlBk;
import com.kingdee.eas.fm.ecore.app.bean.node.RdscntWthCntrlBkSys;
import com.kingdee.eas.fm.ecore.app.bean.node.RqstngBkOfRdscntWthCntrlBk;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftRediscountWithCentralBankRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        AgainDiscountApplyBillInfo entityInfo = (AgainDiscountApplyBillInfo)billBaseInfo;
        CommercialDraftRediscountWithCentralBankRequest cc = (CommercialDraftRediscountWithCentralBankRequest)kmsg.getDocumentCommercialDraft();
        String idNb = entityInfo.getDraftNumber();
        String holderOrgCode = cc.getRqstngBkOfRdscntWthCntrlBk().getCmonId();
        ECDSBillStatusEnum eenum = ECDSCommon.findElecDraftBillState(ctx, holderOrgCode, idNb);
        DraftMessageEnum messageTypeEnum = entityInfo.getAgainDiscountType() == DiscountTypeEnum.RM00 ? DraftMessageEnum.M015_MAIDUAN : DraftMessageEnum.M015_HUIGOU;
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, idNb, holderOrgCode, entityInfo.getId().toString(), eenum, ElecDraftActionEnum.SEND, messageTypeEnum, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AgainDiscountApplyBillInfo entityInfo = (AgainDiscountApplyBillInfo)billBaseInfo;
        CommercialDraftRediscountWithCentralBankRequest info = new CommercialDraftRediscountWithCentralBankRequest();
        ComrclDrft cd = new ComrclDrft();
        cd.setIdNb(String.valueOf(entityInfo.getDraftNumber()));
        cd.setIsseAmt(String.valueOf(entityInfo.getDraftAmount().setScale(2, 4)));
        RqstngBkOfRdscntWthCntrlBk rb = new RqstngBkOfRdscntWthCntrlBk();
        rb.setCmonId(entityInfo.getDrawerOrgCode());
        rb.setElctrncSgntr(entityInfo.getElectricSign());
        rb.setNm(entityInfo.getDrawerName());
        Acct rbAcct = new Acct();
        rbAcct.setId(entityInfo.getDrawerAccount());
        rbAcct.setAcctSvcr(entityInfo.getDrawerBank());
        rb.setAcct(rbAcct);
        if (entityInfo.getDrawerCarryBank() != null) {
            Agcy rbAgcy = new Agcy();
            Acct acct = new Acct();
            acct.setAcctSvcr(entityInfo.getDrawerCarryBank());
            rbAgcy.setAcct(acct);
            rb.setAgcy(rbAgcy);
        }
        RdscntWthCntrlBk rw = new RdscntWthCntrlBk();
        rw.setAmt(String.valueOf(entityInfo.getFactAmount().setScale(2, 4)));
        rw.setBanEndrsmtMk(entityInfo.getBanEndorsement().getValue());
        if (entityInfo.getBatchNumber() != null) {
            rw.setBtchNb(entityInfo.getBatchNumber());
        }
        rw.setDt(entityInfo.getAgainDiscountApplyDate().toString());
        rw.setIntrstRate(entityInfo.getAgainDiscountRate().setScale(6, 4));
        if (entityInfo.getDrawerRemark() != null) {
            rw.setRmrkByPropsr(entityInfo.getDrawerRemark());
        }
        if (entityInfo.getRedeemAmount() != null) {
            rw.setRpdAmt(String.valueOf(entityInfo.getRedeemAmount().setScale(2, 4)));
        }
        if (entityInfo.getRedeemEndDate() != null) {
            rw.setRpdDueDt(entityInfo.getRedeemEndDate().toString());
        }
        if (entityInfo.getRedeemRate() != null) {
            rw.setRpdIntrstRate(entityInfo.getRedeemRate().setScale(6, 4));
        }
        rw.setRpdMk(entityInfo.getAgainDiscountType().getValue());
        if (entityInfo.getRedeemStartDate() != null) {
            rw.setRpdOpenDt(entityInfo.getRedeemStartDate().toString());
        }
        rw.setSttlmMk(entityInfo.getSettlementOnline().getValue());
        if (!FMHelper.isEmpty((String)entityInfo.getDrawerRemark())) {
            rw.setRmrkByPropsr(entityInfo.getDrawerRemark());
        } else {
            rw.setRmrkByPropsr(null);
        }
        RdscntWthCntrlBkSys rs = new RdscntWthCntrlBkSys();
        Acct rsAcct = new Acct();
        rsAcct.setId(entityInfo.getDiscountInAccount());
        rsAcct.setAcctSvcr(entityInfo.getDiscountInBank());
        rs.setAcct(rsAcct);
        rs.setNm(entityInfo.getDiscountInName());
        info.setRdscntWthCntrlBk(rw);
        info.setRdscntWthCntrlBkSys(rs);
        info.setRqstngBkOfRdscntWthCntrlBk(rb);
        info.setComrclDrft(cd);
        KMsg kMsg = new KMsg();
        kMsg.setDocumentCommercialDraft(info);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AgainDiscountApplyBillInfo eactinfo = (AgainDiscountApplyBillInfo)billBaseInfo;
        return eactinfo.getDiscountInBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AgainDiscountApplyBillInfo eactinfo = (AgainDiscountApplyBillInfo)billBaseInfo;
        return eactinfo.getDrawerBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AgainDiscountApplyBillInfo eactinfo = (AgainDiscountApplyBillInfo)billBaseInfo;
        return eactinfo.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        AgainDiscountApplyBillInfo entityInfo = (AgainDiscountApplyBillInfo)billBaseInfo;
        CommercialDraftRediscountWithCentralBankRequest ct = (CommercialDraftRediscountWithCentralBankRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getRqstngBkOfRdscntWthCntrlBk().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getRqstngBkOfRdscntWthCntrlBk().getAcct().getAcctSvcr(), acctId = ct.getRqstngBkOfRdscntWthCntrlBk().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getRqstngBkOfRdscntWthCntrlBk().setRole(oinfo.getOrgUnitRoleType().getValue());
        entityInfo.setDrawerRole(oinfo.getOrgUnitRoleType());
    }
}

