/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.DraftBizTypeEnum;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.DraftRepurchasedRediscountWithCentralBankRequestInfo;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftRepurchasedRediscountWithCentralBankRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.RdscntWthCntrlBkSys;
import com.kingdee.eas.fm.ecore.app.bean.node.RpdRdscntWthCntrlBk;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendDraftRepurchasedRediscountWithCentralBankRequest
implements ISendHandler {
    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        CommercialDraftRepurchasedRediscountWithCentralBankRequest cr = (CommercialDraftRepurchasedRediscountWithCentralBankRequest)kmsg.getDocumentCommercialDraft();
        DraftRepurchasedRediscountWithCentralBankRequestInfo info = (DraftRepurchasedRediscountWithCentralBankRequestInfo)billBaseInfo;
        ElecDraftBillEntryInfo elecinfo = ECDSCommon.findElecDraftBillEntry(ctx, info.getDraftNumber(), cr.getRdscntWthCntrlBkSys().getCmonId(), DraftBizTypeEnum.ZAITIEXIAN, false);
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, elecinfo.getFormerOrgCode(), info.getDraftNumber());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, info.getDraftNumber(), info.getRdscntOrgCode(), info.getId().toString(), stateEnum, ElecDraftActionEnum.SEND, DraftMessageEnum.M016, null);
    }

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        KMsg kMsg = new KMsg();
        DraftRepurchasedRediscountWithCentralBankRequestInfo info = (DraftRepurchasedRediscountWithCentralBankRequestInfo)billBaseInfo;
        ComrclDrft comrclDrft = new ComrclDrft();
        comrclDrft.setIdNb(info.getDraftNumber());
        comrclDrft.setIsseAmt(info.getDraftAmount().toString());
        RpdRdscntWthCntrlBk rrdwb = new RpdRdscntWthCntrlBk();
        rrdwb.setDt(info.getDiscountDate().toString());
        rrdwb.setAmt(String.valueOf(info.getDiscountAmount().setScale(2, 4)));
        rrdwb.setIntrstRate(String.valueOf(info.getDiscountRate().setScale(6, 4)));
        rrdwb.setBanEndrsmtMk(info.getDiscountBanEndrsmtMk().getValue());
        rrdwb.setSttlmMk(info.getDiscountSttlmMk().getValue());
        rrdwb.setBtchNb(info.getDiscountBatch());
        if (FMHelper.isEmpty((String)info.getDiscountRmrkByPropsr())) {
            rrdwb.setRmrkByPropsr(info.getDiscountRmrkByPropsr());
        } else {
            rrdwb.setRmrkByPropsr(null);
        }
        RdscntWthCntrlBkSys rwbs = new RdscntWthCntrlBkSys();
        rwbs.setRole(info.getRdscntType().getValue());
        rwbs.setCmonId(info.getRdscntOrgCode().toString());
        rwbs.setElctrncSgntr(info.getRdscntElctrncSgntr());
        Acct acct = new Acct();
        acct.setId(info.getRdscntAccount());
        acct.setAcctSvcr(info.getRdscntBank());
        rwbs.setAcct(acct);
        Agcy agcy = new Agcy();
        Acct agcyAcct = new Acct();
        agcyAcct.setAcctSvcr(info.getRdscntAgcyBank());
        agcy.setAcct(agcyAcct);
        CommercialDraftRepurchasedRediscountWithCentralBankRequest cdwb = new CommercialDraftRepurchasedRediscountWithCentralBankRequest();
        cdwb.setComrclDrft(comrclDrft);
        cdwb.setRdscntWthCntrlBkSys(rwbs);
        cdwb.setRpdRdscntWthCntrlBk(rrdwb);
        kMsg.setDocumentCommercialDraft(cdwb);
        return kMsg;
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DraftRepurchasedRediscountWithCentralBankRequestInfo eactinfo = (DraftRepurchasedRediscountWithCentralBankRequestInfo)billBaseInfo;
        return eactinfo.getRdscntBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DraftRepurchasedRediscountWithCentralBankRequestInfo eactinfo = (DraftRepurchasedRediscountWithCentralBankRequestInfo)billBaseInfo;
        return eactinfo.getRdscntBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        DraftRepurchasedRediscountWithCentralBankRequestInfo eactinfo = (DraftRepurchasedRediscountWithCentralBankRequestInfo)billBaseInfo;
        return eactinfo.getDraftNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftRepurchasedRediscountWithCentralBankRequest ct = (CommercialDraftRepurchasedRediscountWithCentralBankRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getRdscntWthCntrlBkSys().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getRdscntWthCntrlBkSys().getAcct().getAcctSvcr(), acctId = ct.getRdscntWthCntrlBkSys().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getRdscntWthCntrlBkSys().setRole(oinfo.getOrgUnitRoleType().getValue());
    }
}

