/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.ecds.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.AcceptRequestBillInfo;
import com.kingdee.eas.fm.ecore.DraftMessageEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.ElecDraftBillInfo;
import com.kingdee.eas.fm.ecore.OperateServiceAgreementInfo;
import com.kingdee.eas.fm.ecore.app.bean.KMsg;
import com.kingdee.eas.fm.ecore.app.bean.commercialdraft.CommercialDraftAcceptanceRequest;
import com.kingdee.eas.fm.ecore.app.bean.node.Accptnc;
import com.kingdee.eas.fm.ecore.app.bean.node.Acct;
import com.kingdee.eas.fm.ecore.app.bean.node.Agcy;
import com.kingdee.eas.fm.ecore.app.bean.node.ComrclDrft;
import com.kingdee.eas.fm.ecore.app.bean.node.Drwr;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.ecore.app.ecds.ISendHandler;
import com.kingdee.eas.framework.BillBaseInfo;

public class SendHandlerAcceptanceRequest
implements ISendHandler {
    private ElecDraftBillInfo billInfo;

    @Override
    public KMsg sendBefore(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AcceptRequestBillInfo info = (AcceptRequestBillInfo)billBaseInfo;
        String idNb = info.getDrawerNumber();
        this.billInfo = ECDSCommon.findElecDraftBillInfoByIndb(ctx, idNb);
        ComrclDrft comrclDrft = new ComrclDrft();
        if (null != info.getDrawerNumber()) {
            comrclDrft.setIdNb(info.getDrawerNumber());
            comrclDrft.setIsseAmt(String.valueOf(info.getDraftAmount().setScale(2)));
        }
        Accptnc accptnc = new Accptnc();
        accptnc.setUcondlConsgnmtMrk("CC00");
        accptnc.setTxlCtrctNb(info.getContractNumber());
        accptnc.setInvcNb(info.getInvoiceNumber());
        accptnc.setBtchNb(info.getBtchNumber());
        if (!FMHelper.isEmpty((String)this.billInfo.getRemark())) {
            accptnc.setRmrkByPropsr(this.billInfo.getRemark());
        } else {
            accptnc.setRmrkByPropsr(null);
        }
        Drwr drwr = new Drwr();
        if (info.getDrawerRole() != null) {
            drwr.setRole(info.getDrawerRole().getValue());
        }
        drwr.setCmonId(info.getDrawerOrgCode());
        drwr.setElctrncSgntr(info.getDrawerElecSign());
        Acct acct = new Acct();
        acct.setId(info.getDrawerAccount());
        acct.setAcctSvcr(info.getDrawerBank());
        drwr.setAcct(acct);
        if (info.getDrawerCarryBank() != null) {
            Acct acct2 = new Acct();
            acct2.setAcctSvcr(info.getDrawerCarryBank());
            Agcy agcy = new Agcy();
            agcy.setAcct(acct2);
            drwr.setAgcy(agcy);
        }
        KMsg kMsg = new KMsg();
        CommercialDraftAcceptanceRequest commercialDraftAcceptanceRequest = new CommercialDraftAcceptanceRequest();
        commercialDraftAcceptanceRequest.setComrclDrft(comrclDrft);
        commercialDraftAcceptanceRequest.setAccptnc(accptnc);
        commercialDraftAcceptanceRequest.setDrwr(drwr);
        kMsg.setDocumentCommercialDraft(commercialDraftAcceptanceRequest);
        return kMsg;
    }

    @Override
    public void sendAfter(Context ctx, KMsg kmsg, String msgStr, BillBaseInfo billBaseInfo, String errorInfo) throws BOSException, EASBizException {
        AcceptRequestBillInfo info = (AcceptRequestBillInfo)billBaseInfo;
        String idNb = info.getDrawerNumber();
        ECDSBillStatusEnum stateEnum = ECDSCommon.findElecDraftBillState(ctx, info.getDrawerOrgCode(), this.billInfo.getDraftNumber());
        ECDSCommon.insertElecDraftActionBill(ctx, kmsg, this.billInfo.getDraftNumber(), info.getDrawerOrgCode(), info.getId().toString(), stateEnum, ElecDraftActionEnum.SEND, DraftMessageEnum.M002, null);
    }

    @Override
    public String getOppAccountBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AcceptRequestBillInfo actinfo = (AcceptRequestBillInfo)billBaseInfo;
        String idNb = actinfo.getDrawerNumber();
        return this.billInfo.getAcceptorBank();
    }

    @Override
    public String getSendBank(Context ctx, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AcceptRequestBillInfo actinfo = (AcceptRequestBillInfo)billBaseInfo;
        return actinfo.getDrawerBank();
    }

    @Override
    public String getDraftNum(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        AcceptRequestBillInfo actinfo = (AcceptRequestBillInfo)billBaseInfo;
        return actinfo.getDrawerNumber();
    }

    @Override
    public void checkAndFill(Context ctx, KMsg kmsg, BillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        String acctId;
        String actorBank;
        CommercialDraftAcceptanceRequest ct = (CommercialDraftAcceptanceRequest)kmsg.getDocumentCommercialDraft();
        String bizOrgNumber = ct.getDrwr().getCmonId();
        OperateServiceAgreementInfo oinfo = ECDSCommon.checkOperateServiceAgreement(ctx, bizOrgNumber, actorBank = ct.getDrwr().getAcct().getAcctSvcr(), acctId = ct.getDrwr().getAcct().getId());
        if (oinfo == null) {
            throw new BOSException(ECDSCommon.SEND_CHECK_ERROR);
        }
        ct.getDrwr().setRole(oinfo.getOrgUnitRoleType().getValue());
    }
}

