/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.app.security;

import com.cfca.toolkit.Castle;
import com.cfca.toolkit.CastleException;
import com.cfca.toolkit.CastleProperties;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import com.cfca.util.pki.pkcs.PKCS7SignedData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CnccCastle
extends Castle {
    private static final Logger log = LogManager.getLogger(CnccCastle.class);
    private static JCrypto jcrypto = JCrypto.getInstance();
    private static Session session = null;
    private static String mUserCertFilePath;
    private static String mUserCertPassword;
    private static X509Certificate mUserCert;
    private static PrivateKey mPrivateKey;
    private static boolean mUserCertReady;
    private static PKCS12 p12;
    private static CnccCastle cnccCastle;

    public static synchronized CnccCastle getInstance(CastleProperties arg0) {
        if (cnccCastle != null) {
            return cnccCastle;
        }
        return new CnccCastle(arg0);
    }

    private CnccCastle(CastleProperties arg0) {
        super(arg0);
        mUserCertFilePath = arg0.getmUserCertFilePath();
        mUserCertPassword = arg0.getmUserCertPassword();
        try {
            jcrypto.initialize("JSOFT_LIB", null);
            session = jcrypto.openSession("JSOFT_LIB");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void initCertAppContext() throws FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, CastleException {
        if (mUserCertFilePath != null && mUserCertPassword != null) {
            p12 = new PKCS12();
            CnccCastle.getPrivateKeyAndCertificate(mUserCertFilePath, mUserCertPassword);
            try {
                p12.load(mUserCertFilePath);
                p12.decrypt(mUserCertPassword.toCharArray());
            }
            catch (Exception ex) {
                throw new CastleException((Throwable)ex);
            }
        }
    }

    public static synchronized String SignDataDetached(byte[] srcMessage) throws Exception {
        try {
            byte[] signData = new byte[1672];
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            Mechanism mechanism1 = new Mechanism("SHA1");
            signData = p7.generateSignedData(false, PKCS7SignedData.DATA, srcMessage, mechanism1, p12.getPrivateKey(), p12.getCerts(), null);
            signData = p7.generateSignedDataContent(signData);
            byte[] b64 = Base64.encode((byte[])signData);
            signData = CnccCastle.convertSignResult(b64);
            return new String(signData);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public synchronized boolean VerifySignedDataDetached(String signature, byte[] srcMessage) {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        boolean verify = false;
        try {
            p7.loadBase64(CnccCastle.convert64SignResult(signature.getBytes()));
            verify = p7.verifyP7SignedData(srcMessage);
        }
        catch (Exception ex) {
            return false;
        }
        return verify;
    }

    private static synchronized byte[] convert64SignResult(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        byte[] base64Data = new String(bos.toByteArray()).trim().getBytes();
        return base64Data;
    }

    private static synchronized void getPrivateKeyAndCertificate(String mUserCertFilePath, String mUserCertPassword) throws FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, CastleException {
        FileInputStream keyStoreStream = null;
        KeyStore keyStore = null;
        try {
            File certFile = new File(mUserCertFilePath);
            String certFileName = certFile.getName();
            char[] password = mUserCertPassword.toCharArray();
            if (certFileName.toLowerCase().indexOf(".pfx") != -1 || certFileName.toLowerCase().indexOf(".keystore") != -1 || certFileName.toLowerCase().indexOf(".jks") != -1) {
                keyStoreStream = new FileInputStream(certFile);
                keyStore = certFileName.toLowerCase().indexOf(".pfx") != -1 ? KeyStore.getInstance("PKCS12", "BC") : KeyStore.getInstance("JKS");
                keyStore.load(keyStoreStream, password);
                Enumeration<String> aliasesEnum = keyStore.aliases();
                while (aliasesEnum.hasMoreElements()) {
                    String alias = aliasesEnum.nextElement();
                    if (mPrivateKey == null && keyStore.isKeyEntry(alias)) {
                        mPrivateKey = (PrivateKey)keyStore.getKey(alias, password);
                    }
                    if (mUserCert != null || !keyStore.isKeyEntry(alias)) continue;
                    mUserCert = (X509Certificate)keyStore.getCertificate(alias);
                }
            } else {
                throw new CastleException("\u53ea\u652f\u6301pfx\u6587\u4ef6\u6216keystore jks\u5b58\u50a8\u7528\u6237\u8bc1\u4e66");
            }
            keyStoreStream.close();
        }
        catch (KeyStoreException kse) {
            throw new CastleException((Throwable)kse);
        }
        catch (FileNotFoundException ffe) {
            throw ffe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException("not support this algorithm");
        }
        catch (UnrecoverableKeyException uke) {
            throw uke;
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match" + nspe.getMessage());
        }
        catch (CertificateException ce) {
            throw ce;
        }
        if (mPrivateKey == null || mUserCert == null) {
            throw new CastleException("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u53ca\u79c1\u94a5\u51fa\u9519");
        }
        mUserCertReady = true;
    }

    private static synchronized byte[] convertSignResult(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            bos.write(tmp);
        }
        byte[] base64Data = new String(bos.toByteArray()).trim().getBytes();
        bos = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < base64Data.length; ++i) {
                if (i != 0 && i % 64 == 0) {
                    bos.write("\r\n".getBytes());
                }
                bos.write(base64Data[i]);
            }
            bos.write("\r\n".getBytes());
        }
        catch (Exception ex) {
            return null;
        }
        return bos.toByteArray();
    }
}

