/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.AcceptRequestBillInfo;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.DraftBizTypeEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.UnconditionalPaymentEnum;
import com.kingdee.eas.fm.edraf.AcceptanceApplyBillFactory;
import com.kingdee.eas.fm.edraf.AcceptanceApplyBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.app.AbstractAcceptanceApplyBillControllerBean;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryCollection;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillFactory;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillInfo;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryCollection;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryFactory;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcceptanceApplyBillControllerBean
extends AbstractAcceptanceApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.AcceptanceApplyBillControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AcceptanceApplyBillInfo billInfo = (AcceptanceApplyBillInfo)model;
        ECDSCommunicationStatusEnum state = billInfo.getCommunicationStatus();
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.TSCDDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"0_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (!(state != null && (state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) || state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL) || state.equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) && billInfo.getReturnOpinion() == null))) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        return sic;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AcceptanceApplyBillInfo acceptBillInfo = (AcceptanceApplyBillInfo)model;
        AcceptRequestBillInfo acceptRequestInfo = new AcceptRequestBillInfo();
        CommercialDraftInfo draftInfo = acceptBillInfo.getCommercialDraft();
        acceptRequestInfo.setNumber(acceptBillInfo.getNumber());
        acceptRequestInfo.setCompany(acceptBillInfo.getCompany());
        acceptRequestInfo.setDrawerNumber(draftInfo.getDraftNumber());
        acceptRequestInfo.setDraftAmount(draftInfo.getDraftAmount());
        acceptRequestInfo.setUcondlConsgnmtMrk(acceptBillInfo.isIsAcceptor() ? UnconditionalPaymentEnum.CC00 : UnconditionalPaymentEnum.CC01);
        acceptRequestInfo.setContractNumber(FMHelper.isEmpty((String)acceptBillInfo.getContractNumber()) ? null : acceptBillInfo.getContractNumber());
        acceptRequestInfo.setInvoiceNumber(null);
        acceptRequestInfo.setBtchNumber(FMHelper.isEmpty((String)acceptBillInfo.getBatchNumber()) ? null : acceptBillInfo.getBatchNumber());
        acceptRequestInfo.setDescription(acceptBillInfo.getDescription());
        acceptRequestInfo.setDrawerRole(draftInfo.getDrawerRole());
        acceptRequestInfo.setDrawerElecSign("0");
        acceptRequestInfo.setDrawerOrgCode(draftInfo.getDrawerOrgCode());
        acceptRequestInfo.setDrawerAccount(draftInfo.getDrawerAccountNumber());
        acceptRequestInfo.setDrawerBank(draftInfo.getDrawerBankNumber());
        acceptRequestInfo.setRmrkByPropsr(acceptRequestInfo.getDescription());
        acceptRequestInfo.setBizPromoterOrgCode(draftInfo.getDrawerOrgCode());
        return acceptRequestInfo;
    }

    @Override
    public void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        AcceptanceApplyBillInfo acceptInfo;
        if (ecdsApplyBillStatus.equals((Object)ApplyBillStatusEnum.RECEIVE_031_OK) && !FMHelper.isEmpty((CoreBaseInfo)(acceptInfo = AcceptanceApplyBillFactory.getLocalInstance(ctx).getAcceptanceApplyBillInfo((IObjectPK)new ObjectStringPK(sourceBillId))))) {
            EntityViewInfo viewinfo = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("parent", (Object)acceptInfo.getCommercialDraft().getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("draftBizType", (Object)DraftBizTypeEnum.CHENGDUI));
            viewinfo.setFilter(fi);
            CommercialDraftBackSideEntryCollection commColl = CommercialDraftBackSideEntryFactory.getLocalInstance((Context)ctx).getCommercialDraftBackSideEntryCollection(viewinfo);
            DraftRegisterBillInfo draftRegInfo = DraftRegisterBillFactory.getLocalInstance((Context)ctx).getDraftRegisterBillInfo((IObjectPK)new ObjectStringPK(acceptInfo.getSourceBillId()));
            SelectorItemCollection sic = new SelectorItemCollection();
            draftRegInfo.setClewAccept(true);
            sic.add("clewAccept");
            if (commColl.size() != 0) {
                EntityViewInfo viewinfo_stock = new EntityViewInfo();
                FilterInfo fi_stock = new FilterInfo();
                fi_stock.getFilterItems().add(new FilterItemInfo("parent", (Object)commColl.get(0).getId().toString()));
                viewinfo_stock.setFilter(fi_stock);
                StockBillAccptEntryCollection stocColl = StockBillAccptEntryFactory.getLocalInstance((Context)ctx).getStockBillAccptEntryCollection(viewinfo_stock);
                StockBillAccptEntryInfo stockInfo = stocColl.get(0);
                sic.add("acceptorCdtBody");
                sic.add("acceptorCdtDate");
                sic.add("acceptorCreditRat");
                draftRegInfo.setAcceptorCdtBody(stockInfo.getAccptCdtRater());
                draftRegInfo.setAcceptorCdtDate(stockInfo.getAccptRtDueDate());
                draftRegInfo.setAcceptorCreditRat(stockInfo.getAccptCredieRate());
            }
            DraftRegisterBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)draftRegInfo, sic);
        }
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection acceptanceCol = AcceptanceApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (acceptanceCol == null || acceptanceCol.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return acceptanceCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.TSCDSQ;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AcceptanceApplyBillInfo acceptBillInfo = (AcceptanceApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = acceptBillInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        cancelBillInfo.setEletricSign("0");
        cancelBillInfo.setCancelOrgCode(draftInfo.getDrawerOrgCode());
        cancelBillInfo.setCancelAccount(draftInfo.getDrawerAccountNumber());
        cancelBillInfo.setCancelBank(draftInfo.getDrawerBankNumber());
        cancelBillInfo.setBizPromoterOrgCode(draftInfo.getDrawerOrgCode());
        return cancelBillInfo;
    }
}

