/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.PledgeReqBillInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.edraf.CollateralApplyBillFactory;
import com.kingdee.eas.fm.edraf.CollateralApplyBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.app.AbstractCollateralApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestFactory;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CollateralApplyBillControllerBean
extends AbstractCollateralApplyBillControllerBean {
    private static final long serialVersionUID = 1679773657719639709L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.CollateralApplyBillControllerBean");

    protected void initInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.initInfo(ctx, model);
    }

    protected void checkBeforeAddNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBeforeAddNew(ctx, model);
    }

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CollateralApplyBillInfo info = (CollateralApplyBillInfo)model;
        if (info.isIsCancelDraft() && info.getEndECDSState() != ECDSBillStatusEnum.ZYDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"4_CollateralApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getOperateState().getValue() != 0 && info.getCommunicationStatus().getValue() != 2 && info.getReturnOpinion() != null) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CollateralApplyBillInfo info = (CollateralApplyBillInfo)model;
        PledgeReqBillInfo ecdsInfo = new PledgeReqBillInfo();
        ecdsInfo.setDraftNumber(info.getCommercialDraft().getDraftNumber());
        ecdsInfo.setDraftAmount(info.getCommercialDraft().getDraftAmount());
        ecdsInfo.setIssueDate(info.getApplyDate());
        ecdsInfo.setBatchNum(info.getBatchNumber());
        ecdsInfo.setRemark(info.getRemark());
        ecdsInfo.setDrawerName(info.getPledgorName().getName());
        ecdsInfo.setDrawerOrgCode(info.getPledgorOrgCode());
        ecdsInfo.setDrawerAccount(info.getPledgorBank().getBankAccountNumber());
        ecdsInfo.setDrawerBank(info.getPledgorAcctSvcr().getNumber());
        ecdsInfo.setPledgeName(info.getPawneeName().getName());
        ecdsInfo.setPledgeAccount(info.getPawneeNumber());
        ecdsInfo.setPledgeBank(info.getPawneeAcctSvcr());
        ecdsInfo.setDrawerRole(RoleEnum.RC00);
        ecdsInfo.setBizPromoterOrgCode(info.getPledgorOrgCode());
        ecdsInfo.setBizSerialNumber(info.getBizCode());
        String eletricSign = "0";
        if (info.getApplyCompany() != null) {
            eletricSign = EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString());
        }
        ecdsInfo.setDrawerElecSign(eletricSign);
        return ecdsInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection registerCol = CollateralApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (registerCol == null || registerCol.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return registerCol;
    }

    public String getBosType() {
        return new CollateralApplyBillInfo().getBOSType().toString();
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZYSQ;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        CollateralApplyBillInfo endorInfo = this.getCollateralApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(sourceBillId));
        if (endorInfo != null && endorInfo.getSourceBillId() != null && endorInfo.isIsCancelDraft()) {
            DraftCollateralizationRequestInfo draftInfo = DraftCollateralizationRequestFactory.getLocalInstance((Context)ctx).getDraftCollateralizationRequestInfo((IObjectPK)new ObjectUuidPK(endorInfo.getSourceBillId()));
            if (ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_OK) {
                if (draftInfo != null && draftInfo.getSourceBillId() != null && draftInfo.isIsCancelDraft()) {
                    DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance((Context)ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(draftInfo.getSourceBillId()));
                    SelectorItemCollection selCollection = new SelectorItemCollection();
                    selCollection.add(new SelectorItemInfo("draftStockOperate"));
                    selCollection.add(new SelectorItemInfo("collateral"));
                    stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                    stockInfo.setCollateral(false);
                    DraftStockBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)stockInfo, selCollection);
                }
            } else if (ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_ERROR) {
                SelectorItemCollection selCollection = new SelectorItemCollection();
                selCollection.add(new SelectorItemInfo("operateState"));
                draftInfo.setOperateState(OperateStateEnum.SUBMITGATEWAY);
                DraftCollateralizationRequestFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)draftInfo, selCollection);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("pledgorName.name"));
        sic.add(new SelectorItemInfo("pawneeName.name"));
        sic.add(new SelectorItemInfo("pledgorBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("pledgorAcctSvcr.number"));
        return sic;
    }

    protected void _submitToEcds(Context ctx, Set set) throws BOSException, EASBizException {
        super._batchCommitECDS(ctx, set);
    }

    @Override
    public void _draftReturn(Context ctx, String billId, String opinion) throws BOSException, EASBizException {
        super._draftReturn(ctx, billId, opinion);
    }

    protected void _modifyResult(Context ctx, String id, ECDSCommunicationStatusEnum state) throws BOSException, EASBizException {
        CollateralApplyBillInfo billInfo = this.getCollateralApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.SUBMIT_UNCONFIRM)) {
            billInfo.setCommunicationStatus(state);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(id), (CoreBaseInfo)billInfo);
        }
    }

    @Override
    public void _commitECDS(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._commitECDS(ctx, model);
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CollateralApplyBillInfo info = (CollateralApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = info.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        String eletricSign = "0";
        if (info.getApplyCompany() != null) {
            eletricSign = EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString());
        }
        cancelBillInfo.setEletricSign(eletricSign);
        cancelBillInfo.setCancelOrgCode(info.getPledgorOrgCode());
        cancelBillInfo.setCancelAccount(info.getPledgorBank().getBankAccountNumber());
        cancelBillInfo.setCancelBank(info.getPledgorAcctSvcr().getNumber());
        cancelBillInfo.setBizPromoterOrgCode(info.getPledgorOrgCode());
        return cancelBillInfo;
    }
}

