/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.PaperDraftBillBaseInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SspdgPmtTypeEnum;
import com.kingdee.eas.fm.ecore.SuspendingPaymentRegisterBillInfo;
import com.kingdee.eas.fm.edraf.AbstractAcceptanceRegisterBillInfo;
import com.kingdee.eas.fm.edraf.AbstractPaperDraftBillBaseInfo;
import com.kingdee.eas.fm.edraf.AcceptanceRegisterBillFactory;
import com.kingdee.eas.fm.edraf.AcceptanceRegisterBillInfo;
import com.kingdee.eas.fm.edraf.CounterMandRegisterBillCollection;
import com.kingdee.eas.fm.edraf.CounterMandRegisterBillFactory;
import com.kingdee.eas.fm.edraf.CounterMandRegisterBillInfo;
import com.kingdee.eas.fm.edraf.CounterMandRemoveRegisterBillFactory;
import com.kingdee.eas.fm.edraf.CounterMandRemoveRegisterBillInfo;
import com.kingdee.eas.fm.edraf.CounterMandTypeEnum;
import com.kingdee.eas.fm.edraf.DraftTypeEnum;
import com.kingdee.eas.fm.edraf.DrawTypeEnum;
import com.kingdee.eas.fm.edraf.IAcceptanceRegisterBill;
import com.kingdee.eas.fm.edraf.ManipulateStateEnum;
import com.kingdee.eas.fm.edraf.MutualResultEnum;
import com.kingdee.eas.fm.edraf.app.AbstractCounterMandRegisterBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import org.apache.log4j.Logger;

public class CounterMandRegisterBillControllerBean
extends AbstractCounterMandRegisterBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.CounterMandRegisterBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CounterMandRegisterBillInfo billInfo = (CounterMandRegisterBillInfo)model;
        String sourceBillId = billInfo.getSourceBillId();
        AbstractPaperDraftBillBaseInfo acceptanceBillInfo = null;
        if (sourceBillId != null && !sourceBillId.equals("")) {
            acceptanceBillInfo = AcceptanceRegisterBillFactory.getLocalInstance(ctx).getAcceptanceRegisterBillInfo((IObjectPK)new ObjectStringPK(sourceBillId));
        }
        if (billInfo.getRegisterCompany() == null) {
            billInfo.setRegisterCompany(acceptanceBillInfo == null ? null : acceptanceBillInfo.getRegisterCompany());
        }
        return super._addnew(ctx, (IObjectValue)billInfo);
    }

    @Override
    public boolean checkDraftApplyBill(IObjectValue model) {
        CounterMandRegisterBillInfo billInfo = (CounterMandRegisterBillInfo)model;
        MutualResultEnum result = billInfo.getMutualResult();
        return result != null && (result.equals((Object)MutualResultEnum.ARRANGEDSUMBIT) || result.equals((Object)MutualResultEnum.SUMBITFAIL));
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add("*");
        return sic;
    }

    @Override
    public PaperDraftBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CounterMandRegisterBillInfo regInfo = (CounterMandRegisterBillInfo)model;
        SuspendingPaymentRegisterBillInfo billInfo = new SuspendingPaymentRegisterBillInfo();
        if (regInfo.getPaperType() != null) {
            billInfo.setDraftType(regInfo.getPaperType().equals((Object)DraftTypeEnum.DC01) ? com.kingdee.eas.fm.ecore.DraftTypeEnum.AC01 : com.kingdee.eas.fm.ecore.DraftTypeEnum.AC02);
        }
        billInfo.setDraftNumber(regInfo.getPaperNumber());
        billInfo.setDraftAmount(regInfo.getBillAmount());
        billInfo.setIssueDate(regInfo.getPaperOutData());
        billInfo.setDueDate(regInfo.getDraftData());
        billInfo.setRemark(regInfo.getRemark());
        if (regInfo.getCounterMandType() != null) {
            billInfo.setRefusalType(regInfo.getCounterMandType().equals((Object)CounterMandTypeEnum.COUNTERMAND) ? SspdgPmtTypeEnum.SP00 : SspdgPmtTypeEnum.SP01);
        }
        billInfo.setStopPaymentData(regInfo.getCounterMandDate());
        billInfo.setStopPayerName(regInfo.getApplyCounterMandName());
        billInfo.setStopAccepName(regInfo.getAcceptCounterMandName());
        billInfo.setAcceptorName(regInfo.getAccepter());
        billInfo.setAcceptorBank(regInfo.getAcceptLine());
        billInfo.setId(regInfo.getId());
        billInfo.setBizPromoterOrgCode(regInfo.getDrawerOrgCode());
        billInfo.setBizSerialNumber(regInfo.getBizCode());
        return billInfo;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZPGSZFJGSCGDJ;
    }

    @Override
    protected void _botpCounterMandRemove(Context ctx, IObjectCollection col) throws BOSException, EASBizException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        if (col != null && col instanceof CounterMandRegisterBillCollection) {
            CounterMandRegisterBillCollection counterMandCol = (CounterMandRegisterBillCollection)col;
            CounterMandRemoveRegisterBillInfo info = null;
            for (int i = 0; i < counterMandCol.size(); ++i) {
                info = new CounterMandRemoveRegisterBillInfo();
                CounterMandRegisterBillInfo sourceInfo = counterMandCol.get(i);
                info.setSourceBillId(sourceInfo.getId().toString());
                info.setPaperNumber(sourceInfo.getPaperNumber());
                info.setCounterMandType(sourceInfo.getCounterMandType());
                info.setPaperType(sourceInfo.getPaperType());
                info.setRemoveDate(new Date());
                info.setAccepter(sourceInfo.getAccepter());
                info.setAcceptLine(sourceInfo.getAcceptLine());
                info.setAcceptLineName(sourceInfo.getAcceptLineName());
                info.setApplyRemoveName(sourceInfo.getApplyCounterMandName());
                info.setAcceptRemoveName(sourceInfo.getAcceptCounterMandName());
                info.setCounterMand(sourceInfo);
                info.setPaperOutData(sourceInfo.getPaperOutData());
                info.setDraftData(sourceInfo.getDraftData());
                info.setAcceptData(sourceInfo.getAcceptData());
                info.setAcceptData(sourceInfo.getAcceptData());
                info.setManipulateState(ManipulateStateEnum.SAVE);
                info.setBillAmount(sourceInfo.getBillAmount());
                info.setCompany(sourceInfo.getCompany());
                info.setCreator(sourceInfo.getCreator());
                info.setMutualResult(MutualResultEnum.ARRANGEDSUMBIT);
                IObjectPK pk = CounterMandRemoveRegisterBillFactory.getLocalInstance(ctx).addnew(info);
                String stockPK = sourceInfo.getId().toString();
                sourceInfo.setRemoves(true);
                CounterMandRegisterBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)sourceInfo);
                String counterMandSourceID = sourceInfo.getSourceBillId();
                AbstractAcceptanceRegisterBillInfo counterMandSourceInfo = null;
                if (!StringUtils.isEmpty((String)counterMandSourceID) && AcceptanceRegisterBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectStringPK(counterMandSourceID))) {
                    counterMandSourceInfo = AcceptanceRegisterBillFactory.getLocalInstance(ctx).getAcceptanceRegisterBillInfo((IObjectPK)new ObjectStringPK(counterMandSourceID));
                }
                if (counterMandSourceInfo != null) {
                    counterMandSourceInfo.setDrawType(DrawTypeEnum.NOT);
                    AcceptanceRegisterBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)counterMandSourceInfo);
                }
                BOTRelationInfo relateInfo = new BOTRelationInfo();
                relateInfo.setSrcEntityID(BOSUuid.read((String)stockPK).getType().toString());
                relateInfo.setDestEntityID(BOSUuid.read((String)pk.toString()).getType().toString());
                relateInfo.setSrcObjectID(stockPK);
                relateInfo.setDestObjectID(pk.toString());
                relateInfo.setDate(new Date());
                relateInfo.setOperatorID("unknown");
                relateInfo.setIsEffected(true);
                relateInfo.setType(0);
                iBOTRelation.addnew(relateInfo);
            }
        }
    }

    @Override
    public void delPaperDraftBillBase(Context ctx, String sourceIDList, String destobjecIDs, String copyBillIDs) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer copySql = new StringBuffer();
        StringBuffer destSql = new StringBuffer();
        sql.append("update ").append("T_EDR_AcceptanceRegisterBill").append(" set FDrawType = 0 where fid in ").append(sourceIDList.toString()).append("");
        copySql.append("update ").append("T_EDR_CounterMandRegisterBill").append(" set FManipulateState = '02' where fid in").append(copyBillIDs.toString()).append("");
        destSql.append("delete ").append("T_EDR_CounterMandRegisterBill").append(" where fid in ").append(destobjecIDs.toString()).append("");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        DbUtil.execute((Context)ctx, (String)copySql.toString());
        DbUtil.execute((Context)ctx, (String)destSql.toString());
    }

    @Override
    public void setSourceBill(Context ctx, String sourceBillId, String opinion) throws BOSException, EASBizException {
        IAcceptanceRegisterBill iAcceptanceRegisterBill = AcceptanceRegisterBillFactory.getLocalInstance(ctx);
        AcceptanceRegisterBillInfo billInfo = iAcceptanceRegisterBill.getAcceptanceRegisterBillInfo((IObjectPK)new ObjectStringPK(sourceBillId));
        billInfo.setDrawType(DrawTypeEnum.NOT);
        String returnOpinion = billInfo.getReturnOption();
        returnOpinion = !StringUtils.isEmpty((String)returnOpinion) && !returnOpinion.equals("") ? returnOpinion + opinion : opinion;
        String str = returnOpinion;
        if (returnOpinion.length() > 256) {
            str = returnOpinion.substring(0, 255);
        }
        billInfo.setReturnOption(str);
        iAcceptanceRegisterBill.save((CoreBaseInfo)billInfo);
    }

    @Override
    public void rewriteApplyBill(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
    }
}

