/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.RepurchaseDiscountRedeemReqInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.edraf.DiscountRpdApplyBillCollection;
import com.kingdee.eas.fm.edraf.DiscountRpdApplyBillFactory;
import com.kingdee.eas.fm.edraf.DiscountRpdApplyBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.IDiscountRpdApplyBill;
import com.kingdee.eas.fm.edraf.app.AbstractDiscountRpdApplyBillControllerBean;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftKindEnum;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class DiscountRpdApplyBillControllerBean
extends AbstractDiscountRpdApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.DiscountRpdApplyBillControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DiscountRpdApplyBillInfo billInfo = (DiscountRpdApplyBillInfo)model;
        if (billInfo.getOperateState().equals((Object)FCOperateStateEnum.save)) {
            billInfo.setOperateState(FCOperateStateEnum.SUBMIT1);
        }
        return super._submit(ctx, (IObjectValue)billInfo);
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        env.setFilter(filter);
        DiscountRpdApplyBillCollection billCol = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDiscountRpdApplyBillCollection(env);
        if (billCol != null && billCol.size() > 0) {
            DiscountRpdApplyBillInfo billInfo = null;
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                billInfo = billCol.get(i);
                billInfo.setOperateState(FCOperateStateEnum.SUBMIT1);
                this.submit(ctx, (CoreBaseInfo)billInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"19_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.SUBMIT1, CompareType.EQUALS));
        env.setFilter(filter);
        DiscountRpdApplyBillCollection billCol = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDiscountRpdApplyBillCollection(env);
        if (billCol != null && billCol.size() > 0) {
            DiscountRpdApplyBillInfo billInfo = null;
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                billInfo = billCol.get(i);
                this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"20_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        Object[] idArray;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.AUDITED, CompareType.EQUALS));
        env.setFilter(filter);
        DiscountRpdApplyBillCollection billCol = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDiscountRpdApplyBillCollection(env);
        if (billCol != null && billCol.size() > 0) {
            idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
                this.unAudit4WF(ctx, billCol.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"21_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        String sql = "update T_EDR_DiscountRpdApplyBill set FOperateState=?,FAuditDate=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), null});
    }

    @Override
    protected void _draftCancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        IDiscountRpdApplyBill iDiscount = DiscountRpdApplyBillFactory.getLocalInstance(ctx);
        DiscountRpdApplyBillInfo billInfo = iDiscount.getDiscountRpdApplyBillInfo(pk, sic);
        if (billInfo != null && billInfo.getCommercialDraft() != null) {
            ECDSBillStatusEnum state = billInfo.getEndECDSState();
            if (state != null && state.equals((Object)ECDSBillStatusEnum.HGSTXSHDQS) && !billInfo.isIsCancelDraft() && !billInfo.getOperateState().equals((Object)FCOperateStateEnum.CANCEL)) {
                billInfo.setOperateState(FCOperateStateEnum.CANCEL);
                iDiscount.update(pk, (CoreBaseInfo)billInfo);
                billInfo.setOperateState(FCOperateStateEnum.save);
                billInfo.setDraftSourceBill(billInfo.getId().toString());
                billInfo.setId(null);
                billInfo.setBizCode(null);
                billInfo.setSubmitCompany(null);
                billInfo.setSubmitDate(null);
                billInfo.setSubmitter(null);
                billInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
                billInfo.setNumber(null);
                billInfo.setIsCancelDraft(true);
                IObjectPK dispk = iDiscount.addnew((CoreBaseInfo)billInfo);
                EdrafentUtil.saveBotpRelation((Context)ctx, (String)billInfo.getSourceBillId(), (String)dispk.toString());
            } else {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"22_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
            }
        }
    }

    @Override
    protected void _loginAccount(Context ctx, Set set) throws BOSException, EASBizException {
        CoreBaseCollection col;
        HashSet<BOSUuid> idSet;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isLogin", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endECDSState", (Object)ECDSBillStatusEnum.HGSTXSHYQS, CompareType.EQUALS));
        env.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("InAccountNumber.*"));
        env.setSelector(sic);
        DiscountRpdApplyBillCollection billCol = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDiscountRpdApplyBillCollection(env);
        if (billCol != null && billCol.size() > 0) {
            idSet = new HashSet<BOSUuid>();
            col = new CoreBaseCollection();
            DiscountRpdApplyBillInfo info = null;
            CommercialDraftInfo comInfo = null;
            JournalInfo journalInfo = null;
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                Date date;
                Date now;
                info = billCol.get(i);
                comInfo = info.getCommercialDraft();
                idSet.add(info.getId());
                journalInfo = new JournalInfo();
                PeriodInfo peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
                Date bizDate = now = new Date();
                if (peroid != null && (date = peroid.getBeginDate()).compareTo(now) > 0) {
                    bizDate = date;
                }
                journalInfo.setCompany(info.getCompany());
                journalInfo.setBizDate(bizDate);
                journalInfo.setBillNumber(info.getNumber());
                journalInfo.setBillId(info.getId().toString());
                journalInfo.setDebitAmount(info.getDisRpdPayMoney());
                journalInfo.setCreateDate(bizDate);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(info.getInAccountNumber());
                journalInfo.setAccountView(info.getInAccountNumber().getAccount());
                journalInfo.setCurrency(info.getInAccountNumber().getCurrency());
                journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
                journalInfo.setSource(JournalSourceEnum.BYBILL);
                journalInfo.setPeriod(peroid);
                journalInfo.setDescription(info.getOldDisInRamark());
                col.add((CoreBaseInfo)journalInfo);
            }
            if (col.size() <= 0 || idSet.size() <= 0) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"23_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"23_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        JournalFactory.getLocalInstance((Context)ctx).addnew(col);
        String sql = "update T_EDR_DiscountRpdApplyBill set FIsLogin=? where " + FMHelper.buildIn((String)"FID", (Object[])idSet.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(true)});
    }

    @Override
    protected void _unLoginAccount(Context ctx, Set set) throws BOSException, EASBizException {
        HashSet<BOSUuid> idSet;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isLogin", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        DiscountRpdApplyBillCollection coll = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDiscountRpdApplyBillCollection(view);
        if (coll != null && coll.size() > 0) {
            idSet = new HashSet<BOSUuid>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                idSet.add(coll.get(i).getId());
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"24_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", idSet, CompareType.INCLUDE));
        JournalFactory.getLocalInstance((Context)ctx).delete(filter);
        String sql = "update T_EDR_DiscountRpdApplyBill set FIsLogin=? where " + FMHelper.buildIn((String)"FID", (Object[])idSet.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(false)});
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DiscountRpdApplyBillInfo info = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDiscountRpdApplyBillInfo(pk);
        if (info.getOperateState().equals((Object)FCOperateStateEnum.save) || info.getOperateState().equals((Object)FCOperateStateEnum.SUBMIT1)) {
            String billId = info.getSourceBillId();
            if (billId != null && !info.isIsLogin()) {
                if (!info.isIsCancelDraft()) {
                    String sql = "update T_EDT_DraftStockBill set FDraftStockOperate=0 where FID='" + billId + "'";
                    DbUtil.execute((Context)ctx, (String)sql);
                } else {
                    String sourceId = info.getDraftSourceBill();
                    if (sourceId != null) {
                        String oql = "UPDATE T_EDR_DiscountRpdApplyBill SET FOperateState=? WHERE FID='" + sourceId + "'";
                        DbUtil.execute((Context)ctx, (String)oql, (Object[])new Object[]{new Integer(1)});
                    }
                }
            }
            super._delete(ctx, pk);
        }
    }

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DiscountRpdApplyBillInfo billInfo = (DiscountRpdApplyBillInfo)model;
        if (billInfo.getDraftKind().equals((Object)DraftKindEnum.ELECDRAFT)) {
            if (!billInfo.getOperateState().equals((Object)FCOperateStateEnum.AUDITED) && !billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL)) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"25_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"26_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.HGSTXSHDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"27_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (!billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) && !billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"28_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("oldDisOutUser.*"));
        sic.add(new SelectorItemInfo("oldDisOutAccount.*"));
        sic.add(new SelectorItemInfo("InAccountNumber.*"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("InAccountBankNumber.*"));
        sic.add(new SelectorItemInfo("applyCompany.name"));
        sic.add(new SelectorItemInfo("applyCompany.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        return sic;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DiscountRpdApplyBillInfo billInfo = (DiscountRpdApplyBillInfo)model;
        CommercialDraftInfo comInfo = billInfo.getCommercialDraft();
        RepurchaseDiscountRedeemReqInfo bizInfo = new RepurchaseDiscountRedeemReqInfo();
        bizInfo.setDraftNumber(comInfo.getDraftNumber());
        bizInfo.setDraftAmount(comInfo.getDraftAmount());
        bizInfo.setReqDate(billInfo.getApplyDate());
        bizInfo.setRedeemInterRate(billInfo.getDisRpdRate().multiply(new BigDecimal("0.01")).setScale(6, 0));
        bizInfo.setRedeemPaidAmt(billInfo.getDisRpdPayMoney());
        bizInfo.setSettlementMark(billInfo.isIsLine() ? SettlementMarkEnum.SM00 : SettlementMarkEnum.SM01);
        bizInfo.setBatch(billInfo.getBatchNumber());
        bizInfo.setRemark(billInfo.getOldDisInRamark());
        bizInfo.setDrawerOrgCode(billInfo.getOrgUnitCode());
        bizInfo.setBizPromoterOrgCode(billInfo.getOrgUnitCode());
        bizInfo.setDrawerAccount(billInfo.getOldDisOutAccount().getBankAccountNumber());
        bizInfo.setDrawerBank(billInfo.getOldDisOutBankNum());
        bizInfo.setBizPromoterOrgCode(billInfo.getOrgUnitCode());
        bizInfo.setBizSerialNumber(billInfo.getBizCode());
        bizInfo.setBanEndorsement(billInfo.isIsAttorn() ? BanEndorsementMarkEnum.EM00 : BanEndorsementMarkEnum.EM01);
        bizInfo.setDrawerElecSign("0");
        return bizInfo;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DiscountRpdApplyBillInfo billInfo = (DiscountRpdApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        cancelBillInfo.setDraftNumber(billInfo.getCommercialDraft().getDraftNumber());
        cancelBillInfo.setDraftAmount(billInfo.getCommercialDraft().getDraftAmount());
        cancelBillInfo.setCancelAccount(billInfo.getOldDisOutAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(billInfo.getOldDisOutBankNum());
        cancelBillInfo.setCancelOrgCode(billInfo.getOrgUnitCode());
        cancelBillInfo.setBizPromoterOrgCode(billInfo.getOrgUnitCode());
        cancelBillInfo.setBizSerialNumber(billInfo.getBizCode());
        cancelBillInfo.setEletricSign("0");
        return cancelBillInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection registerCol = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (registerCol == null || registerCol.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"29_DiscountRpdApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        return registerCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.HGSTXSHSQ;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        String stockId;
        DiscountRpdApplyBillInfo billInfo = DiscountRpdApplyBillFactory.getLocalInstance(ctx).getDiscountRpdApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        if (billInfo.isIsCancelDraft()) {
            String stockId2;
            String billId;
            String sql = null;
            int opstate = 0;
            if (billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) && (billId = billInfo.getDraftSourceBill()) != null) {
                sql = "update T_EDR_DiscountRpdApplyBill set FOperateState=? where FID='" + billId + "'";
                opstate = 1;
            }
            if (billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_SUCCESS) && (stockId2 = billInfo.getSourceBillId()) != null) {
                sql = "UPDATE T_EDT_DraftStockBill SET FDraftStockOperate=? where FID='" + stockId2 + "'";
                opstate = 0;
            }
            if (sql != null) {
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(opstate)});
            }
        }
        if ((ecdsApplyBillStatus.equals((Object)ApplyBillStatusEnum.RECEIVE_033_ERROR) || ecdsApplyBillStatus.equals((Object)ApplyBillStatusEnum.RECEIVE_031_BAN)) && (stockId = billInfo.getSourceBillId()) != null) {
            String sql = "UPDATE T_EDT_DraftStockBill SET FDraftStockOperate=? where FID='" + stockId + "'";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0)});
            billInfo.setEndECDSState(billInfo.getStartECDSState());
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("endECDSState"));
            DiscountRpdApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
        }
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DiscountRpdApplyBillInfo baseInfo = (DiscountRpdApplyBillInfo)model;
        baseInfo.setAuditDate(new Timestamp(new Date().getTime()));
        baseInfo.setOperateState(FCOperateStateEnum.AUDITED);
        baseInfo.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("auditor"));
        DiscountRpdApplyBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)baseInfo, sic);
    }

    @Override
    protected void _unAudit4WF(Context ctx, IObjectValue model) throws BOSException {
    }
}

