/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECoreQueryServiceFacadeFactory;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.app.util.EcdsSerNumber;
import com.kingdee.eas.fm.edraf.AcceptanceApplyBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafSysNotificationFacadeFactory;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.IDraftApplyBillBase;
import com.kingdee.eas.fm.edraf.ImpawnRemoveRequestInfo;
import com.kingdee.eas.fm.edraf.IssuanceApplyBillInfo;
import com.kingdee.eas.fm.edraf.RegisterApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractDraftApplyBillBaseControllerBean;
import com.kingdee.eas.fm.edraf.app.util.BussinessHandleCallBack;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftDestructionRequestBillInfo;
import com.kingdee.eas.fm.edrafent.DraftLienInfoBillInfo;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillInfo;
import com.kingdee.eas.fm.edrafent.IDrafentApplyBillBase;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class DraftApplyBillBaseControllerBean
extends AbstractDraftApplyBillBaseControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.DraftApplyBillBaseControllerBean");
    private static Date sysDate = null;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo;
        DraftApplyBillBaseInfo billInfo = (DraftApplyBillBaseInfo)model;
        if (billInfo.getBizCode() == null) {
            billInfo.setBizCode(EdrafSysNotificationFacadeFactory.getLocalInstance(ctx).generateBizCode(this.getRequestType(), billInfo.getBOSType().toString()));
        }
        if ((companyInfo = EdrafUtil.getFinCompany(ctx)) != null && billInfo.getCompany() == null) {
            billInfo.setCompany(companyInfo);
            if (!FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)billInfo, (String)companyInfo.getId().toString())) {
                billInfo.setNumber(String.valueOf(EcdsSerNumber.getPK()));
            }
        }
        return super._addnew(ctx, model);
    }

    public abstract RequestTypeEnum getRequestType();

    public abstract ApplyBillBaseInfo convertToECDSApplyBill(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    public abstract ApplyBillBaseInfo convertToECDSCancelBill(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    public abstract void checkDraftApplyBill(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    public abstract DraftApplyBillBaseCollection getBillCollection(Context var1, Set var2, SelectorItemCollection var3) throws BOSException, EASBizException;

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("commercialDraft.*");
        return sic;
    }

    @Override
    protected Map _batchCommitECDS(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        DraftApplyBillBaseCollection billCol = this.getBillCollection(ctx, idSet, this.getSelector());
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<String> correctList = new ArrayList<String>();
        if (billCol != null && billCol.size() > 0) {
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                DraftApplyBillBaseInfo billInfo = billCol.get(i);
                try {
                    IDraftApplyBillBase iDraftApplyBillBase = (IDraftApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(billInfo.getBOSType());
                    try {
                        iDraftApplyBillBase.commitECDS4WF(billInfo);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"30_DraftApplyBillBaseControllerBean", (Locale)ctx.getLocale())});
                    }
                    iDraftApplyBillBase.commitECDS(billInfo);
                    if (billInfo.getCommercialDraft().getDraftNumber() == null) {
                        correctList.add(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"31_DraftApplyBillBaseControllerBean", (Locale)ctx.getLocale()) + billInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"32_DraftApplyBillBaseControllerBean", (Locale)ctx.getLocale()));
                        continue;
                    }
                    correctList.add(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"15_DiscountReqApplyBillControllerBean", (Locale)ctx.getLocale()) + billInfo.getCommercialDraft().getDraftNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"16_DiscountReqApplyBillControllerBean", (Locale)ctx.getLocale()));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    if (billInfo.getCommercialDraft().getDraftNumber() == null) {
                        errorList.add(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"31_DraftApplyBillBaseControllerBean", (Locale)ctx.getLocale()) + billInfo.getNumber() + "_" + e.getMessage());
                        continue;
                    }
                    errorList.add(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"15_DiscountReqApplyBillControllerBean", (Locale)ctx.getLocale()) + billInfo.getCommercialDraft().getDraftNumber() + "_" + e.getMessage());
                }
            }
        }
        if (correctList.size() > 0) {
            StringBuffer correctMessage = new StringBuffer();
            for (int i = 0; i < correctList.size(); ++i) {
                correctMessage.append(correctList.get(i) + ";\n");
            }
            map.put("correctNum", correctList.size() + "");
            map.put("correctMessage", correctMessage.toString());
        }
        if (errorList.size() > 0) {
            String expMsg = null;
            String[] errorDetail = null;
            StringBuffer errorMessage = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                expMsg = errorList.get(i).toString();
                if (expMsg.indexOf("_") <= 0) continue;
                errorDetail = errorList.get(i).toString().split("_");
                errorMessage.append(errorDetail[0]).append(ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"18_DiscountReqApplyBillControllerBean", (Locale)ctx.getLocale())).append(errorDetail[1]).append("\n");
            }
            map.put("errorNum", errorList.size() + "");
            map.put("errorMessage", errorMessage.toString());
        }
        return map;
    }

    @Override
    protected void _commitECDS(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDraftApplyBill(ctx, model);
        DraftApplyBillBaseInfo billInfo = (DraftApplyBillBaseInfo)model;
        this.updateBillOperateState(ctx, billInfo);
        String bizCode = billInfo.getBizCode();
        Map sendResultMap = null;
        if (!billInfo.isIsCancelDraft() || billInfo instanceof RegisterApplyBillInfo) {
            RequestTypeEnum requestTypeEnum = this.getRequestType();
            if (billInfo instanceof RegisterApplyBillInfo) {
                RegisterApplyBillInfo registerInfo = (RegisterApplyBillInfo)billInfo;
                if (registerInfo.getCommercialDraft() != null && registerInfo.getCommercialDraft().getId() != null) {
                    CommercialDraftInfo commInfo = registerInfo.getCommercialDraft();
                    if (sysDate == null) {
                        sysDate = ECoreQueryServiceFacadeFactory.getLocalInstance((Context)ctx).getSystemDate();
                    }
                    commInfo.setIssueDate(sysDate);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("issueDate");
                    CommercialDraftFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)commInfo, sic);
                }
                if (registerInfo.isIsCancelDraft()) {
                    requestTypeEnum = RequestTypeEnum.CPSQ;
                }
            }
            ApplyBillBaseInfo applyBillInfo = this.convertToECDSApplyBill(ctx, (IObjectValue)billInfo);
            String senderOrgNumber = applyBillInfo.getBizPromoterOrgCode();
            sendResultMap = BussinessHandleCallBack.sendEDCS(ctx, bizCode, senderOrgNumber, (IObjectValue)applyBillInfo, billInfo.getCommercialDraft().getDraftNumber(), requestTypeEnum);
        } else {
            ApplyBillBaseInfo applyBillInfo = this.convertToECDSCancelBill(ctx, (IObjectValue)billInfo);
            String senderOrgNumber = applyBillInfo.getBizPromoterOrgCode();
            String oriApplyBillId = billInfo.getDraftSourceBill();
            IDraftApplyBillBase draftApplyBillBase = (IDraftApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(BOSUuid.read((String)oriApplyBillId).getType());
            DraftApplyBillBaseInfo oriApplyBill = draftApplyBillBase.getDraftApplyBillBaseInfo((IObjectPK)new ObjectStringPK(oriApplyBillId));
            sendResultMap = BussinessHandleCallBack.sendEDCSCancel(ctx, bizCode, senderOrgNumber, (IObjectValue)applyBillInfo, billInfo.getCommercialDraft().getDraftNumber(), this.getRequestType(), oriApplyBill.getBizCode());
        }
        if (sendResultMap.get("result") != null && sendResultMap.get("result").toString().equals("0")) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{sendResultMap.get("eCause")});
        }
    }

    protected void updateBillOperateState(Context ctx, DraftApplyBillBaseInfo billInfo) throws EASBizException, BOSException {
        String bizCode;
        billInfo.setOperateState(FCOperateStateEnum.submit);
        billInfo.setSubmitDate(DateHelper.getTime());
        billInfo.setSubmitCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        billInfo.setSubmitter(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        billInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_SUCCESS);
        SelectorItemCollection sic = new SelectorItemCollection();
        if (!(billInfo instanceof RegisterApplyBillInfo)) {
            sysDate = ECoreQueryServiceFacadeFactory.getLocalInstance((Context)ctx).getSystemDate();
            billInfo.setApplyDate(sysDate);
            sic.add("applyDate");
        }
        if ((bizCode = billInfo.getBizCode()) == null) {
            bizCode = EdrafSysNotificationFacadeFactory.getLocalInstance(ctx).generateBizCode(this.getRequestType(), billInfo.getBOSType().toString());
            billInfo.setBizCode(bizCode);
            sic.add("bizCode");
        }
        sic.add("operateState");
        sic.add("submitDate");
        sic.add("submitCompany");
        sic.add("communicationStatus");
        sic.add("submitter");
        super.updatePartial(ctx, (CoreBaseInfo)billInfo, sic);
        if (!billInfo.isIsCancelDraft() || billInfo instanceof RegisterApplyBillInfo) {
            String id = billInfo.getSourceBillId();
            IDrafentApplyBillBase iDrafentApplyBillBase = (IDrafentApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(id);
            if (!(billInfo instanceof AcceptanceApplyBillInfo) && !(billInfo instanceof IssuanceApplyBillInfo)) {
                DrafentApplyBillBaseInfo sourceBillInfo = iDrafentApplyBillBase.getDrafentApplyBillBaseInfo((IObjectPK)new ObjectStringPK(id));
                sourceBillInfo.setFinanceOperateState(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.submit);
                SelectorItemCollection sicv = new SelectorItemCollection();
                sicv.add("FinanceOperateState");
                iDrafentApplyBillBase.updatePartial((CoreBaseInfo)sourceBillInfo, sicv);
            }
        }
    }

    @Override
    protected void _draftReturn(Context ctx, String billId, String opinion) throws BOSException, EASBizException {
        IDraftApplyBillBase iDraftApplyBillBase = (IDraftApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(BOSUuid.read((String)billId).getType());
        DraftApplyBillBaseInfo applyBillInfo = iDraftApplyBillBase.getDraftApplyBillBaseInfo((IObjectPK)new ObjectStringPK(billId));
        SelectorItemCollection sic = new SelectorItemCollection();
        String sourceBillId = applyBillInfo.getSourceBillId();
        if (FMHelper.isEmpty((String)sourceBillId)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"2_AcceptanceRegisterBillControllerBean", (Locale)ctx.getLocale())});
        }
        IDrafentApplyBillBase iDrafentApplyBillBase = (IDrafentApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(sourceBillId);
        DrafentApplyBillBaseInfo sourceBillInfo = iDrafentApplyBillBase.getDrafentApplyBillBaseInfo((IObjectPK)new ObjectStringPK(sourceBillId));
        if (!applyBillInfo.isIsCancelDraft() && sourceBillInfo.getOperateState() == OperateStateEnum.CANCEL) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"33_DraftApplyBillBaseControllerBean", (Locale)ctx.getLocale())});
        }
        if (applyBillInfo.getCommunicationStatus() == ECDSCommunicationStatusEnum.SUBMIT_READY) {
            if (applyBillInfo.isFiVouchered()) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"34_DraftApplyBillBaseControllerBean", (Locale)ctx.getLocale())});
            }
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            iBOTRelation.removeRelationBySrcObjId(sourceBillId, applyBillInfo.getBOSType().toString());
            iDraftApplyBillBase.delete((IObjectPK)new ObjectUuidPK(billId));
        } else if (applyBillInfo.getCommunicationStatus().getValue() == 2 || applyBillInfo.getCommunicationStatus().getValue() == 5) {
            applyBillInfo.setReturnOpinion(opinion);
            sic.add(new SelectorItemInfo("returnOpinion"));
            iDraftApplyBillBase.updatePartial((CoreBaseInfo)applyBillInfo, sic);
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            iBOTRelation.removeRelationBySrcObjId(sourceBillId, applyBillInfo.getBOSType().toString());
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"35_DraftApplyBillBaseControllerBean", (Locale)ctx.getLocale())});
        }
        sic = new SelectorItemCollection();
        sourceBillInfo.setReturnOpinion(opinion);
        sic.add(new SelectorItemInfo("returnOpinion"));
        if (sourceBillInfo instanceof DraftRegisterBillInfo && applyBillInfo instanceof IssuanceApplyBillInfo) {
            if (applyBillInfo.isIsCancelDraft()) {
                ((DraftRegisterBillInfo)sourceBillInfo).setClewDrawer(true);
            } else {
                ((DraftRegisterBillInfo)sourceBillInfo).setClewDrawer(false);
            }
            sic.add(new SelectorItemInfo("clewDrawer"));
        }
        if (sourceBillInfo instanceof DraftRegisterBillInfo && applyBillInfo instanceof AcceptanceApplyBillInfo) {
            if (applyBillInfo.isIsCancelDraft()) {
                ((DraftRegisterBillInfo)sourceBillInfo).setClewAccept(true);
            } else {
                ((DraftRegisterBillInfo)sourceBillInfo).setClewAccept(false);
            }
            sic.add(new SelectorItemInfo("clewAccept"));
        }
        sic.add(new SelectorItemInfo("operateState"));
        if (sourceBillInfo.isIsCancelDraft()) {
            if (sourceBillInfo instanceof DraftLienInfoBillInfo && applyBillInfo instanceof ImpawnRemoveRequestInfo) {
                sourceBillInfo.setOperateState(OperateStateEnum.CANCEL1);
                sourceBillInfo.setIsCancelDraft(false);
                sic.add(new SelectorItemInfo("isCancelDraft"));
            } else if (sourceBillInfo instanceof DraftDestructionRequestBillInfo) {
                sourceBillInfo.setOperateState(OperateStateEnum.SAVE);
                sourceBillInfo.setFinanceOperateState(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.init_Value);
                sourceBillInfo.setSubmitCompany(null);
                sourceBillInfo.setSubmitter(null);
                sourceBillInfo.setSubmitDate(null);
                sourceBillInfo.setAuditDate(null);
                sic.add(new SelectorItemInfo("financeOperateState"));
                sic.add(new SelectorItemInfo("submitCompany"));
                sic.add(new SelectorItemInfo("submitter"));
                sic.add(new SelectorItemInfo("submitDate"));
                sic.add(new SelectorItemInfo("auditDate"));
            } else if (!(applyBillInfo instanceof IssuanceApplyBillInfo) && !(applyBillInfo instanceof AcceptanceApplyBillInfo)) {
                sourceBillInfo.setIsCancelDraft(false);
                sourceBillInfo.setOperateState(OperateStateEnum.SUBMITGATEWAY);
                sic.add(new SelectorItemInfo("isCancelDraft"));
            }
        } else if (sourceBillInfo instanceof DraftLienInfoBillInfo && applyBillInfo instanceof ImpawnRemoveRequestInfo) {
            sourceBillInfo.setOperateState(OperateStateEnum.SUBMIT);
        } else if (!(applyBillInfo instanceof AcceptanceApplyBillInfo) && !(applyBillInfo instanceof IssuanceApplyBillInfo)) {
            sourceBillInfo.setFinanceOperateState(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.init_Value);
            sourceBillInfo.setOperateState(OperateStateEnum.SAVE);
            sourceBillInfo.setSubmitCompany(null);
            sourceBillInfo.setSubmitter(null);
            sourceBillInfo.setSubmitDate(null);
            sourceBillInfo.setAuditDate(null);
            sic.add(new SelectorItemInfo("financeOperateState"));
            sic.add(new SelectorItemInfo("submitCompany"));
            sic.add(new SelectorItemInfo("submitter"));
            sic.add(new SelectorItemInfo("submitDate"));
            sic.add(new SelectorItemInfo("auditDate"));
        }
        iDrafentApplyBillBase.updatePartial((CoreBaseInfo)sourceBillInfo, sic);
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
    }

    @Override
    protected void _modifyResult(Context ctx, IObjectValue model, ECDSCommunicationStatusEnum statu) throws BOSException, EASBizException {
        DraftApplyBillBaseInfo info = (DraftApplyBillBaseInfo)model;
        info.setCommunicationStatus(statu);
        IDraftApplyBillBase iDrafentApplyBillBase = (IDraftApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(info.getId().toString());
        info.setCommunicationStatus(statu);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("communicationStatus"));
        iDrafentApplyBillBase.updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected void _audit4WF(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DraftApplyBillBaseInfo baseInfo = (DraftApplyBillBaseInfo)model;
        baseInfo.setOperateState(FCOperateStateEnum.AUDITED);
        baseInfo.setAuditor(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        IDraftApplyBillBase iDraftApplyBillBase = (IDraftApplyBillBase)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityBizInterface(baseInfo.getBOSType());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("auditor"));
        iDraftApplyBillBase.updatePartial((CoreBaseInfo)baseInfo, sic);
    }

    @Override
    protected void _commitECDS4WF(Context ctx, IObjectValue model) throws BOSException {
    }
}

