/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.EndorserRequestInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.EndorsementApplyBillCollection;
import com.kingdee.eas.fm.edraf.EndorsementApplyBillFactory;
import com.kingdee.eas.fm.edraf.EndorsementApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractEndorsementApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftEndorsementBillFactory;
import com.kingdee.eas.fm.edrafent.DraftEndorsementBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EndorsementApplyBillControllerBean
extends AbstractEndorsementApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.EndorsementApplyBillControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EndorsementApplyBillInfo info = (EndorsementApplyBillInfo)model;
        if (info.isIsCancelDraft() && info.getEndECDSState() != ECDSBillStatusEnum.BSDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"36_EndorsementApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (info.getOperateState().getValue() != 0 && info.getCommunicationStatus().getValue() != 2) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EndorsementApplyBillInfo info = (EndorsementApplyBillInfo)model;
        EndorserRequestInfo reqInfo = new EndorserRequestInfo();
        reqInfo.setBillNumber(info.getCommercialDraft().getDraftNumber());
        reqInfo.setBizDate(info.getApplyDate());
        reqInfo.setBillAmount(info.getCommercialDraft().getDraftAmount());
        reqInfo.setBanEndorsement(info.isIsAttorn() ? BanEndorsementMarkEnum.EM00 : BanEndorsementMarkEnum.EM01);
        reqInfo.setEndorserRole(RoleEnum.RC00);
        reqInfo.setEndorserName(info.getEndorsementerName().getName());
        reqInfo.setEndorserOrgCode(info.getOrgCode());
        reqInfo.setEndorserAccount(info.getEndorsementerAccount());
        reqInfo.setEndorserBank(info.getEndorsementerBankNumber());
        reqInfo.setByEndorserName(info.getByEndorsementName().getName());
        reqInfo.setByEndorserAccount(info.getByEndorsementAccount());
        reqInfo.setByEndorserBank(info.getByEndorsementBankNumber());
        reqInfo.setRemark(info.getRemark());
        reqInfo.setSourceBillId(info.getId().toString());
        reqInfo.setCompany(info.getApplyCompany());
        reqInfo.setBizSerialNumber(info.getBizCode());
        reqInfo.setBizPromoterOrgCode(info.getOrgCode());
        reqInfo.setEndorserRemark(EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString()));
        return reqInfo;
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("endorsementerName.name"));
        sic.add(new SelectorItemInfo("byEndorsementName.name"));
        return sic;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection registerCol = EndorsementApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        return registerCol;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        EndorsementApplyBillInfo endorInfo = this.getEndorsementApplyBillInfo(ctx, (IObjectPK)new ObjectUuidPK(sourceBillId));
        if (endorInfo != null && endorInfo.getSourceBillId() != null && endorInfo.isIsCancelDraft() && ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_033_OK) {
            DraftEndorsementBillInfo draftInfo = DraftEndorsementBillFactory.getLocalInstance((Context)ctx).getDraftEndorsementBillInfo((IObjectPK)new ObjectUuidPK(endorInfo.getSourceBillId()));
            if (draftInfo != null && draftInfo.getSourceBillId() != null && draftInfo.isIsCancelDraft()) {
                DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance((Context)ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(draftInfo.getSourceBillId()));
                SelectorItemCollection selCollection = new SelectorItemCollection();
                selCollection.add(new SelectorItemInfo("draftStockOperate"));
                stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                DraftStockBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)stockInfo, selCollection);
            }
        } else if (endorInfo == null || endorInfo.getSourceBillId() == null || ecdsApplyBillStatus == ApplyBillStatusEnum.RECEIVE_031_BAN) {
            // empty if block
        }
    }

    @Override
    public void _draftReturn(Context ctx, String billId, String opinion) throws BOSException, EASBizException {
        super._draftReturn(ctx, billId, opinion);
    }

    @Override
    public Map _batchCommitECDS(Context ctx, Set idSet) throws BOSException, EASBizException {
        Set set = idSet;
        boolean flag = false;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        envi.setFilter(filter);
        EndorsementApplyBillCollection coll = this.getEndorsementApplyBillCollection(ctx, envi);
        for (int i = 0; i < coll.size(); ++i) {
            EndorsementApplyBillInfo info = coll.get(i);
            if (info.getOperateState().getValue() == 0 || info.getCommunicationStatus().getValue() == 2) continue;
            set.remove(info.getId());
            flag = true;
        }
        Map map = super._batchCommitECDS(ctx, set);
        if (flag) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return map;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZRBSSQ;
    }

    @Override
    public void _commitECDS(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._commitECDS(ctx, model);
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EndorsementApplyBillInfo endorBillInfo = (EndorsementApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = endorBillInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        cancelBillInfo.setEletricSign(EdrafUtil.getSignatureByBillId(ctx, endorBillInfo.getSourceBillId(), endorBillInfo.getApplyCompany().getId().toString()));
        cancelBillInfo.setCancelOrgCode(endorBillInfo.getOrgCode());
        cancelBillInfo.setCancelAccount(endorBillInfo.getEndorsementerAccount());
        cancelBillInfo.setCancelBank(endorBillInfo.getEndorsementerBankNumber());
        cancelBillInfo.setBizPromoterOrgCode(endorBillInfo.getOrgCode());
        return cancelBillInfo;
    }
}

