/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.PromptPaymentReqInfo;
import com.kingdee.eas.fm.ecore.ProxyPropositionEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.HintPaymentApplyBillFactory;
import com.kingdee.eas.fm.edraf.HintPaymentApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractHintPaymentApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftPromptPaymentBillFactory;
import com.kingdee.eas.fm.edrafent.DraftPromptPaymentBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class HintPaymentApplyBillControllerBean
extends AbstractHintPaymentApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.HintPaymentApplyBillControllerBean");

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("holderName.*"));
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        return sic;
    }

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HintPaymentApplyBillInfo billInfo = (HintPaymentApplyBillInfo)model;
        ECDSCommunicationStatusEnum state = billInfo.getCommunicationStatus();
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.TSFKDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"39_HintPaymentApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (state == null || billInfo.getOperateState() == null || !state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) && (!state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL) && !state.equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) || billInfo.getReturnOpinion() != null || !billInfo.getOperateState().equals(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.save))) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HintPaymentApplyBillInfo billInfo = (HintPaymentApplyBillInfo)model;
        CommercialDraftInfo commInfo = billInfo.getCommercialDraft();
        if (commInfo.getDraftAmount() != null && billInfo.getPayAccount().compareTo(commInfo.getDraftAmount()) != 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"40_HintPaymentApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        PromptPaymentReqInfo reqInfo = new PromptPaymentReqInfo();
        reqInfo.setPaymentAmount(billInfo.getPayAccount());
        reqInfo.setPaymentDate(billInfo.getApplyDate());
        reqInfo.setSettlementMark(billInfo.isIsOnLine() ? SettlementMarkEnum.SM00 : SettlementMarkEnum.SM01);
        if (billInfo.isIsFinace()) {
            reqInfo.setProxyPropositio(ProxyPropositionEnum.PP00);
            reqInfo.setRemark("0");
        } else {
            String signature = EdrafUtil.getSignatureByBillId(ctx, billInfo.getSourceBillId(), billInfo.getApplyCompany().getId().toString());
            reqInfo.setRemark(signature);
        }
        if (billInfo.isIsSeft()) {
            reqInfo.setProxyPropositio(ProxyPropositionEnum.PP01);
        }
        reqInfo.setDraweeRemark(billInfo.getHolderRamark());
        reqInfo.setRoleName(billInfo.getHolderName().getName());
        reqInfo.setOrgCode(billInfo.getOrgCode());
        reqInfo.setBizSerialNumber(billInfo.getBizCode());
        reqInfo.setReloAccount(FMHelper.isEmpty((String)billInfo.getHolderAccount().getBankAccountNumber()) ? "0" : billInfo.getHolderAccount().getBankAccountNumber());
        reqInfo.setReloBank(billInfo.getHolderBankNumber().getNumber());
        reqInfo.setDraftNumber(commInfo.getDraftNumber());
        reqInfo.setDraftAmount(commInfo.getDraftAmount());
        reqInfo.setBizPromoterOrgCode(billInfo.getOrgCode());
        return reqInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection paymentCol = HintPaymentApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (paymentCol == null || paymentCol.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"41_HintPaymentApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        return paymentCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.TSFKSQ;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        HintPaymentApplyBillInfo billInfo = HintPaymentApplyBillFactory.getLocalInstance(ctx).getHintPaymentApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        if (billInfo.isIsCancelDraft() && billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_SUCCESS)) {
            String sourceId = billInfo.getSourceBillId();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("draftStockBill.id"));
            sic.add(new SelectorItemInfo("draftStockBill.present"));
            sic.add(new SelectorItemInfo("draftStockBill.draftStockOperate"));
            DraftPromptPaymentBillInfo info = DraftPromptPaymentBillFactory.getLocalInstance((Context)ctx).getDraftPromptPaymentBillInfo((IObjectPK)new ObjectUuidPK(sourceId), sic);
            DraftStockBillInfo stockInfo = info.getDraftStockBill();
            if (stockInfo != null) {
                stockInfo.setPresent(false);
                stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("present"));
                sic.add(new SelectorItemInfo("draftStockOperate"));
                DraftStockBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)stockInfo, sic);
            }
        }
        if (billInfo.isIsCancelDraft() && billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL)) {
            String sourceBillID = billInfo.getSourceBillId();
            DraftPromptPaymentBillInfo draftPayBillInfo = DraftPromptPaymentBillFactory.getLocalInstance((Context)ctx).getDraftPromptPaymentBillInfo((IObjectPK)new ObjectUuidPK(sourceBillID));
            draftPayBillInfo.setOperateState(OperateStateEnum.SUBMITGATEWAY);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("operateState"));
            DraftPromptPaymentBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)draftPayBillInfo, sic);
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HintPaymentApplyBillInfo acceptBillInfo = (HintPaymentApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = acceptBillInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        String signature = EdrafUtil.getSignatureByBillId(ctx, acceptBillInfo.getSourceBillId(), acceptBillInfo.getApplyCompany().getId().toString());
        cancelBillInfo.setEletricSign(signature);
        cancelBillInfo.setCancelOrgCode(draftInfo.getHolderOrgCode());
        cancelBillInfo.setCancelAccount(acceptBillInfo.getHolderAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(acceptBillInfo.getHolderBankNumber().getNumber());
        cancelBillInfo.setBizPromoterOrgCode(draftInfo.getHolderOrgCode());
        return cancelBillInfo;
    }
}

