/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ImpawnUnchainApplyBillInfo;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.ImpawnRemoveRequestFactory;
import com.kingdee.eas.fm.edraf.ImpawnRemoveRequestInfo;
import com.kingdee.eas.fm.edraf.app.AbstractImpawnRemoveRequestControllerBean;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftLienInfoBillFactory;
import com.kingdee.eas.fm.edrafent.DraftLienInfoBillInfo;
import com.kingdee.eas.fm.edrafent.IDraftLienInfoBill;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ImpawnRemoveRequestControllerBean
extends AbstractImpawnRemoveRequestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.ImpawnRemoveRequestControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ImpawnRemoveRequestInfo billInfo = (ImpawnRemoveRequestInfo)model;
        ECDSCommunicationStatusEnum state = billInfo.getCommunicationStatus();
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.ZYJCDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"42_ImpawnRemoveRequestControllerBean", (Locale)ctx.getLocale())});
        }
        if (!(state != null && (state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) || state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL) || state.equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) && billInfo.getReturnOpinion() == null))) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ImpawnRemoveRequestInfo impawnRemoveInfo = (ImpawnRemoveRequestInfo)model;
        ImpawnUnchainApplyBillInfo imapwnUnchainInfo = new ImpawnUnchainApplyBillInfo();
        CommercialDraftInfo draftInfo = impawnRemoveInfo.getCommercialDraft();
        imapwnUnchainInfo.setDraftNumber(draftInfo.getDraftNumber());
        imapwnUnchainInfo.setDraftAmount(draftInfo.getDraftAmount());
        imapwnUnchainInfo.setImpawnUnchainDate(impawnRemoveInfo.getApplyDate());
        imapwnUnchainInfo.setBatchNumber(FMHelper.isEmpty((String)impawnRemoveInfo.getBatchNumber()) ? null : impawnRemoveInfo.getBatchNumber());
        imapwnUnchainInfo.setPawneeRemark(impawnRemoveInfo.getRemark());
        imapwnUnchainInfo.setImpawnName(impawnRemoveInfo.getPawneeName().getName());
        imapwnUnchainInfo.setElectricSign("0");
        imapwnUnchainInfo.setImpawnOrgCode(impawnRemoveInfo.getPawneeOrgCode());
        imapwnUnchainInfo.setImpawnAccount(FMHelper.isEmpty((CoreBaseInfo)impawnRemoveInfo.getPawneeAccount()) ? "0" : impawnRemoveInfo.getPawneeAccount().getBankAccountNumber());
        imapwnUnchainInfo.setImpawnBank(impawnRemoveInfo.getPawneeBeBank().getNumber());
        imapwnUnchainInfo.setBizSerialNumber(impawnRemoveInfo.getBizCode());
        imapwnUnchainInfo.setBizPromoterOrgCode(impawnRemoveInfo.getPawneeOrgCode());
        return imapwnUnchainInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)new Integer(2), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)new Integer(5), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection impawnRemoveCol = ImpawnRemoveRequestFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (impawnRemoveCol == null || impawnRemoveCol.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return impawnRemoveCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.ZYJCSQ;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        if (sourceBillId == null || sourceBillId.equals("")) {
            return;
        }
        ImpawnRemoveRequestInfo info = ImpawnRemoveRequestFactory.getLocalInstance(ctx).getImpawnRemoveRequestInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        if (info.isIsCancelDraft() && info.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_SUCCESS)) {
            String lienInfoId = info.getSourceBillId();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("operateState");
            sic.add("isCancelDraft");
            IDraftLienInfoBill iDraftLienInfoBill = DraftLienInfoBillFactory.getLocalInstance((Context)ctx);
            DraftLienInfoBillInfo lienInfo = iDraftLienInfoBill.getDraftLienInfoBillInfo((IObjectPK)new ObjectUuidPK(lienInfoId), sic);
            lienInfo.setOperateState(OperateStateEnum.SUBMIT);
            lienInfo.setIsCancelDraft(false);
            iDraftLienInfoBill.updatePartial((CoreBaseInfo)lienInfo, sic);
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ImpawnRemoveRequestInfo impawnRemoveInfo = (ImpawnRemoveRequestInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = impawnRemoveInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        cancelBillInfo.setEletricSign("0");
        cancelBillInfo.setCancelOrgCode(impawnRemoveInfo.getPawneeOrgCode());
        cancelBillInfo.setCancelAccount(impawnRemoveInfo.getPawneeAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(impawnRemoveInfo.getPawneeBeBank().getNumber());
        cancelBillInfo.setBizPromoterOrgCode(impawnRemoveInfo.getPawneeOrgCode());
        return cancelBillInfo;
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        sic.add("pawneeAccount.bankAccountNumber");
        sic.add("pawneeBeBank.number");
        sic.add("pawneeName.name");
        return sic;
    }
}

