/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.TipsTicketCollectorBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EdrafException;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.IssuanceApplyBillFactory;
import com.kingdee.eas.fm.edraf.IssuanceApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractIssuanceApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class IssuanceApplyBillControllerBean
extends AbstractIssuanceApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.IssuanceApplyBillControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IssuanceApplyBillInfo billInfo = (IssuanceApplyBillInfo)model;
        ECDSCommunicationStatusEnum state = billInfo.getCommunicationStatus();
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.TSSPDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"43_IssuanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (!(state != null && (state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) || state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL) || state.equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) && billInfo.getReturnOpinion() == null))) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IssuanceApplyBillInfo issuanceInfo = (IssuanceApplyBillInfo)model;
        TipsTicketCollectorBillInfo info = new TipsTicketCollectorBillInfo();
        CommercialDraftInfo draftInfo = issuanceInfo.getCommercialDraft();
        info.setNumber(issuanceInfo.getNumber());
        info.setCompany(issuanceInfo.getCompany());
        info.setDraftAmount(draftInfo.getDraftAmount());
        info.setDraftNumber(draftInfo.getDraftNumber());
        info.setDraftRemark(draftInfo.getRemark());
        if (issuanceInfo.getApplyCompany() == null || issuanceInfo.getApplyCompany().getId() == null) {
            info.setDrawerElecSign("0");
        } else {
            String signature = EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), issuanceInfo.getApplyCompany().getId().toString());
            info.setDrawerElecSign(signature);
        }
        info.setDraftOrgCode(draftInfo.getDrawerOrgCode());
        info.setDrawerAccount(draftInfo.getDrawerAccountNumber());
        info.setDrawerBank(draftInfo.getDrawerBankNumber());
        info.setBizPromoterOrgCode(draftInfo.getDrawerOrgCode());
        info.setBizSerialNumber(issuanceInfo.getBizCode());
        return info;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection issuanceCol = IssuanceApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (issuanceCol == null || issuanceCol.size() == 0) {
            throw new EdrafException(EdrafException.SUBMIT_ERROR);
        }
        return issuanceCol;
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        return sic;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.QSSPSQ;
    }

    @Override
    public void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        IssuanceApplyBillInfo issApplyBill;
        if (ecdsApplyBillStatus.equals((Object)ApplyBillStatusEnum.RECEIVE_031_OK) && (issApplyBill = IssuanceApplyBillFactory.getLocalInstance(ctx).getIssuanceApplyBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId))) != null && issApplyBill.getSourceBillId() != null) {
            String sql = "UPDATE T_EDT_DraftRegisterBill SET FClewDrawer=1 WHERE FID='" + issApplyBill.getSourceBillId() + "'";
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IssuanceApplyBillInfo info = (IssuanceApplyBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        cancelBillInfo.setDraftNumber(info.getCommercialDraft().getDraftNumber());
        cancelBillInfo.setDraftAmount(info.getCommercialDraft().getDraftAmount());
        if (info.getApplyCompany() == null || info.getApplyCompany().getId() == null) {
            cancelBillInfo.setEletricSign("0");
        } else {
            String signature = EdrafUtil.getSignatureByBillId(ctx, info.getSourceBillId(), info.getApplyCompany().getId().toString());
            cancelBillInfo.setEletricSign(signature);
        }
        cancelBillInfo.setCancelOrgCode(info.getCommercialDraft().getDrawerOrgCode());
        cancelBillInfo.setCancelAccount(info.getCommercialDraft().getDrawerAccountNumber());
        cancelBillInfo.setCancelBank(info.getCommercialDraft().getDrawerBankNumber());
        cancelBillInfo.setBizPromoterOrgCode(info.getCommercialDraft().getDrawerOrgCode());
        return cancelBillInfo;
    }
}

