/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ecore.BusinessNotificationCollection;
import com.kingdee.eas.fm.ecore.BusinessNotificationFactory;
import com.kingdee.eas.fm.ecore.BusinessNotificationInfo;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSPaperActionStatusEnum;
import com.kingdee.eas.fm.ecore.ElecDraftActionEnum;
import com.kingdee.eas.fm.ecore.NotificationEnum;
import com.kingdee.eas.fm.ecore.SystemTypeEnum;
import com.kingdee.eas.fm.ecore.app.EcdsConfig;
import com.kingdee.eas.fm.ecore.app.ecds.ECDSCommon;
import com.kingdee.eas.fm.edraf.EdrafSysNotificationFacadeFactory;
import com.kingdee.eas.fm.edraf.app.AbstractNoticePollingInterfaceFacadeControllerBean;
import com.kingdee.eas.fm.edraf.app.util.BussinessHandleCallBack;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import org.apache.log4j.Logger;

public class NoticePollingInterfaceFacadeControllerBean
extends AbstractNoticePollingInterfaceFacadeControllerBean {
    private static final long serialVersionUID = -4221781331898479307L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.NoticePollingInterfaceFacadeControllerBean");

    @Override
    protected synchronized void _innerHandleMsgWithTransmission(Context ctx) throws BOSException, EASBizException {
        if (!EcdsConfig.getInstance().isOn()) {
            return;
        }
        if (!EcdsConfig.getInstance().isInEdrafIsOn()) {
            return;
        }
        ECDSCommon.setEDRAF_SWITCH_TIME();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"44_NoticePollingInterfaceFacadeControllerBean", (Locale)ctx.getLocale()));
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Boolean iSendClient = new Boolean(false);
        filter.getFilterItems().add(new FilterItemInfo("iSendClient", (Object)iSendClient));
        filter.getFilterItems().add(new FilterItemInfo("isHandleError", (Object)false));
        env.setFilter(filter);
        BusinessNotificationCollection col = BusinessNotificationFactory.getLocalInstance((Context)ctx).getBusinessNotificationCollection(env);
        if (null != col && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                BusinessNotificationInfo info = col.get(i);
                NotificationEnum notificationType = info.getNotificationType();
                String id = info.getId().toString();
                String draftTakerOrgCode = info.getHolderOrgCode();
                String draftNumber = info.getDraftNumber();
                ElecDraftActionEnum ecdsApplyBillStatus = info.getActionType();
                ECDSBillStatusEnum ecdsBillStatusEnum = info.getCommunicatedDraftStatus();
                SystemTypeEnum draftType = info.getSystemType();
                String handleResult = info.getCommunicateResult();
                if (draftType == SystemTypeEnum.Draft_System) {
                    if (notificationType == NotificationEnum.Reply_Notification) {
                        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"45_NoticePollingInterfaceFacadeControllerBean", (Locale)ctx.getLocale()));
                        String bizCode = info.getBizSerialNumber();
                        try {
                            EdrafSysNotificationFacadeFactory.getLocalInstance(ctx).replyNotifyCallBack(draftTakerOrgCode, draftNumber, ecdsApplyBillStatus, ecdsBillStatusEnum, bizCode, handleResult, id);
                        }
                        catch (Exception e) {
                            logger.info((Object)e.getMessage().toString());
                            EdrafUtil.updateBuzNotice(ctx, id, false, e.getMessage().toString());
                        }
                        continue;
                    }
                    if (notificationType == NotificationEnum.Revice_Notification) {
                        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"46_NoticePollingInterfaceFacadeControllerBean", (Locale)ctx.getLocale()));
                        try {
                            EdrafSysNotificationFacadeFactory.getLocalInstance(ctx).staySignUpCallBack(draftTakerOrgCode, draftNumber, ecdsBillStatusEnum, id);
                        }
                        catch (Exception e) {
                            logger.info((Object)e.getMessage().toString());
                            EdrafUtil.updateBuzNotice(ctx, id, false, e.getMessage().toString());
                        }
                        continue;
                    }
                    if (notificationType == NotificationEnum.Revice_CancelBill) {
                        try {
                            EdrafSysNotificationFacadeFactory.getLocalInstance(ctx).cancelCallBack(draftTakerOrgCode, draftNumber, ecdsApplyBillStatus, info.getMessageID(), ecdsBillStatusEnum, info.getId().toString());
                        }
                        catch (Exception e) {
                            logger.info((Object)e.getMessage().toString());
                            EdrafUtil.updateBuzNotice(ctx, id, false, e.getMessage().toString());
                        }
                        continue;
                    }
                    logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"47_NoticePollingInterfaceFacadeControllerBean", (Locale)ctx.getLocale()));
                    try {
                        EdrafSysNotificationFacadeFactory.getLocalInstance(ctx).pureNotifyCallBack(draftTakerOrgCode, draftNumber, ecdsBillStatusEnum, id);
                    }
                    catch (Exception e) {
                        logger.info((Object)e.getMessage().toString());
                        EdrafUtil.updateBuzNotice(ctx, id, false, e.getMessage().toString());
                    }
                    continue;
                }
                if (draftType != SystemTypeEnum.Paper_System) continue;
                try {
                    ECDSPaperActionStatusEnum paperApplyBillStatus = info.getPaperDraftStatus();
                    String messageID = info.getMessageID();
                    BussinessHandleCallBack.paperDraftNotifyCallBack(ctx, info.getBizSerialNumber(), paperApplyBillStatus, handleResult, messageID, info.getId().toString());
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)e.getMessage());
                    EdrafUtil.updateBuzNotice(ctx, id, false, e.getMessage().toString());
                }
            }
        }
    }
}

