/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ActionCancelBillInfo;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.ApplyBillStatusEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.OverdueCuePayInfo;
import com.kingdee.eas.fm.ecore.ProxyPropositionEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.SettlementMarkEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.OverClewtApplyReqBillFactory;
import com.kingdee.eas.fm.edraf.OverClewtApplyReqBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractOverClewtApplyReqBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftOverdueClewPaymentBillFactory;
import com.kingdee.eas.fm.edrafent.DraftOverdueClewPaymentBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class OverClewtApplyReqBillControllerBean
extends AbstractOverClewtApplyReqBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.OverClewtApplyReqBillControllerBean");

    @Override
    protected void _modefyResult(Context ctx, String id, ECDSCommunicationStatusEnum state) throws BOSException, EASBizException {
    }

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OverClewtApplyReqBillInfo billInfo = (OverClewtApplyReqBillInfo)model;
        ECDSCommunicationStatusEnum state = billInfo.getCommunicationStatus();
        if (billInfo.isIsCancelDraft() && billInfo.getEndECDSState() != ECDSBillStatusEnum.YQTSFKDQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"48_OverClewtApplyReqBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (state == null || billInfo.getOperateState() == null || !state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) && (!state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL) && !state.equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) || billInfo.getReturnOpinion() != null || !billInfo.getOperateState().equals(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.save))) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OverClewtApplyReqBillInfo billInfo = (OverClewtApplyReqBillInfo)model;
        CommercialDraftInfo commInfo = billInfo.getCommercialDraft();
        if (commInfo != null && billInfo.getPayAccount().compareTo(commInfo.getDraftAmount()) != 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"49_OverClewtApplyReqBillControllerBean", (Locale)ctx.getLocale())});
        }
        OverdueCuePayInfo reqInfo = new OverdueCuePayInfo();
        reqInfo.setDraftNumber(commInfo.getDraftNumber());
        reqInfo.setDraftAmount(commInfo.getDraftAmount());
        reqInfo.setOverdueDate(billInfo.getApplyDate());
        reqInfo.setSettlementOnline(billInfo.isIsOnLine() ? SettlementMarkEnum.SM00 : SettlementMarkEnum.SM01);
        if (billInfo.isIsFinace()) {
            reqInfo.setSupplyApplySign(ProxyPropositionEnum.PP00);
            reqInfo.setElectricSign("0");
        } else {
            String eletricSign = EdrafUtil.getSignatureByBillId(ctx, billInfo.getSourceBillId(), billInfo.getApplyCompany().getId().toString());
            reqInfo.setElectricSign(eletricSign);
        }
        if (billInfo.isIsSeft()) {
            reqInfo.setSupplyApplySign(ProxyPropositionEnum.PP01);
        }
        reqInfo.setPayerRemark(billInfo.getHolderRamark());
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(billInfo.getHolderName().getId().toString()));
        reqInfo.setDrawerName(companyInfo.getName());
        reqInfo.setOverdueAmount(billInfo.getPayAccount());
        reqInfo.setDrawerOrgCode(billInfo.getOrgCode());
        reqInfo.setBizPromoterOrgCode(billInfo.getOrgCode());
        reqInfo.setBizSerialNumber(billInfo.getBizCode());
        reqInfo.setOverdueReason(billInfo.getOverDueReson());
        reqInfo.setPayerRemark(billInfo.getHolderRamark());
        reqInfo.setDrawerAccount(FMHelper.isEmpty((String)billInfo.getHolderAccount().getBankAccountNumber()) ? "0" : billInfo.getHolderAccount().getBankAccountNumber());
        reqInfo.setDrawerBank(billInfo.getHolderBankNumber().getNumber());
        billInfo.setOverDueReson(billInfo.getOverDueReson());
        return reqInfo;
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection Selector = super.getSelector();
        Selector.add("holderBankNumber.*");
        Selector.add("holderAccount.*");
        return Selector;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection paymentCol = OverClewtApplyReqBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (paymentCol == null || paymentCol.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"41_HintPaymentApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        return paymentCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.YQTSFKSQ;
    }

    @Override
    protected void _rewriteECDSMess(Context ctx, String sourceBillId, String bizCode, ApplyBillStatusEnum ecdsApplyBillStatus) throws BOSException, EASBizException {
        OverClewtApplyReqBillInfo billInfo = OverClewtApplyReqBillFactory.getLocalInstance(ctx).getOverClewtApplyReqBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        if (billInfo.isIsCancelDraft() && billInfo.getCommunicationStatus().equals((Object)ECDSCommunicationStatusEnum.PROCESS_SUCCESS) || ecdsApplyBillStatus.equals((Object)ApplyBillStatusEnum.RECEIVE_031_BAN)) {
            String sourceId = billInfo.getSourceBillId();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("draftStockBill.*"));
            DraftOverdueClewPaymentBillInfo info = DraftOverdueClewPaymentBillFactory.getLocalInstance((Context)ctx).getDraftOverdueClewPaymentBillInfo((IObjectPK)new ObjectUuidPK(sourceId));
            DraftStockBillInfo stockInfo = info.getDraftStockBill();
            if (stockInfo != null) {
                stockInfo.setPresent(false);
                stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("present"));
                sic.add(new SelectorItemInfo("draftStockOperate"));
                DraftStockBillFactory.getLocalInstance((Context)ctx).updatePartial((CoreBaseInfo)stockInfo, sic);
            }
        }
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OverClewtApplyReqBillInfo acceptBillInfo = (OverClewtApplyReqBillInfo)model;
        ActionCancelBillInfo cancelBillInfo = new ActionCancelBillInfo();
        CommercialDraftInfo draftInfo = acceptBillInfo.getCommercialDraft();
        cancelBillInfo.setDraftNumber(draftInfo.getDraftNumber());
        cancelBillInfo.setDraftAmount(draftInfo.getDraftAmount());
        String signature = EdrafUtil.getSignatureByBillId(ctx, acceptBillInfo.getSourceBillId(), acceptBillInfo.getApplyCompany().getId().toString());
        cancelBillInfo.setEletricSign(signature);
        cancelBillInfo.setCancelOrgCode(draftInfo.getHolderOrgCode());
        cancelBillInfo.setCancelAccount(acceptBillInfo.getHolderAccount().getBankAccountNumber());
        cancelBillInfo.setCancelBank(acceptBillInfo.getHolderBankNumber().getNumber());
        cancelBillInfo.setBizPromoterOrgCode(draftInfo.getHolderOrgCode());
        return cancelBillInfo;
    }

    public String getBosType() {
        return null;
    }
}

