/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edraf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.ecore.ApplyBillBaseInfo;
import com.kingdee.eas.fm.ecore.BizCancelBillInfo;
import com.kingdee.eas.fm.ecore.DraftRegisterBillInfo;
import com.kingdee.eas.fm.ecore.DraftTypeEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.ecore.RequestTypeEnum;
import com.kingdee.eas.fm.ecore.RoleEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseCollection;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.RegisterApplyBillFactory;
import com.kingdee.eas.fm.edraf.RegisterApplyBillInfo;
import com.kingdee.eas.fm.edraf.app.AbstractRegisterApplyBillControllerBean;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class RegisterApplyBillControllerBean
extends AbstractRegisterApplyBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edraf.app.RegisterApplyBillControllerBean");

    @Override
    public void checkDraftApplyBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RegisterApplyBillInfo billInfo = (RegisterApplyBillInfo)model;
        ECDSCommunicationStatusEnum state = billInfo.getCommunicationStatus();
        if (billInfo.isIsCancelDraft() && !billInfo.getEndECDSState().equals((Object)ECDSBillStatusEnum.CPYDJ) && billInfo.getEndECDSState() != ECDSBillStatusEnum.TSCDYQS) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"73_RegisterApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        if (state == null || !state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_READY) && (!state.equals((Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL) && !state.equals((Object)ECDSCommunicationStatusEnum.PROCESS_FAIL) || billInfo.getReturnOpinion() != null)) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"1_AcceptanceApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("applyCompany.name"));
        sic.add(new SelectorItemInfo("applyCompany.id"));
        return sic;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSApplyBill(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        RegisterApplyBillInfo billInfo = (RegisterApplyBillInfo)model;
        CommercialDraftInfo commDraft = billInfo.getCommercialDraft();
        if (!billInfo.isIsCancelDraft()) {
            DraftRegisterBillInfo applyBillInfo = new DraftRegisterBillInfo();
            applyBillInfo.setNumber(billInfo.getNumber());
            applyBillInfo.setDraftAmount(commDraft.getDraftAmount());
            applyBillInfo.setCompany(billInfo.getApplyCompany());
            if (commDraft.getDraftType() != null) {
                applyBillInfo.setDraftType(commDraft.getDraftType() == DrafTypeEnum.AC01 ? DraftTypeEnum.AC01 : DraftTypeEnum.AC02);
            }
            applyBillInfo.setIssueDate(commDraft.getIssueDate());
            applyBillInfo.setDueDate(commDraft.getDueDate());
            applyBillInfo.setBanEndorsement(commDraft.getBanEndorsement());
            applyBillInfo.setRemark(billInfo.getDescription());
            applyBillInfo.setDrawerName(commDraft.getDrawerName());
            applyBillInfo.setDrawerOrgCode(commDraft.getDrawerOrgCode());
            applyBillInfo.setDrawerAccount(commDraft.getDrawerAccountNumber());
            applyBillInfo.setDrawerBank(commDraft.getDrawerBankNumber());
            applyBillInfo.setDrawerCreditRat(commDraft.getDrawerCreditRate());
            applyBillInfo.setDrawerCdtRater(commDraft.getDrawerRateAgcy());
            applyBillInfo.setDrawerRtDueDate(commDraft.getDrawerRateDueDate());
            applyBillInfo.setAcceptorName(commDraft.getAcceptorName());
            applyBillInfo.setAcceptorAccount(commDraft.getAcceptorAccountNumber());
            applyBillInfo.setAcceptorBank(commDraft.getAcceptorBankNumber());
            applyBillInfo.setPayeeName(commDraft.getPayeeName());
            applyBillInfo.setPayeeAccount(commDraft.getPayeeAccountNumber());
            applyBillInfo.setPayeeBank(commDraft.getPayeeBankNumber());
            applyBillInfo.setDrawerCreditRat(commDraft.getDrawerCreditRate());
            applyBillInfo.setPayeeName(commDraft.getPayeeName());
            applyBillInfo.setPayeeAccount(commDraft.getPayeeAccountNumber());
            applyBillInfo.setPayeeBank(commDraft.getPayeeBankNumber());
            applyBillInfo.setSourceBillId(billInfo.getId().toString());
            applyBillInfo.setDrawerRole(RoleEnum.getEnum((String)"RC00"));
            applyBillInfo.setDrawerElecSign(EdrafUtil.getSignatureByBillId(ctx, billInfo.getSourceBillId(), billInfo.getApplyCompany().getId().toString()));
            applyBillInfo.setBizPromoterOrgCode(commDraft.getDrawerOrgCode());
            applyBillInfo.setBizSerialNumber(billInfo.getBizCode());
            return applyBillInfo;
        }
        BizCancelBillInfo bizcaceInfo = new BizCancelBillInfo();
        bizcaceInfo.setCancelAccount(commDraft.getDrawerAccountNumber());
        bizcaceInfo.setCancelBank(commDraft.getDrawerBankNumber());
        bizcaceInfo.setCancelRole(RoleEnum.getEnum((String)"RC00"));
        bizcaceInfo.setCancelOrgCode(commDraft.getDrawerOrgCode());
        String eletricSign = EdrafUtil.getSignatureByBillId(ctx, billInfo.getSourceBillId(), billInfo.getApplyCompany().getId().toString());
        bizcaceInfo.setEletricSign(eletricSign);
        bizcaceInfo.setDraftAmount(commDraft.getDraftAmount());
        bizcaceInfo.setDraftNumber(commDraft.getDraftNumber());
        bizcaceInfo.setBizPromoterOrgCode(commDraft.getDrawerOrgCode());
        bizcaceInfo.setSourceBillId(billInfo.getId().toString());
        bizcaceInfo.setBizSerialNumber(billInfo.getBizCode());
        return bizcaceInfo;
    }

    @Override
    public DraftApplyBillBaseCollection getBillCollection(Context ctx, Set idSet, SelectorItemCollection sic) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)FCOperateStateEnum.save, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_READY, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.SUBMIT_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("communicationStatus", (Object)ECDSCommunicationStatusEnum.PROCESS_FAIL, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("returnOpinion", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and (#2 or ((#3 or #4) and #5))");
        env.setSelector(sic);
        env.setFilter(filter);
        DraftApplyBillBaseCollection registerCol = RegisterApplyBillFactory.getLocalInstance(ctx).getDraftApplyBillBaseCollection(env);
        if (registerCol == null || registerCol.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fm.edraf.EDRAFAutoGenerateResource", (String)"41_HintPaymentApplyBillControllerBean", (Locale)ctx.getLocale())});
        }
        return registerCol;
    }

    @Override
    public RequestTypeEnum getRequestType() {
        return RequestTypeEnum.CPXXDJ;
    }

    @Override
    public ApplyBillBaseInfo convertToECDSCancelBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RegisterApplyBillInfo cantcebillInfo = (RegisterApplyBillInfo)model;
        BizCancelBillInfo bizcaceInfo = new BizCancelBillInfo();
        bizcaceInfo.setCancelAccount(cantcebillInfo.getCommercialDraft().getDrawerAccountNumber());
        bizcaceInfo.setCancelBank(cantcebillInfo.getCommercialDraft().getDrawerBankNumber());
        bizcaceInfo.setCancelRole(cantcebillInfo.getCommercialDraft().getDrawerRole());
        bizcaceInfo.setCancelOrgCode(cantcebillInfo.getCommercialDraft().getDrawerOrgCode());
        bizcaceInfo.setEletricSign(EdrafUtil.getSignatureByBillId(ctx, cantcebillInfo.getSourceBillId(), cantcebillInfo.getApplyCompany().getId().toString()));
        bizcaceInfo.setDraftAmount(cantcebillInfo.getCommercialDraft().getDraftAmount());
        bizcaceInfo.setDraftNumber(cantcebillInfo.getCommercialDraft().getDraftNumber());
        return bizcaceInfo;
    }
}

