/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.EndorsementApplyBillInfo;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edrafent.CommunicationWayEnum;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftEndorsementBillCollection;
import com.kingdee.eas.fm.edrafent.DraftEndorsementBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftEndorsementBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftEndorsementBillControllerBean
extends AbstractDraftEndorsementBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftEndorsementBillControllerBean");

    protected void afterAddNew(Context ctx, IObjectPK returnPK, IObjectValue model) throws BOSException, EASBizException {
        DraftEndorsementBillInfo info = (DraftEndorsementBillInfo)model;
        DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId().toString()));
        stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.ENDORSEMENT);
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("draftStockOperate"));
        DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, selColl);
        super.afterAddNew(ctx, returnPK, model);
    }

    @Override
    protected void _bankCorporate(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftEndorsementBillCollection coll = this.getDraftEndorsementBillCollection(ctx, envi);
        for (int i = 0; i < coll.size(); ++i) {
            DraftEndorsementBillInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 2) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("financeOperateState"));
            selColl.add(new SelectorItemInfo("submitDate"));
            selColl.add(new SelectorItemInfo("submitter"));
            selColl.add(new SelectorItemInfo("submitCompany"));
            selColl.add(new SelectorItemInfo("communicationWay"));
            info.setFinanceOperateState(com.kingdee.eas.fm.edrafent.FCOperateStateEnum.save);
            info.setOperateState(OperateStateEnum.SUBMITGATEWAY);
            info.setCommunicationWay(CommunicationWayEnum.WITH_BEBANK);
            this.updatePartial(ctx, (CoreBaseInfo)info, selColl);
        }
    }

    @Override
    protected void _financeCompany(Context ctx, Set set) throws BOSException, EASBizException {
    }

    @Override
    protected void _submit(Context ctx, Set set) throws BOSException, EASBizException {
        DraftEndorsementBillInfo info;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftEndorsementBillCollection coll = this.getDraftEndorsementBillCollection(ctx, envi);
        if (coll.size() == 1 && (info = coll.get(0)).getOperateState().getValue() != 0) {
            throw new EASBizException(new NumericExceptionSubItem("8118541", "\u5355\u636e\u5df2\u63d0\u4ea4\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftEndorsementBillInfo info2 = coll.get(i);
            if (info2.getOperateState().getValue() != 0) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            info2.setOperateState(OperateStateEnum.SUBMIT);
            this.updatePartial(ctx, (CoreBaseInfo)info2, selColl);
            super.submit(ctx, (CoreBaseInfo)info2);
            DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(info2.getSourceBillId().toString()));
            stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.ENDORSEMENT);
            SelectorItemCollection sel = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("draftStockOperate"));
            DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, sel);
        }
    }

    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        super.isCanDelete(ctx, pk, coreBillInfo);
        DraftEndorsementBillInfo info = this.getDraftEndorsementBillInfo(ctx, pk);
        if (info.getOperateState().getValue() == 0 || info.getOperateState().getValue() == 1) {
            if (info.getFinanceOperateState() != com.kingdee.eas.fm.edrafent.FCOperateStateEnum.init_Value) {
                throw new EASBizException(new NumericExceptionSubItem("123088", "\u5df2\u5ba1\u6279\u6216\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("123088", "\u5df2\u5ba1\u6279\u6216\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u53ef\u5220\u9664\uff01"));
        }
    }

    @Override
    protected void _audit(Context ctx, Set set) throws BOSException, EASBizException {
        DraftEndorsementBillInfo info;
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftEndorsementBillCollection coll = this.getDraftEndorsementBillCollection(ctx, envi);
        if (coll.size() == 1 && (info = coll.get(0)).getOperateState().getValue() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("811341", "\u63d0\u4ea4\u72b6\u6001\u7684\u80cc\u4e66\u8f6c\u8ba9\u5355\u53ef\u5ba1\u6279\uff01"));
        }
        for (int i = 0; i < coll.size(); ++i) {
            DraftEndorsementBillInfo info2 = coll.get(i);
            if (info2.getOperateState().getValue() != 1) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("auditDate"));
            selColl.add(new SelectorItemInfo("auditor"));
            info2.setOperateState(OperateStateEnum.AUDIT);
            info2.setAuditDate(DateHelper.getTime());
            info2.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
            this.updatePartial(ctx, (CoreBaseInfo)info2, selColl);
            this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(info2.getId()), info2);
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        envi.setFilter(filter);
        DraftEndorsementBillCollection coll = this.getDraftEndorsementBillCollection(ctx, envi);
        for (int i = 0; i < coll.size(); ++i) {
            DraftEndorsementBillInfo info = coll.get(i);
            if (info.getOperateState().getValue() != 2) continue;
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("operateState"));
            selColl.add(new SelectorItemInfo("auditDate"));
            selColl.add(new SelectorItemInfo("auditor"));
            info.setOperateState(OperateStateEnum.SAVE);
            info.setAuditDate(null);
            info.setAuditor(null);
            this.updatePartial(ctx, (CoreBaseInfo)info, selColl);
            this.unAudit4WF(ctx, info);
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return EndorsementApplyBillInfo.class.getName();
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    protected void checkCanBeCancelled(Context ctx, IObjectValue model, DraftApplyTypeEnum cancelType) throws EASBizException, BOSException {
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("commercialDraft.draftECDSStatus"));
        selColl.add(new SelectorItemInfo("*"));
        DraftEndorsementBillInfo info = this.getDraftEndorsementBillInfo(ctx, (IObjectPK)new ObjectUuidPK(model.getString("id")), selColl);
        if (!info.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY) || !info.getCommercialDraft().getDraftECDSStatus().equals((Object)ECDSBillStatusEnum.BSDQS)) {
            throw new EASBizException(new NumericExceptionSubItem("1234646", "\u80cc\u4e66\u5f85\u7b7e\u6536\u4e14\u672a\u64a4\u9500\u7684\u80cc\u4e66\u5355\u624d\u5141\u8bb8\u64a4\u9500\uff01"));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String draftStockBillID = this.getDraftEndorsementBillInfo(ctx, pk).getSourceBillId();
        super._delete(ctx, pk);
        if (draftStockBillID != null) {
            DraftStockBillInfo stockInfo = DraftStockBillFactory.getLocalInstance(ctx).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(draftStockBillID));
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("draftStockOperate"));
            stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
            DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, selColl);
        }
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        DraftEndorsementBillInfo info = (DraftEndorsementBillInfo)baseInfo;
        EndorsementApplyBillInfo newBillInfo = new EndorsementApplyBillInfo();
        newBillInfo.setCommercialDraft(info.getCommercialDraft());
        newBillInfo.setOperateState(FCOperateStateEnum.save);
        newBillInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
        newBillInfo.setStartECDSState(info.getCommercialDraft().getDraftECDSStatus());
        newBillInfo.setEndECDSState(info.getCommercialDraft().getDraftECDSStatus());
        newBillInfo.setIsCancelDraft(false);
        newBillInfo.setEndorsementerName(info.getEndorsementerName());
        newBillInfo.setEndorsementerAccount(info.getEndorsementerAccount().getBankAccountNumber());
        newBillInfo.setEndorsementerBankNumber(info.getEndorsementerBankNumber().getNumber());
        newBillInfo.setByEndorsementName(info.getByEndorsementName());
        newBillInfo.setByEndorsementAccount(info.getByEndorsementAccount());
        newBillInfo.setByEndorsementBankNumber(info.getByEndorsementBankNumber());
        newBillInfo.setRemark(info.getRemark());
        newBillInfo.setReqDate(info.getReqDate());
        newBillInfo.setIsAttorn(info.isIsAttorn());
        newBillInfo.setSourceBillId(info.getId().toString());
        newBillInfo.setOrgCode(info.getOrgCode());
        newBillInfo.setApplyCompany(info.getCompany());
        newBillInfo.setApplyDate(info.getReqDate());
        return newBillInfo;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("endorsementerAccount.*"));
        sic.add(new SelectorItemInfo("endorsementerBankNumber.*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        return sic;
    }
}

