/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.HintPaymentApplyBillInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftPromptPaymentBillCollection;
import com.kingdee.eas.fm.edrafent.DraftPromptPaymentBillFactory;
import com.kingdee.eas.fm.edrafent.DraftPromptPaymentBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftPromptPaymentBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftPromptPaymentBillControllerBean
extends AbstractDraftPromptPaymentBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftPromptPaymentBillControllerBean");

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DraftPromptPaymentBillInfo info = (DraftPromptPaymentBillInfo)model;
        if (info.getNumber() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
            if (DraftPromptPaymentBillFactory.getLocalInstance(ctx).exists(filter)) {
                throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01"});
            }
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _audit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.SUBMIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftPromptPaymentBillCollection billCol = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillCollection(env);
        if (billCol != null && billCol.size() > 0) {
            DraftPromptPaymentBillInfo billInfo = null;
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                billInfo = billCol.get(i);
                this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u63d0\u4ea4\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u5ba1\u6279\uff01"});
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException {
        Object[] idArray;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftPromptPaymentBillCollection billCol = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillCollection(env);
        if (billCol != null && billCol.size() > 0) {
            idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
                this.unAudit4WF(ctx, billCol.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u5ba1\u6279\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u53ef\u4ee5\u53cd\u5ba1\u6279\uff01"});
        }
        String sql = "update T_EDT_DraftPromptPaymentBill set FOperateState=?,FAuditDate=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), null});
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operateState"));
        sic.add(new SelectorItemInfo("draftStockBill.*"));
        DraftPromptPaymentBillInfo info = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillInfo(pk);
        if (info.getOperateState().equals((Object)OperateStateEnum.SAVE) || info.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
            DraftStockBillInfo stockInfo = info.getDraftStockBill();
            if (stockInfo != null) {
                stockInfo.setPresent(false);
                stockInfo.setDraftStockOperate(DraftStockBillOperateEnum.REGISTER);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("present"));
                sic.add(new SelectorItemInfo("draftStockOperate"));
                DraftStockBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)stockInfo, sic);
            }
            super._delete(ctx, pk);
        }
    }

    @Override
    protected void _draftSubmit(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.SAVE, CompareType.EQUALS));
        env.setFilter(filter);
        DraftPromptPaymentBillCollection col = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillCollection(env);
        if (col != null && col.size() > 0) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                super.submit(ctx, (CoreBaseInfo)col.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u5b58\u72b6\u6001\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u5141\u8bb8\u63d0\u4ea4\uff01"});
        }
    }

    @Override
    protected void _submitToECDS(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.setFilter(filter);
        DraftPromptPaymentBillCollection billCol = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillCollection(env);
        DraftPromptPaymentBillInfo billInfo = new DraftPromptPaymentBillInfo();
        billInfo.setSubmitDate(DateHelper.getTime());
        if (billCol.size() > 0) {
            HashSet<BOSUuid> set = new HashSet<BOSUuid>();
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                set.add(billCol.get(i).getId());
            }
            if (set.size() > 0) {
                String sql = "update T_EDT_DraftPromptPaymentBill set FOperateState=?,FSubmitDate=?,FSubmitterID=?,FSubmitCompanyID=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                CompanyOrgUnitInfo companyName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                UserInfo userName = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), billInfo.getSubmitDate(), userName.getId().toString(), companyName.getId().toString()});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u53ea\u6709\u5df2\u5ba1\u6279\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u5141\u8bb8\u63d0\u4ea4\u94f6\u4f01\u4e92\u8054\uff01"});
        }
    }

    @Override
    protected void _loginAccount(Context ctx, List billList) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isLoginAccount", (Object)Boolean.FALSE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLoginAccount", null));
        filter.getFilterItems().add(new FilterItemInfo("draftStockBill.commercialDraft.draftECDSStatus", (Object)ECDSBillStatusEnum.PJYJQ, CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or #2) and #3");
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("draftStockBill.commercialDraft.*");
        selectors.add("company.*");
        selectors.add("financAccount.*");
        selectors.add("financAccount.account.*");
        selectors.add("financAccount.currency.*");
        view.setSelector(selectors);
        view.setFilter(filter);
        DraftPromptPaymentBillCollection coll = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillCollection(view);
        if (coll != null && coll.size() > 0) {
            HashSet<BOSUuid> set = new HashSet<BOSUuid>();
            DraftPromptPaymentBillInfo info = null;
            JournalInfo journalInfo = null;
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                Date date;
                Date now;
                info = coll.get(i);
                journalInfo = new JournalInfo();
                PeriodInfo peroid = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info.getCompany());
                Date bizDate = now = new Date();
                if (peroid != null && (date = peroid.getBeginDate()).compareTo(now) > 0) {
                    bizDate = date;
                }
                journalInfo.setCompany(info.getCompany());
                journalInfo.setBizDate(bizDate);
                journalInfo.setBillNumber(info.getNumber());
                journalInfo.setBillId(info.getId().toString());
                journalInfo.setCreditAmount(info.getPayAccount());
                journalInfo.setCreateDate(bizDate);
                journalInfo.setType(JournalTypeEnum.BANK);
                journalInfo.setAccountBank(info.getFinancAccount());
                journalInfo.setAccountView(info.getFinancAccount().getAccount());
                journalInfo.setCurrency(info.getFinancAccount().getCurrency());
                journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
                journalInfo.setSource(JournalSourceEnum.BYBILL);
                journalInfo.setPeriod(peroid);
                journalInfo.setDescription(info.getHolderRamark());
                JournalFactory.getLocalInstance((Context)ctx).addnew(journalInfo);
                set.add(info.getId());
            }
            if (set != null && set.size() > 0) {
                String sql = "update T_EDT_DraftPromptPaymentBill set FIsLoginAccount=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{Boolean.TRUE});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u672a\u767b\u8d26\u5e76\u4e14\u5df2\u7ed3\u6e05\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u5141\u8bb8\u767b\u8d26\uff01"});
        }
    }

    @Override
    protected void _unLoginAccount(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isLoginAccount", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        DraftPromptPaymentBillCollection coll = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillCollection(view);
        if (coll.size() > 0) {
            HashSet<BOSUuid> set = new HashSet<BOSUuid>();
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                DraftPromptPaymentBillInfo info = coll.get(i);
                set.add(info.getId());
            }
            if (set.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("billId", set, CompareType.INCLUDE));
                JournalFactory.getLocalInstance((Context)ctx).delete(filter);
                String sql = "update T_EDT_DraftPromptPaymentBill set FIsLoginAccount=? where " + FMHelper.buildIn((String)"FID", (Object[])set.toArray());
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Boolean(false)});
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u767b\u8d26\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u5141\u8bb8\u53cd\u767b\u8d26\uff01"});
        }
    }

    @Override
    protected void checkCanBeCancelled(Context ctx, IObjectValue model, DraftApplyTypeEnum cancelType) throws EASBizException, BOSException {
        DraftPromptPaymentBillInfo info = (DraftPromptPaymentBillInfo)model;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("draftStockBill.commercialDraft.*"));
        sic.add(new SelectorItemInfo("operateState"));
        DraftPromptPaymentBillInfo billInfo = DraftPromptPaymentBillFactory.getLocalInstance(ctx).getDraftPromptPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), sic);
        if (!billInfo.getDraftStockBill().getCommercialDraft().getDraftECDSStatus().equals((Object)ECDSBillStatusEnum.TSFKDQS) || !info.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY) || info.isIsCancelDraft()) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u64cd\u4f5c\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\u7f51\u5173\u4e14\u7535\u7968\u72b6\u6001\u4e3a\u63d0\u793a\u4ed8\u6b3e\u5f85\u7b7e\u6536\u7684\u63d0\u793a\u4ed8\u6b3e\u5355\u624d\u5141\u8bb8\u64a4\u9500\u64cd\u4f5c\uff01"});
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        return HintPaymentApplyBillInfo.class.getName();
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum cancelType) {
        HintPaymentApplyBillInfo hintInfo = null;
        if (baseInfo instanceof DraftPromptPaymentBillInfo) {
            DraftPromptPaymentBillInfo paymentBillInfo = (DraftPromptPaymentBillInfo)baseInfo;
            hintInfo = new HintPaymentApplyBillInfo();
            CommercialDraftInfo commInfo = paymentBillInfo.getDraftStockBill().getCommercialDraft();
            hintInfo.setCommercialDraft(commInfo);
            hintInfo.setStartECDSState(commInfo.getDraftECDSStatus());
            hintInfo.setEndECDSState(commInfo.getDraftECDSStatus());
            hintInfo.setSourceBillId(paymentBillInfo.getId().toString());
            hintInfo.setHolderName(paymentBillInfo.getHolderName());
            hintInfo.setHolderAccount(paymentBillInfo.getHolderAccount());
            hintInfo.setHolderBankNumber(paymentBillInfo.getHolderBankNumber());
            hintInfo.setOrgCode(paymentBillInfo.getOrgCode());
            hintInfo.setPayAccount(paymentBillInfo.getPayAccount());
            hintInfo.setIsFinace(paymentBillInfo.isIsFinace());
            hintInfo.setIsSeft(paymentBillInfo.isIsSeft());
            hintInfo.setHolderRamark(paymentBillInfo.getHolderRamark());
            hintInfo.setApplyDate(paymentBillInfo.getPayBizDate());
            hintInfo.setOperateState(FCOperateStateEnum.save);
            hintInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
            hintInfo.setApplyCompany(paymentBillInfo.getCompany());
        }
        return hintInfo;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("draftStockBill.commercialDraft.*");
        sic.add("payBizDate");
        sic.add("holderName.id");
        sic.add("holderAccount.id");
        sic.add("holderBankNumber.id");
        sic.add("orgCode");
        sic.add("payAccount");
        sic.add("financAccount.id");
        sic.add("financBankNumber.id");
        sic.add("phone");
        sic.add("holderRamark");
        sic.add("isSeft");
        sic.add("isFinace");
        sic.add("isOnLine");
        sic.add("isLoginAccount");
        sic.add("batchNumber");
        sic.add("draftStockBill.id");
        sic.add("bgItemName");
        sic.add("bgItemName");
        sic.add("bgItemName");
        sic.add("bgItemName");
        return sic;
    }
}

