/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.AcceptanceApplyBillInfo;
import com.kingdee.eas.fm.edraf.DraftApplyBillBaseInfo;
import com.kingdee.eas.fm.edraf.ECDSCommunicationStatusEnum;
import com.kingdee.eas.fm.edraf.FCOperateStateEnum;
import com.kingdee.eas.fm.edraf.IssuanceApplyBillInfo;
import com.kingdee.eas.fm.edraf.RegisterApplyBillInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseCollection;
import com.kingdee.eas.fm.edrafent.DrafentApplyBillBaseInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftDestructionRequestBillFactory;
import com.kingdee.eas.fm.edrafent.DraftDestructionRequestBillInfo;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillCollection;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillFactory;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillInfo;
import com.kingdee.eas.fm.edrafent.EdrafBillException;
import com.kingdee.eas.fm.edrafent.IDraftRegisterBill;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.app.AbstractDraftRegisterBillControllerBean;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftRegisterBillControllerBean
extends AbstractDraftRegisterBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.edrafent.app.DraftRegisterBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DraftRegisterBillInfo info = this.saveCommercialDraft(ctx, model);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DraftRegisterBillInfo info = (DraftRegisterBillInfo)model;
        if (info.getNumber() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
            if (DraftRegisterBillFactory.getLocalInstance(ctx).exists(filter)) {
                throw new EASBizException(new NumericExceptionSubItem("66998", "\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01"));
            }
            info = this.saveCommercialDraft(ctx, (IObjectValue)info);
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DraftRegisterBillInfo draftInfo = (DraftRegisterBillInfo)model;
        draftInfo = this.saveCommercialDraft(ctx, (IObjectValue)draftInfo);
        return super._submit(ctx, (IObjectValue)draftInfo);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DraftRegisterBillInfo info = this.saveCommercialDraft(ctx, model);
        super._submit(ctx, pk, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DraftRegisterBillInfo draftInfo = DraftRegisterBillFactory.getLocalInstance(ctx).getDraftRegisterBillInfo(pk);
        if (draftInfo.getOperateState().equals((Object)OperateStateEnum.SAVE) || draftInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
            if (draftInfo.getCommercialDraft() != null && draftInfo.getCommercialDraft().getId() != null) {
                String id = draftInfo.getCommercialDraft().getId().toString();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
                CommercialDraftFactory.getLocalInstance(ctx).delete(filter);
            }
            super._delete(ctx, pk);
        }
    }

    private DraftRegisterBillInfo saveCommercialDraft(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DraftRegisterBillInfo draftInfo = (DraftRegisterBillInfo)model;
        CommercialDraftInfo commInfo = draftInfo.getCommercialDraft();
        if (draftInfo.getId() == null) {
            if (commInfo.getId() == null) {
                CommercialDraftFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)commInfo);
                draftInfo.setCommercialDraft(commInfo);
            }
        } else if (commInfo.getId() != null) {
            CommercialDraftFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(commInfo.getId()), (CoreBaseInfo)commInfo);
        }
        return draftInfo;
    }

    @Override
    protected void _submitToECDS(Context ctx, Set idSet) throws BOSException, EASBizException {
        IDraftRegisterBill idraft = DraftRegisterBillFactory.getLocalInstance(ctx);
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.setFilter(filter);
        env.getSelector().add(new SelectorItemInfo("id"));
        DraftRegisterBillCollection billCol = idraft.getDraftRegisterBillCollection(env);
        DraftRegisterBillInfo billInfo = null;
        if (billCol.size() > 0) {
            Object[] idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
            }
            billInfo = new DraftRegisterBillInfo();
            billInfo.setSubmitDate(DateHelper.getTime());
            UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            String sql = "update T_EDT_DraftRegisterBill set FOperateState= ?,FSubmitterID=?,FSubmitDate=?,FSubmitCompanyID=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(3), curUser.getId().toString(), billInfo.getSubmitDate(), curCompany.getId().toString()});
        }
    }

    @Override
    protected void _draftCancel(Context ctx, Set set) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("commercialDraft.*"));
        view.setSelector(selColl);
        DraftRegisterBillCollection draftCol = DraftRegisterBillFactory.getLocalInstance(ctx).getDraftRegisterBillCollection(view);
        for (int i = 0; i < draftCol.size(); ++i) {
            DraftRegisterBillInfo info = draftCol.get(i);
            if (info.isIsCancelDraft() || info.getCommercialDraft().getDraftECDSStatus() == null || info.getCommercialDraft().getDraftECDSStatus().getValue() != "010004" && info.getCommercialDraft().getDraftECDSStatus().getValue() != "020006") continue;
            DraftDestructionRequestBillInfo draftBillInfo = new DraftDestructionRequestBillInfo();
            draftBillInfo.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            draftBillInfo.setOperateState(OperateStateEnum.SAVE);
            draftBillInfo.setDraftRegisterBill(info);
            draftBillInfo.setIsCancelDraft(true);
            draftBillInfo.setSourceBillId(info.getId().toString());
            DraftDestructionRequestBillFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)draftBillInfo);
            info.setIsCancelDraft(true);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            EdrafentUtil.saveBotpRelation(ctx, (CoreBillBaseInfo)info, (CoreBillBaseInfo)draftBillInfo, info.getId().toString(), draftBillInfo.getId().toString());
        }
    }

    @Override
    public void _audit(Context ctx, Set idSet) throws BOSException, EASBizException, EdrafBillException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.SUBMIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftRegisterBillCollection billCol = DraftRegisterBillFactory.getLocalInstance(ctx).getDraftRegisterBillCollection(env);
        if (billCol.size() > 0) {
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                DraftRegisterBillInfo billInfo = billCol.get(i);
                this.audit4WF(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u63d0\u4ea4\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\uff01"});
        }
    }

    @Override
    protected void _unAudit(Context ctx, Set idSet) throws BOSException, EASBizException, EdrafBillException {
        Object[] idArray;
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        env.getSelector().add(new SelectorItemInfo("id"));
        env.setFilter(filter);
        DraftRegisterBillCollection billCol = DraftRegisterBillFactory.getLocalInstance(ctx).getDraftRegisterBillCollection(env);
        if (billCol.size() > 0) {
            idArray = new String[billCol.size()];
            int n = billCol.size();
            for (int i = 0; i < n; ++i) {
                idArray[i] = billCol.get(i).getId().toString();
                this.unAudit4WF(ctx, billCol.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u5df2\u5ba1\u6279\u7684\u5355\u636e\u624d\u5141\u8bb8\u53cd\u5ba1\u6279\uff01"});
        }
        String sql = "update T_EDT_DraftRegisterBill set FOperateState=?,FAuditDate=? where " + FMHelper.buildIn((String)"FID", (Object[])idArray);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(0), null});
    }

    @Override
    protected void _draftSubmit(Context ctx, Set idSet) throws BOSException, EASBizException, EdrafBillException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)new Integer(0), CompareType.EQUALS));
        env.setFilter(filter);
        DraftRegisterBillCollection col = DraftRegisterBillFactory.getLocalInstance(ctx).getDraftRegisterBillCollection(env);
        if (col.size() > 0) {
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                super.submit(ctx, (CoreBaseInfo)col.get(i));
            }
        } else {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u4fdd\u5b58\u72b6\u6001\u7684\u5355\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\uff01"});
        }
    }

    @Override
    protected String getApplyBillClassName(DraftApplyTypeEnum cancelType) {
        if (cancelType == DraftApplyTypeEnum.CHENGDUI) {
            return AcceptanceApplyBillInfo.class.getName();
        }
        if (cancelType == DraftApplyTypeEnum.SHOUPIAO) {
            return IssuanceApplyBillInfo.class.getName();
        }
        if (cancelType == DraftApplyTypeEnum.CHUPIAO) {
            return RegisterApplyBillInfo.class.getName();
        }
        return null;
    }

    @Override
    protected String getBankBillClassName(DraftApplyTypeEnum cancelType) {
        return null;
    }

    @Override
    public DraftApplyBillBaseInfo getApplyBillBaseInfo(DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        IssuanceApplyBillInfo applyBaseInfo = null;
        DraftRegisterBillInfo billInfo = (DraftRegisterBillInfo)baseInfo;
        CommercialDraftInfo commDraftInfo = billInfo.getCommercialDraft();
        if (applyType.equals((Object)DraftApplyTypeEnum.CHUPIAO)) {
            RegisterApplyBillInfo registerBill = new RegisterApplyBillInfo();
            registerBill.setApplyCompany(billInfo.getCompany());
            registerBill.setApplyDate(new Date());
            registerBill.setDraftTime(billInfo.getDraftTime());
            registerBill.setAssurerAddress(billInfo.getAssurerAddress());
            registerBill.setAssurDate(billInfo.getAssurDate());
            registerBill.setAcceptorDate(billInfo.getAcceptorDate());
            registerBill.setIsAcceptor(billInfo.isIsAcceptor());
            registerBill.setContractNumber(billInfo.getContractNumber());
            registerBill.setIsAttorn(billInfo.isIsAttorn());
            registerBill.setDrawerCdtBody(billInfo.getDrawerCdtBody());
            registerBill.setAcceptorCdtBody(billInfo.getAcceptorCdtBody());
            registerBill.setAcceptorCdtDate(billInfo.getAcceptorCdtDate());
            registerBill.setClewAccept(billInfo.isClewAccept());
            registerBill.setClewDrawer(billInfo.isClewDrawer());
            registerBill.setProcedureRate(billInfo.getProcedureRate());
            registerBill.setMoneySum(billInfo.getMoneySum());
            registerBill.setDrawerAccount(billInfo.getDrawerAccount());
            registerBill.setDrawerName(billInfo.getDrawerName());
            registerBill.setDraftNumber(commDraftInfo.getDraftNumber());
            registerBill.setDrawerBank(billInfo.getDrawerBank());
            registerBill.setDrawerBankNumber(billInfo.getDrawerBankNumber());
            registerBill.setPayeeBank(billInfo.getPayeeBank());
            registerBill.setPayeeName(billInfo.getPayeeName());
            registerBill.setAssurersName(billInfo.getAssurersName());
            registerBill.setAssurersAccount(billInfo.getAssurersAccount());
            registerBill.setAssurersBankNumber(billInfo.getAssurersBankNumber());
            registerBill.setAccpetorBank(billInfo.getAccpetorBank());
            registerBill.setAccpetorBankName(billInfo.getAccpetorBankName());
            registerBill.setAccpetorBankNumber(billInfo.getAccpetorBankNumber());
            registerBill.setAmountAccount(billInfo.getAmountAccount());
            registerBill.setPayeeBank(billInfo.getPayeeBank());
            registerBill.setAcceptorCompany(billInfo.getAcceptorCompany());
            registerBill.setSourceBillId(billInfo.getId().toString());
            registerBill.setBatchNumber(billInfo.getBatchNumber());
            registerBill.setIsCancelDraft(false);
            registerBill.setAcceptorCreditRat(billInfo.getAcceptorCreditRat());
            applyBaseInfo = registerBill;
        }
        if (applyType.equals((Object)DraftApplyTypeEnum.CHENGDUI)) {
            AcceptanceApplyBillInfo acceptanceBill = new AcceptanceApplyBillInfo();
            acceptanceBill.setApplyCompany(billInfo.getCompany());
            acceptanceBill.setApplyDate(new Date());
            acceptanceBill.setDraftTime(billInfo.getDraftTime());
            acceptanceBill.setAssurerAddress(billInfo.getAssurerAddress());
            acceptanceBill.setAssurDate(billInfo.getAssurDate());
            acceptanceBill.setAcceptorDate(billInfo.getAcceptorDate());
            acceptanceBill.setIsAcceptor(billInfo.isIsAcceptor());
            acceptanceBill.setContractNumber(billInfo.getContractNumber());
            acceptanceBill.setIsAttorn(billInfo.isIsAttorn());
            acceptanceBill.setDrawerCdtBody(billInfo.getDrawerCdtBody());
            acceptanceBill.setAcceptorCdtBody(billInfo.getAcceptorCdtBody());
            acceptanceBill.setAcceptorCdtDate(billInfo.getAcceptorCdtDate());
            acceptanceBill.setProcedureRate(billInfo.getProcedureRate());
            acceptanceBill.setMoneySum(billInfo.getMoneySum());
            acceptanceBill.setDrawerAccount(billInfo.getDrawerAccount());
            acceptanceBill.setDrawerName(billInfo.getDrawerName());
            acceptanceBill.setDrawerBank(billInfo.getDrawerBank());
            acceptanceBill.setDrawerBankNumber(billInfo.getDrawerBankNumber());
            acceptanceBill.setPayeeBank(billInfo.getPayeeBank());
            acceptanceBill.setPayeeName(billInfo.getPayeeName());
            acceptanceBill.setAssurersName(billInfo.getAssurersName());
            acceptanceBill.setAssurersAccount(billInfo.getAssurersAccount());
            acceptanceBill.setAssurersBankNumber(billInfo.getAssurersBankNumber());
            acceptanceBill.setAccpetorBank(billInfo.getAccpetorBank());
            acceptanceBill.setAccpetorBankName(billInfo.getAccpetorBankName());
            acceptanceBill.setAccpetorBankNumber(billInfo.getAccpetorBankNumber());
            acceptanceBill.setAmountAccount(billInfo.getAmountAccount());
            acceptanceBill.setPayeeBank(billInfo.getPayeeBank());
            acceptanceBill.setAcceptorCompany(billInfo.getAcceptorCompany());
            acceptanceBill.setSourceBillId(billInfo.getId().toString());
            acceptanceBill.setBatchNumber(billInfo.getBatchNumber());
            acceptanceBill.setAcceptorCreditRat(billInfo.getAcceptorCreditRat());
            acceptanceBill.setDescription(billInfo.getDescription());
            applyBaseInfo = acceptanceBill;
        }
        if (applyType.equals((Object)DraftApplyTypeEnum.SHOUPIAO)) {
            IssuanceApplyBillInfo issuanceBill = new IssuanceApplyBillInfo();
            issuanceBill.setApplyCompany(billInfo.getCompany());
            issuanceBill.setApplyDate(new Date());
            issuanceBill.setDraftTime(billInfo.getDraftTime());
            issuanceBill.setAssurerAddress(billInfo.getAssurerAddress());
            issuanceBill.setAssurDate(billInfo.getAssurDate());
            issuanceBill.setAcceptorDate(billInfo.getAcceptorDate());
            issuanceBill.setIsAcceptor(billInfo.isIsAcceptor());
            issuanceBill.setContractNumber(billInfo.getContractNumber());
            issuanceBill.setIsAttorn(billInfo.isIsAttorn());
            issuanceBill.setDrawerCdtBody(billInfo.getDrawerCdtBody());
            issuanceBill.setAcceptorCdtBody(billInfo.getAcceptorCdtBody());
            issuanceBill.setAcceptorCdtDate(billInfo.getAcceptorCdtDate());
            issuanceBill.setDrawerAccount(billInfo.getDrawerAccount());
            issuanceBill.setDrawerName(billInfo.getDrawerName());
            issuanceBill.setDrawerBank(billInfo.getDrawerBank());
            issuanceBill.setDrawerBankNumber(billInfo.getDrawerBankNumber());
            issuanceBill.setPayeeBank(billInfo.getPayeeBank());
            issuanceBill.setPayeeName(billInfo.getPayeeName());
            issuanceBill.setAssurersName(billInfo.getAssurersName());
            issuanceBill.setAssurersAccount(billInfo.getAssurersAccount());
            issuanceBill.setAssurersBankNumber(billInfo.getAssurersBankNumber());
            issuanceBill.setAccpetorBank(billInfo.getAccpetorBank());
            issuanceBill.setAccpetorBankName(billInfo.getAccpetorBankName());
            issuanceBill.setAccpetorBankNumber(billInfo.getAccpetorBankNumber());
            issuanceBill.setPayeeBank(billInfo.getPayeeBank());
            issuanceBill.setSourceBillId(billInfo.getId().toString());
            issuanceBill.setAcceptorCompany(billInfo.getAcceptorCompany());
            issuanceBill.setBatchNumber(billInfo.getBatchNumber());
            issuanceBill.setAcceptorCreditRat(billInfo.getAcceptorCreditRat());
            applyBaseInfo = issuanceBill;
        }
        if (applyBaseInfo != null) {
            applyBaseInfo.setOperateState(FCOperateStateEnum.save);
            applyBaseInfo.setDescription(billInfo.getDescription());
            applyBaseInfo.setCommercialDraft(commDraftInfo);
            applyBaseInfo.setCompany(null);
            if (commDraftInfo != null) {
                applyBaseInfo.setStartECDSState(commDraftInfo.getDraftECDSStatus());
                applyBaseInfo.setEndECDSState(commDraftInfo.getDraftECDSStatus());
            }
            applyBaseInfo.setCommunicationStatus(ECDSCommunicationStatusEnum.SUBMIT_READY);
        }
        return applyBaseInfo;
    }

    @Override
    public DrafentApplyBillBaseInfo reversBillState(Context ctx, DrafentApplyBillBaseInfo baseInfo, DraftApplyTypeEnum applyType) {
        DraftRegisterBillInfo billInfo = (DraftRegisterBillInfo)baseInfo;
        if (applyType.equals((Object)DraftApplyTypeEnum.CHUPIAO)) {
            baseInfo = super.reversBillState(ctx, billInfo, applyType);
        }
        if (applyType.equals((Object)DraftApplyTypeEnum.CHENGDUI)) {
            billInfo.setClewAccept(true);
            CommercialDraftInfo commDraftInfo = billInfo.getCommercialDraft();
            if (commDraftInfo != null) {
                billInfo.setDescription(commDraftInfo.getRemark());
            }
        }
        if (applyType.equals((Object)DraftApplyTypeEnum.SHOUPIAO)) {
            billInfo.setClewDrawer(true);
        }
        billInfo.setReturnOpinion(null);
        return baseInfo;
    }

    @Override
    public DrafentApplyBillBaseCollection getBillBaseCollection(Context ctx, Set idSet, DraftApplyTypeEnum applyType) throws BOSException, EASBizException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        if (applyType.equals((Object)DraftApplyTypeEnum.CHUPIAO)) {
            filter.getFilterItems().add(new FilterItemInfo("operateState", (Object)OperateStateEnum.AUDIT, CompareType.EQUALS));
        }
        if (applyType.equals((Object)DraftApplyTypeEnum.CHENGDUI)) {
            filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", (Object)ECDSBillStatusEnum.CPYDJ, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("clewAccept", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        if (applyType.equals((Object)DraftApplyTypeEnum.SHOUPIAO)) {
            filter.getFilterItems().add(new FilterItemInfo("commercialDraft.draftECDSStatus", (Object)ECDSBillStatusEnum.TSCDYQS, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("clewDrawer", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        env.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        env.setSelector(sic);
        DrafentApplyBillBaseCollection billCol = DraftRegisterBillFactory.getLocalInstance(ctx).getDrafentApplyBillBaseCollection(env);
        if (billCol == null || billCol.size() == 0) {
            throw new FMException(FMException.COMMMONEXCEPTION, new Object[]{"\u6240\u9009\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u64cd\u4f5c\u6761\u4ef6\uff01"});
        }
        return billCol;
    }
}

